<?php
defined('_JEXEC') or die;

// Define icons and colors for each metric
$metricIcons = [
	'total_workers' => 'fa-users',
	'early_arrivals' => 'fa-clock',
	'late_arrivals' => 'fa-clock',
	'late_checkouts' => 'fa-clock',
	'total_hours_worked' => 'fa-hourglass',
	'total_overtime' => 'fa-hourglass-end',
	'with_ppe' => 'fa-shield-alt',
	'without_ppe' => 'fa-times-circle',
	'total_payments' => 'fa-money-bill-wave',
	'total_overtime_payments' => 'fa-money-bill-wave',
	'efficiency_ratings' => [
    	'Unsatisfactory' => 'fa-thumbs-down',
    	'Needs Improvement' => 'fa-exclamation-circle',
    	'Meets Expectations' => 'fa-check-circle',
    	'Exceeds Expectations' => 'fa-star',
    	'Outstanding' => 'fa-trophy',
	],
	'performance_remarks' => [
    	'Poor' => 'fa-thumbs-down',
    	'Fair' => 'fa-exclamation-circle',
    	'Good' => 'fa-check-circle',
    	'Very Good' => 'fa-star',
    	'Excellent' => 'fa-trophy',
	],
];

$metricColors = [
	'total_workers' => 'text-primary',
	'early_arrivals' => 'text-success',
	'late_arrivals' => 'text-warning',
	'late_checkouts' => 'text-danger',
	'total_hours_worked' => 'text-info',
	'total_overtime' => 'text-secondary',
	'with_ppe' => 'text-success',
	'without_ppe' => 'text-danger',
	'total_payments' => 'text-primary',
	'total_overtime_payments' => 'text-secondary',
	'efficiency_ratings' => [
    	'Unsatisfactory' => 'text-danger',
    	'Needs Improvement' => 'text-warning',
    	'Meets Expectations' => 'text-info',
    	'Exceeds Expectations' => 'text-success',
    	'Outstanding' => 'text-primary',
	],
	'performance_remarks' => [
    	'Poor' => 'text-danger',
    	'Fair' => 'text-warning',
    	'Good' => 'text-info',
    	'Very Good' => 'text-success',
    	'Excellent' => 'text-primary',
	],
];
?>

<div class="casual-work-dashboard card p-3 shadow-sm">
	<h3 class="text-center mb-3">Casual Work Dashboard</h3>

	<!-- Metrics Display -->
	<ul class="list-group">
    	<!-- Basic Metrics -->
    	<?php foreach ($this->metrics as $metric => $value): ?>
        	<?php if (isset($metricIcons[$metric])): ?>
            	<li class="list-group-item d-flex justify-content-between align-items-center">
                	<span>
                    	<i class="fas <?php echo $metricIcons[$metric]; ?> <?php echo $metricColors[$metric]; ?>"></i>
                    	<strong><?php echo ucfirst(str_replace('_', ' ', $metric)); ?>:</strong>
                	</span>
                	<span class="badge bg-primary rounded-pill"><?php echo $value; ?></span>
            	</li>
        	<?php endif; ?>
    	<?php endforeach; ?>

    	<!-- Efficiency Ratings Section -->
    	<li class="list-group-item bg-light">
        	<h4 class="mb-0" style="font-size: 1.25rem; font-weight: 600;">Efficiency Ratings</h4>
    	</li>
    	<?php
    	$efficiencyLabels = [
        	'Unsatisfactory' => 'Those Rated as Unsatisfactory',
        	'Needs Improvement' => 'Those Rated as Needing Improvement',
        	'Meets Expectations' => 'Those Rated as Meeting Expectations',
        	'Exceeds Expectations' => 'Those Rated as Exceeding Expectations',
        	'Outstanding' => 'Those Rated as Outstanding',
    	];
    	foreach ($this->metrics['efficiency_ratings'] as $rating => $count): ?>
        	<li class="list-group-item d-flex justify-content-between align-items-center">
            	<span>
                	<i class="fas <?php echo $metricIcons['efficiency_ratings'][$rating]; ?> <?php echo $metricColors['efficiency_ratings'][$rating]; ?>"></i>
                	<strong><?php echo $efficiencyLabels[$rating]; ?>:</strong>
            	</span>
            	<span class="badge bg-primary rounded-pill"><?php echo $count; ?></span>
        	</li>
    	<?php endforeach; ?>

    	<!-- Performance Remarks Section -->
    	<li class="list-group-item bg-light">
        	<h4 class="mb-0" style="font-size: 1.25rem; font-weight: 600;">Performance Remarks</h4>
    	</li>
    	<?php
    	$performanceLabels = [
        	'Poor' => 'Marked as Poor Performers',
        	'Fair' => 'Marked as Fair Performers',
        	'Good' => 'Marked as Good Performers',
        	'Very Good' => 'Marked as Very Good Performers',
        	'Excellent' => 'Marked as Excellent Performers',
    	];
    	foreach ($this->metrics['performance_remarks'] as $remark => $count): ?>
        	<li class="list-group-item d-flex justify-content-between align-items-center">
            	<span>
                	<i class="fas <?php echo $metricIcons['performance_remarks'][$remark]; ?> <?php echo $metricColors['performance_remarks'][$remark]; ?>"></i>
                	<strong><?php echo $performanceLabels[$remark]; ?>:</strong>
            	</span>
            	<span class="badge bg-primary rounded-pill"><?php echo $count; ?></span>
        	</li>
    	<?php endforeach; ?>
	</ul>
</div>

<!-- Include Bootstrap 5 and FontAwesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">