<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;

class ModCasualWorkDashboardHelper
{
	public static function getMetrics($formId, $timePeriod = 'today')
	{
    	$db = Factory::getDbo();
    	$now = Factory::getDate();
    	$today = $now->format('Y-m-d'); // Format: 2025-02-17

    	// Calculate the start and end dates based on the selected time period
    	switch ($timePeriod) {
        	case 'today':
            	$startDate = $today;
            	$endDate = $today;
            	break;
        	case 'previous_day':
            	$startDate = $now->modify('-1 day')->format('Y-m-d');
            	$endDate = $startDate;
            	break;
        	case 'last_1_day':
            	$startDate = $now->modify('-1 day')->format('Y-m-d');
            	$endDate = $today;
            	break;
        	case 'last_2_days':
            	$startDate = $now->modify('-2 days')->format('Y-m-d');
            	$endDate = $today;
            	break;
        	case 'last_3_days':
            	$startDate = $now->modify('-3 days')->format('Y-m-d');
            	$endDate = $today;
            	break;
        	case 'last_7_days':
            	$startDate = $now->modify('-7 days')->format('Y-m-d');
            	$endDate = $today;
            	break;
        	case 'last_30_days':
            	$startDate = $now->modify('-30 days')->format('Y-m-d');
            	$endDate = $today;
            	break;
        	case 'last_1_year':
            	$startDate = $now->modify('-1 year')->format('Y-m-d');
            	$endDate = $today;
            	break;
        	default:
            	$startDate = $today;
            	$endDate = $today;
            	break;
    	}

    	// Fetch all submissions for the selected time period
    	$query = $db->getQuery(true)
        	->select($db->quoteName(array('s.SubmissionId', 'v.FieldName', 'v.FieldValue')))
        	->from($db->quoteName('#__rsform_submissions', 's'))
        	->join('INNER', $db->quoteName('#__rsform_submission_values', 'v') . ' ON s.SubmissionId = v.SubmissionId')
        	->where($db->quoteName('s.FormId') . ' = ' . $db->quote($formId))
        	->where($db->quoteName('v.FieldName') . ' = ' . $db->quote('Local_Time'))
        	->where($db->quoteName('v.FieldValue') . ' BETWEEN ' . $db->quote($startDate . ' 00:00:00') . ' AND ' . $db->quote($endDate . ' 23:59:59'));

    	$db->setQuery($query);
    	$submissions = $db->loadObjectList();

    	// Initialize metrics
    	$metrics = [
        	'total_workers' => 0,
        	'early_arrivals' => 0,
        	'late_arrivals' => 0,
        	'late_checkouts' => 0,
        	'total_hours_worked' => 0,
        	'total_overtime' => 0,
        	'with_ppe' => 0,
        	'without_ppe' => 0,
        	'total_payments' => 0,
        	'total_overtime_payments' => 0,
        	'efficiency_ratings' => [
            	'Unsatisfactory' => 0,
            	'Needs Improvement' => 0,
            	'Meets Expectations' => 0,
            	'Exceeds Expectations' => 0,
            	'Outstanding' => 0,
        	],
        	'performance_remarks' => [
            	'Poor' => 0,
            	'Fair' => 0,
            	'Good' => 0,
            	'Very Good' => 0,
            	'Excellent' => 0,
        	],
    	];

    	// Process submissions
    	foreach ($submissions as $submission) {
        	$fieldName = $submission->FieldName;
        	$fieldValue = $submission->FieldValue;

        	switch ($fieldName) {
            	case 'Check-in':
                	$checkInTime = strtotime($fieldValue);
                	if ($checkInTime < strtotime('08:30:00')) {
                    	$metrics['early_arrivals']++;
                	} else {
                    	$metrics['late_arrivals']++;
                	}
                	break;

            	case 'CheckOutTime':
                	if (strtotime($fieldValue) > strtotime('17:00:00')) {
                    	$metrics['late_checkouts']++;
                	}
                	break;

            	case 'HoursWorked':
                	$metrics['total_hours_worked'] += (float) $fieldValue;
                	break;

            	case 'Overtime':
                	$metrics['total_overtime'] += (float) $fieldValue;
                	break;

            	case 'HasPPE':
                	if ($fieldValue === 'Yes') {
                    	$metrics['with_ppe']++;
                	} else {
                    	$metrics['without_ppe']++;
                	}
                	break;

            	case 'PayAmount':
                	$metrics['total_payments'] += (float) $fieldValue;
                	break;

            	case 'OvertimePayAmount':
                	$metrics['total_overtime_payments'] += (float) $fieldValue;
                	break;

            	case 'WorkerEfficiencyRating':
                	if (isset($metrics['efficiency_ratings'][$fieldValue])) {
                    	$metrics['efficiency_ratings'][$fieldValue]++;
                	}
                	break;

            	case 'SupervisorPerformanceRemarks':
                	if (isset($metrics['performance_remarks'][$fieldValue])) {
                    	$metrics['performance_remarks'][$fieldValue]++;
                	}
                	break;
        	}
    	}

    	// Total workers is the number of submissions for the selected time period
    	$metrics['total_workers'] = count($submissions);

    	return $metrics;
	}
}