/**ABDB**/CREATE TABLE `#__update_sites_extensions` (
  `update_site_id` int(11) NOT NULL DEFAULT 0,
  `extension_id` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`update_site_id`,`extension_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Links extensions to update sites';
/**ABDB**/INSERT INTO `#__update_sites_extensions`  VALUES 
('1', '220'),
('2', '221'),
('3', '24'),
('4', '232'),
('5', '232'),
('6', '237'),
('8', '238'),
('11', '240'),
('12', '301'),
('13', '302'),
('14', '300'),
('15', '305'),
('16', '308'),
('17', '311'),
('18', '323'),
('19', '328');
/**ABDB**/CREATE TABLE `#__rsform_calculations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `formId` int(11) NOT NULL,
  `total` varchar(255) NOT NULL,
  `expression` text NOT NULL,
  `ordering` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `formId` (`formId`),
  KEY `ordering` (`ordering`),
  KEY `formId_2` (`formId`,`ordering`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `#__viewlevels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `title` varchar(100) NOT NULL DEFAULT '',
  `ordering` int(11) NOT NULL DEFAULT 0,
  `rules` varchar(5120) NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_assetgroup_title_lookup` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__viewlevels`  VALUES 
('1', 'Public', '0', '[1]'),
('2', 'Registered', '2', '[6,2,8]'),
('3', 'Special', '3', '[6,3,8]'),
('5', 'Guest', '1', '[9]'),
('6', 'Super Users', '4', '[8]'),
('7', 'Staff', '0', '[13]'),
('8', 'NGO Clients Access', '0', '[]'),
('9', 'Moheta', '0', '[14,13]');
/**ABDB**/CREATE TABLE `#__action_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `message_language_key` varchar(255) NOT NULL DEFAULT '',
  `message` text NOT NULL,
  `log_date` datetime NOT NULL,
  `extension` varchar(50) NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT 0,
  `item_id` int(11) NOT NULL DEFAULT 0,
  `ip_address` varchar(40) NOT NULL DEFAULT '0.0.0.0',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_user_id_logdate` (`user_id`,`log_date`),
  KEY `idx_user_id_extension` (`user_id`,`extension`),
  KEY `idx_extension_item_id` (`extension`,`item_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2607 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__update_sites` (
  `update_site_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT '',
  `type` varchar(20) DEFAULT '',
  `location` text NOT NULL,
  `enabled` int(11) DEFAULT 0,
  `last_check_timestamp` bigint(20) DEFAULT 0,
  `extra_query` varchar(1000) DEFAULT '',
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  PRIMARY KEY (`update_site_id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Update Sites';
/**ABDB**/INSERT INTO `#__update_sites`  VALUES 
('1', 'Joomla! Core', 'tuf', 'https://update.joomla.org/cms/', '1', '1771498755', '', NULL, NULL),
('2', 'Accredited Joomla! Translations', 'collection', 'https://update.joomla.org/language/translationlist_5.xml', '1', '1771498756', '', NULL, NULL),
('3', 'Joomla! Update Component', 'extension', 'https://update.joomla.org/core/extensions/com_joomlaupdate.xml', '1', '1771498756', '', NULL, NULL),
('4', 'Gantry 5', 'extension', 'http://updates.gantry.org/5.0/joomla/pkg_gantry5.xml', '1', '1771498757', '', NULL, NULL),
('5', 'Gantry 5', 'collection', 'http://updates.gantry.org/5.0/joomla/list.xml', '1', '1771498757', '', NULL, NULL),
('6', 'Akeeba Backup Core for Joomla!', 'extension', 'https://cdn.akeeba.com/updates/pkgakeebabackupcore.xml', '1', '1771498757', '', NULL, NULL),
('11', 'Convert Forms', 'extension', 'https://www.tassos.gr/updates/convert-forms-free.xml', '1', '1771498757', '', NULL, NULL),
('12', 'Installer - RSForm! Pro', 'extension', 'https://www.rsjoomla.com/updates/com_rsform/Other/plg_installer.xml', '1', '1771498757', '', NULL, NULL),
('13', 'System - RSForm! Pro Delete Submissions', 'extension', 'https://www.rsjoomla.com/updates/com_rsform/Other/plg_rsformdeletesubmissions.xml', '1', '1771498758', '', NULL, NULL),
('14', 'RSForm! Pro', 'extension', 'https://www.rsjoomla.com/updates/com_rsform/Component/com_rsform.xml', '1', '1771498758', '', NULL, NULL),
('15', 'RSForm! Pro - Advanced Form Fields', 'extension', 'https://www.rsjoomla.com/updates/plg_rsform_plugins/plg_rsfpadvancedformfields/plg_rsfpadvancedformfields.xml', '1', '1771498758', '', NULL, NULL),
('16', 'Regular Labs Library', 'extension', 'https://download.regularlabs.com/updates.xml?e=library&type=.xml', '1', '1771498759', '', NULL, NULL),
('17', 'Sourcerer', 'extension', 'https://download.regularlabs.com/updates.xml?e=sourcerer&type=.xml', '1', '1771498759', '', NULL, NULL),
('18', 'RSForm! Pro - Module List', 'extension', 'https://www.rsjoomla.com/updates/com_rsform/Modules/mod_rsform_list.xml', '1', '1771498760', '', NULL, NULL),
('19', 'RSForm! Pro - Module', 'extension', 'https://www.rsjoomla.com/updates/com_rsform/Modules/mod_rsform.xml', '1', '1771498760', '', NULL, NULL);
/**ABDB**/CREATE TABLE `#__action_log_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) NOT NULL DEFAULT '',
  `type_alias` varchar(255) NOT NULL DEFAULT '',
  `id_holder` varchar(255) DEFAULT NULL,
  `title_holder` varchar(255) DEFAULT NULL,
  `table_name` varchar(255) DEFAULT NULL,
  `text_prefix` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__action_log_config`  VALUES 
('1', 'article', 'com_content.article', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
('2', 'article', 'com_content.form', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
('3', 'banner', 'com_banners.banner', 'id', 'name', '#__banners', 'PLG_ACTIONLOG_JOOMLA'),
('4', 'user_note', 'com_users.note', 'id', 'subject', '#__user_notes', 'PLG_ACTIONLOG_JOOMLA'),
('5', 'media', 'com_media.file', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
('6', 'category', 'com_categories.category', 'id', 'title', '#__categories', 'PLG_ACTIONLOG_JOOMLA'),
('7', 'menu', 'com_menus.menu', 'id', 'title', '#__menu_types', 'PLG_ACTIONLOG_JOOMLA'),
('8', 'menu_item', 'com_menus.item', 'id', 'title', '#__menu', 'PLG_ACTIONLOG_JOOMLA'),
('9', 'newsfeed', 'com_newsfeeds.newsfeed', 'id', 'name', '#__newsfeeds', 'PLG_ACTIONLOG_JOOMLA'),
('10', 'link', 'com_redirect.link', 'id', 'old_url', '#__redirect_links', 'PLG_ACTIONLOG_JOOMLA'),
('11', 'tag', 'com_tags.tag', 'id', 'title', '#__tags', 'PLG_ACTIONLOG_JOOMLA'),
('12', 'style', 'com_templates.style', 'id', 'title', '#__template_styles', 'PLG_ACTIONLOG_JOOMLA'),
('13', 'plugin', 'com_plugins.plugin', 'extension_id', 'name', '#__extensions', 'PLG_ACTIONLOG_JOOMLA'),
('14', 'component_config', 'com_config.component', 'extension_id', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
('15', 'contact', 'com_contact.contact', 'id', 'name', '#__contact_details', 'PLG_ACTIONLOG_JOOMLA'),
('16', 'module', 'com_modules.module', 'id', 'title', '#__modules', 'PLG_ACTIONLOG_JOOMLA'),
('17', 'access_level', 'com_users.level', 'id', 'title', '#__viewlevels', 'PLG_ACTIONLOG_JOOMLA'),
('18', 'banner_client', 'com_banners.client', 'id', 'name', '#__banner_clients', 'PLG_ACTIONLOG_JOOMLA'),
('19', 'application_config', 'com_config.application', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
('20', 'task', 'com_scheduler.task', 'id', 'title', '#__scheduler_tasks', 'PLG_ACTIONLOG_JOOMLA'),
('21', 'field', 'com_fields.field', 'id', 'title', '#__fields', 'PLG_ACTIONLOG_JOOMLA'),
('22', 'guidedtour', 'com_guidedtours.state', 'id', 'title', '#__guidedtours', 'PLG_ACTIONLOG_JOOMLA');
/**ABDB**/CREATE TABLE `#__template_overrides` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `template` varchar(50) NOT NULL DEFAULT '',
  `hash_id` varchar(255) NOT NULL DEFAULT '',
  `extension_id` int(11) DEFAULT 0,
  `state` tinyint(4) NOT NULL DEFAULT 0,
  `action` varchar(50) NOT NULL DEFAULT '',
  `client_id` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `created_date` datetime NOT NULL,
  `modified_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_template` (`template`),
  KEY `idx_extension_id` (`extension_id`)
) ENGINE=InnoDB AUTO_INCREMENT=88 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(400) NOT NULL DEFAULT '',
  `username` varchar(150) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `password` varchar(100) NOT NULL DEFAULT '',
  `block` tinyint(4) NOT NULL DEFAULT 0,
  `sendEmail` tinyint(4) DEFAULT 0,
  `registerDate` datetime NOT NULL,
  `lastvisitDate` datetime DEFAULT NULL,
  `activation` varchar(100) NOT NULL DEFAULT '',
  `params` text NOT NULL,
  `lastResetTime` datetime DEFAULT NULL COMMENT 'Date of last password reset',
  `resetCount` int(11) NOT NULL DEFAULT 0 COMMENT 'Count of password resets since lastResetTime',
  `otpKey` varchar(1000) NOT NULL DEFAULT '' COMMENT 'Two factor authentication encrypted keys',
  `otep` varchar(1000) NOT NULL DEFAULT '' COMMENT 'One time emergency passwords',
  `requireReset` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'Require user to reset password on next login',
  `authProvider` varchar(100) NOT NULL DEFAULT '' COMMENT 'Name of used authentication plugin',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_username` (`username`),
  KEY `idx_name` (`name`(100)),
  KEY `idx_block` (`block`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=976 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__users`  VALUES 
('957', 'Maids Admin', 'MaidsUG', 'mubmart7@gmail.com', '$2y$10$TJZepuH8NspIIxZvv9EuGOj8SAMiVhnBcstJttJlWOaXX83NUGmyi', '0', '1', '2022-07-26 13:56:52', '2026-02-19 10:59:13', '0', '{\"admin_style\":\"\",\"colorScheme\":\"\",\"allowTourAutoStart\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"timezone\":\"\",\"a11y_mono\":\"0\",\"a11y_contrast\":\"0\",\"a11y_highlight\":\"0\",\"a11y_font\":\"0\"}', NULL, '0', '', '', '0', ''),
('958', 'NGO Client', 'NGOClient', 'greatrwandaj@gmail.com', '$2y$10$T7KrcAv.tROLIyaBJcUiHeDq/VTf1zEdzXT9tOoWjEUvHI9CcP0sC', '0', '0', '2025-01-28 15:39:17', '2025-02-17 18:02:18', '', '{\"admin_style\":\"\",\"colorScheme\":\"\",\"allowTourAutoStart\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"timezone\":\"\",\"a11y_mono\":\"0\",\"a11y_contrast\":\"0\",\"a11y_highlight\":\"0\",\"a11y_font\":\"0\"}', NULL, '0', '', '', '0', ''),
('959', 'NGO Admin', 'NGOadmin', 'greatkenyaj@gmail.com', '$2y$10$Vn6EYjE24UvqSvcfotTck.VTnyFF5ZnEzZIbvspNgq/PfHryporVC', '0', '0', '2025-01-28 15:47:26', '2025-02-05 13:18:26', '', '{\"admin_style\":\"\",\"colorScheme\":\"\",\"allowTourAutoStart\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"timezone\":\"\",\"a11y_mono\":\"0\",\"a11y_contrast\":\"0\",\"a11y_highlight\":\"0\",\"a11y_font\":\"0\"}', NULL, '0', '', '', '0', ''),
('962', 'Martin', 'maidsStaff', 'martmub7@gmail.com', '$2y$10$ZSFjxLBVxSec7mXTlwWzG.FnTUHpSE6qoLz3sq097Bxeg7AoiX6WG', '0', '0', '2025-02-24 10:05:01', '2026-02-16 10:28:06', '', '{\"admin_style\":\"\",\"colorScheme\":\"\",\"allowTourAutoStart\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"timezone\":\"\",\"a11y_mono\":\"0\",\"a11y_contrast\":\"0\",\"a11y_highlight\":\"0\",\"a11y_font\":\"0\"}', NULL, '0', '', '', '0', ''),
('966', 'Lakaraber Eve Anyine', 'EVE', 'lakarabereve@gmail.com', '$2y$10$Wy59FDy3kvoHzUr0/BXNYe7JXMHvvXBL.Jc/xh4TX5aMIEiv/6V02', '0', '0', '2025-06-24 09:19:23', '2026-02-10 04:55:42', '', '{\"activate\":1,\"admin_style\":\"\",\"colorScheme\":\"\",\"allowTourAutoStart\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"timezone\":\"\",\"a11y_mono\":\"0\",\"a11y_contrast\":\"0\",\"a11y_highlight\":\"0\",\"a11y_font\":\"0\"}', NULL, '0', '', '', '0', ''),
('967', 'nakabugo patricia', 'patricia', 'nakabugopatrica9@gmail.com', '$2y$10$rINl6ODamDnsBHhO3fupsOnGJH1dAAq5/pUatXwGADiCoyI8Fg2t.', '0', '0', '2025-07-10 12:45:19', '2026-02-13 18:38:46', '', '{\"admin_style\":\"\",\"colorScheme\":\"\",\"allowTourAutoStart\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"timezone\":\"\",\"a11y_mono\":\"0\",\"a11y_contrast\":\"0\",\"a11y_highlight\":\"0\",\"a11y_font\":\"0\"}', NULL, '0', '', '', '0', ''),
('970', 'Samuel Kiira', 'Brosamack', 'samuelkiiraeluk@gmail.com', '$2y$10$GYE.Y.uqkBbafXoZ7ZO43u4BZvrPtlS2OuyP9sHep4qpgaiETYi16', '0', '0', '2025-10-14 14:34:31', '2025-10-22 15:50:29', '', '{\"admin_style\":\"\",\"colorScheme\":\"\",\"allowTourAutoStart\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"timezone\":\"\",\"a11y_mono\":\"0\",\"a11y_contrast\":\"0\",\"a11y_highlight\":\"0\",\"a11y_font\":\"0\"}', NULL, '0', '', '', '0', ''),
('971', 'KAYDOT', 'DOTUN', 'odranmay@gmail.com', '$2y$10$GzTrReM00K4mlEryHNmQ5ORa0LqmKEqErqTzwQh0Skd1MYJXlT2PW', '1', '0', '2025-10-20 03:38:40', NULL, '92c73c79b642f0dd9fd68d5b3a216b4f', '{}', NULL, '0', '', '', '0', ''),
('972', 'Mathew', 'wamubirigwemathew', 'wamubirigwemathew@gmail.com', '$2y$10$lB.jazUwGOxysdCrQrjEMuHTX1udxQyZpeEPAyAWapQ7eQiL.UXZS', '0', '0', '2025-10-23 07:18:37', '2025-11-05 11:44:39', '', '{\"activate\":0,\"admin_style\":\"\",\"colorScheme\":\"\",\"allowTourAutoStart\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"timezone\":\"\",\"a11y_mono\":\"0\",\"a11y_contrast\":\"0\",\"a11y_highlight\":\"0\",\"a11y_font\":\"0\"}', NULL, '0', '', '', '0', ''),
('973', 'APOLLO MAUREEN', 'APOLLO MAUREEN', 'apomoureen@gmail.com', '$2y$10$LQyVtzjefrmwd8gaZ1laSu9lukgmCbHyOaw0vQA2JHpctEKlKsoTu', '0', '0', '2025-10-24 10:16:10', '2025-11-10 17:48:24', '', '{\"activate\":0,\"admin_style\":\"\",\"colorScheme\":\"\",\"allowTourAutoStart\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"timezone\":\"\",\"a11y_mono\":\"0\",\"a11y_contrast\":\"0\",\"a11y_highlight\":\"0\",\"a11y_font\":\"0\"}', NULL, '0', '', '', '0', ''),
('974', 'TolgapaxGL', 'Tolgapax', 'tolgacan@em2.thematinggrounds.com', '$2y$10$0Zlyod7kMuRZ7fagH7ph6e/AgzTgJV5NE7CvX1zKEoxbZkKtdd54O', '1', '0', '2026-01-28 23:43:59', NULL, 'dea081f74faec77f8f57a1044ec2ab8d', '{\"activate\":1}', NULL, '0', '', '', '0', ''),
('975', 'Sandra Leah', 'Cassandra Leah', 'andezandra@gmail.com', '$2y$10$gxN/599PDD1EgeWcVKqlkupR.q3Xq2GsSX6.1YCpzfywrh.aK4RTu', '0', '0', '2026-01-29 09:01:02', '2026-02-19 06:26:23', '', '{\"activate\":1,\"admin_style\":\"\",\"colorScheme\":\"\",\"allowTourAutoStart\":\"\",\"admin_language\":\"\",\"language\":\"\",\"editor\":\"\",\"timezone\":\"\",\"a11y_mono\":\"0\",\"a11y_contrast\":\"0\",\"a11y_highlight\":\"0\",\"a11y_font\":\"0\"}', NULL, '0', '', '', '0', '');
/**ABDB**/CREATE TABLE `#__ucm_content` (
  `core_content_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `core_type_alias` varchar(400) NOT NULL DEFAULT '' COMMENT 'FK to the content types table',
  `core_title` varchar(400) NOT NULL DEFAULT '',
  `core_alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `core_body` mediumtext DEFAULT NULL,
  `core_state` tinyint(4) NOT NULL DEFAULT 0,
  `core_checked_out_time` datetime DEFAULT NULL,
  `core_checked_out_user_id` int(10) unsigned DEFAULT NULL,
  `core_access` int(10) unsigned NOT NULL DEFAULT 0,
  `core_params` text DEFAULT NULL,
  `core_featured` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `core_metadata` varchar(2048) NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `core_created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `core_created_by_alias` varchar(255) NOT NULL DEFAULT '',
  `core_created_time` datetime NOT NULL,
  `core_modified_user_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Most recent user that modified',
  `core_modified_time` datetime NOT NULL,
  `core_language` char(7) NOT NULL DEFAULT '',
  `core_publish_up` datetime DEFAULT NULL,
  `core_publish_down` datetime DEFAULT NULL,
  `core_content_item_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'ID from the individual type table',
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `core_images` text DEFAULT NULL,
  `core_urls` text DEFAULT NULL,
  `core_hits` int(10) unsigned NOT NULL DEFAULT 0,
  `core_version` int(10) unsigned NOT NULL DEFAULT 1,
  `core_ordering` int(11) NOT NULL DEFAULT 0,
  `core_metakey` text DEFAULT NULL,
  `core_metadesc` text DEFAULT NULL,
  `core_catid` int(10) unsigned NOT NULL DEFAULT 0,
  `core_type_id` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`core_content_id`),
  KEY `tag_idx` (`core_state`,`core_access`),
  KEY `idx_access` (`core_access`),
  KEY `idx_alias` (`core_alias`(100)),
  KEY `idx_language` (`core_language`),
  KEY `idx_title` (`core_title`(100)),
  KEY `idx_modified_time` (`core_modified_time`),
  KEY `idx_created_time` (`core_created_time`),
  KEY `idx_content_type` (`core_type_alias`(100)),
  KEY `idx_core_modified_user_id` (`core_modified_user_id`),
  KEY `idx_core_checked_out_user_id` (`core_checked_out_user_id`),
  KEY `idx_core_created_user_id` (`core_created_user_id`),
  KEY `idx_core_type_id` (`core_type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Contains core content data in name spaced fields';
/**ABDB**/INSERT INTO `#__ucm_content`  VALUES 
('1', 'com_content.article', 'Welcome to your blog', 'welcome-to-your-blog', '<p>This is a sample blog posting.</p>\r\n<p>If you log in to the site (the Administrator Login link is on the very bottom of this page) you will be able to edit it and all of the other existing articles. You will also be able to create a new article and make other changes to the site.</p>\r\n<p>As you add and modify articles you will see how your site changes and also how you can customise it in various ways.</p>\r\n<p>Go ahead, you can\'t break it.</p>', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '1', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '957', '', '2022-07-26 13:57:30', '957', '2022-08-14 22:50:25', '*', '2022-07-26 13:57:30', NULL, '3', '122', '{\"image_intro\":\"images\\/sampledata\\/cassiopeia\\/nasa1-1200.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/cassiopeia\\/nasa1-1200.jpg?width=1200&height=400\",\"image_intro_alt\":\"Amazing Andromeda Galaxy\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/sampledata\\/cassiopeia\\/nasa1-400.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/cassiopeia\\/nasa1-400.jpg?width=400&height=400\",\"image_fulltext_alt\":\"\",\"image_fulltext_alt_empty\":\"1\",\"float_fulltext\":\"jl-float-left jl-margin-right\",\"image_fulltext_caption\":\"www.nasa.gov\\/multimedia\\/imagegallery\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '5', '2', '3', '', '', '8', '1'),
('2', 'com_content.article', 'About your home page', 'about-your-home-page', '<p>Your home page is set to display the content like slideshow, image, text, blog content and so on using Gantry layout manager. The Layout Manager in the Gantry-based theme administration interface provides several options for setting up the layout of the theme\'s Outlines.</p>\r\n<p>You can change the content by editing the Home Layout settings in the Layout manager in your site template administrator. Go to System -&gt; Site Template Styles -&gt; here you can see the <strong>Home</strong> layout style, i.e Veno Pro - Home (Template Name - Layout Name).</p>\r\n<p>The layout(Home in this case) consists of several different sections, particles, each with its own set of settings that enable you to customize the behavior and look of your site on the front end.</p>\r\n<p>You can find out all about Layout documentation in Gantry5 <a href=\"https://docs.gantry.org/gantry5/configure/layout-manager\" target=\"_blank\" rel=\"noopener\">Layout Manager</a> Guide.</p>\r\n', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '1', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '957', '', '2022-07-26 13:57:30', '957', '2022-07-27 13:53:07', '*', '2022-07-26 13:57:30', NULL, '4', '124', '{\"image_intro\":\"images\\/sampledata\\/cassiopeia\\/nasa2-1200.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/cassiopeia\\/nasa2-1200.jpg?width=1200&height=400\",\"image_intro_alt\":\"\",\"image_intro_alt_empty\":\"1\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/sampledata\\/cassiopeia\\/nasa2-400.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/cassiopeia\\/nasa2-400.jpg?width=400&height=400\",\"image_fulltext_alt\":\"\",\"image_fulltext_alt_empty\":\"1\",\"float_fulltext\":\"jl-float-left jl-margin-right\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '61', '12', '2', '', '', '8', '1'),
('3', 'com_content.article', 'Your Modules', 'your-modules', '<p>Your site has some commonly used modules already preconfigured. These include:</p>\r\n<ul>\r\n<li>Image (type: Custom), which holds the image beneath the menu. This is a Custom module that you can edit to change the image.</li>\r\n<li>Popular Tags (type: Tags - Popular), which will appear if you use tagging on your articles. Enter a tag in the Tags field when editing.</li>\r\n<li>Older Posts (type: Articles - Category), which lists out articles by categories.</li>\r\n<li>Syndication (type: Syndication Feeds), which allows your readers to read your posts in a news reader.</li>\r\n<li>Login Form (type: Login), which allows your users to access restricted areas of the website.</li>\r\n</ul>\r\n<p>Each of these modules has many options which you can experiment with in the Module Manager in your site Administrator. When you are logged in you can also select the edit icon in the top right corner which will take you to an edit screen for that module. Always be sure to save and close any module you edit.</p>\r\n<p>Joomla! also includes many other modules you can incorporate in your site. As you develop your site you may want to add more modules that you can find at the <a href=\"https://extensions.joomla.org/\">Joomla Extensions Directory.</a></p>', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '1', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '957', '', '2022-07-26 13:57:30', '957', '2022-08-14 22:50:06', '*', '2022-07-26 13:57:30', NULL, '5', '126', '{\"image_intro\":\"images\\/sampledata\\/cassiopeia\\/nasa3-1200.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/cassiopeia\\/nasa3-1200.jpg?width=1200&height=400\",\"image_intro_alt\":\"\",\"image_intro_alt_empty\":\"1\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/sampledata\\/cassiopeia\\/nasa3-400.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/cassiopeia\\/nasa3-400.jpg?width=400&height=400\",\"image_fulltext_alt\":\"Crab Nebula\",\"float_fulltext\":\"jl-float-left jl-margin-right\",\"image_fulltext_caption\":\"www.nasa.gov\\/multimedia\\/imagegallery\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '0', '3', '1', '', '', '8', '1'),
('4', 'com_content.article', 'Your Template', 'your-template', '<p>Templates control the look and feel of your website.</p>\r\n<p>This blog is installed with the Cassiopeia template.</p>\r\n<p>You can edit the options by selecting the Working on Your Site, Template Settings link in the menu which is visible when you log in.</p>\r\n<p>For example you can change the site background colour, highlights colour, site title, site description and title font used.</p>\r\n<p>More options are available in the site administrator. You may also install a new template using the extension manager.</p>', '1', NULL, NULL, '1', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '1', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '957', '', '2022-07-26 13:57:30', '957', '2022-08-14 22:50:54', '*', '2022-07-26 13:57:30', NULL, '6', '128', '{\"image_intro\":\"images\\/sampledata\\/cassiopeia\\/nasa4-1200.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/cassiopeia\\/nasa4-1200.jpg?width=1200&height=400\",\"image_intro_alt\":\"\",\"image_intro_alt_empty\":\"1\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/sampledata\\/cassiopeia\\/nasa4-400.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/cassiopeia\\/nasa4-400.jpg?width=400&height=400\",\"image_fulltext_alt\":\"\",\"image_fulltext_alt_empty\":\"1\",\"float_fulltext\":\"jl-float-left jl-margin-right\",\"image_fulltext_caption\":\"www.nasa.gov\\/multimedia\\/imagegallery\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '1', '2', '0', '', '', '8', '1');
/**ABDB**/CREATE TABLE `#__webauthn_credentials` (
  `id` varchar(1000) NOT NULL COMMENT 'Credential ID',
  `user_id` varchar(128) NOT NULL COMMENT 'User handle',
  `label` varchar(190) NOT NULL COMMENT 'Human readable label',
  `credential` mediumtext NOT NULL COMMENT 'Credential source data, JSON format',
  PRIMARY KEY (`id`(100)),
  KEY `user_id` (`user_id`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__convertforms_conversions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `campaign_id` int(11) NOT NULL,
  `form_id` int(11) NOT NULL,
  `visitor_id` varchar(64) DEFAULT NULL,
  `user_id` int(11) NOT NULL DEFAULT 0,
  `params` mediumtext DEFAULT NULL,
  `state` tinyint(4) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `state` (`state`),
  KEY `created` (`created`),
  KEY `form_id` (`form_id`),
  KEY `campaign_id` (`campaign_id`),
  KEY `user_id` (`user_id`),
  KEY `state_created` (`state`,`created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__convertforms_submission_meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `submission_id` int(11) NOT NULL,
  `meta_type` varchar(100) NOT NULL,
  `meta_key` varchar(100) NOT NULL,
  `meta_value` mediumtext NOT NULL,
  `params` mediumtext DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `submission_id` (`submission_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__convertforms_tasks_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL,
  `created_by` mediumint(9) NOT NULL,
  `task_id` mediumint(9) NOT NULL,
  `payload` text DEFAULT NULL,
  `success` tinyint(1) NOT NULL,
  `errors` text DEFAULT NULL,
  `execution_time` float DEFAULT NULL COMMENT 'The time the action took to finish in seconds',
  `ref_type` varchar(100) DEFAULT 'submission',
  `ref_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__modules_menu` (
  `moduleid` int(11) NOT NULL DEFAULT 0,
  `menuid` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`moduleid`,`menuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__modules_menu`  VALUES 
('1', '0'),
('2', '0'),
('3', '0'),
('4', '0'),
('6', '0'),
('7', '0'),
('8', '0'),
('9', '0'),
('10', '0'),
('12', '0'),
('14', '0'),
('15', '0'),
('16', '129'),
('17', '0'),
('79', '0'),
('86', '0'),
('87', '0'),
('88', '0'),
('89', '0'),
('90', '0'),
('91', '0'),
('92', '0'),
('93', '0'),
('94', '0'),
('95', '0'),
('96', '0'),
('97', '0'),
('98', '0'),
('99', '0'),
('100', '0'),
('101', '0'),
('102', '0'),
('103', '0'),
('104', '0'),
('105', '0'),
('106', '0'),
('107', '0'),
('108', '0'),
('109', '0'),
('110', '0'),
('111', '0'),
('112', '0'),
('113', '101'),
('114', '0'),
('115', '0'),
('116', '0'),
('117', '101'),
('118', '0'),
('119', '0'),
('120', '0'),
('122', '0'),
('123', '0'),
('125', '0'),
('126', '0'),
('127', '0'),
('128', '0'),
('129', '0'),
('130', '0'),
('131', '0'),
('132', '0'),
('133', '0'),
('134', '0'),
('145', '0'),
('150', '0'),
('151', '0'),
('194', '297'),
('208', '303');
/**ABDB**/CREATE TABLE `#__rsform_translations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_id` int(11) NOT NULL,
  `lang_code` varchar(16) NOT NULL,
  `reference` varchar(64) NOT NULL,
  `reference_id` varchar(255) NOT NULL,
  `value` mediumtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `lang_code` (`lang_code`),
  KEY `reference` (`reference`),
  KEY `lang_search` (`form_id`,`lang_code`,`reference`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int(10) unsigned NOT NULL,
  `banner_id` int(10) unsigned NOT NULL,
  `count` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`track_date`,`track_type`,`banner_id`),
  KEY `idx_track_date` (`track_date`),
  KEY `idx_track_type` (`track_type`),
  KEY `idx_banner_id` (`banner_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__rsform_submission_columns` (
  `FormId` int(11) NOT NULL,
  `ColumnName` varchar(255) NOT NULL,
  `ColumnStatic` tinyint(1) NOT NULL,
  PRIMARY KEY (`FormId`,`ColumnName`,`ColumnStatic`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/CREATE TABLE `#__assets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set parent.',
  `lft` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set rgt.',
  `level` int(10) unsigned NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_asset_name` (`name`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=252 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__assets`  VALUES 
('1', '0', '0', '345', '0', 'root.1', 'Root Asset', '{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.api\":{\"8\":1},\"core.login.offline\":{\"6\":1},\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
('2', '1', '1', '2', '1', 'com_admin', 'com_admin', '{}'),
('3', '1', '3', '6', '1', 'com_banners', 'com_banners', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('4', '1', '7', '8', '1', 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
('5', '1', '9', '10', '1', 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
('6', '1', '11', '12', '1', 'com_config', 'com_config', '{}'),
('7', '1', '13', '16', '1', 'com_contact', 'com_contact', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('8', '1', '17', '124', '1', 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.execute.transition\":{\"6\":1,\"5\":1}}'),
('9', '1', '125', '126', '1', 'com_cpanel', 'com_cpanel', '{}'),
('10', '1', '127', '128', '1', 'com_installer', 'com_installer', '{\"core.manage\":{\"7\":0},\"core.delete\":{\"7\":0},\"core.edit.state\":{\"7\":0}}'),
('11', '1', '129', '130', '1', 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1}}'),
('12', '1', '131', '132', '1', 'com_login', 'com_login', '{}'),
('14', '1', '133', '134', '1', 'com_massmail', 'com_massmail', '{}'),
('15', '1', '135', '136', '1', 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}'),
('16', '1', '137', '146', '1', 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1}}'),
('17', '1', '147', '148', '1', 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
('18', '1', '149', '282', '1', 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1}}'),
('19', '1', '283', '286', '1', 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('20', '1', '287', '288', '1', 'com_plugins', 'com_plugins', '{\"core.admin\":{\"7\":1}}'),
('21', '1', '289', '290', '1', 'com_redirect', 'com_redirect', '{\"core.admin\":{\"7\":1}}'),
('23', '1', '291', '292', '1', 'com_templates', 'com_templates', '{\"core.admin\":{\"7\":1}}'),
('24', '1', '297', '300', '1', 'com_users', 'com_users', '{\"core.admin\":{\"7\":1}}'),
('26', '1', '301', '302', '1', 'com_wrapper', 'com_wrapper', '{}'),
('27', '8', '18', '27', '2', 'com_content.category.2', 'Uncategorised', '{}'),
('28', '3', '4', '5', '2', 'com_banners.category.3', 'Uncategorised', '{}'),
('29', '7', '14', '15', '2', 'com_contact.category.4', 'Uncategorised', '{}'),
('30', '19', '284', '285', '2', 'com_newsfeeds.category.5', 'Uncategorised', '{}'),
('32', '24', '298', '299', '2', 'com_users.category.7', 'Uncategorised', '{}'),
('33', '1', '303', '304', '1', 'com_finder', 'com_finder', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('34', '1', '305', '306', '1', 'com_joomlaupdate', 'com_joomlaupdate', '{}'),
('35', '1', '307', '308', '1', 'com_tags', 'com_tags', '{}'),
('36', '1', '309', '310', '1', 'com_contenthistory', 'com_contenthistory', '{}'),
('37', '1', '311', '312', '1', 'com_ajax', 'com_ajax', '{}'),
('38', '1', '313', '314', '1', 'com_postinstall', 'com_postinstall', '{}'),
('39', '18', '150', '151', '2', 'com_modules.module.1', 'Main Menu', '{}'),
('40', '18', '152', '153', '2', 'com_modules.module.2', 'Login', '{}'),
('41', '18', '154', '155', '2', 'com_modules.module.3', 'Popular Articles', '{}'),
('42', '18', '156', '157', '2', 'com_modules.module.4', 'Recently Added Articles', '{}'),
('43', '18', '158', '159', '2', 'com_modules.module.8', 'Toolbar', '{}'),
('44', '18', '160', '161', '2', 'com_modules.module.9', 'Notifications', '{}'),
('45', '18', '162', '163', '2', 'com_modules.module.10', 'Logged-in Users', '{}'),
('46', '18', '164', '165', '2', 'com_modules.module.12', 'Admin Menu', '{}'),
('48', '18', '170', '171', '2', 'com_modules.module.14', 'User Status', '{}'),
('49', '18', '172', '173', '2', 'com_modules.module.15', 'Title', '{}'),
('50', '18', '174', '175', '2', 'com_modules.module.16', 'Login Form', '{}'),
('51', '18', '176', '177', '2', 'com_modules.module.17', 'Breadcrumbs', '{}'),
('52', '18', '178', '179', '2', 'com_modules.module.79', 'Multilanguage status', '{}'),
('53', '18', '182', '183', '2', 'com_modules.module.86', 'Joomla Version', '{}'),
('55', '18', '186', '187', '2', 'com_modules.module.87', 'Sample Data', '{}'),
('56', '8', '28', '45', '2', 'com_content.workflow.1', 'COM_WORKFLOW_BASIC_WORKFLOW', '{}'),
('57', '56', '29', '30', '3', 'com_content.stage.1', 'COM_WORKFLOW_BASIC_STAGE', '{}'),
('58', '56', '31', '32', '3', 'com_content.transition.1', 'UNPUBLISH', '{}'),
('59', '56', '33', '34', '3', 'com_content.transition.2', 'PUBLISH', '{}'),
('60', '56', '35', '36', '3', 'com_content.transition.3', 'TRASH', '{}'),
('61', '56', '37', '38', '3', 'com_content.transition.4', 'ARCHIVE', '{}'),
('62', '56', '39', '40', '3', 'com_content.transition.5', 'FEATURE', '{}'),
('63', '56', '41', '42', '3', 'com_content.transition.6', 'UNFEATURE', '{}'),
('64', '56', '43', '44', '3', 'com_content.transition.7', 'PUBLISH_AND_FEATURE', '{}'),
('65', '1', '293', '294', '1', 'com_privacy', 'com_privacy', '{}'),
('66', '1', '295', '296', '1', 'com_actionlogs', 'com_actionlogs', '{}'),
('67', '18', '166', '167', '2', 'com_modules.module.88', 'Latest Actions', '{}'),
('68', '18', '168', '169', '2', 'com_modules.module.89', 'Privacy Dashboard', '{}'),
('70', '18', '180', '181', '2', 'com_modules.module.103', 'Site', '{}'),
('71', '18', '184', '185', '2', 'com_modules.module.104', 'System', '{}'),
('72', '18', '188', '189', '2', 'com_modules.module.91', 'System Dashboard', '{}'),
('73', '18', '190', '191', '2', 'com_modules.module.92', 'Content Dashboard', '{}'),
('74', '18', '192', '193', '2', 'com_modules.module.93', 'Menus Dashboard', '{}'),
('75', '18', '194', '195', '2', 'com_modules.module.94', 'Components Dashboard', '{}'),
('76', '18', '196', '197', '2', 'com_modules.module.95', 'Users Dashboard', '{}'),
('77', '18', '198', '199', '2', 'com_modules.module.99', 'Frontend Link', '{}'),
('78', '18', '200', '201', '2', 'com_modules.module.100', 'Messages', '{}'),
('79', '18', '202', '203', '2', 'com_modules.module.101', 'Post Install Messages', '{}'),
('80', '18', '204', '205', '2', 'com_modules.module.102', 'User Status', '{}'),
('82', '18', '206', '207', '2', 'com_modules.module.105', '3rd Party', '{}'),
('83', '18', '208', '209', '2', 'com_modules.module.106', 'Help Dashboard', '{}'),
('84', '18', '210', '211', '2', 'com_modules.module.107', 'Privacy Requests', '{}'),
('85', '18', '212', '213', '2', 'com_modules.module.108', 'Privacy Status', '{}'),
('86', '18', '214', '215', '2', 'com_modules.module.96', 'Popular Articles', '{}'),
('87', '18', '216', '217', '2', 'com_modules.module.97', 'Recently Added Articles', '{}'),
('88', '18', '218', '219', '2', 'com_modules.module.98', 'Logged-in Users', '{}'),
('89', '18', '220', '221', '2', 'com_modules.module.90', 'Login Support', '{}'),
('90', '1', '315', '316', '1', 'com_scheduler', 'com_scheduler', '{}'),
('91', '8', '46', '49', '2', 'com_content.fieldgroup.1', 'The Author', '{}'),
('92', '91', '47', '48', '3', 'com_content.field.1', 'About the Author', '{}'),
('93', '8', '50', '93', '2', 'com_content.workflow.2', 'Blog Workflow', '{}'),
('94', '93', '51', '52', '3', 'com_content.stage.2', 'Idea', '{}'),
('95', '93', '53', '54', '3', 'com_content.stage.3', 'Copywriting', '{}'),
('96', '93', '55', '56', '3', 'com_content.stage.4', 'Graphic Design', '{}'),
('97', '93', '57', '58', '3', 'com_content.stage.5', 'Fact Check', '{}'),
('98', '93', '59', '60', '3', 'com_content.stage.6', 'Content Review', '{}'),
('99', '93', '61', '62', '3', 'com_content.stage.7', 'Published', '{}'),
('100', '93', '63', '64', '3', 'com_content.stage.8', 'On Hold', '{}'),
('101', '93', '65', '66', '3', 'com_content.stage.9', 'Trashed', '{}'),
('102', '93', '67', '68', '3', 'com_content.stage.10', 'Unpublished', '{}'),
('103', '93', '69', '70', '3', 'com_content.transition.8', 'Write Article', '{}'),
('104', '93', '71', '72', '3', 'com_content.transition.9', 'Graphic Design', '{}'),
('105', '93', '73', '74', '3', 'com_content.transition.10', 'Check Facts', '{}'),
('106', '93', '75', '76', '3', 'com_content.transition.11', 'Review Content', '{}'),
('107', '93', '77', '78', '3', 'com_content.transition.12', 'Edit', '{}'),
('108', '93', '79', '80', '3', 'com_content.transition.13', 'Publish and Feature', '{}'),
('109', '93', '81', '82', '3', 'com_content.transition.14', 'Set on Hold', '{}'),
('110', '93', '83', '84', '3', 'com_content.transition.15', 'TRASH', '{}'),
('111', '93', '85', '86', '3', 'com_content.transition.16', 'Resume Idea', '{}'),
('112', '93', '87', '88', '3', 'com_content.transition.17', 'UNPUBLISH', '{}'),
('113', '93', '89', '90', '3', 'com_content.transition.18', 'TRASH', '{}'),
('114', '93', '91', '92', '3', 'com_content.transition.19', 'Publish again', '{}'),
('115', '8', '94', '103', '2', 'com_content.category.8', 'Blog', '{}'),
('116', '8', '104', '111', '2', 'com_content.category.9', 'Help', '{}'),
('117', '8', '112', '119', '2', 'com_content.category.10', 'Joomla', '{}'),
('118', '8', '120', '123', '2', 'com_content.category.11', 'Typography', '{}'),
('119', '116', '105', '106', '3', 'com_content.article.1', 'About', '{}'),
('120', '116', '107', '108', '3', 'com_content.article.2', 'Working on Your Site', '{}'),
('121', '115', '95', '96', '3', 'com_content.article.3', 'Welcome to your blog', '{}'),
('123', '115', '97', '98', '3', 'com_content.article.4', 'About your home page', '{}'),
('125', '115', '99', '100', '3', 'com_content.article.5', 'Your Modules', '{}'),
('127', '115', '101', '102', '3', 'com_content.article.6', 'Your Template', '{}'),
('129', '117', '113', '114', '3', 'com_content.article.7', 'Millions', '{}'),
('130', '117', '115', '116', '3', 'com_content.article.8', 'Love', '{}'),
('131', '117', '117', '118', '3', 'com_content.article.9', 'Joomla', '{}'),
('132', '116', '109', '110', '3', 'com_content.article.10', 'New feature: Workflows', '{}'),
('133', '118', '121', '122', '3', 'com_content.article.11', 'Typography', '{}'),
('134', '16', '138', '139', '2', 'com_menus.menu.2', 'Main Menu', '{}'),
('135', '16', '140', '141', '2', 'com_menus.menu.3', 'Special Menu', '{}'),
('136', '16', '142', '143', '2', 'com_menus.menu.4', 'Bottom Menu', '{}'),
('137', '18', '222', '223', '2', 'com_modules.module.109', 'Main Menu Blog', '{}'),
('138', '18', '224', '225', '2', 'com_modules.module.110', 'Special Menu', '{}'),
('139', '18', '226', '227', '2', 'com_modules.module.111', 'Syndication', '{}'),
('140', '18', '228', '229', '2', 'com_modules.module.112', 'Archived Articles', '{}'),
('141', '18', '230', '231', '2', 'com_modules.module.113', 'Latest Posts', '{}'),
('142', '18', '232', '233', '2', 'com_modules.module.114', 'Older Posts', '{}'),
('143', '18', '234', '235', '2', 'com_modules.module.115', 'Bottom Menu', '{}'),
('144', '18', '236', '237', '2', 'com_modules.module.116', 'Search', '{}'),
('145', '18', '238', '239', '2', 'com_modules.module.117', 'Image', '{}'),
('146', '18', '240', '241', '2', 'com_modules.module.118', 'Popular Tags', '{}'),
('147', '18', '242', '243', '2', 'com_modules.module.119', 'Similar Items', '{}'),
('148', '18', '244', '245', '2', 'com_modules.module.120', 'Site Information', '{}'),
('149', '18', '246', '247', '2', 'com_modules.module.121', 'Gantry 5 Particle', '{}'),
('150', '1', '325', '326', '1', 'com_gantry5', 'com_gantry5', '{}'),
('151', '1', '327', '328', '1', 'com_akeebabackup', 'com_akeebabackup', '{}'),
('152', '18', '248', '249', '2', 'com_modules.module.122', 'Progress Bar Module 122', '{}'),
('153', '1', '329', '330', '1', 'com_convertforms', 'COM_CONVERTFORMS', '{}'),
('154', '18', '250', '251', '2', 'com_modules.module.123', 'Newsletter', '{}'),
('156', '27', '19', '20', '3', 'com_content.article.12', 'Uikit Overview', '{}'),
('157', '27', '21', '22', '3', 'com_content.article.13', 'Header Layouts', '{}'),
('158', '27', '23', '24', '3', 'com_content.article.14', 'Variations', '{}'),
('159', '27', '25', '26', '3', 'com_content.article.15', 'Offline Page', '{}'),
('160', '18', '252', '253', '2', 'com_modules.module.125', 'Home Feature List', '{}'),
('161', '18', '254', '255', '2', 'com_modules.module.126', 'Header Overlay', '{}'),
('162', '18', '256', '257', '2', 'com_modules.module.127', 'Header Feature Box', '{}'),
('163', '16', '144', '145', '2', 'com_menus.menu.5', 'One Page Menu', '{}'),
('164', '18', '258', '259', '2', 'com_modules.module.128', 'Feature Box Module 128', '{}'),
('165', '18', '260', '261', '2', 'com_modules.module.129', 'Every question has an answer', '{}'),
('166', '18', '262', '263', '2', 'com_modules.module.130', 'Partner Carousel', '{}'),
('167', '18', '264', '265', '2', 'com_modules.module.131', 'Contact form module', '{}'),
('168', '18', '266', '267', '2', 'com_modules.module.132', 'Hello', '{}'),
('169', '1', '331', '332', '1', 'com_guidedtours', 'com_guidedtours', '{}'),
('170', '1', '333', '334', '1', 'com_mails', 'com_mails', '{}'),
('171', '1', '335', '336', '1', 'com_workflow', 'com_workflow', '{}'),
('172', '1', '337', '338', '1', 'com_scheduler.task.1', 'com_scheduler.task.1', '{}'),
('173', '1', '339', '340', '1', 'com_scheduler.task.2', 'com_scheduler.task.2', '{}'),
('174', '1', '341', '342', '1', 'com_scheduler.task.3', 'com_scheduler.task.3', '{}'),
('175', '1', '343', '344', '1', 'com_rsform', 'com_rsform', '{}'),
('176', '18', '268', '269', '2', 'com_modules.module.134', 'Approval Status', '{}'),
('187', '18', '270', '271', '2', 'com_modules.module.145', 'NGO Status', '{}'),
('188', '18', '272', '273', '2', 'com_modules.module.146', 'RSForm! Pro Module List', '{}'),
('192', '18', '274', '275', '2', 'com_modules.module.150', 'RSForm Submissions', '{}'),
('193', '18', '276', '277', '2', 'com_modules.module.151', 'RSForm! Pro Module', '{}'),
('237', '18', '278', '279', '2', 'com_modules.module.194', 'Casual Work Dashboard', '{}'),
('251', '18', '280', '281', '2', 'com_modules.module.208', 'Maids Management System Dashboard', '{}');
/**ABDB**/CREATE TABLE `#__finder_tokens` (
  `term` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `stem` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `common` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `phrase` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `weight` float unsigned NOT NULL DEFAULT 1,
  `context` tinyint(3) unsigned NOT NULL DEFAULT 2,
  `language` char(7) NOT NULL DEFAULT '',
  KEY `idx_word` (`term`),
  KEY `idx_stem` (`stem`),
  KEY `idx_context` (`context`),
  KEY `idx_language` (`language`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__tuf_metadata` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `update_site_id` int(11) DEFAULT 0,
  `root` text DEFAULT NULL,
  `targets` text DEFAULT NULL,
  `snapshot` text DEFAULT NULL,
  `timestamp` text DEFAULT NULL,
  `mirrors` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Secure TUF Updates';
/**ABDB**/INSERT INTO `#__tuf_metadata`  VALUES 
('1', '1', '{\"signed\":{\"_type\":\"root\",\"spec_version\":\"1.0\",\"version\":12,\"expires\":\"2026-12-16T13:18:16Z\",\"keys\":{\"00e432b504508246e2bd536dd6c13e55e8b3256f0be9f767fae26da6c2a28663\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"250f8d293c49817a83909dead96ad82b62f7ac16844cf589f8d2f0e0b15cab21\"}},\"07eb082f367c034a95878687f6648aa76d93652b6ee73e58817053d89af6c44f\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"9b2af2d9b9727227735253d795bd27ea8f0e294a5f3603e822dc5052b44802b9\"}},\"179d107f20a2354ac5bd9a1f32a2df1763c0059617f0c132bebeb4816a1a8637\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"159a4195cbafce2bb959f09ab2b36a2127b8967f94d389f65f1e7892fccfe8b8\"}},\"192ad7343e7d431533d9577fd957b6f924680177db4dc6c0e146dad6810a90a4\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"042b66e1431a1f5c2c15b4a16ea60f23f466851b58e9ff057dbfc2a5e0d821d1\"}},\"1b1b1dd55b2c1c7258714cf1c1ae06f23e4607b28c762d016a9d81c48ffe5669\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"a18e5ebabc19d5d5984b601a292ece61ba3662ab2d071dc520da5bd4f8948799\"}},\"273e94e5477e306ad6de75be1524860e219e265ff9a57c81ababd0691e45706c\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"1cb6702338830ef1c9e76a022fed27172d475bbaace754d8141ebc96dad8b15f\"}},\"2dcaf3d0e552f150792f7c636d45429246dcfa34ac35b46a44f5c87cd17d457e\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"cb0a7a131961a20edea051d6dc2b091fb650bd399bd8514adb67b3c60db9f8f9\"}},\"31dd7c7290d664c9b88c0dead2697175293ea7df81b7f24153a37370fd3901c3\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"589d029a68b470deff1ca16dbf3eea6b5b3fcba0ae7bb52c468abc7fb058b2a2\"}},\"9e41a9d62d94c6a1c8a304f62c5bd72d84a9f286f27e8327cedeacb09e5156cc\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"6043c8bacc76ac5c9750f45454dd865c6ca1fc57d69e14cc192cfd420f6a66a9\"}},\"9eabc37383b243cd236375c66693db385911914b52556e1ec05fc70ed45e1bfe\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"a4b8509488f1c29ab0b1f610e7452fbec78b4f33f1fba5a418d6ff087c567429\"}},\"a1a4b7fdbeedfdeff12d7776de098a2f8de8d2ab7bfe10062a281b3819b078c1\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"ea764b0b475b3c396627ac6689cbd8f54a5f93e87b6f5e3eb44a7ccafb542ff3\"}},\"a599a27a3ec4d520059c591338759dc401006b1c4cb1db85a286e667253d28b6\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"45e416d24d13a60ace5ab028827d5cfc8ba177bb9466bf2acd8efa6e3547911a\"}},\"bfee044dd4574a281c9b7c0b6829913ef292c66c0512d1091a298cfca8493da9\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"6eb44460e5914e8e0df726ddb90bd1f3771b8ce5af19b40fb01ac5a85b023a6f\"}},\"e2229942b0fc1e6d7f82adf258e5bdadac10046d1470b7ec459c9eb4e076026b\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"ad1950e117b29ebe7a38635a2e574123e07571e4f9a011783e053b5f15d2562a\"}},\"ecc851a051c8d6439331ff0a37c7727321fc39896a34f950f73638b8a7cb472e\":{\"keytype\":\"ed25519\",\"scheme\":\"ed25519\",\"keyid_hash_algorithms\":[\"sha256\",\"sha512\"],\"keyval\":{\"public\":\"5d451915bc2b93a0e4e4745bc6a8b292d58996d50e0fb66c78c7827152a65879\"}}},\"roles\":{\"root\":{\"keyids\":[\"1b1b1dd55b2c1c7258714cf1c1ae06f23e4607b28c762d016a9d81c48ffe5669\",\"2dcaf3d0e552f150792f7c636d45429246dcfa34ac35b46a44f5c87cd17d457e\",\"192ad7343e7d431533d9577fd957b6f924680177db4dc6c0e146dad6810a90a4\"],\"threshold\":1},\"snapshot\":{\"keyids\":[\"07eb082f367c034a95878687f6648aa76d93652b6ee73e58817053d89af6c44f\",\"2dcaf3d0e552f150792f7c636d45429246dcfa34ac35b46a44f5c87cd17d457e\",\"ecc851a051c8d6439331ff0a37c7727321fc39896a34f950f73638b8a7cb472e\",\"e2229942b0fc1e6d7f82adf258e5bdadac10046d1470b7ec459c9eb4e076026b\",\"bfee044dd4574a281c9b7c0b6829913ef292c66c0512d1091a298cfca8493da9\",\"9eabc37383b243cd236375c66693db385911914b52556e1ec05fc70ed45e1bfe\",\"273e94e5477e306ad6de75be1524860e219e265ff9a57c81ababd0691e45706c\",\"00e432b504508246e2bd536dd6c13e55e8b3256f0be9f767fae26da6c2a28663\",\"179d107f20a2354ac5bd9a1f32a2df1763c0059617f0c132bebeb4816a1a8637\",\"a1a4b7fdbeedfdeff12d7776de098a2f8de8d2ab7bfe10062a281b3819b078c1\",\"192ad7343e7d431533d9577fd957b6f924680177db4dc6c0e146dad6810a90a4\",\"a599a27a3ec4d520059c591338759dc401006b1c4cb1db85a286e667253d28b6\"],\"threshold\":1},\"targets\":{\"keyids\":[\"31dd7c7290d664c9b88c0dead2697175293ea7df81b7f24153a37370fd3901c3\",\"ecc851a051c8d6439331ff0a37c7727321fc39896a34f950f73638b8a7cb472e\",\"e2229942b0fc1e6d7f82adf258e5bdadac10046d1470b7ec459c9eb4e076026b\",\"bfee044dd4574a281c9b7c0b6829913ef292c66c0512d1091a298cfca8493da9\",\"9eabc37383b243cd236375c66693db385911914b52556e1ec05fc70ed45e1bfe\",\"273e94e5477e306ad6de75be1524860e219e265ff9a57c81ababd0691e45706c\",\"00e432b504508246e2bd536dd6c13e55e8b3256f0be9f767fae26da6c2a28663\",\"179d107f20a2354ac5bd9a1f32a2df1763c0059617f0c132bebeb4816a1a8637\",\"a1a4b7fdbeedfdeff12d7776de098a2f8de8d2ab7bfe10062a281b3819b078c1\"],\"threshold\":1},\"timestamp\":{\"keyids\":[\"9e41a9d62d94c6a1c8a304f62c5bd72d84a9f286f27e8327cedeacb09e5156cc\"],\"threshold\":1}},\"consistent_snapshot\":true},\"signatures\":[{\"keyid\":\"1b1b1dd55b2c1c7258714cf1c1ae06f23e4607b28c762d016a9d81c48ffe5669\",\"sig\":\"566d6aa10932b36ebda6fbb56f17a683c0044cc1e94947fa26f454319e544bf83ccaaca8197874ef51c2eb51ba252297bc1b4f8c6d8b58ed31f30d6d8e100801\"}]}', '{\"signed\":{\"_type\":\"targets\",\"spec_version\":\"1.0\",\"version\":85,\"expires\":\"2026-05-17T16:48:54Z\",\"targets\":{\"Joomla_5.1.2-Stable-Upgrade_Package.zip\":{\"length\":28134889,\"hashes\":{\"sha512\":\"d6b46cdedb9b31d01a607fe4c2f3a830a3265ed6ae5c0cb7b0f836b1b016ee7c639bd8948df00baf1b61a87f2fc71368a80b39e67ef9ec2b8842ee0ab09a620f\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 5.1.2 Release\",\"downloads\":[{\"url\":\"https://downloads.joomla.org/cms/joomla5/5-1-2/Joomla_5.1.2-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/5.1.2/Joomla_5.1.2-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://update.joomla.org/releases/5.1.2/Joomla_5.1.2-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://www.joomla.org/announcements/release-news/5909-joomla-5-1-2-and-joomla-4-4-6-security-and-bug-fix-release.html\",\"title\":\"Joomla! 5.1.2 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 5.1.2\",\"php_minimum\":\"8.1.0\",\"channel\":\"6.x\",\"stability\":\"Stable\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"11.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(5\\\\.[0-4])|^(4\\\\.4)\"},\"type\":\"file\",\"version\":\"5.1.2\"}},\"Joomla_5.3.3-Stable-Update_Package.zip\":{\"length\":29441974,\"hashes\":{\"sha512\":\"396cdba79e1c85138341e00f7e91fcb7d78e6de4126a7f9f76dc5a3973ceaf20dee90bb1b09492669dbaf4d4c9200df46677c09fb7fbd0535d14505d3c7cf3a2\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 5.3.3 Release\",\"downloads\":[{\"url\":\"https://downloads.joomla.org/cms/joomla5/5-3-3/Joomla_5.3.3-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/5.3.3/Joomla_5.3.3-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://update.joomla.org/releases/5.3.3/Joomla_5.3.3-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://www.joomla.org/announcements/release-news/5930-joomla-5-3-3-bugfix-release.html\",\"title\":\"Joomla! 5.3.3 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 5.3.3\",\"php_minimum\":\"8.1.0\",\"channel\":\"5.x\",\"stability\":\"Stable\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"11.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(5\\\\.[0-4])|^(4\\\\.4)\"},\"type\":\"file\",\"version\":\"5.3.3\"}},\"Joomla_5.3.4-Stable-Update_Package.zip\":{\"length\":29854677,\"hashes\":{\"sha512\":\"12a386645464b4f973ec28b40252cca28f56fdbe3f89efa37a4deaebb3334088c427e74bb90fa3068efc2df785a96510befde496f6341bd83f2a1b45b3d693ea\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 5.3.4 Release\",\"downloads\":[{\"url\":\"https://downloads.joomla.org/cms/joomla5/5-3-4/Joomla_5.3.4-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/5.3.4/Joomla_5.3.4-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://update.joomla.org/releases/5.3.4/Joomla_5.3.4-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://www.joomla.org/announcements/release-news/5936-joomla-5-3-4-security-bugfix-release.html\",\"title\":\"Joomla! 5.3.4 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 5.3.4\",\"php_minimum\":\"8.1.0\",\"channel\":\"5.x\",\"stability\":\"Stable\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"11.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(5\\\\.[0-4])|^(4\\\\.4)\"},\"type\":\"file\",\"version\":\"5.3.4\"}},\"Joomla_5.4.0-Stable-Update_Package.zip\":{\"length\":29974846,\"hashes\":{\"sha512\":\"c862b2674acd3f7da6062ea2a0defa35c2c5c9091eaf742106f6cf5793d321ed7a9b99901c7ad15845cef4e4cb7e2806af64794fdcf5a30b7e1c4db60bcd10ae\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 5.4.0 Release\",\"downloads\":[{\"url\":\"https://downloads.joomla.org/cms/joomla5/5-4-0/Joomla_5.4.0-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/5.4.0/Joomla_5.4.0-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://update.joomla.org/releases/5.4.0/Joomla_5.4.0-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://www.joomla.org/announcements/release-news/5939-joomla-6-0-and-joomla-5-4-are-here.html\",\"title\":\"Joomla! 5.4.0 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 5.4.0\",\"php_minimum\":\"8.1.0\",\"channel\":\"5.x\",\"stability\":\"Stable\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"11.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(5\\\\.[0-4])|^(4\\\\.4)\"},\"type\":\"file\",\"version\":\"5.4.0\"}},\"Joomla_5.4.1-Stable-Update_Package.zip\":{\"length\":30009045,\"hashes\":{\"sha512\":\"aeddd1143cd574ff3f6e9bc7d7c67bf5d21dc1b404d98498a691b1fff12f5d245b48424f97155f20e2807e4ee2c1aed7313fae3ab8c0d27a08a20947c166c43e\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 5.4.1 Release\",\"downloads\":[{\"url\":\"https://downloads.joomla.org/cms/joomla5/5-4-1/Joomla_5.4.1-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/5.4.1/Joomla_5.4.1-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://update.joomla.org/releases/5.4.1/Joomla_5.4.1-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://www.joomla.org/announcements/release-news/5941-joomla-6-0-1-and-5-4-1-bugfix-release.html\",\"title\":\"Joomla! 5.4.1 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 5.4.1\",\"php_minimum\":\"8.1.0\",\"channel\":\"5.x\",\"stability\":\"Stable\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"11.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(5\\\\.[0-4])|^(4\\\\.4)\"},\"type\":\"file\",\"version\":\"5.4.1\"}},\"Joomla_5.4.1-rc1-Release_Candidate-Update_Package.zip\":{\"length\":30010108,\"hashes\":{\"sha512\":\"facfd83e03d245c474ca166ebb0bf9635e7b225177c5dd96e18686db67dcd778a68cfaf346cc363761b1df4e5ad3f2d7870f0ea21ecc1a6fbbb46d85a40a00e1\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 5.4.1-rc1 Release\",\"downloads\":[{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/5.4.1-rc1/Joomla_5.4.1-rc1-Release_Candidate-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://github.com/joomla/joomla-cms/releases/tag/5.4.1\",\"title\":\"Joomla! 5.4.1-rc1 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 5.4.1-rc1\",\"php_minimum\":\"8.1.0\",\"channel\":\"5.x\",\"stability\":\"RC\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"11.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(5\\\\.[0-4])|^(4\\\\.4)\"},\"type\":\"file\",\"version\":\"5.4.1-rc1\"}},\"Joomla_5.4.1-rc2-Release_Candidate-Update_Package.zip\":{\"length\":30009059,\"hashes\":{\"sha512\":\"9345d1d34e6ae6fd7611bff6c164638df2ad07dbdd985d20f3aec0072147d4aebe74f87c0eaf7e767aa5d8232a624ff1db87bc2950d7d83027bb693a17504a20\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 5.4.1-rc2 Release\",\"downloads\":[{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/5.4.1-rc2/Joomla_5.4.1-rc2-Release_Candidate-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://github.com/joomla/joomla-cms/releases/tag/5.4.1-rc2\",\"title\":\"Joomla! 5.4.1-rc2 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 5.4.1-rc2\",\"php_minimum\":\"8.1.0\",\"channel\":\"5.x\",\"stability\":\"RC\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"11.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(5\\\\.[0-4])|^(4\\\\.4)\"},\"type\":\"file\",\"version\":\"5.4.1-rc2\"}},\"Joomla_5.4.2-Stable-Update_Package.zip\":{\"length\":30316442,\"hashes\":{\"sha512\":\"e83add95a43103ec2d6ccada9e33a29fa6feb2d8e27b6bd16376f4a75d9b588c029b1f24c97b0772e3a6eb0e20d2b8e0e3526cf2af242d90c280ef63abeddaa9\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 5.4.2 Release\",\"downloads\":[{\"url\":\"https://downloads.joomla.org/cms/joomla5/5-4-2/Joomla_5.4.2-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/5.4.2/Joomla_5.4.2-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://update.joomla.org/releases/5.4.2/Joomla_5.4.2-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://www.joomla.org/announcements/release-news/5942-joomla-6-0-2-and-5-4-2-security-bugfix-release.html\",\"title\":\"Joomla! 5.4.2 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 5.4.2\",\"php_minimum\":\"8.1.0\",\"channel\":\"5.x\",\"stability\":\"Stable\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"11.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(5\\\\.[0-4])|^(4\\\\.4)\"},\"type\":\"file\",\"version\":\"5.4.2\"}},\"Joomla_5.4.2-rc1-Release_Candidate-Update_Package.zip\":{\"length\":30316061,\"hashes\":{\"sha512\":\"31e53a1a242dfc49fb900e5d6000f6a0235115c13d636d037825b2061df36645da9aa01088d2e33cccb6546fd797a3c76068d5615057d36bc63f06ee5acc2124\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 5.4.2-rc1 Release\",\"downloads\":[{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/5.4.2-rc1/Joomla_5.4.2-rc1-Release_Candidate-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://github.com/joomla/joomla-cms/releases/tag/5.4.2-rc1\",\"title\":\"Joomla! 5.4.2-rc1 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 5.4.2-rc1\",\"php_minimum\":\"8.1.0\",\"channel\":\"5.x\",\"stability\":\"RC\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"11.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(5\\\\.[0-4])|^(4\\\\.4)\"},\"type\":\"file\",\"version\":\"5.4.2-rc1\"}},\"Joomla_5.4.3-Stable-Update_Package.zip\":{\"length\":30403970,\"hashes\":{\"sha512\":\"63901b3cca37a59fe8028e0adb01eda3bb3669dc410c21b1ab7cb040997980c75d2d52b242d053800a542f4d60cf6a15e5fdabc963014c35aef80f6b8b02857f\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 5.4.3 Release\",\"downloads\":[{\"url\":\"https://downloads.joomla.org/cms/joomla5/5-4-3/Joomla_5.4.3-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/5.4.3/Joomla_5.4.3-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://update.joomla.org/releases/5.4.3/Joomla_5.4.3-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://www.joomla.org/announcements/release-news/5943-joomla-6-0-3-and-5-4-3-bugfix-release.html\",\"title\":\"Joomla! 5.4.3 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 5.4.3\",\"php_minimum\":\"8.1.0\",\"channel\":\"5.x\",\"stability\":\"Stable\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"11.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(5\\\\.[0-4])|^(4\\\\.4)\"},\"type\":\"file\",\"version\":\"5.4.3\"}},\"Joomla_5.4.3-rc1-Release_Candidate-Update_Package.zip\":{\"length\":30403996,\"hashes\":{\"sha512\":\"2dbfdae57da5bd411c35e7e484c77984ecd7b67c185410fb9ac8f0970aa9f3071728d6e0151addd1037c4a1ed0dda7aa0fbb35fbf29f26879018b202ae21e8cc\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 5.4.3-rc1 Release\",\"downloads\":[{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/5.4.3-rc1/Joomla_5.4.3-rc1-Release_Candidate-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://github.com/joomla/joomla-cms/releases/tag/5.4.3-rc1\",\"title\":\"Joomla! 5.4.3-rc1 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 5.4.3-rc1\",\"php_minimum\":\"8.1.0\",\"channel\":\"5.x\",\"stability\":\"RC\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"11.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(5\\\\.[0-4])|^(4\\\\.4)\"},\"type\":\"file\",\"version\":\"5.4.3-rc1\"}},\"Joomla_6.0.0-Stable-Update_Package.zip\":{\"length\":30236123,\"hashes\":{\"sha512\":\"ab69bb8305aa23f010695366ef769c99ec5a32343afbb418b6ed03c9ca541ad0222136d3a7ed4a8989f33d638ffdfc4c551e96250e0dbaa3fe45f2c2e8825018\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 6.0.0 Release\",\"downloads\":[{\"url\":\"https://downloads.joomla.org/cms/joomla6/6-0-0/Joomla_6.0.0-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/6.0.0/Joomla_6.0.0-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://update.joomla.org/releases/6.0.0/Joomla_6.0.0-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://www.joomla.org/announcements/release-news/5939-joomla-6-0-and-joomla-5-4-are-here.html\",\"title\":\"Joomla! 6.0.0 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 6.0.0\",\"php_minimum\":\"8.3.0\",\"channel\":\"6.x\",\"stability\":\"Stable\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"12.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(6\\\\.[0-4])|^(5\\\\.4)\"},\"type\":\"file\",\"version\":\"6.0.0\"}},\"Joomla_6.0.1-Stable-Update_Package.zip\":{\"length\":30247182,\"hashes\":{\"sha512\":\"38f8dd3ff1fd48b9973193a4484591b3b9f4a7516eb7640ff1687d84c81d4dc8cd05f6f58b9f48172bae41a466442f4a5af4a23e3d63869aeb1b05f4fdd6512e\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 6.0.1 Release\",\"downloads\":[{\"url\":\"https://downloads.joomla.org/cms/joomla6/6-0-1/Joomla_6.0.1-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/6.0.1/Joomla_6.0.1-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://update.joomla.org/releases/6.0.1/Joomla_6.0.1-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://www.joomla.org/announcements/release-news/5941-joomla-6-0-1-and-5-4-1-bugfix-release.html\",\"title\":\"Joomla! 6.0.1 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 6.0.1\",\"php_minimum\":\"8.3.0\",\"channel\":\"6.x\",\"stability\":\"Stable\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"12.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(6\\\\.[0-4])|^(5\\\\.4)\"},\"type\":\"file\",\"version\":\"6.0.1\"}},\"Joomla_6.0.1-rc1-Release_Candidate-Update_Package.zip\":{\"length\":30248231,\"hashes\":{\"sha512\":\"fe48586af9382070dd6275885f931d7bb6eca63129e2a252587c7c48ca9d666d3a38f41a0122698f671657a729467f4eef4fde09dfc97dbfb3c633341b568839\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 6.0.1-rc1 Release\",\"downloads\":[{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/6.0.1-rc1/Joomla_6.0.1-rc1-Release_Candidate-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://github.com/joomla/joomla-cms/releases/tag/6.0.1-rc1\",\"title\":\"Joomla! 6.0.1-rc1 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 6.0.1-rc1\",\"php_minimum\":\"8.3.0\",\"channel\":\"6.x\",\"stability\":\"RC\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"12.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(6\\\\.[0-4])|^(5\\\\.4)\"},\"type\":\"file\",\"version\":\"6.0.1-rc1\"}},\"Joomla_6.0.1-rc2-Release_Candidate-Update_Package.zip\":{\"length\":30247185,\"hashes\":{\"sha512\":\"37aa3600138a3e61250060b6650276bccd975d2dd629a0fb074762024a77a2a94197b1424a49785aa1382d48d4526acc59932fe8ac00e1207d30cc9f82544343\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 6.0.1-rc2 Release\",\"downloads\":[{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/6.0.1-rc2/Joomla_6.0.1-rc2-Release_Candidate-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://github.com/joomla/joomla-cms/releases/tag/6.0.1-rc2\",\"title\":\"Joomla! 6.0.1-rc2 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 6.0.1-rc2\",\"php_minimum\":\"8.3.0\",\"channel\":\"6.x\",\"stability\":\"RC\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"12.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(6\\\\.[0-4])|^(5\\\\.4)\"},\"type\":\"file\",\"version\":\"6.0.1-rc2\"}},\"Joomla_6.0.2-Stable-Update_Package.zip\":{\"length\":30555623,\"hashes\":{\"sha512\":\"c0cff255fcf8e0359453c18365f4906afcce115981a5114e3388da583ad192bde320c8bdd191cd8ca4e55ad5585c9c4cd098c2e1661d8a109d37b94340e4b6a6\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 6.0.2 Release\",\"downloads\":[{\"url\":\"https://downloads.joomla.org/cms/joomla6/6-0-2/Joomla_6.0.2-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/6.0.2/Joomla_6.0.2-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://update.joomla.org/releases/6.0.2/Joomla_6.0.2-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://www.joomla.org/announcements/release-news/5942-joomla-6-0-2-and-5-4-2-security-bugfix-release.html\",\"title\":\"Joomla! 6.0.2 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 6.0.2\",\"php_minimum\":\"8.3.0\",\"channel\":\"6.x\",\"stability\":\"Stable\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"12.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(6\\\\.[0-4])|^(5\\\\.4)\"},\"type\":\"file\",\"version\":\"6.0.2\"}},\"Joomla_6.0.2-rc1-Release_Candidate-Update_Package.zip\":{\"length\":30555248,\"hashes\":{\"sha512\":\"298fb6c5510b95ed5be9862d9e574220a7cf638105c210bc64aad6677bb84b524cb02b6a9dbc8ca1d02fa936f410f4ed501b0914feab3eb7620b47e68696aaa4\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 6.0.2-rc1 Release\",\"downloads\":[{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/6.0.2-rc1/Joomla_6.0.2-rc1-Release_Candidate-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://github.com/joomla/joomla-cms/releases/tag/6.0.2-rc1\",\"title\":\"Joomla! 6.0.2-rc1 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 6.0.2-rc1\",\"php_minimum\":\"8.3.0\",\"channel\":\"6.x\",\"stability\":\"RC\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"12.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(6\\\\.[0-4])|^(5\\\\.4)\"},\"type\":\"file\",\"version\":\"6.0.2-rc1\"}},\"Joomla_6.0.3-Stable-Update_Package.zip\":{\"length\":30645479,\"hashes\":{\"sha512\":\"212a681935d260925cbb15e0fa4d9c9e40978aa32ab7137ff1e0775be26eaa6634317521ec8a411aed3f76990758cbe4dcec3c86186458238dc45f8a3886e5dc\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 6.0.3 Release\",\"downloads\":[{\"url\":\"https://downloads.joomla.org/cms/joomla6/6-0-3/Joomla_6.0.3-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/6.0.3/Joomla_6.0.3-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"},{\"url\":\"https://update.joomla.org/releases/6.0.3/Joomla_6.0.3-Stable-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://www.joomla.org/announcements/release-news/5943-joomla-6-0-3-and-5-4-3-bugfix-release.html\",\"title\":\"Joomla! 6.0.3 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 6.0.3\",\"php_minimum\":\"8.3.0\",\"channel\":\"6.x\",\"stability\":\"Stable\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"12.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(6\\\\.[0-4])|^(5\\\\.4)\"},\"type\":\"file\",\"version\":\"6.0.3\"}},\"Joomla_6.0.3-rc1-Release_Candidate-Update_Package.zip\":{\"length\":30645486,\"hashes\":{\"sha512\":\"dd1734db5e01645e4ca2b8e3500922ecee0441014e1c42eb3cc074169d84bf04f6d3eca5bc7ef21ad5c5bb7001df3608b59db3fbe13adb679bbfa0068fbbc9be\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 6.0.3-rc1 Release\",\"downloads\":[{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/6.0.3-rc1/Joomla_6.0.3-rc1-Release_Candidate-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://github.com/joomla/joomla-cms/releases/tag/6.0.3-rc1\",\"title\":\"Joomla! 6.0.3-rc1 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 6.0.3-rc1\",\"php_minimum\":\"8.3.0\",\"channel\":\"6.x\",\"stability\":\"RC\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"12.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(6\\\\.[0-4])|^(5\\\\.4)\"},\"type\":\"file\",\"version\":\"6.0.3-rc1\"}},\"Joomla_6.1.0-alpha1-Alpha-Update_Package.zip\":{\"length\":30430173,\"hashes\":{\"sha512\":\"e229f74cff44e899ed699781a35bebee9a956728b0fbd7236e6c41f3e63df16b72c2355ef4266ec1561ebddcb4a9127979cfe671dd0b6c0912dc0e5214461a70\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 6.1.0-alpha1 Release\",\"downloads\":[{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/6.1.0-alpha1/Joomla_6.1.0-alpha1-Alpha-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://developer.joomla.org/news/1014-joomla-6-1-alpha1-test-the-future-of-joomla.html\",\"title\":\"Joomla! 6.1.0-alpha1 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 6.1.0-alpha1\",\"php_minimum\":\"8.3.0\",\"channel\":\"6.x\",\"stability\":\"Alpha\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"12.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(6\\\\.[0-4])|^(5\\\\.4)\"},\"type\":\"file\",\"version\":\"6.1.0-alpha1\"}},\"Joomla_6.1.0-alpha2-Alpha-Full_Package.zip\":{\"length\":33107068,\"hashes\":{\"sha512\":\"be9711e1bda18981f077369105399eff9e8ab9203cad43d2c5385689e32db7bc6e11f3b5e406194dd9c2d7f5892bb92c6702cf5436badf3d971150ffcfda0a72\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 6.1.0-alpha2 Release\",\"downloads\":[{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/6.1.0-alpha2/Joomla_6.1.0-alpha2-Alpha-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://developer.joomla.org/news/1015-joomla-6-1-alpha2-see-how-its-coming-together.html\",\"title\":\"Joomla! 6.1.0-alpha2 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 6.1.0-alpha2\",\"php_minimum\":\"8.3.0\",\"channel\":\"6.x\",\"stability\":\"Alpha\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"12.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(6\\\\.[0-4])|^(5\\\\.4)\"},\"type\":\"file\",\"version\":\"6.1.0-alpha2\"}},\"Joomla_6.1.0-alpha2-Alpha-Update_Package.zip\":{\"length\":30736927,\"hashes\":{\"sha512\":\"388790c8b32f624e5b33531f4a41eefa85b5273e76e20a847b01c7eaa59367939317581e5f75ade6c024f25894740c9651ce2faaa330ac8a7fb863434c170879\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 6.1.0-alpha2 Release\",\"downloads\":[{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/6.1.0-alpha2/Joomla_6.1.0-alpha2-Alpha-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://developer.joomla.org/news/1015-joomla-6-1-alpha2-see-how-its-coming-together.html\",\"title\":\"Joomla! 6.1.0-alpha2 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 6.1.0-alpha2\",\"php_minimum\":\"8.3.0\",\"channel\":\"6.x\",\"stability\":\"Alpha\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"12.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(6\\\\.[0-4])|^(5\\\\.4)\"},\"type\":\"file\",\"version\":\"6.1.0-alpha2\"}},\"Joomla_6.1.0-alpha3-Alpha-Full_Package.zip\":{\"length\":33216519,\"hashes\":{\"sha512\":\"16eb1fb81ef4b0c2f3ebca14538945d291623f544d77946e556fc2f17561bda55c256be4f56c0f5034609bbc10e7dcbf0995691b0cd613f5dc58658fe964333b\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 6.1.0-alpha3 Release\",\"downloads\":[{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/6.1.0-alpha3/Joomla_6.1.0-alpha3-Alpha-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://developer.joomla.org/news/1018-joomla-6-1-alpha3-wrapping-up-the-alpha-phase.html\",\"title\":\"Joomla! 6.1.0-alpha3 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 6.1.0-alpha3\",\"php_minimum\":\"8.3.0\",\"channel\":\"6.x\",\"stability\":\"Alpha\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"12.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(6\\\\.[0-4])|^(5\\\\.4)\"},\"type\":\"file\",\"version\":\"6.1.0-alpha3\"}},\"Joomla_6.1.0-alpha3-Alpha-Update_Package.zip\":{\"length\":30842460,\"hashes\":{\"sha512\":\"9290f78cdba43c0bbb4e9b812a1e06cd548e6a4e14b51529d50d5acab3fdb4f7ab5cc6828655596159af41962b51f5a14008a26f06e3f9c5b3781f309cb52a19\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 6.1.0-alpha3 Release\",\"downloads\":[{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/6.1.0-alpha3/Joomla_6.1.0-alpha3-Alpha-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://developer.joomla.org/news/1018-joomla-6-1-alpha3-wrapping-up-the-alpha-phase.html\",\"title\":\"Joomla! 6.1.0-alpha3 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 6.1.0-alpha3\",\"php_minimum\":\"8.3.0\",\"channel\":\"6.x\",\"stability\":\"Alpha\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"12.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(6\\\\.[0-4])|^(5\\\\.4)\"},\"type\":\"file\",\"version\":\"6.1.0-alpha3\"}},\"Joomla_6.1.0-beta1-Beta-Update_Package.zip\":{\"length\":31254760,\"hashes\":{\"sha512\":\"eecfdf26696494ab4e3a685aded4ec11391bef9e92deaf6bfac7be96425238c59e2496952ff978450e8e2d3e9ddbee71b578d5f373aacb4bb506c4c17c0bca66\"},\"custom\":{\"client\":\"site\",\"description\":\"Joomla! 6.1.0-beta1 Release\",\"downloads\":[{\"url\":\"https://github.com/joomla/joomla-cms/releases/download/6.1.0-beta1/Joomla_6.1.0-beta1-Beta-Update_Package.zip\",\"format\":\"zip\",\"type\":\"full\"}],\"element\":\"joomla\",\"infourl\":{\"url\":\"https://developer.joomla.org/news/1019-joomla-6-1-beta1-feature-freeze-see-what-made-it.html\",\"title\":\"Joomla! 6.1.0-beta1 Release\"},\"maintainer\":\"Joomla! Production Department\",\"maintainerurl\":\"https://www.joomla.org\",\"name\":\"Joomla! 6.1.0-beta1\",\"php_minimum\":\"8.3.0\",\"channel\":\"6.x\",\"stability\":\"Beta\",\"supported_databases\":{\"mariadb\":\"10.4\",\"mysql\":\"8.0.13\",\"postgresql\":\"12.0\"},\"targetplatform\":{\"name\":\"joomla\",\"version\":\"(6\\\\.[0-4])|^(5\\\\.4)\"},\"type\":\"file\",\"version\":\"6.1.0-beta1\"}}}},\"signatures\":[{\"keyid\":\"a1a4b7fdbeedfdeff12d7776de098a2f8de8d2ab7bfe10062a281b3819b078c1\",\"sig\":\"753a5882aac4717722829e2a1c18c2f1a93e53e03deb16c9ce6508eaa35a00a2be8335a1401904591c2b733788106e28e35f9a5c488f80e3b10eb66cdeeed30a\"},{\"keyid\":\"31dd7c7290d664c9b88c0dead2697175293ea7df81b7f24153a37370fd3901c3\",\"sig\":\"9b306dbf7ed470d452410090b0c02a9b00e66728ea1431f6912ac511f81cc831f1244ad39aa4eaac4d36fad99cba444cd8d4fb90111e657f7498e2d98b63e40c\"}]}', '{\"signed\":{\"_type\":\"snapshot\",\"spec_version\":\"1.0\",\"version\":96,\"expires\":\"2026-09-15T16:50:30Z\",\"meta\":{\"targets.json\":{\"length\":27159,\"hashes\":{\"sha512\":\"fcdff27f1743987981396e0319a5d08a079bd1b7b9d06c46e1b9db6fff347358074f3713ff55d470cb56eedf40b8900b11c22d47fe2a664a1670ead8caa557e2\"},\"version\":85}}},\"signatures\":[{\"keyid\":\"07eb082f367c034a95878687f6648aa76d93652b6ee73e58817053d89af6c44f\",\"sig\":\"de6212e6872976ad58d01d5e4fa0b4031417a015178cfbcaa27d9d1874887793163c93c4198d59680ef396295983d9645b98cb478d2e5473022347074ab2c30f\"}]}', '{\"signed\":{\"_type\":\"timestamp\",\"spec_version\":\"1.0\",\"version\":961,\"expires\":\"2026-02-21T01:06:16Z\",\"meta\":{\"snapshot.json\":{\"length\":532,\"hashes\":{\"sha512\":\"a14ce26f8af8d07b73c9fe6f42fa6eedef1d1a620242a501b455ae5d9a3ff5538f2882e4eab610453a628a23cd4cb8c02c055f65495fbe67fb8b3c841add3370\"},\"version\":96}}},\"signatures\":[{\"keyid\":\"9e41a9d62d94c6a1c8a304f62c5bd72d84a9f286f27e8327cedeacb09e5156cc\",\"sig\":\"f6b21025059913ee042b8920dc20c4e11ef4e904f240cf296535afaf848680e0aebd48389301f9dd89ea624caab6efc23ceadc3ba56dedb62854632eedba9d09\"}]}', NULL);
/**ABDB**/CREATE TABLE `#__ucm_base` (
  `ucm_id` int(10) unsigned NOT NULL,
  `ucm_item_id` int(11) NOT NULL,
  `ucm_type_id` int(11) NOT NULL,
  `ucm_language_id` int(11) NOT NULL,
  PRIMARY KEY (`ucm_id`),
  KEY `idx_ucm_item_id` (`ucm_item_id`),
  KEY `idx_ucm_type_id` (`ucm_type_id`),
  KEY `idx_ucm_language_id` (`ucm_language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__ucm_base`  VALUES 
('1', '3', '1', '0'),
('2', '4', '1', '0'),
('3', '5', '1', '0'),
('4', '6', '1', '0');
/**ABDB**/CREATE TABLE `#__rsform_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `formId` int(11) NOT NULL,
  `connection` tinyint(1) NOT NULL,
  `host` varchar(255) NOT NULL,
  `driver` varchar(16) NOT NULL,
  `port` int(10) NOT NULL,
  `username` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `database` varchar(255) NOT NULL,
  `method` tinyint(1) NOT NULL,
  `table` varchar(255) NOT NULL,
  `data` mediumtext NOT NULL,
  `wheredata` mediumtext NOT NULL,
  `extra` mediumtext NOT NULL,
  `andor` text NOT NULL,
  `ordering` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__banner_clients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL DEFAULT '',
  `contact` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `extrainfo` text NOT NULL,
  `state` tinyint(4) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `metakey` text DEFAULT NULL,
  `own_prefix` tinyint(4) NOT NULL DEFAULT 0,
  `metakey_prefix` varchar(400) NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT -1,
  `track_clicks` tinyint(4) NOT NULL DEFAULT -1,
  `track_impressions` tinyint(4) NOT NULL DEFAULT -1,
  PRIMARY KEY (`id`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0,
  `context` varchar(255) NOT NULL DEFAULT '',
  `group_id` int(10) unsigned NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `label` varchar(255) NOT NULL DEFAULT '',
  `default_value` text DEFAULT NULL,
  `type` varchar(255) NOT NULL DEFAULT 'text',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `state` tinyint(4) NOT NULL DEFAULT 0,
  `required` tinyint(4) NOT NULL DEFAULT 0,
  `only_use_in_subform` tinyint(4) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `params` text NOT NULL,
  `fieldparams` text NOT NULL,
  `language` char(7) NOT NULL DEFAULT '',
  `created_time` datetime NOT NULL,
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL,
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `access` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_user_id` (`created_user_id`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__fields`  VALUES 
('1', '92', 'com_content.article', '1', 'About the Author', 'about-the-author', 'About the Author', '', 'textarea', '', '', '1', '0', '0', NULL, NULL, '0', '{\"hint\":\"\",\"class\":\"\",\"label_class\":\"\",\"show_on\":\"\",\"render_class\":\"\",\"showlabel\":\"1\",\"label_render_class\":\"\",\"display\":\"3\",\"prefix\":\"\",\"suffix\":\"\",\"layout\":\"\",\"display_readonly\":\"2\"}', '{\"rows\":3,\"cols\":80,\"maxlength\":400,\"filter\":\"\"}', '*', '2022-07-26 13:57:30', '957', '2022-07-26 13:57:30', '957', '1');
/**ABDB**/CREATE TABLE `#__rsform_directory_fields` (
  `formId` int(11) NOT NULL,
  `componentId` int(11) NOT NULL,
  `viewable` tinyint(1) NOT NULL,
  `searchable` tinyint(1) NOT NULL,
  `editable` tinyint(1) NOT NULL,
  `indetails` tinyint(1) NOT NULL,
  `incsv` tinyint(1) NOT NULL,
  `sort` tinyint(1) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL,
  UNIQUE KEY `formId` (`formId`,`componentId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `#__rsform_directory_fields`  VALUES 
('3', '-7', '0', '0', '0', '0', '0', '0', '16'),
('3', '-5', '0', '0', '1', '0', '0', '0', '14'),
('3', '-4', '0', '0', '0', '0', '0', '0', '11'),
('3', '-3', '0', '0', '0', '0', '0', '0', '9'),
('3', '-2', '0', '0', '0', '0', '0', '0', '8'),
('3', '-1', '1', '0', '1', '0', '0', '0', '6'),
('3', '24', '1', '0', '1', '0', '0', '0', '3'),
('3', '32', '1', '0', '1', '0', '0', '0', '4'),
('3', '33', '1', '0', '1', '0', '0', '0', '5'),
('3', '34', '1', '0', '1', '0', '0', '0', '7'),
('3', '35', '1', '0', '1', '0', '0', '0', '10'),
('3', '36', '1', '0', '1', '0', '0', '0', '12'),
('3', '37', '1', '0', '1', '0', '0', '0', '13'),
('3', '38', '1', '0', '1', '0', '0', '0', '15'),
('3', '39', '1', '0', '1', '0', '0', '0', '17'),
('3', '40', '1', '0', '1', '0', '0', '0', '18'),
('3', '41', '1', '0', '1', '0', '0', '0', '19'),
('3', '42', '1', '0', '1', '0', '0', '0', '20'),
('3', '43', '1', '0', '1', '0', '0', '0', '21'),
('3', '44', '1', '0', '1', '0', '0', '0', '22'),
('3', '45', '1', '0', '1', '0', '0', '0', '23'),
('3', '59', '1', '0', '1', '0', '0', '0', '2'),
('3', '60', '1', '0', '1', '0', '0', '0', '24'),
('3', '61', '1', '0', '1', '0', '0', '0', '25'),
('3', '62', '1', '0', '1', '0', '0', '0', '26'),
('3', '63', '1', '0', '1', '0', '0', '0', '27'),
('3', '64', '1', '0', '1', '0', '0', '0', '28'),
('3', '65', '1', '0', '1', '0', '0', '0', '29'),
('3', '66', '1', '0', '1', '0', '0', '0', '30'),
('3', '67', '1', '0', '1', '0', '0', '0', '31'),
('3', '68', '1', '0', '1', '0', '0', '0', '32'),
('3', '69', '1', '0', '1', '0', '0', '0', '33'),
('3', '70', '1', '0', '1', '0', '0', '0', '34'),
('3', '71', '1', '0', '1', '0', '0', '0', '35'),
('3', '72', '1', '0', '1', '0', '0', '0', '36'),
('3', '74', '0', '0', '0', '0', '0', '0', '37'),
('3', '75', '0', '0', '0', '0', '0', '0', '37'),
('6', '-7', '0', '0', '0', '1', '1', '0', '20'),
('6', '-5', '0', '0', '0', '1', '1', '0', '19'),
('6', '-4', '0', '0', '0', '1', '1', '0', '18'),
('6', '-3', '0', '0', '0', '1', '1', '0', '17'),
('6', '-2', '0', '0', '0', '1', '1', '0', '16'),
('6', '-1', '0', '0', '0', '1', '1', '0', '15'),
('6', '85', '1', '1', '1', '1', '1', '0', '1'),
('6', '86', '0', '0', '1', '1', '1', '0', '3'),
('6', '88', '1', '0', '1', '1', '1', '0', '5'),
('6', '89', '1', '0', '1', '1', '1', '0', '4'),
('6', '91', '0', '1', '1', '1', '1', '0', '7'),
('6', '92', '0', '0', '1', '1', '1', '0', '6'),
('6', '95', '0', '0', '1', '1', '1', '0', '8'),
('6', '135', '1', '1', '1', '1', '1', '0', '2'),
('6', '138', '0', '1', '1', '1', '1', '0', '9'),
('6', '139', '0', '0', '1', '1', '1', '0', '10'),
('6', '140', '0', '0', '1', '1', '1', '0', '11'),
('6', '145', '0', '0', '1', '1', '1', '0', '12'),
('6', '146', '0', '0', '1', '1', '1', '0', '13'),
('6', '147', '0', '0', '0', '1', '1', '0', '14'),
('7', '-7', '0', '0', '0', '0', '0', '0', '11'),
('7', '-5', '0', '0', '0', '0', '0', '0', '10'),
('7', '-4', '0', '0', '0', '0', '0', '0', '9'),
('7', '-3', '0', '0', '0', '0', '0', '0', '8'),
('7', '-2', '0', '0', '0', '0', '0', '0', '7'),
('7', '-1', '1', '0', '0', '1', '1', '0', '1'),
('7', '148', '0', '0', '0', '0', '0', '0', '6'),
('7', '193', '1', '1', '0', '1', '1', '0', '2'),
('7', '194', '1', '1', '0', '1', '1', '0', '3'),
('7', '195', '1', '0', '0', '1', '1', '0', '4'),
('7', '196', '1', '0', '0', '1', '1', '0', '5'),
('8', '-7', '0', '0', '0', '0', '0', '0', '24'),
('8', '-5', '0', '0', '0', '0', '0', '0', '23'),
('8', '-4', '0', '0', '0', '0', '0', '0', '22'),
('8', '-3', '0', '0', '0', '0', '0', '0', '21'),
('8', '-2', '0', '0', '0', '0', '0', '0', '20'),
('8', '-1', '0', '0', '0', '0', '0', '0', '19'),
('8', '150', '1', '1', '1', '1', '1', '0', '2'),
('8', '158', '0', '0', '1', '1', '1', '0', '3'),
('8', '159', '1', '1', '1', '1', '1', '0', '4'),
('8', '160', '1', '1', '1', '1', '1', '0', '5'),
('8', '161', '0', '0', '1', '1', '1', '0', '7'),
('8', '162', '0', '0', '1', '1', '1', '0', '8'),
('8', '164', '1', '1', '1', '1', '1', '0', '10'),
('8', '165', '0', '0', '1', '1', '1', '0', '11'),
('8', '166', '0', '0', '1', '1', '1', '0', '9'),
('8', '167', '1', '1', '1', '1', '1', '0', '12'),
('8', '168', '0', '0', '1', '1', '1', '0', '13'),
('8', '169', '0', '0', '1', '1', '1', '0', '14'),
('8', '170', '0', '1', '1', '1', '1', '0', '15'),
('8', '171', '0', '0', '1', '1', '1', '0', '16'),
('8', '172', '1', '1', '1', '1', '1', '0', '17'),
('8', '173', '0', '0', '1', '1', '1', '0', '18'),
('8', '174', '1', '0', '1', '1', '1', '0', '1'),
('8', '175', '0', '0', '1', '1', '1', '0', '25'),
('8', '176', '1', '1', '1', '1', '1', '0', '26'),
('8', '177', '0', '0', '0', '0', '0', '0', '27'),
('8', '178', '0', '0', '0', '0', '0', '0', '28'),
('8', '181', '1', '1', '1', '1', '1', '0', '6'),
('8', '182', '1', '1', '1', '1', '1', '0', '29'),
('8', '183', '1', '1', '1', '1', '1', '0', '30'),
('8', '184', '1', '1', '1', '1', '1', '0', '31'),
('8', '185', '0', '1', '1', '1', '1', '0', '32'),
('8', '186', '0', '0', '1', '1', '1', '0', '33'),
('8', '187', '0', '0', '1', '1', '1', '0', '34'),
('8', '188', '0', '0', '1', '1', '1', '0', '35'),
('8', '189', '0', '1', '1', '1', '1', '0', '36'),
('8', '190', '0', '0', '1', '1', '1', '0', '37'),
('8', '191', '0', '0', '1', '1', '1', '0', '38'),
('8', '192', '0', '0', '1', '1', '1', '0', '39'),
('8', '206', '0', '0', '1', '1', '1', '0', '40'),
('8', '207', '0', '0', '1', '1', '1', '0', '41'),
('8', '220', '0', '0', '0', '0', '0', '0', '42'),
('8', '221', '0', '0', '0', '0', '0', '0', '43'),
('8', '224', '0', '0', '0', '0', '0', '0', '44'),
('9', '-7', '0', '0', '0', '0', '0', '0', '9'),
('9', '-5', '0', '0', '0', '0', '0', '0', '8'),
('9', '-4', '0', '0', '0', '0', '0', '0', '7'),
('9', '-3', '0', '0', '0', '0', '0', '0', '6'),
('9', '-2', '0', '0', '0', '0', '0', '0', '5'),
('9', '-1', '1', '0', '0', '1', '1', '0', '1'),
('9', '198', '1', '1', '0', '1', '1', '0', '2'),
('9', '200', '1', '0', '0', '1', '1', '0', '3'),
('9', '202', '0', '0', '0', '0', '0', '0', '4'),
('9', '203', '1', '1', '0', '1', '0', '0', '10'),
('9', '204', '1', '1', '0', '1', '1', '0', '11'),
('9', '205', '1', '0', '0', '1', '1', '0', '12'),
('11', '-7', '0', '0', '0', '0', '0', '0', '9'),
('11', '-5', '0', '0', '0', '0', '0', '0', '8'),
('11', '-4', '0', '0', '0', '0', '0', '0', '7'),
('11', '-3', '0', '0', '0', '0', '0', '0', '6'),
('11', '-2', '0', '0', '0', '0', '0', '0', '5'),
('11', '-1', '1', '0', '0', '1', '1', '0', '1');
/**ABDB**/CREATE TABLE `#__workflow_stages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `workflow_id` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `default` tinyint(4) NOT NULL DEFAULT 0,
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_workflow_id` (`workflow_id`),
  KEY `idx_checked_out` (`checked_out`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_default` (`default`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflow_stages`  VALUES 
('1', '57', '1', '1', '1', 'COM_WORKFLOW_BASIC_STAGE', '', '1', NULL, NULL),
('2', '94', '0', '2', '1', 'Idea', 'Basic stage. Every newly submitted article for Blog.', '0', NULL, NULL),
('3', '95', '0', '2', '1', 'Copywriting', 'Copywriter is at work.', '0', NULL, NULL),
('4', '96', '0', '2', '1', 'Graphic Design', 'Graphic Designer is at work.', '0', NULL, NULL),
('5', '97', '0', '2', '1', 'Fact Check', 'Fact Checker is at work.', '0', NULL, NULL),
('6', '98', '0', '2', '1', 'Content Review', 'The article is reviewed, checked for text, illustration, HTML.', '0', NULL, NULL),
('7', '99', '0', '2', '1', 'Published', 'Online and Published.', '1', NULL, NULL),
('8', '100', '0', '2', '1', 'On Hold', 'On hold, waiting.', '0', NULL, NULL),
('9', '101', '0', '2', '1', 'Trashed', 'Not accepted', '0', NULL, NULL),
('10', '102', '0', '2', '1', 'Unpublished', 'A published article is unpublished and unfeatured', '0', NULL, NULL);
/**ABDB**/CREATE TABLE `#__fields_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0,
  `context` varchar(255) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `note` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `state` tinyint(4) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `params` text NOT NULL,
  `language` char(7) NOT NULL DEFAULT '',
  `created` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `modified` datetime NOT NULL,
  `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
  `access` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__fields_groups`  VALUES 
('1', '91', 'com_content.article', 'The Author', '', '', '1', NULL, NULL, '0', '{\"display_readonly\":\"1\"}', '*', '2022-07-26 13:57:30', '957', '2022-07-26 13:57:30', '957', '1');
/**ABDB**/CREATE TABLE `#__rsform_config` (
  `SettingName` varchar(64) NOT NULL DEFAULT '',
  `SettingValue` text NOT NULL,
  PRIMARY KEY (`SettingName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__rsform_config`  VALUES 
('allow_unsafe', '0'),
('backup.mask', 'backup-{domain}-{date}'),
('calculations.decimal', '.'),
('calculations.nodecimals', '2'),
('calculations.thousands', ','),
('deleteafter.interval', '10'),
('deleteafter.last_run', '1771498714'),
('disposable_domains', ''),
('export.limit', '500'),
('export.mask', 'export-{formId}-{domain}-{date}'),
('global.codemirror', '0'),
('global.date_mask', 'Y-m-d H:i:s'),
('global.default_language', 'en-GB'),
('global.default_layout', 'bootstrap5'),
('global.default_load_layout_framework', '1'),
('global.disable_multilanguage', '0'),
('global.filtering', 'joomla'),
('global.grid_show_caption', '0'),
('global.grid_show_previews', '1'),
('global.modal_width', '0'),
('global.preview_itemid', ''),
('global.register.code', ''),
('google.api_key', ''),
('logging', '1'),
('logging_verbose', '0'),
('request_timeout', '0'),
('use_csrf', '1');
/**ABDB**/CREATE TABLE `#__workflow_transitions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0,
  `workflow_id` int(11) NOT NULL,
  `published` tinyint(4) NOT NULL DEFAULT 0,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `from_stage_id` int(11) NOT NULL,
  `to_stage_id` int(11) NOT NULL,
  `options` text NOT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `checked_out` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_title` (`title`(191)),
  KEY `idx_asset_id` (`asset_id`),
  KEY `idx_checked_out` (`checked_out`),
  KEY `idx_from_stage_id` (`from_stage_id`),
  KEY `idx_to_stage_id` (`to_stage_id`),
  KEY `idx_workflow_id` (`workflow_id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__workflow_transitions`  VALUES 
('1', '58', '1', '1', '1', 'UNPUBLISH', '', '-1', '1', '{\"publishing\":\"0\"}', NULL, NULL),
('2', '59', '2', '1', '1', 'PUBLISH', '', '-1', '1', '{\"publishing\":\"1\"}', NULL, NULL),
('3', '60', '3', '1', '1', 'TRASH', '', '-1', '1', '{\"publishing\":\"-2\"}', NULL, NULL),
('4', '61', '4', '1', '1', 'ARCHIVE', '', '-1', '1', '{\"publishing\":\"2\"}', NULL, NULL),
('5', '62', '5', '1', '1', 'FEATURE', '', '-1', '1', '{\"featuring\":\"1\"}', NULL, NULL),
('6', '63', '6', '1', '1', 'UNFEATURE', '', '-1', '1', '{\"featuring\":\"0\"}', NULL, NULL),
('7', '64', '7', '1', '1', 'PUBLISH_AND_FEATURE', '', '-1', '1', '{\"publishing\":\"1\",\"featuring\":\"1\"}', NULL, NULL),
('8', '103', '0', '2', '1', 'Write Article', 'The content strategist checks any idea which is submitted in category blog. ', '2', '3', '{\"publishing\":0,\"featuring\":0,\"notification_send_mail\":false}', NULL, NULL),
('9', '104', '0', '2', '1', 'Graphic Design', 'The Graphic Designer can now add any illustrations.', '3', '4', '{\"publishing\":0,\"featuring\":0,\"notification_send_mail\":false}', NULL, NULL),
('10', '105', '0', '2', '1', 'Check Facts', 'The article is complete and must be checked by a subject expert.', '4', '5', '{\"publishing\":0,\"featuring\":0,\"notification_send_mail\":false}', NULL, NULL),
('11', '106', '0', '2', '1', 'Review Content', 'The complete article is reviewed.', '5', '6', '{\"publishing\":0,\"featuring\":0,\"notification_send_mail\":false}', NULL, NULL),
('12', '107', '0', '2', '1', 'Edit', 'The article must be reviewed.', '6', '3', '{\"publishing\":0,\"featuring\":0,\"notification_send_mail\":false}', NULL, NULL),
('13', '108', '0', '2', '1', 'Publish and Feature', '', '6', '7', '{\"publishing\":1,\"featuring\":1,\"notification_send_mail\":true,\"notification_text\":\"Article published!\",\"notification_groups\":[\"7\"]}', NULL, NULL),
('14', '109', '0', '2', '1', 'Set on Hold', '', '-1', '8', '{\"publishing\":2,\"featuring\":0,\"notification_send_mail\":false}', NULL, NULL),
('15', '110', '0', '2', '1', 'Trash', '', '2', '9', '{\"publishing\":-2,\"featuring\":0,\"notification_send_mail\":false}', NULL, NULL),
('16', '111', '0', '2', '1', 'Resume Idea', 'An article on hold can be resumed as idea.', '8', '2', '{\"publishing\":0,\"featuring\":0,\"notification_send_mail\":false}', NULL, NULL),
('17', '112', '0', '2', '1', 'Unpublish', 'A published article is unpublished.', '7', '10', '{\"publishing\":0,\"featuring\":0,\"notification_send_mail\":false}', NULL, NULL),
('18', '113', '0', '2', '1', 'Trash', 'Trash a published article.', '7', '9', '{\"publishing\":0,\"featuring\":0,\"notification_send_mail\":false}', NULL, NULL),
('19', '114', '0', '2', '1', 'Publish again', 'Re-activate an unpublished article.', '10', '7', '{\"publishing\":1,\"featuring\":0,\"notification_send_mail\":true,\"notification_text\":\"Article published!\",\"notification_groups\":[\"7\"]}', NULL, NULL);
/**ABDB**/CREATE TABLE `#__schemaorg` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `itemId` int(10) unsigned DEFAULT NULL,
  `context` varchar(100) DEFAULT NULL,
  `schemaType` varchar(100) DEFAULT NULL,
  `schema` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__user_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `catid` int(10) unsigned NOT NULL DEFAULT 0,
  `subject` varchar(100) NOT NULL DEFAULT '',
  `body` text NOT NULL,
  `state` tinyint(4) NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `created_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created_time` datetime NOT NULL,
  `modified_user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `modified_time` datetime NOT NULL,
  `review_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_category_id` (`catid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__convertforms_campaigns` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `state` tinyint(4) NOT NULL DEFAULT 0,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ordering` int(11) NOT NULL DEFAULT 0,
  `service` varchar(50) NOT NULL,
  `params` mediumtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__convertforms_campaigns`  VALUES 
('1', 'Demo Campaign', '1', '0000-00-00 00:00:00', '0', '0', NULL);
/**ABDB**/CREATE TABLE `#__finder_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `mime` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `title` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__finder_types`  VALUES 
('1', 'Category', ''),
('2', 'Contact', ''),
('3', 'Article', ''),
('4', 'News Feed', ''),
('5', 'Tag', '');
/**ABDB**/CREATE TABLE `#__menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menutype` varchar(24) NOT NULL COMMENT 'The type of menu this item belongs to. FK to #__menu_types.menutype',
  `title` varchar(255) NOT NULL COMMENT 'The display title of the menu item.',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL COMMENT 'The SEF alias of the menu item.',
  `note` varchar(255) NOT NULL DEFAULT '',
  `path` varchar(1024) NOT NULL COMMENT 'The computed path of the menu item based on the alias field.',
  `link` varchar(1024) NOT NULL COMMENT 'The actually link the menu item refers to.',
  `type` varchar(16) NOT NULL COMMENT 'The type of link: Component, URL, Alias, Separator',
  `published` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'The published state of the menu link.',
  `parent_id` int(10) unsigned NOT NULL DEFAULT 1 COMMENT 'The parent menu item in the menu tree.',
  `level` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'The relative level in the tree.',
  `component_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to #__extensions.id',
  `checked_out` int(10) unsigned DEFAULT NULL COMMENT 'FK to #__users.id',
  `checked_out_time` datetime DEFAULT NULL COMMENT 'The time the menu item was checked out.',
  `browserNav` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'The click behaviour of the link.',
  `access` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'The access level required to view the menu item.',
  `img` varchar(255) NOT NULL COMMENT 'The image of the menu item.',
  `template_style_id` int(10) unsigned NOT NULL DEFAULT 0,
  `params` text NOT NULL COMMENT 'JSON encoded data for the menu item.',
  `lft` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT 0 COMMENT 'Nested set rgt.',
  `home` tinyint(3) unsigned NOT NULL DEFAULT 0 COMMENT 'Indicates if this menu item is the home or default page.',
  `language` char(7) NOT NULL DEFAULT '',
  `client_id` tinyint(4) NOT NULL DEFAULT 0,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_client_id_parent_id_alias_language` (`client_id`,`parent_id`,`alias`(100),`language`),
  KEY `idx_componentid` (`component_id`,`menutype`,`published`,`access`),
  KEY `idx_menutype` (`menutype`),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_path` (`path`(100)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=317 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__menu`  VALUES 
('1', '', 'Menu_Item_Root', 'root', '', '', '', '', '1', '0', '0', '0', NULL, NULL, '0', '0', '', '0', '', '0', '211', '0', '*', '0', NULL, NULL),
('2', 'main', 'com_banners', 'Banners', '', 'Banners', 'index.php?option=com_banners', 'component', '1', '1', '1', '3', NULL, NULL, '0', '0', 'class:bookmark', '0', '', '1', '10', '0', '*', '1', NULL, NULL),
('3', 'main', 'com_banners', 'Banners', '', 'Banners/Banners', 'index.php?option=com_banners&view=banners', 'component', '1', '2', '2', '3', NULL, NULL, '0', '0', 'class:banners', '0', '', '2', '3', '0', '*', '1', NULL, NULL),
('4', 'main', 'com_banners_categories', 'Categories', '', 'Banners/Categories', 'index.php?option=com_categories&view=categories&extension=com_banners', 'component', '1', '2', '2', '5', NULL, NULL, '0', '0', 'class:banners-cat', '0', '', '4', '5', '0', '*', '1', NULL, NULL),
('5', 'main', 'com_banners_clients', 'Clients', '', 'Banners/Clients', 'index.php?option=com_banners&view=clients', 'component', '1', '2', '2', '3', NULL, NULL, '0', '0', 'class:banners-clients', '0', '', '6', '7', '0', '*', '1', NULL, NULL),
('6', 'main', 'com_banners_tracks', 'Tracks', '', 'Banners/Tracks', 'index.php?option=com_banners&view=tracks', 'component', '1', '2', '2', '3', NULL, NULL, '0', '0', 'class:banners-tracks', '0', '', '8', '9', '0', '*', '1', NULL, NULL),
('7', 'main', 'com_contact', 'Contacts', '', 'Contacts', 'index.php?option=com_contact', 'component', '1', '1', '1', '7', NULL, NULL, '0', '0', 'class:address-book', '0', '', '113', '122', '0', '*', '1', NULL, NULL),
('8', 'main', 'com_contact_contacts', 'Contacts', '', 'Contacts/Contacts', 'index.php?option=com_contact&view=contacts', 'component', '1', '7', '2', '7', NULL, NULL, '0', '0', 'class:contact', '0', '', '114', '115', '0', '*', '1', NULL, NULL),
('9', 'main', 'com_contact_categories', 'Categories', '', 'Contacts/Categories', 'index.php?option=com_categories&view=categories&extension=com_contact', 'component', '1', '7', '2', '5', NULL, NULL, '0', '0', 'class:contact-cat', '0', '', '116', '117', '0', '*', '1', NULL, NULL),
('10', 'main', 'com_newsfeeds', 'News Feeds', '', 'News Feeds', 'index.php?option=com_newsfeeds', 'component', '1', '1', '1', '16', NULL, NULL, '0', '0', 'class:rss', '0', '', '125', '130', '0', '*', '1', NULL, NULL),
('11', 'main', 'com_newsfeeds_feeds', 'Feeds', '', 'News Feeds/Feeds', 'index.php?option=com_newsfeeds&view=newsfeeds', 'component', '1', '10', '2', '16', NULL, NULL, '0', '0', 'class:newsfeeds', '0', '', '126', '127', '0', '*', '1', NULL, NULL),
('12', 'main', 'com_newsfeeds_categories', 'Categories', '', 'News Feeds/Categories', 'index.php?option=com_categories&view=categories&extension=com_newsfeeds', 'component', '1', '10', '2', '5', NULL, NULL, '0', '0', 'class:newsfeeds-cat', '0', '', '128', '129', '0', '*', '1', NULL, NULL),
('13', 'main', 'com_finder', 'Smart Search', '', 'Smart Search', 'index.php?option=com_finder', 'component', '1', '1', '1', '23', NULL, NULL, '0', '0', 'class:search-plus', '0', '', '131', '140', '0', '*', '1', NULL, NULL),
('14', 'main', 'com_tags', 'Tags', '', 'Tags', 'index.php?option=com_tags&view=tags', 'component', '1', '1', '1', '25', NULL, NULL, '0', '1', 'class:tags', '0', '', '141', '142', '0', '', '1', NULL, NULL),
('15', 'main', 'com_associations', 'Multilingual Associations', '', 'Multilingual Associations', 'index.php?option=com_associations&view=associations', 'component', '1', '1', '1', '30', NULL, NULL, '0', '0', 'class:language', '0', '', '123', '124', '0', '*', '1', NULL, NULL),
('16', 'main', 'mod_menu_fields', 'Contact Custom Fields', '', 'Contacts/Contact Custom Fields', 'index.php?option=com_fields&context=com_contact.contact', 'component', '1', '7', '2', '29', NULL, NULL, '0', '0', 'class:messages-add', '0', '', '118', '119', '0', '*', '1', NULL, NULL),
('17', 'main', 'mod_menu_fields_group', 'Contact Custom Fields Group', '', 'Contacts/Contact Custom Fields Group', 'index.php?option=com_fields&view=groups&context=com_contact.contact', 'component', '1', '7', '2', '29', NULL, NULL, '0', '0', 'class:messages-add', '0', '', '120', '121', '0', '*', '1', NULL, NULL),
('18', 'main', 'com_finder_index', 'Smart-Search-Index', '', 'Smart Search/Smart-Search-Index', 'index.php?option=com_finder&view=index', 'component', '1', '13', '2', '23', NULL, NULL, '0', '0', 'class:finder', '0', '', '132', '133', '0', '*', '1', NULL, NULL),
('19', 'main', 'com_finder_maps', 'Smart-Search-Maps', '', 'Smart Search/Smart-Search-Maps', 'index.php?option=com_finder&view=maps', 'component', '1', '13', '2', '23', NULL, NULL, '0', '0', 'class:finder-maps', '0', '', '134', '135', '0', '*', '1', NULL, NULL),
('20', 'main', 'com_finder_filters', 'Smart-Search-Filters', '', 'Smart Search/Smart-Search-Filters', 'index.php?option=com_finder&view=filters', 'component', '1', '13', '2', '23', NULL, NULL, '0', '0', 'class:finder-filters', '0', '', '136', '137', '0', '*', '1', NULL, NULL),
('21', 'main', 'com_finder_searches', 'Smart-Search-Searches', '', 'Smart Search/Smart-Search-Searches', 'index.php?option=com_finder&view=searches', 'component', '1', '13', '2', '23', NULL, NULL, '0', '0', 'class:finder-searches', '0', '', '138', '139', '0', '*', '1', NULL, NULL),
('101', 'mainmenu', 'Featured Articles', 'featured-articles', '', 'sample-layouts/featured-articles', 'index.php?option=com_content&view=featured', 'component', '-2', '106', '2', '19', NULL, NULL, '0', '1', ' ', '0', '{\"layout_type\":\"blog\",\"num_leading_articles\":1,\"blog_class_leading\":\"\",\"num_intro_articles\":3,\"blog_class\":\"\",\"num_columns\":\"\",\"multi_column_order\":\"\",\"num_links\":0,\"link_intro_image\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"front\",\"order_date\":\"\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"1\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"1\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\"}', '94', '95', '0', '*', '0', NULL, NULL),
('103', 'mainmenu', 'Help', 'help', '', 'help', 'index.php?option=com_content&view=category&layout=blog&id=9', 'component', '-2', '1', '1', '19', NULL, NULL, '0', '1', ' ', '0', '{\"layout_type\":\"blog\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_category_heading_title_text\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"num_leading_articles\":0,\"blog_class_leading\":\"\",\"num_intro_articles\":4,\"blog_class\":\"boxed\",\"num_columns\":\"\",\"multi_column_order\":\"\",\"num_links\":0,\"show_featured\":\"\",\"link_intro_image\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"\",\"show_pagination_results\":\"1\",\"article_layout\":\"_:default\",\"show_title\":\"\",\"link_titles\":\"0\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_hits\":\"0\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"1\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\"}', '77', '90', '0', '*', '0', NULL, NULL),
('104', 'mainmenu', 'Login', 'login', '', 'sample-layouts/login', 'index.php?option=com_users&view=login', 'component', '-2', '106', '2', '22', NULL, NULL, '0', '5', ' ', '0', '{\"loginredirectchoice\":\"1\",\"login_redirect_url\":\"\",\"login_redirect_menuitem\":\"101\",\"logindescription_show\":\"1\",\"login_description\":\"\",\"login_image\":\"\",\"login_image_alt\":\"\",\"logoutredirectchoice\":\"1\",\"logout_redirect_url\":\"\",\"logout_redirect_menuitem\":\"101\",\"logoutdescription_show\":\"1\",\"logout_description\":\"\",\"logout_image\":\"\",\"logout_image_alt\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\"}', '106', '107', '0', '*', '0', NULL, NULL),
('105', 'mainmenu', 'Logout', 'logout', '', 'logout', 'index.php?option=com_users&view=login&layout=logout&task=user.menulogout', 'component', '1', '1', '1', '22', NULL, NULL, '0', '2', ' ', '0', '{\"logout\":\"129\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\"}', '43', '44', '0', '*', '0', NULL, NULL),
('106', 'mainmenu', 'Sample Layouts', 'sample-layouts', '', 'sample-layouts', '', 'heading', '-2', '1', '1', '0', NULL, NULL, '0', '1', ' ', '0', '{\"layout_type\":\"heading\",\"menu_text\":1,\"show_page_heading\":0,\"secure\":0}', '91', '112', '0', '*', '0', NULL, NULL),
('107', 'mainmenu', 'Typography', 'typography', '', 'help/typography', 'index.php?option=com_content&view=article&id=11&catid=11', 'component', '-2', '103', '2', '19', NULL, NULL, '0', '1', ' ', '0', '{\"show_title\":\"0\",\"link_titles\":\"0\",\"show_intro\":\"1\",\"info_block_position\":\"\",\"info_block_show_title\":\"0\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_hits\":\"0\",\"show_tags\":\"0\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\"}', '82', '83', '0', '*', '0', NULL, NULL),
('108', '1special-menu', 'Create a Post', 'create-a-post', '', 'create-a-post', 'index.php?option=com_content&view=form&layout=edit', 'component', '1', '1', '1', '19', NULL, NULL, '0', '3', ' ', '0', '{\"enable_category\":1,\"catid\":8,\"menu_text\":1,\"show_page_heading\":0,\"secure\":0}', '143', '148', '0', '*', '0', NULL, NULL),
('109', '1special-menu', 'Working on Your Site', 'working-on-your-site', '', 'working-on-your-site', 'index.php?option=com_content&view=article&id=2', 'component', '1', '1', '1', '19', NULL, NULL, '0', '1', ' ', '0', '{\"menu_text\":1,\"show_page_heading\":0,\"secure\":0}', '149', '150', '0', '*', '0', NULL, NULL),
('110', '1special-menu', 'Site Administrator', 'site-administrator', '', 'site-administrator', 'administrator', 'url', '1', '1', '1', '0', NULL, NULL, '1', '3', ' ', '0', '{\"menu_text\":1,\"secure\":0}', '151', '152', '0', '*', '0', NULL, NULL),
('111', '1special-menu', 'Change Password', 'change-password', '', 'change-password', 'index.php?option=com_users&view=profile&layout=edit', 'component', '1', '1', '1', '22', NULL, NULL, '0', '2', ' ', '0', '{\"menu_text\":1,\"show_page_heading\":0,\"secure\":0}', '153', '154', '0', '*', '0', NULL, NULL),
('112', 'mainmenu', 'Log out', 'log-out', '', 'log-out', 'index.php?option=com_users&view=login', 'component', '-2', '1', '1', '22', NULL, NULL, '0', '7', ' ', '0', '{\"loginredirectchoice\":\"1\",\"login_redirect_url\":\"\",\"login_redirect_menuitem\":\"\",\"logindescription_show\":\"1\",\"login_description\":\"\",\"login_image\":\"\",\"login_image_alt\":\"\",\"logoutredirectchoice\":\"1\",\"logout_redirect_url\":\"\",\"logout_redirect_menuitem\":\"\",\"logoutdescription_show\":\"1\",\"logout_description\":\"\",\"logout_image\":\"\",\"logout_image_alt\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"0\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\"}', '155', '156', '0', '*', '0', NULL, NULL),
('113', '2bottom-menu', 'Login', 'login-1', '', 'login-1', 'index.php?Itemid=', 'alias', '1', '1', '1', '0', NULL, NULL, '0', '5', ' ', '0', '{\"aliasoptions\":104,\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"secure\":0}', '157', '158', '0', '*', '0', NULL, NULL),
('114', '2bottom-menu', 'Logout', 'logout-1', '', 'logout-1', 'index.php?Itemid=', 'alias', '1', '1', '1', '0', NULL, NULL, '0', '2', ' ', '0', '{\"aliasoptions\":105,\"alias_redirect\":0,\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"secure\":0}', '159', '160', '0', '*', '0', NULL, NULL),
('115', '2bottom-menu', 'Search', 'search', '', 'search', 'index.php?option=com_finder&view=search', 'component', '1', '1', '1', '23', NULL, NULL, '0', '1', ' ', '0', '{\"show_date_filters\":\"1\",\"show_advanced\":\"\",\"expand_advanced\":\"1\",\"show_taxonomy\":\"1\",\"show_date\":\"1\",\"show_url\":\"1\",\"menu_text\":0,\"menu_show\":0,\"secure\":0}', '161', '162', '0', '*', '0', NULL, NULL),
('116', '1special-menu', 'Site Settings', 'site-settings', '', 'create-a-post/site-settings', 'index.php?option=com_config&view=config', 'component', '1', '108', '2', '20', NULL, NULL, '0', '6', ' ', '0', '{\"menu_text\":1,\"show_page_heading\":0,\"secure\":0}', '144', '145', '0', '*', '0', NULL, NULL),
('117', '1special-menu', 'Template Settings', 'template-settings', '', 'create-a-post/template-settings', 'index.php?option=com_config&view=templates', 'component', '1', '108', '2', '20', NULL, NULL, '0', '6', ' ', '0', '{\"menu_text\":1,\"show_page_heading\":0,\"secure\":0}', '146', '147', '0', '*', '0', NULL, NULL),
('118', 'mainmenu', 'Blog', 'blog', '', 'sample-layouts/blog', 'index.php?option=com_content&view=category&layout=blog&id=8', 'component', '-2', '106', '2', '19', NULL, NULL, '0', '1', ' ', '0', '{\"layout_type\":\"blog\",\"show_category_title\":0,\"num_leading_articles\":1,\"num_intro_articles\":2,\"num_links\":2,\"orderby_sec\":\"front\",\"order_date\":\"published\",\"blog_class_leading\":\"boxed columns-1\",\"blog_class\":\"columns-2\",\"show_pagination\":2,\"show_pagination_results\":1,\"show_category\":0,\"info_bloc_position\":0,\"show_publish_date\":0,\"show_hits\":0,\"show_feed_link\":0,\"menu_text\":1,\"show_page_heading\":0,\"secure\":0}', '92', '93', '0', '*', '0', NULL, NULL),
('119', 'mainmenu', 'Category List', 'category-list', '', 'sample-layouts/category-list', 'index.php?option=com_content&view=category&id=8', 'component', '-2', '106', '2', '19', NULL, NULL, '0', '1', ' ', '0', '{\"menu_text\":1,\"show_page_heading\":1,\"secure\":0}', '96', '97', '0', '*', '0', NULL, NULL),
('120', 'mainmenu', 'Articles', 'articles', '', 'sample-layouts/articles', 'index.php?option=com_content&view=category&layout=blog&id=10', 'component', '-2', '106', '2', '19', NULL, NULL, '0', '1', ' ', '0', '{\"layout_type\":\"blog\",\"show_category_title\":\"\",\"show_description\":\"\",\"show_description_image\":\"\",\"maxLevel\":\"\",\"show_empty_categories\":\"\",\"show_no_articles\":\"\",\"show_category_heading_title_text\":\"\",\"show_subcat_desc\":\"\",\"show_cat_num_articles\":\"\",\"show_cat_tags\":\"\",\"num_leading_articles\":\"\",\"blog_class_leading\":\"\",\"num_intro_articles\":\"\",\"blog_class\":\"\",\"num_columns\":\"\",\"multi_column_order\":\"\",\"num_links\":\"\",\"show_featured\":\"\",\"link_intro_image\":\"\",\"show_subcategory_content\":\"\",\"orderby_pri\":\"\",\"orderby_sec\":\"\",\"order_date\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"article_layout\":\"_:default\",\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_readmore\":\"\",\"show_readmore_title\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"show_feed_link\":\"\",\"feed_summary\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\"}', '98', '105', '0', '*', '0', NULL, NULL),
('121', 'mainmenu', 'About your home page', 'about-your-home-page', '', 'help/about-your-home-page', 'index.php?option=com_content&view=article&id=4', 'component', '-2', '103', '2', '19', NULL, NULL, '0', '1', ' ', '0', '{\"menu_show\":1,\"show_page_heading\":0,\"secure\":0}', '78', '79', '0', '*', '0', NULL, NULL),
('122', 'mainmenu', 'New feature: Workflows', 'new-feature-workflows', '', 'help/new-feature-workflows', 'index.php?option=com_content&view=article&id=10', 'component', '-2', '103', '2', '19', NULL, NULL, '0', '1', ' ', '0', '{\"menu_show\":1,\"show_page_heading\":0,\"secure\":0}', '80', '81', '0', '*', '0', NULL, NULL),
('123', 'mainmenu', 'Millions', 'millions', '', 'sample-layouts/articles/millions', 'index.php?option=com_content&view=article&id=7', 'component', '-2', '120', '3', '19', NULL, NULL, '0', '1', ' ', '0', '{\"menu_show\":1,\"secure\":0}', '99', '100', '0', '*', '0', NULL, NULL),
('124', 'mainmenu', 'Love', 'love', '', 'sample-layouts/articles/love', 'index.php?option=com_content&view=article&id=8', 'component', '-2', '120', '3', '19', NULL, NULL, '0', '1', ' ', '0', '{\"menu_show\":1,\"secure\":0}', '101', '102', '0', '*', '0', NULL, NULL),
('125', 'mainmenu', 'Joomla', 'joomla', '', 'sample-layouts/articles/joomla', 'index.php?option=com_content&view=article&id=9', 'component', '-2', '120', '3', '19', NULL, NULL, '0', '1', ' ', '0', '{\"menu_show\":1,\"secure\":0}', '103', '104', '0', '*', '0', NULL, NULL),
('129', 'mainmenu', 'Home', 'home', '', 'home', 'index.php?option=com_users&view=login', 'component', '1', '1', '1', '22', NULL, NULL, '0', '1', ' ', '14', '{\"loginredirectchoice\":\"0\",\"login_redirect_url\":\"\",\"login_redirect_menuitem\":\"\",\"logindescription_show\":\"1\",\"login_description\":\"Tech - Enabled Workforce Solutions\",\"login_image\":\"\",\"login_image_alt\":\"\",\"logoutredirectchoice\":\"1\",\"logout_redirect_url\":\"\",\"logout_redirect_menuitem\":\"\",\"logoutdescription_show\":\"1\",\"logout_description\":\"\",\"logout_image\":\"\",\"logout_image_alt\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Maids Management System\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '11', '12', '1', '*', '0', NULL, NULL),
('136', 'mainmenu', 'Pricing', 'pricing', '', 'pricing', 'index.php?option=com_gantry5&view=custom', 'component', '-2', '1', '1', '231', NULL, NULL, '0', '1', ' ', '18', '{\"particle\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '55', '56', '0', '*', '0', NULL, NULL),
('137', 'mainmenu', 'Contact', 'contact', '', 'contact', 'index.php?option=com_contact&view=contact&id=1', 'component', '-2', '1', '1', '7', NULL, NULL, '0', '1', ' ', '19', '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"show_name\":\"0\",\"show_tags\":\"\",\"show_info\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"add_mailto_link\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_image\":\"\",\"allow_vcard\":\"\",\"show_misc\":\"\",\"show_articles\":\"\",\"articles_display_num\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '61', '62', '0', '*', '0', NULL, NULL),
('139', 'mainmenu', 'Uikit Typography', 'uikit-typography', '', 'help/uikit-typography', 'index.php?option=com_content&view=article&id=12', 'component', '-2', '103', '2', '19', NULL, NULL, '0', '1', ' ', '0', '{\"show_title\":\"0\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '84', '85', '0', '*', '0', NULL, NULL),
('140', 'mainmenu', 'Header Layouts', 'header-layouts', '', 'help/header-layouts', 'index.php?option=com_content&view=article&id=13', 'component', '-2', '103', '2', '19', NULL, NULL, '0', '1', ' ', '0', '{\"show_title\":\"\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\"}', '86', '87', '0', '*', '0', NULL, NULL),
('141', 'mainmenu', 'Variations', 'variations', '', 'help/variations', 'index.php?option=com_content&view=article&id=14', 'component', '-2', '103', '2', '19', NULL, NULL, '0', '1', ' ', '0', '{\"show_title\":\"0\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\"}', '88', '89', '0', '*', '0', NULL, NULL),
('142', 'mainmenu', 'Error Page', 'error-page', '', 'sample-layouts/error-page', 'index.php/404-error', 'url', '-2', '106', '2', '0', NULL, NULL, '0', '1', ' ', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '108', '109', '0', '*', '0', NULL, NULL),
('143', 'mainmenu', 'Offline Page', 'offline-page', '', 'sample-layouts/offline-page', 'index.php?option=com_content&view=article&id=15', 'component', '-2', '106', '2', '19', NULL, NULL, '0', '1', ' ', '0', '{\"show_title\":\"0\",\"link_titles\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"0\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"0\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_tags\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '110', '111', '0', '*', '0', NULL, NULL),
('144', 'one-page', 'Works', 'works', '', 'works', '#g-header', 'url', '1', '1', '1', '0', NULL, NULL, '0', '1', ' ', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '67', '68', '0', '*', '0', NULL, NULL),
('145', 'one-page', 'About', 'about', '', 'about', '#g-hero', 'url', '1', '1', '1', '0', NULL, NULL, '0', '1', ' ', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '65', '66', '0', '*', '0', NULL, NULL),
('146', 'one-page', 'Services', 'services', '', 'services', '#g-showcase', 'url', '1', '1', '1', '0', NULL, NULL, '0', '1', ' ', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '71', '72', '0', '*', '0', NULL, NULL),
('147', 'one-page', 'Team', 'team', '', 'team', '#g-feature', 'url', '1', '1', '1', '0', NULL, NULL, '0', '1', ' ', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '69', '70', '0', '*', '0', NULL, NULL),
('148', 'one-page', 'Contact us', 'contact-us', '', 'contact-us', '#g-below', 'url', '1', '1', '1', '0', NULL, NULL, '0', '1', ' ', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '75', '76', '0', '*', '0', NULL, NULL),
('149', 'one-page', 'Home', 'home-onepage', '', 'home-onepage', '#g-slideshow', 'url', '1', '1', '1', '0', NULL, NULL, '0', '1', ' ', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '63', '64', '0', '*', '0', NULL, NULL),
('150', 'one-page', 'Core values', 'core-values', '', 'core-values', '#g-container-main', 'url', '1', '1', '1', '0', NULL, NULL, '0', '1', ' ', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '73', '74', '0', '*', '0', NULL, NULL),
('151', '2bottom-menu', 'Tags', 'tags', '', 'tags', 'index.php?option=com_tags&view=tags', 'component', '1', '1', '1', '25', NULL, NULL, '0', '1', ' ', '0', '{\"tag_columns\":4,\"all_tags_description\":\"\",\"all_tags_show_description_image\":\"\",\"all_tags_description_image\":\"\",\"all_tags_description_image_alt\":\"\",\"all_tags_orderby\":\"\",\"all_tags_orderby_direction\":\"\",\"all_tags_show_tag_image\":\"\",\"all_tags_show_tag_description\":\"\",\"all_tags_tag_maximum_characters\":\"\",\"all_tags_show_tag_hits\":\"\",\"maximum\":200,\"filter_field\":\"\",\"show_pagination_limit\":\"\",\"show_pagination\":\"\",\"show_pagination_results\":\"\",\"show_feed_link\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '163', '164', '0', '*', '0', NULL, NULL),
('256', 'main', 'COM_GANTRY5', 'com-gantry5', '', 'com-gantry5', 'index.php?option=com_gantry5', 'component', '1', '1', '1', '231', NULL, NULL, '0', '1', 'class:component', '0', '{}', '165', '170', '0', '', '1', NULL, NULL),
('257', 'main', 'COM_GANTRY5_ADMIN_MENU_THEMES', 'com-gantry5-admin-menu-themes', '', 'com-gantry5/com-gantry5-admin-menu-themes', 'index.php?option=com_gantry5&view=themes', 'component', '1', '256', '2', '231', NULL, NULL, '0', '1', 'class:component', '0', '{}', '166', '167', '0', '', '1', NULL, NULL),
('258', 'main', 'COM_GANTRY5_ADMIN_MENU_THEME', 'com-gantry5-admin-menu-theme', '', 'com-gantry5/com-gantry5-admin-menu-theme', 'index.php?option=com_gantry5', 'component', '1', '256', '2', '231', NULL, NULL, '0', '1', 'class:component', '0', '{}', '168', '169', '0', '', '1', NULL, NULL),
('274', 'main', 'COM_AKEEBABACKUP', 'com-akeebabackup', '', 'com-akeebabackup', 'index.php?option=com_akeebabackup', 'component', '1', '1', '1', '235', NULL, NULL, '0', '1', 'class:component', '0', '{}', '171', '180', '0', '', '1', NULL, NULL),
('275', 'main', 'COM_AKEEBABACKUP_CONTROLPANEL', 'com-akeebabackup-controlpanel', '', 'com-akeebabackup/com-akeebabackup-controlpanel', 'index.php?option=com_akeebabackup&view=Controlpanel', 'component', '1', '274', '2', '235', NULL, NULL, '0', '1', 'class:component', '0', '{}', '172', '173', '0', '', '1', NULL, NULL),
('276', 'main', 'COM_AKEEBABACKUP_CONFIGURATION', 'com-akeebabackup-configuration', '', 'com-akeebabackup/com-akeebabackup-configuration', 'index.php?option=com_akeebabackup&view=Configuration', 'component', '1', '274', '2', '235', NULL, NULL, '0', '1', 'class:component', '0', '{}', '174', '175', '0', '', '1', NULL, NULL),
('277', 'main', 'COM_AKEEBABACKUP_BACKUP', 'com-akeebabackup-backup', '', 'com-akeebabackup/com-akeebabackup-backup', 'index.php?option=com_akeebabackup&view=Backup', 'component', '1', '274', '2', '235', NULL, NULL, '0', '1', 'class:component', '0', '{}', '176', '177', '0', '', '1', NULL, NULL),
('278', 'main', 'COM_AKEEBABACKUP_MANAGE', 'com-akeebabackup-manage', '', 'com-akeebabackup/com-akeebabackup-manage', 'index.php?option=com_akeebabackup&view=Manage', 'component', '1', '274', '2', '235', NULL, NULL, '0', '1', 'class:component', '0', '{}', '178', '179', '0', '', '1', NULL, NULL),
('279', 'main', 'COM_CONVERTFORMS', 'com-convertforms', '', 'com-convertforms', 'index.php?option=com_convertforms', 'component', '1', '1', '1', '240', NULL, NULL, '0', '1', 'class:banners', '0', '{}', '181', '192', '0', '', '1', NULL, NULL),
('280', 'main', 'NR_DASHBOARD', 'nr-dashboard', '', 'com-convertforms/nr-dashboard', 'index.php?option=com_convertforms&view=convertforms', 'component', '1', '279', '2', '240', NULL, NULL, '0', '1', 'class:forms', '0', '{}', '182', '183', '0', '', '1', NULL, NULL),
('281', 'main', 'COM_CONVERTFORMS_FORMS', 'com-convertforms-forms', '', 'com-convertforms/com-convertforms-forms', 'index.php?option=com_convertforms&view=forms', 'component', '1', '279', '2', '240', NULL, NULL, '0', '1', 'class:forms', '0', '{}', '184', '185', '0', '', '1', NULL, NULL),
('282', 'main', 'COM_CONVERTFORMS_CAMPAIGNS', 'com-convertforms-campaigns', '', 'com-convertforms/com-convertforms-campaigns', 'index.php?option=com_convertforms&view=campaigns', 'component', '1', '279', '2', '240', NULL, NULL, '0', '1', 'class:campaigns', '0', '{}', '186', '187', '0', '', '1', NULL, NULL),
('283', 'main', 'COM_CONVERTFORMS_SUBMISSIONS', 'com-convertforms-submissions', '', 'com-convertforms/com-convertforms-submissions', 'index.php?option=com_convertforms&view=conversions', 'component', '1', '279', '2', '240', NULL, NULL, '0', '1', 'class:conversions', '0', '{}', '188', '189', '0', '', '1', NULL, NULL),
('284', 'main', 'COM_CONVERTFORMS_ADDONS', 'com-convertforms-addons', '', 'com-convertforms/com-convertforms-addons', 'index.php?option=com_convertforms&view=addons', 'component', '1', '279', '2', '240', NULL, NULL, '0', '1', 'class:addons', '0', '{}', '190', '191', '0', '', '1', NULL, NULL),
('285', 'main', 'RSFormPro', 'rsformpro', '', 'rsformpro', 'index.php?option=com_rsform', 'component', '1', '1', '1', '300', NULL, NULL, '0', '1', 'class:component', '0', '{}', '193', '208', '0', '', '1', NULL, NULL),
('286', 'main', 'COM_RSFORM_DASHBOARD', 'com-rsform-dashboard', '', 'rsformpro/com-rsform-dashboard', 'index.php?option=com_rsform', 'component', '1', '285', '2', '300', NULL, NULL, '0', '1', 'class:component', '0', '{}', '194', '195', '0', '', '1', NULL, NULL),
('287', 'main', 'COM_RSFORM_MANAGE_FORMS', 'com-rsform-manage-forms', '', 'rsformpro/com-rsform-manage-forms', 'index.php?option=com_rsform&view=forms', 'component', '1', '285', '2', '300', NULL, NULL, '0', '1', 'class:component', '0', '{}', '196', '197', '0', '', '1', NULL, NULL),
('288', 'main', 'COM_RSFORM_MANAGE_SUBMISSIONS', 'com-rsform-manage-submissions', '', 'rsformpro/com-rsform-manage-submissions', 'index.php?option=com_rsform&view=submissions', 'component', '1', '285', '2', '300', NULL, NULL, '0', '1', 'class:component', '0', '{}', '198', '199', '0', '', '1', NULL, NULL),
('289', 'main', 'COM_RSFORM_MANAGE_DIRECTORY_SUBMISSIONS', 'com-rsform-manage-directory-submissions', '', 'rsformpro/com-rsform-manage-directory-submissions', 'index.php?option=com_rsform&view=directory', 'component', '1', '285', '2', '300', NULL, NULL, '0', '1', 'class:component', '0', '{}', '200', '201', '0', '', '1', NULL, NULL),
('290', 'main', 'COM_RSFORM_CONFIGURATION', 'com-rsform-configuration', '', 'rsformpro/com-rsform-configuration', 'index.php?option=com_rsform&view=configuration', 'component', '1', '285', '2', '300', NULL, NULL, '0', '1', 'class:component', '0', '{}', '202', '203', '0', '', '1', NULL, NULL),
('291', 'main', 'COM_RSFORM_BACKUP_SCREEN', 'com-rsform-backup-screen', '', 'rsformpro/com-rsform-backup-screen', 'index.php?option=com_rsform&view=backupscreen', 'component', '1', '285', '2', '300', NULL, NULL, '0', '1', 'class:component', '0', '{}', '204', '205', '0', '', '1', NULL, NULL),
('292', 'main', 'COM_RSFORM_RESTORE_SCREEN', 'com-rsform-restore-screen', '', 'rsformpro/com-rsform-restore-screen', 'index.php?option=com_rsform&view=restorescreen', 'component', '1', '285', '2', '300', NULL, NULL, '0', '1', 'class:component', '0', '{}', '206', '207', '0', '', '1', NULL, NULL),
('293', 'mainmenu', 'Update File', 'update-file', '', 'update-file', 'index.php?option=com_rsform&view=directory', 'component', '-2', '1', '1', '300', NULL, NULL, '0', '8', ' ', '28', '{\"formId\":\"3\",\"lang\":\"\",\"enable_directory\":\"1\",\"alignment\":\"center\",\"show_descriptions\":\"0\",\"show_confirmed\":\"0\",\"show_filtering_result\":\"0\",\"show_all_submissions\":\"0\",\"show_logged_in_submissions\":\"1\",\"userId\":\"\",\"display_num\":\"10\",\"enclosure\":\"\\\"\",\"delimiter\":\",\",\"total_cache\":0,\"default_ordering\":\"SubmissionId\",\"default_direction\":\"desc\",\"filter_glue\":\"OR\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '53', '54', '0', '*', '0', NULL, NULL),
('294', 'mainmenu', 'Edit File', 'edit-file', '', 'edit-file', 'index.php?option=com_rsform&view=directory', 'component', '-2', '1', '1', '300', NULL, NULL, '0', '1', ' ', '0', '{\"formId\":\"3\",\"lang\":\"\",\"enable_directory\":\"1\",\"alignment\":\"center\",\"show_descriptions\":\"1\",\"show_confirmed\":\"0\",\"show_filtering_result\":\"0\",\"show_all_submissions\":\"0\",\"show_logged_in_submissions\":\"1\",\"userId\":\"\",\"display_num\":\"10\",\"enclosure\":\"\\\"\",\"delimiter\":\",\",\"total_cache\":0,\"default_ordering\":\"SubmissionId\",\"default_direction\":\"desc\",\"filter_glue\":\"OR\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '57', '58', '0', '*', '0', NULL, NULL),
('295', 'mainmenu', 'NGO Data', 'ngo-data', '', 'ngo-data', 'index.php?option=com_rsform&view=directory', 'component', '-2', '1', '1', '300', NULL, NULL, '0', '3', ' ', '27', '{\"formId\":\"3\",\"lang\":\"\",\"enable_directory\":\"1\",\"alignment\":\"center\",\"show_descriptions\":\"1\",\"show_confirmed\":\"0\",\"show_filtering_result\":\"0\",\"show_all_submissions\":\"0\",\"show_logged_in_submissions\":\"0\",\"userId\":\"\",\"display_num\":\"100\",\"enclosure\":\"\\\"\",\"delimiter\":\",\",\"total_cache\":0,\"default_ordering\":\"SubmissionId\",\"default_direction\":\"desc\",\"filter_glue\":\"OR\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '59', '60', '0', '*', '0', NULL, NULL),
('296', '1special-menu', 'Register', 'register', '', 'register', 'index.php?option=com_users&view=registration', 'component', '1', '1', '1', '22', NULL, NULL, '0', '1', ' ', '14', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '209', '210', '0', '*', '0', NULL, NULL),
('297', 'mainmenu', 'Moheta Dashboard', 'moheta-dashboard', '', 'dashboard/moheta-dashboard', 'index.php?option=com_gantry5&view=custom', 'component', '-2', '303', '2', '231', NULL, NULL, '0', '9', ' ', '29', '{\"particle\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '28', '29', '0', '*', '0', NULL, NULL),
('298', 'mainmenu', 'Moheta Work Progress', 'moheta-work-progress', '', 'all-works/moheta-work-progress', 'index.php?option=com_rsform&view=rsform&formId=6', 'component', '-2', '302', '2', '300', NULL, NULL, '0', '9', ' ', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '46', '47', '0', '*', '0', NULL, NULL),
('299', 'mainmenu', 'Moheta Supervisor Report', 'moheta-supervisor-report', '', 'all-works/moheta-supervisor-report', 'index.php?option=com_rsform&view=rsform&formId=7', 'component', '-2', '302', '2', '300', '957', '2025-02-20 10:20:22', '0', '9', ' ', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '50', '51', '0', '*', '0', NULL, NULL),
('300', 'mainmenu', 'Moheta Workers', 'moheta-workers', '', 'all-works/moheta-workers', 'index.php?option=com_rsform&view=directory', 'component', '-2', '302', '2', '300', NULL, NULL, '0', '9', ' ', '0', '{\"formId\":\"6\",\"lang\":\"\",\"enable_directory\":\"1\",\"alignment\":\"center\",\"show_descriptions\":\"1\",\"show_confirmed\":\"0\",\"show_filtering_result\":\"0\",\"show_all_submissions\":\"1\",\"show_logged_in_submissions\":\"0\",\"userId\":\"\",\"display_num\":\"10\",\"enclosure\":\"\\\"\",\"delimiter\":\",\",\"total_cache\":0,\"default_ordering\":\"SubmissionId\",\"default_direction\":\"desc\",\"filter_glue\":\"OR\",\"filter_values\":{\"name\":[\"Local_Time\"],\"operator\":[\"contains\"],\"value\":[\"{global:today}\"]},\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '48', '49', '0', '*', '0', NULL, NULL),
('302', 'mainmenu', 'All Works', 'all-works', '', 'all-works', '#', 'url', '-2', '1', '1', '0', NULL, NULL, '0', '1', ' ', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '45', '52', '0', '*', '0', NULL, NULL),
('303', 'mainmenu', 'Dashboard', 'dashboard', '', 'dashboard', 'index.php?option=com_gantry5&view=custom', 'component', '1', '1', '1', '231', NULL, NULL, '0', '1', ' ', '0', '{\"particle\":\"\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '27', '30', '0', '*', '0', NULL, NULL),
('304', 'mainmenu', 'Add Maids', 'add-maids', '', 'add-maids', 'index.php?option=com_rsform&view=rsform&formId=8', 'component', '1', '1', '1', '300', NULL, NULL, '0', '7', ' ', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '25', '26', '0', '*', '0', NULL, NULL),
('305', 'mainmenu', 'All Maids', 'all-maids', '', 'maids/all-maids', 'index.php?option=com_rsform&view=directory', 'component', '1', '306', '2', '300', NULL, NULL, '0', '7', ' ', '0', '{\"formId\":\"8\",\"lang\":\"\",\"enable_directory\":\"1\",\"alignment\":\"center\",\"show_descriptions\":\"1\",\"show_confirmed\":\"0\",\"show_filtering_result\":\"0\",\"show_all_submissions\":\"1\",\"show_logged_in_submissions\":\"0\",\"userId\":\"\",\"display_num\":\"100\",\"enclosure\":\"\\\"\",\"delimiter\":\",\",\"total_cache\":0,\"default_ordering\":\"SubmissionId\",\"default_direction\":\"desc\",\"filter_glue\":\"OR\",\"dynamic_filter_values\":{\"name\":[\"Active_With_Lafab_Solutions\"],\"operator\":[\"is\"],\"value\":[\"Yes\\r\\nNo\\r\\nOnce Worked with Lafab\"]},\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '14', '15', '0', '*', '0', NULL, NULL),
('306', 'mainmenu', 'Maids', 'maids', '', 'maids', '#', 'url', '1', '1', '1', '0', NULL, NULL, '0', '1', ' ', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '13', '24', '0', '*', '0', NULL, NULL),
('307', 'mainmenu', 'Avaliable Maids in Uganda', 'avaliable-maids', '', 'maids/avaliable-maids', 'index.php?option=com_rsform&view=directory', 'component', '1', '306', '2', '300', NULL, NULL, '0', '1', ' ', '30', '{\"formId\":\"8\",\"lang\":\"\",\"enable_directory\":\"1\",\"alignment\":\"center\",\"show_descriptions\":\"1\",\"show_confirmed\":\"0\",\"show_filtering_result\":\"0\",\"show_all_submissions\":\"1\",\"show_logged_in_submissions\":\"0\",\"userId\":\"\",\"display_num\":\"100\",\"enclosure\":\"\\\"\",\"delimiter\":\",\",\"total_cache\":0,\"default_ordering\":\"SubmissionId\",\"default_direction\":\"desc\",\"filter_glue\":\"OR\",\"filter_values\":{\"name\":[\"Status\"],\"operator\":[\"is\"],\"value\":[\"Available\"]},\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"Avaliable Maids in Uganda\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '16', '17', '0', '*', '0', NULL, NULL),
('308', 'mainmenu', 'Today Payments', 'today-payments', '', 'maids/today-payments', 'index.php?option=com_rsform&view=directory', 'component', '1', '306', '2', '300', NULL, NULL, '0', '7', ' ', '14', '{\"formId\":\"8\",\"lang\":\"\",\"enable_directory\":\"1\",\"alignment\":\"center\",\"show_descriptions\":\"1\",\"show_confirmed\":\"0\",\"show_filtering_result\":\"0\",\"show_all_submissions\":\"1\",\"show_logged_in_submissions\":\"0\",\"userId\":\"\",\"display_num\":\"0\",\"enclosure\":\"\\\"\",\"delimiter\":\",\",\"total_cache\":0,\"default_ordering\":\"SubmissionId\",\"default_direction\":\"desc\",\"filter_glue\":\"OR\",\"filter_values\":{\"name\":[\"Date_of_Payment\"],\"operator\":[\"contains\"],\"value\":[\"{global:today}\"]},\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '18', '19', '0', '*', '0', NULL, NULL),
('309', 'mainmenu', 'Warning Payments', 'warning-payments', '', 'maids/warning-payments', 'index.php?option=com_rsform&view=directory', 'component', '1', '306', '2', '300', '957', '2025-02-25 08:37:22', '0', '7', ' ', '14', '{\"formId\":\"8\",\"lang\":\"\",\"enable_directory\":\"1\",\"alignment\":\"center\",\"show_descriptions\":\"1\",\"show_confirmed\":\"0\",\"show_filtering_result\":\"0\",\"show_all_submissions\":\"1\",\"show_logged_in_submissions\":\"0\",\"userId\":\"\",\"display_num\":\"0\",\"enclosure\":\"\\\"\",\"delimiter\":\",\",\"total_cache\":0,\"default_ordering\":\"SubmissionId\",\"default_direction\":\"desc\",\"filter_glue\":\"OR\",\"filter_values\":{\"name\":[\"Date_of_Payment\"],\"operator\":[\"less_than\"],\"value\":[\"{global:today}\"]},\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '20', '21', '0', '*', '0', NULL, NULL),
('310', 'mainmenu', 'Maids Reviews', 'maids-reviews', '', 'maids/maids-reviews', 'index.php?option=com_rsform&view=directory', 'component', '1', '306', '2', '300', NULL, NULL, '0', '7', ' ', '14', '{\"formId\":\"8\",\"lang\":\"\",\"enable_directory\":\"1\",\"alignment\":\"center\",\"show_descriptions\":\"1\",\"show_confirmed\":\"0\",\"show_filtering_result\":\"0\",\"show_all_submissions\":\"1\",\"show_logged_in_submissions\":\"0\",\"userId\":\"\",\"display_num\":\"100\",\"enclosure\":\"\\\"\",\"delimiter\":\",\",\"total_cache\":0,\"default_ordering\":\"SubmissionId\",\"default_direction\":\"desc\",\"filter_glue\":\"OR\",\"filter_values\":{\"name\":[\"\"],\"operator\":[\"is\"],\"value\":[\"\"]},\"dynamic_filter_values\":{\"name\":[\"Active_With_Lafab_Solutions\",\"Maid_Boss_Paid_for_this_Month\",\"Maid_Paid_this_Month\"],\"operator\":[\"is\",\"is\",\"is\"],\"value\":[\"Yes\\r\\nNo\\r\\nOnce Worked with Lafab\",\"Yes\\r\\nNo\",\"Yes\\r\\nNo\"]},\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '22', '23', '0', '*', '0', NULL, NULL),
('311', 'mainmenu', 'Tools', 'tools', '', 'tools', '#', 'url', '1', '1', '1', '0', NULL, NULL, '0', '1', ' ', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu-anchor_rel\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '31', '42', '0', '*', '0', NULL, NULL),
('312', 'mainmenu', 'Maid Payment', 'maid-payment', '', 'tools/maid-payment', 'index.php?option=com_rsform&view=rsform&formId=7', 'component', '1', '311', '2', '300', NULL, NULL, '0', '7', ' ', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '34', '35', '0', '*', '0', NULL, NULL),
('313', 'mainmenu', 'Maids Payment Data', 'maids-payment-data', '', 'tools/maids-payment-data', 'index.php?option=com_rsform&view=directory', 'component', '1', '311', '2', '300', NULL, NULL, '0', '7', ' ', '0', '{\"formId\":\"7\",\"lang\":\"\",\"enable_directory\":\"1\",\"alignment\":\"center\",\"show_descriptions\":\"0\",\"show_confirmed\":\"0\",\"show_filtering_result\":\"0\",\"show_all_submissions\":\"1\",\"show_logged_in_submissions\":\"0\",\"userId\":\"\",\"display_num\":\"100\",\"enclosure\":\"\\\"\",\"delimiter\":\",\",\"total_cache\":0,\"default_ordering\":\"SubmissionId\",\"default_direction\":\"desc\",\"filter_glue\":\"OR\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '36', '37', '0', '*', '0', NULL, NULL),
('314', 'mainmenu', 'Recieved Payment', 'recieved-payment', '', 'tools/recieved-payment', 'index.php?option=com_rsform&view=rsform&formId=9', 'component', '1', '311', '2', '300', NULL, NULL, '0', '7', ' ', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '38', '39', '0', '*', '0', NULL, NULL),
('315', 'mainmenu', 'Recieved Payment Data', 'recieved-payment-data', '', 'tools/recieved-payment-data', 'index.php?option=com_rsform&view=directory', 'component', '1', '311', '2', '300', NULL, NULL, '0', '7', ' ', '0', '{\"formId\":\"9\",\"lang\":\"\",\"enable_directory\":\"1\",\"alignment\":\"center\",\"show_descriptions\":\"0\",\"show_confirmed\":\"0\",\"show_filtering_result\":\"0\",\"show_all_submissions\":\"1\",\"show_logged_in_submissions\":\"0\",\"userId\":\"\",\"display_num\":\"50\",\"enclosure\":\"\\\"\",\"delimiter\":\",\",\"total_cache\":0,\"default_ordering\":\"SubmissionId\",\"default_direction\":\"desc\",\"filter_glue\":\"OR\",\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '40', '41', '0', '*', '0', NULL, NULL),
('316', 'mainmenu', 'Add Maid Agent', 'add-maid-agent', '', 'tools/add-maid-agent', 'index.php?option=com_rsform&view=rsform&formId=11', 'component', '1', '311', '2', '300', NULL, NULL, '0', '7', ' ', '0', '{\"menu-anchor_title\":\"\",\"menu-anchor_css\":\"\",\"menu_icon_css\":\"\",\"menu_image\":\"\",\"menu_image_css\":\"\",\"menu_text\":1,\"menu_show\":1,\"page_title\":\"\",\"show_page_heading\":\"\",\"page_heading\":\"\",\"pageclass_sfx\":\"\",\"menu-meta_description\":\"\",\"robots\":\"\",\"gantry\":1,\"gantry-dropdown_dir\":\"right\",\"gantry-width\":\"auto\",\"gantry-layout\":\"list\",\"gantry-visible\":true,\"gantry-columns\":\"[]\",\"gantry-columns_count\":\"[]\",\"gantry-options\":\"[]\"}', '32', '33', '0', '*', '0', NULL, NULL);/**ABDB**/
/**ABDB**/CREATE TABLE `#__rsform_forms` (
  `FormId` int(11) NOT NULL AUTO_INCREMENT,
  `FormName` text NOT NULL,
  `FormLayout` longtext NOT NULL,
  `GridLayout` mediumtext NOT NULL,
  `FormLayoutName` text NOT NULL,
  `LoadFormLayoutFramework` tinyint(1) NOT NULL DEFAULT 1,
  `FormLayoutAutogenerate` tinyint(1) NOT NULL DEFAULT 1,
  `FormLayoutFlow` tinyint(1) NOT NULL DEFAULT 0,
  `DisableSubmitButton` tinyint(1) NOT NULL DEFAULT 0,
  `RemoveCaptchaLogged` tinyint(1) NOT NULL DEFAULT 0,
  `CSS` mediumtext NOT NULL,
  `JS` mediumtext NOT NULL,
  `FormTitle` text NOT NULL,
  `ShowFormTitle` tinyint(1) NOT NULL DEFAULT 1,
  `Published` tinyint(1) NOT NULL DEFAULT 1,
  `Lang` varchar(32) NOT NULL DEFAULT '',
  `ReturnUrl` text NOT NULL,
  `ShowSystemMessage` tinyint(1) NOT NULL DEFAULT 1,
  `ShowThankyou` tinyint(1) NOT NULL DEFAULT 1,
  `ScrollToThankYou` tinyint(1) NOT NULL DEFAULT 0,
  `ThankYouMessagePopUp` tinyint(1) NOT NULL DEFAULT 0,
  `Thankyou` mediumtext NOT NULL,
  `ShowContinue` tinyint(1) NOT NULL DEFAULT 1,
  `UserEmailText` mediumtext NOT NULL,
  `UserEmailTo` text NOT NULL,
  `UserEmailCC` text NOT NULL,
  `UserEmailBCC` text NOT NULL,
  `UserEmailFrom` text NOT NULL,
  `UserEmailReplyTo` text NOT NULL,
  `UserEmailReplyToName` text NOT NULL,
  `UserEmailFromName` text NOT NULL,
  `UserEmailSubject` text NOT NULL,
  `UserEmailMode` tinyint(1) NOT NULL DEFAULT 1,
  `UserEmailAttach` tinyint(1) NOT NULL,
  `UserEmailAttachFile` text NOT NULL,
  `UserEmailGenerate` tinyint(1) NOT NULL DEFAULT 0,
  `AdminEmailText` mediumtext NOT NULL,
  `AdminEmailTo` text NOT NULL,
  `AdminEmailCC` text NOT NULL,
  `AdminEmailBCC` text NOT NULL,
  `AdminEmailFrom` text NOT NULL,
  `AdminEmailReplyTo` text NOT NULL,
  `AdminEmailReplyToName` text NOT NULL,
  `AdminEmailFromName` text NOT NULL,
  `AdminEmailSubject` text NOT NULL,
  `AdminEmailMode` tinyint(1) NOT NULL DEFAULT 1,
  `AdminEmailGenerate` tinyint(1) NOT NULL DEFAULT 0,
  `DeletionEmailText` mediumtext NOT NULL,
  `DeletionEmailTo` text NOT NULL,
  `DeletionEmailCC` text NOT NULL,
  `DeletionEmailBCC` text NOT NULL,
  `DeletionEmailFrom` text NOT NULL,
  `DeletionEmailReplyTo` text NOT NULL,
  `DeletionEmailReplyToName` text NOT NULL,
  `DeletionEmailFromName` text NOT NULL,
  `DeletionEmailSubject` text NOT NULL,
  `DeletionEmailMode` tinyint(1) NOT NULL DEFAULT 1,
  `ScriptProcess` mediumtext NOT NULL,
  `ScriptProcess2` mediumtext NOT NULL,
  `ScriptBeforeDisplay` mediumtext NOT NULL,
  `ScriptBeforeValidation` mediumtext NOT NULL,
  `ScriptDisplay` mediumtext NOT NULL,
  `UserEmailScript` mediumtext NOT NULL,
  `AdminEmailScript` mediumtext NOT NULL,
  `AdditionalEmailsScript` mediumtext NOT NULL,
  `MetaTitle` tinyint(1) NOT NULL,
  `MetaDesc` text NOT NULL,
  `MetaKeywords` text NOT NULL,
  `Required` varchar(255) NOT NULL DEFAULT '(*)',
  `ErrorMessage` text NOT NULL,
  `MultipleSeparator` varchar(64) NOT NULL DEFAULT '\\n',
  `TextareaNewLines` tinyint(1) NOT NULL DEFAULT 1,
  `CSSClass` varchar(255) NOT NULL,
  `CSSId` varchar(255) NOT NULL DEFAULT 'userForm',
  `CSSName` varchar(255) NOT NULL,
  `CSSAction` text NOT NULL,
  `CSSAdditionalAttributes` text NOT NULL,
  `AjaxValidation` tinyint(1) NOT NULL,
  `ScrollToError` tinyint(1) NOT NULL,
  `Keepdata` tinyint(1) NOT NULL DEFAULT 1,
  `KeepIP` tinyint(1) NOT NULL DEFAULT 1,
  `DeleteSubmissionsAfter` int(11) NOT NULL DEFAULT 0,
  `Backendmenu` tinyint(1) NOT NULL,
  `ConfirmSubmission` tinyint(1) NOT NULL DEFAULT 0,
  `ConfirmSubmissionDefer` text NOT NULL,
  `ConfirmSubmissionUrl` text NOT NULL,
  `Access` varchar(5) NOT NULL,
  `LimitSubmissions` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`FormId`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__rsform_forms`  VALUES 
('1', 'RSFormPro example', '<h2>{global:formtitle}</h2>\n{error}\n<!-- Do not remove this ID, it is used to identify the page so that the pagination script can work correctly -->\n<div class=\"formContainer\" id=\"rsform_{global:formid}_page_0\">\n	<div class=\"row\">\n		<div class=\"col-md-12\">\n			<div class=\"rsform-block rsform-block-header rsform-type-freetext{Header:errorClass}\">\n					{Header:body}\n			</div>\n			<div class=\"row mb-3 rsform-block rsform-block-fullname rsform-type-textbox{FullName:errorClass}\">\n				<label class=\"col-sm-3 col-form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{FullName:descriptionhtml}\" for=\"FullName\">{FullName:caption}<strong class=\"formRequired\">(*)</strong></label>\n				<div class=\"formControls col-sm-9\">\n					{FullName:body}\n					<div><span class=\"formValidation\">{FullName:validation}</span></div>\n				</div>\n			</div>\n			<div class=\"row mb-3 rsform-block rsform-block-email rsform-type-textbox{Email:errorClass}\">\n				<label class=\"col-sm-3 col-form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Email:descriptionhtml}\" for=\"Email\">{Email:caption}<strong class=\"formRequired\">(*)</strong></label>\n				<div class=\"formControls col-sm-9\">\n					{Email:body}\n					<div><span class=\"formValidation\">{Email:validation}</span></div>\n				</div>\n			</div>\n			<div class=\"row mb-3 rsform-block rsform-block-companysize rsform-type-selectlist{CompanySize:errorClass}\">\n				<label class=\"col-sm-3 col-form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{CompanySize:descriptionhtml}\" for=\"CompanySize\">{CompanySize:caption}<strong class=\"formRequired\">(*)</strong></label>\n				<div class=\"formControls col-sm-9\">\n					{CompanySize:body}\n					<div><span class=\"formValidation\">{CompanySize:validation}</span></div>\n				</div>\n			</div>\n			<div class=\"row mb-3 rsform-block rsform-block-position rsform-type-radiogroup{Position:errorClass}\">\n				<label class=\"col-sm-3 col-form-label pt-0 formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Position:descriptionhtml}\" id=\"Position-grouplbl\">{Position:caption}<strong class=\"formRequired\">(*)</strong></label>\n				<div class=\"formControls col-sm-9\" role=\"group\" aria-labelledby=\"Position-grouplbl\">\n					{Position:body}\n					<div><span class=\"formValidation\">{Position:validation}</span></div>\n				</div>\n			</div>\n			<div class=\"row mb-3 rsform-block rsform-block-contactby rsform-type-checkboxgroup{ContactBy:errorClass}\">\n				<label class=\"col-sm-3 col-form-label pt-0 formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{ContactBy:descriptionhtml}\" id=\"ContactBy-grouplbl\">{ContactBy:caption}</label>\n				<div class=\"formControls col-sm-9\" role=\"group\" aria-labelledby=\"ContactBy-grouplbl\">\n					{ContactBy:body}\n					<div><span class=\"formValidation\">{ContactBy:validation}</span></div>\n				</div>\n			</div>\n			<div class=\"row mb-3 rsform-block rsform-block-contactwhen rsform-type-calendar{ContactWhen:errorClass}\">\n				<label class=\"col-sm-3 col-form-label pt-0 formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{ContactWhen:descriptionhtml}\" for=\"txtcal1_0\">{ContactWhen:caption}<strong class=\"formRequired\">(*)</strong></label>\n				<div class=\"formControls col-sm-9\">\n					{ContactWhen:body}\n					<div><span class=\"formValidation\">{ContactWhen:validation}</span></div>\n				</div>\n			</div>\n			<div class=\"row mb-3 rsform-block rsform-block-submit rsform-type-submitbutton{Submit:errorClass}\">\n				<label class=\"col-sm-3 col-form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Submit:descriptionhtml}\">{Submit:caption}</label>\n				<div class=\"formControls col-sm-9\">\n					{Submit:body}\n					<div><span class=\"formValidation\">{Submit:validation}</span></div>\n				</div>\n			</div>\n			<div class=\"rsform-block rsform-block-footer rsform-type-freetext{Footer:errorClass}\">\n					{Footer:body}\n			</div>\n		</div>\n	</div>\n</div>', '[[{\"columns\":[[\"2\",\"1\",\"3\",\"4\",\"5\",\"6\",\"7\",\"8\",\"9\"]],\"sizes\":[\"12\"]}],[]]', 'bootstrap5', '1', '1', '0', '0', '0', '', '', 'RSForm! Pro example', '1', '1', '', '', '1', '1', '0', '0', '<p>Dear {FullName:value},</p><p> thank you for your submission. One of our staff members will contact you by  {ContactBy:value} as soon as possible.</p>', '1', '<p>Dear {FullName:value},</p><p> we received your contact request. Someone will get back to you by {ContactBy:value} soon. </p>', '{Email:value}', '', '', '{global:mailfrom}', '', '', '{global:fromname}', 'Contact confirmation', '1', '0', '', '0', '<p>Customize this e-mail also. You will receive it as administrator. </p><p>{FullName:caption}:{FullName:value}<br />\n{Email:caption}:{Email:value}<br />\n{CompanySize:caption}:{CompanySize:value}<br />\n{Position:caption}:{Position:value}<br />\n{ContactBy:caption}:{ContactBy:value}<br />\n{ContactWhen:caption}:{ContactWhen:value}</p>', 'youradminemail@email.com', '', '', '{global:mailfrom}', '{Email:value}', '', '{FullName:value}', 'Contact', '1', '0', '', '', '', '', '', '', '', '', '', '1', '', '', '', '', '', '', '', '', '0', '', '', '(*)', '', ', ', '1', '', 'userForm', '', '', '', '0', '0', '1', '1', '0', '0', '0', '', '', '', '0'),
('2', 'RSFormPro Multipage example', '<h2>{global:formtitle}</h2>\r\n{error}\r\n<!-- Do not remove this ID, it is used to identify the page so that the pagination script can work correctly -->\r\n<fieldset class=\"formHorizontal formContainer\" id=\"rsform_2_page_0\">\r\n	<div class=\"rsform-block rsform-block-header\">\r\n		<div class=\"formControlLabel\">{Header:caption}</div>\r\n		<div class=\"formControls\">\r\n		<div class=\"formBody\">{Header:body}<span class=\"formValidation\">{Header:validation}</span></div>\r\n		<p class=\"formDescription\">{Header:description}</p>\r\n		</div>\r\n	</div>\r\n	<div class=\"rsform-block rsform-block-fullname\">\r\n		<div class=\"formControlLabel\">{FullName:caption}<strong class=\"formRequired\">(*)</strong></div>\r\n		<div class=\"formControls\">\r\n		<div class=\"formBody\">{FullName:body}<span class=\"formValidation\">{FullName:validation}</span></div>\r\n		<p class=\"formDescription\">{FullName:description}</p>\r\n		</div>\r\n	</div>\r\n	<div class=\"rsform-block rsform-block-email\">\r\n		<div class=\"formControlLabel\">{Email:caption}<strong class=\"formRequired\">(*)</strong></div>\r\n		<div class=\"formControls\">\r\n		<div class=\"formBody\">{Email:body}<span class=\"formValidation\">{Email:validation}</span></div>\r\n		<p class=\"formDescription\">{Email:description}</p>\r\n		</div>\r\n	</div>\r\n	<div class=\"rsform-block rsform-block-page1\">\r\n		<div class=\"formControlLabel\">&nbsp;</div>\r\n		<div class=\"formControls\">\r\n		<div class=\"formBody\">{Page1:body}</div>\r\n		</div>\r\n	</div>\r\n	</fieldset>\r\n<!-- Do not remove this ID, it is used to identify the page so that the pagination script can work correctly -->\r\n<fieldset class=\"formHorizontal formContainer\" id=\"rsform_2_page_1\">\r\n	<div class=\"rsform-block rsform-block-companyheader\">\r\n		<div class=\"formControlLabel\">{CompanyHeader:caption}</div>\r\n		<div class=\"formControls\">\r\n		<div class=\"formBody\">{CompanyHeader:body}<span class=\"formValidation\">{CompanyHeader:validation}</span></div>\r\n		<p class=\"formDescription\">{CompanyHeader:description}</p>\r\n		</div>\r\n	</div>\r\n	<div class=\"rsform-block rsform-block-companysize\">\r\n		<div class=\"formControlLabel\">{CompanySize:caption}<strong class=\"formRequired\">(*)</strong></div>\r\n		<div class=\"formControls\">\r\n		<div class=\"formBody\">{CompanySize:body}<span class=\"formValidation\">{CompanySize:validation}</span></div>\r\n		<p class=\"formDescription\">{CompanySize:description}</p>\r\n		</div>\r\n	</div>\r\n	<div class=\"rsform-block rsform-block-position\">\r\n		<div class=\"formControlLabel\">{Position:caption}<strong class=\"formRequired\">(*)</strong></div>\r\n		<div class=\"formControls\">\r\n		<div class=\"formBody\">{Position:body}<span class=\"formValidation\">{Position:validation}</span></div>\r\n		<p class=\"formDescription\">{Position:description}</p>\r\n		</div>\r\n	</div>\r\n	<div class=\"rsform-block rsform-block-page2\">\r\n		<div class=\"formControlLabel\">&nbsp;</div>\r\n		<div class=\"formControls\">\r\n		<div class=\"formBody\">{Page2:body}</div>\r\n		</div>\r\n	</div>\r\n	</fieldset>\r\n<!-- Do not remove this ID, it is used to identify the page so that the pagination script can work correctly -->\r\n<fieldset class=\"formHorizontal formContainer\" id=\"rsform_2_page_2\">\r\n	<div class=\"rsform-block rsform-block-contactheader\">\r\n		<div class=\"formControlLabel\">{ContactHeader:caption}</div>\r\n		<div class=\"formControls\">\r\n		<div class=\"formBody\">{ContactHeader:body}<span class=\"formValidation\">{ContactHeader:validation}</span></div>\r\n		<p class=\"formDescription\">{ContactHeader:description}</p>\r\n		</div>\r\n	</div>\r\n	<div class=\"rsform-block rsform-block-contactby\">\r\n		<div class=\"formControlLabel\">{ContactBy:caption}</div>\r\n		<div class=\"formControls\">\r\n		<div class=\"formBody\">{ContactBy:body}<span class=\"formValidation\">{ContactBy:validation}</span></div>\r\n		<p class=\"formDescription\">{ContactBy:description}</p>\r\n		</div>\r\n	</div>\r\n	<div class=\"rsform-block rsform-block-contactwhen\">\r\n		<div class=\"formControlLabel\">{ContactWhen:caption}<strong class=\"formRequired\">(*)</strong></div>\r\n		<div class=\"formControls\">\r\n		<div class=\"formBody\">{ContactWhen:body}<span class=\"formValidation\">{ContactWhen:validation}</span></div>\r\n		<p class=\"formDescription\">{ContactWhen:description}</p>\r\n		</div>\r\n	</div>\r\n	<div class=\"rsform-block rsform-block-submit\">\r\n		<div class=\"formControlLabel\">{Submit:caption}</div>\r\n		<div class=\"formControls\">\r\n		<div class=\"formBody\">{Submit:body}<span class=\"formValidation\">{Submit:validation}</span></div>\r\n		<p class=\"formDescription\">{Submit:description}</p>\r\n		</div>\r\n	</div>\r\n	<div class=\"rsform-block rsform-block-footer\">\r\n		<div class=\"formControlLabel\">{Footer:caption}</div>\r\n		<div class=\"formControls\">\r\n		<div class=\"formBody\">{Footer:body}<span class=\"formValidation\">{Footer:validation}</span></div>\r\n		<p class=\"formDescription\">{Footer:description}</p>\r\n		</div>\r\n	</div>\r\n</fieldset>\r\n', '', 'bootstrap5', '1', '1', '0', '0', '0', '', '', 'RSForm! Pro Multipage example', '1', '1', '', '', '1', '1', '0', '0', '<p>Dear {FullName:value},</p><p> thank you for your submission. One of our staff members will contact you by  {ContactBy:value} as soon as possible.</p>', '1', '<p>Dear {FullName:value},</p><p> we received your contact request. Someone will get back to you by {ContactBy:value} soon. </p>', '{Email:value}', '', '', '{global:mailfrom}', '', '', '{global:fromname}', 'Contact confirmation', '1', '0', '', '0', '<p>Customize this e-mail also. You will receive it as administrator. </p><p>{FullName:caption}:{FullName:value}<br />\n{Email:caption}:{Email:value}<br />\n{CompanySize:caption}:{CompanySize:value}<br />\n{Position:caption}:{Position:value}<br />\n{ContactBy:caption}:{ContactBy:value}<br />\n{ContactWhen:caption}:{ContactWhen:value}</p>', 'youradminemail@email.com', '', '', '{global:mailfrom}', '{Email:value}', '', '{FullName:value}', 'Contact request', '1', '0', '', '', '', '', '', '', '', '', '', '1', '', '', '', '', '', '', '', '', '0', 'This is the meta description of your form. You can use it for SEO purposes.', 'rsform, contact, form, joomla', '(*)', '<p class=\"formRed\">Please complete all required fields!</p>', ', ', '1', '', 'userForm', '', '', '', '0', '0', '1', '1', '0', '0', '0', '', '', '', '0'),
('3', 'NGO Database', '<h2>{global:formtitle}</h2>\n{error}\n<!-- Do not remove this ID, it is used to identify the page so that the pagination script can work correctly -->\n<div class=\"formContainer\" id=\"rsform_{global:formid}_page_0\">\n	<div class=\"row\">\n		<div class=\"col-md-12\">\n			<div class=\"mb-3 rsform-block rsform-block-ngo-status2 rsform-type-selectlist{ngo_status2:errorClass}\">\n{if {ngo_status2:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{ngo_status2:descriptionhtml}\" for=\"ngo_status2\">{ngo_status2:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{ngo_status2:body}\n					<div><span class=\"formValidation\">{ngo_status2:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-ngo-name rsform-type-textbox{ngo_name:errorClass}\">\n{if {ngo_name:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{ngo_name:descriptionhtml}\" for=\"ngo_name\">{ngo_name:caption}<strong class=\"formRequired\">(*)</strong></label>\n{/if}\n				<div class=\"formControls\">\n					{ngo_name:body}\n					<div><span class=\"formValidation\">{ngo_name:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-filenumber rsform-type-textbox{FileNumber:errorClass}\">\n{if {FileNumber:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{FileNumber:descriptionhtml}\" for=\"FileNumber\">{FileNumber:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{FileNumber:body}\n					<div><span class=\"formValidation\">{FileNumber:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-dateofregistration rsform-type-datepicker{DateOfRegistration:errorClass}\">\n{if {DateOfRegistration:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{DateOfRegistration:descriptionhtml}\" for=\"DateOfRegistration\">{DateOfRegistration:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{DateOfRegistration:body}\n					<div><span class=\"formValidation\">{DateOfRegistration:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-registrationnumber rsform-type-textbox{RegistrationNumber:errorClass}\">\n{if {RegistrationNumber:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{RegistrationNumber:descriptionhtml}\" for=\"RegistrationNumber\">{RegistrationNumber:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{RegistrationNumber:body}\n					<div><span class=\"formValidation\">{RegistrationNumber:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-ngo-physical-address rsform-type-textarea{NGO_Physical_Address:errorClass}\">\n{if {NGO_Physical_Address:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{NGO_Physical_Address:descriptionhtml}\" for=\"NGO_Physical_Address\">{NGO_Physical_Address:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{NGO_Physical_Address:body}\n					<div><span class=\"formValidation\">{NGO_Physical_Address:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-ngo-email rsform-type-textbox{ngo_email:errorClass}\">\n{if {ngo_email:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{ngo_email:descriptionhtml}\" for=\"ngo_email\">{ngo_email:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{ngo_email:body}\n					<div><span class=\"formValidation\">{ngo_email:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-ngo-category rsform-type-selectlist{NGO_Category:errorClass}\">\n{if {NGO_Category:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{NGO_Category:descriptionhtml}\" for=\"NGO_Category\">{NGO_Category:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{NGO_Category:body}\n					<div><span class=\"formValidation\">{NGO_Category:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-country-of-origin rsform-type-textbox{Country_of_Origin:errorClass}\">\n{if {Country_of_Origin:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Country_of_Origin:descriptionhtml}\" for=\"Country_of_Origin\">{Country_of_Origin:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Country_of_Origin:body}\n					<div><span class=\"formValidation\">{Country_of_Origin:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-district-of-operation rsform-type-textbox{District_of_Operation:errorClass}\">\n{if {District_of_Operation:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{District_of_Operation:descriptionhtml}\" for=\"District_of_Operation\">{District_of_Operation:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{District_of_Operation:body}\n					<div><span class=\"formValidation\">{District_of_Operation:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-region-of-operation rsform-type-selectlist{Region_of_Operation:errorClass}\">\n{if {Region_of_Operation:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Region_of_Operation:descriptionhtml}\" for=\"Region_of_Operation\">{Region_of_Operation:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Region_of_Operation:body}\n					<div><span class=\"formValidation\">{Region_of_Operation:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-sector-or-intervention rsform-type-selectlist{Sector_or_Intervention:errorClass}\">\n{if {Sector_or_Intervention:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Sector_or_Intervention:descriptionhtml}\" for=\"Sector_or_Intervention\">{Sector_or_Intervention:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Sector_or_Intervention:body}\n					<div><span class=\"formValidation\">{Sector_or_Intervention:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-sub-sector rsform-type-selectlist{Sub-sector:errorClass}\">\n{if {Sub-sector:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Sub-sector:descriptionhtml}\" for=\"Sub-sector\">{Sub-sector:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Sub-sector:body}\n					<div><span class=\"formValidation\">{Sub-sector:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-payments-for-ngo-registration rsform-type-textbox{Payments_for_NGO_Registration:errorClass}\">\n{if {Payments_for_NGO_Registration:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Payments_for_NGO_Registration:descriptionhtml}\" for=\"Payments_for_NGO_Registration\">{Payments_for_NGO_Registration:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Payments_for_NGO_Registration:body}\n					<div><span class=\"formValidation\">{Payments_for_NGO_Registration:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-amount-paid-for-review rsform-type-textbox{Amount_paid_for_review:errorClass}\">\n{if {Amount_paid_for_review:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Amount_paid_for_review:descriptionhtml}\" for=\"Amount_paid_for_review\">{Amount_paid_for_review:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Amount_paid_for_review:body}\n					<div><span class=\"formValidation\">{Amount_paid_for_review:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-upload-documents rsform-type-fileupload{Upload_Documents:errorClass}\">\n{if {Upload_Documents:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Upload_Documents:descriptionhtml}\" for=\"Upload_Documents\">{Upload_Documents:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Upload_Documents:body}\n					<div><span class=\"formValidation\">{Upload_Documents:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-ngo-estimated-budget rsform-type-textbox{NGO_estimated_budget:errorClass}\">\n{if {NGO_estimated_budget:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{NGO_estimated_budget:descriptionhtml}\" for=\"NGO_estimated_budget\">{NGO_estimated_budget:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{NGO_estimated_budget:body}\n					<div><span class=\"formValidation\">{NGO_estimated_budget:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-actual-amount-paid-for-permit-expiry-penalty rsform-type-textbox{Actual_amount_paid_for_permit_expiry_penalty:errorClass}\">\n{if {Actual_amount_paid_for_permit_expiry_penalty:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Actual_amount_paid_for_permit_expiry_penalty:descriptionhtml}\" for=\"Actual_amount_paid_for_permit_expiry_penalty\">{Actual_amount_paid_for_permit_expiry_penalty:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Actual_amount_paid_for_permit_expiry_penalty:body}\n					<div><span class=\"formValidation\">{Actual_amount_paid_for_permit_expiry_penalty:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-amount-paid-for-permit rsform-type-textbox{Amount_paid_for_permit:errorClass}\">\n{if {Amount_paid_for_permit:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Amount_paid_for_permit:descriptionhtml}\" for=\"Amount_paid_for_permit\">{Amount_paid_for_permit:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Amount_paid_for_permit:body}\n					<div><span class=\"formValidation\">{Amount_paid_for_permit:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-permit-number rsform-type-textbox{Permit_number:errorClass}\">\n{if {Permit_number:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Permit_number:descriptionhtml}\" for=\"Permit_number\">{Permit_number:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Permit_number:body}\n					<div><span class=\"formValidation\">{Permit_number:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-permit-print-date rsform-type-datepicker{Permit_print_date:errorClass}\">\n{if {Permit_print_date:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Permit_print_date:descriptionhtml}\" for=\"Permit_print_date\">{Permit_print_date:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Permit_print_date:body}\n					<div><span class=\"formValidation\">{Permit_print_date:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-permit-expiry-date rsform-type-datepicker{Permit_expiry_date:errorClass}\">\n{if {Permit_expiry_date:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Permit_expiry_date:descriptionhtml}\" for=\"Permit_expiry_date\">{Permit_expiry_date:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Permit_expiry_date:body}\n					<div><span class=\"formValidation\">{Permit_expiry_date:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-income-from-donors rsform-type-textbox{Income_from_Donors:errorClass}\">\n{if {Income_from_Donors:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Income_from_Donors:descriptionhtml}\" for=\"Income_from_Donors\">{Income_from_Donors:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Income_from_Donors:body}\n					<div><span class=\"formValidation\">{Income_from_Donors:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-name-of-donors rsform-type-textarea{Name_of_Donors:errorClass}\">\n{if {Name_of_Donors:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Name_of_Donors:descriptionhtml}\" for=\"Name_of_Donors\">{Name_of_Donors:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Name_of_Donors:body}\n					<div><span class=\"formValidation\">{Name_of_Donors:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-internally-generated-income rsform-type-textbox{Internally_Generated_Income:errorClass}\">\n{if {Internally_Generated_Income:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Internally_Generated_Income:descriptionhtml}\" for=\"Internally_Generated_Income\">{Internally_Generated_Income:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Internally_Generated_Income:body}\n					<div><span class=\"formValidation\">{Internally_Generated_Income:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-original-expenditure rsform-type-textbox{Original_Expenditure:errorClass}\">\n{if {Original_Expenditure:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Original_Expenditure:descriptionhtml}\" for=\"Original_Expenditure\">{Original_Expenditure:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Original_Expenditure:body}\n					<div><span class=\"formValidation\">{Original_Expenditure:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-payment-of-annual-return rsform-type-textbox{Payment_of_Annual_Return:errorClass}\">\n{if {Payment_of_Annual_Return:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Payment_of_Annual_Return:descriptionhtml}\" for=\"Payment_of_Annual_Return\">{Payment_of_Annual_Return:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Payment_of_Annual_Return:body}\n					<div><span class=\"formValidation\">{Payment_of_Annual_Return:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-amount-paid-for-a-replacement rsform-type-textbox{Amount_paid_for_a_replacement:errorClass}\">\n{if {Amount_paid_for_a_replacement:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Amount_paid_for_a_replacement:descriptionhtml}\" for=\"Amount_paid_for_a_replacement\">{Amount_paid_for_a_replacement:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Amount_paid_for_a_replacement:body}\n					<div><span class=\"formValidation\">{Amount_paid_for_a_replacement:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-amount-paid-for-inspection-report rsform-type-textbox{Amount_paid_for_inspection_report:errorClass}\">\n{if {Amount_paid_for_inspection_report:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Amount_paid_for_inspection_report:descriptionhtml}\" for=\"Amount_paid_for_inspection_report\">{Amount_paid_for_inspection_report:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Amount_paid_for_inspection_report:body}\n					<div><span class=\"formValidation\">{Amount_paid_for_inspection_report:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-amount-paid-for-a-search rsform-type-textbox{Amount_paid_for_a_search:errorClass}\">\n{if {Amount_paid_for_a_search:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Amount_paid_for_a_search:descriptionhtml}\" for=\"Amount_paid_for_a_search\">{Amount_paid_for_a_search:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Amount_paid_for_a_search:body}\n					<div><span class=\"formValidation\">{Amount_paid_for_a_search:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-12\">\n			<div class=\"mb-3 rsform-block rsform-block-submit rsform-type-submitbutton{Submit:errorClass}\">\n{if {Submit:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Submit:descriptionhtml}\">{Submit:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Submit:body}\n					<div><span class=\"formValidation\">{Submit:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n</div>\n					{ngo_status:body}', '[[{\"columns\":[[\"74\"]],\"sizes\":[\"12\"]},{\"columns\":[[\"24\"],[\"32\"],[\"33\"]],\"sizes\":[\"4\",\"4\",\"4\"]},{\"columns\":[[\"34\"],[\"35\"],[\"36\"]],\"sizes\":[\"4\",\"4\",\"4\"]},{\"columns\":[[\"37\"],[\"38\"],[\"39\"]],\"sizes\":[\"4\",\"4\",\"4\"]},{\"columns\":[[\"40\"],[\"41\"],[\"42\"]],\"sizes\":[\"4\",\"4\",\"4\"]},{\"columns\":[[\"43\"],[\"44\"],[\"45\"]],\"sizes\":[\"4\",\"4\",\"4\"]},{\"columns\":[[\"59\"],[\"60\"],[\"61\"]],\"sizes\":[\"4\",\"4\",\"4\"]},{\"columns\":[[\"62\"],[\"63\"],[\"64\"]],\"sizes\":[\"4\",\"4\",\"4\"]},{\"columns\":[[\"65\"],[\"66\"],[\"67\"]],\"sizes\":[\"4\",\"4\",\"4\"]},{\"columns\":[[\"68\"],[\"69\"],[\"70\"]],\"sizes\":[\"4\",\"4\",\"4\"]},{\"columns\":[[\"71\"],[\"72\"],[]],\"sizes\":[\"4\",\"4\",\"4\"]},{\"columns\":[[\"30\"]],\"sizes\":[\"12\"]}],[\"75\"]]', 'bootstrap5', '1', '1', '1', '0', '1', '<style>\r\n.form-label {\r\n  margin-bottom: 0.5rem;\r\n  color: #1e41a1;\r\n  font-size: 18px;\r\n  font-weight: bold;\r\n}\r\n\r\n</style>\r\n', '', 'NGO Database', '1', '1', 'en-GB', '', '1', '1', '0', '1', '<p>Your record has been updated.</p>', '1', '<p>Dear {FullName:value},</p><p> we received your contact request. Someone will get back to you by {ContactBy:value} soon. </p>', '', '', '', '{global:mailfrom}', '', '', '{global:fromname}', 'Contact confirmation', '1', '0', '', '0', '<p>Customize this e-mail also. You will receive it as administrator. </p><p>{FullName:caption}:{FullName:value}<br />\n{Email:caption}:{Email:value}<br />\n{CompanySize:caption}:{CompanySize:value}<br />\n{Position:caption}:{Position:value}<br />\n{ContactBy:caption}:{ContactBy:value}<br />\n{ContactWhen:caption}:{ContactWhen:value}</p>', '', '', '', '{global:mailfrom}', '', '', '{FullName:value}', 'Contact', '1', '0', '', '', '', '', '', '', '', '', '', '1', '', 'use Joomla\\CMS\\Factory;\r\nuse Joomla\\CMS\\Mail\\MailHelper;\r\n\r\n// Get Joomla Database instance\r\n$db = Factory::getDbo();\r\n$user = Factory::getUser();\r\n\r\n// Get Form ID\r\n$formId = $form->FormId;\r\n\r\n// Get the latest Submission ID for this form\r\n$query = $db->getQuery(true)\r\n    ->select($db->quoteName(\'SubmissionId\'))\r\n    ->from($db->quoteName(\'#__rsform_submissions\'))\r\n    ->where($db->quoteName(\'FormId\') . \' = \' . (int) $formId)\r\n    ->order($db->quoteName(\'SubmissionId\') . \' DESC\');\r\n$db->setQuery($query, 0, 1); // Fetch the latest submission\r\n$submissionId = (int) $db->loadResult();\r\n\r\nif (!$submissionId) {\r\n    error_log(\"No submission found for Form ID: $formId\");\r\n    return;\r\n}\r\n\r\n// Get field values using a direct database query\r\n$fields = [\'email\', \'ngo_name\', \'ngo_status\'];\r\n$fieldValues = [];\r\n\r\nforeach ($fields as $fieldName) {\r\n    $query = $db->getQuery(true)\r\n        ->select($db->quoteName(\'FieldValue\'))\r\n        ->from($db->quoteName(\'#__rsform_submission_values\'))\r\n        ->where($db->quoteName(\'SubmissionId\') . \' = \' . $submissionId)\r\n        ->where($db->quoteName(\'FieldName\') . \' = \' . $db->quote($fieldName));\r\n    $db->setQuery($query);\r\n    $fieldValues[$fieldName] = $db->loadResult() ?? \'\';\r\n}\r\n\r\n// Assign retrieved values\r\n$ngoEmail = $fieldValues[\'email\'];\r\n$ngoName = $fieldValues[\'ngo_name\'];\r\n$status = $fieldValues[\'ngo_status\'] ?: \'Pending\';\r\n\r\n// Define Department Emails and Status Workflow\r\n$departments = [\r\n    \'Pending\' => [\'email\' => \'m.mubiru@lafabsolution.com\', \'next_status\' => \'Front Desk Review\', \'subject\' => \"New NGO Submission\", \'message\' => \"A new NGO ($ngoName) has registered. Please review.\"],\r\n    \'Front Desk Review\' => [\'email\' => \'admin@lafabsolution.com\', \'next_status\' => \'Accounts Verification\', \'subject\' => \"NGO Payment Verification Needed\", \'message\' => \"Please verify the payment for NGO: $ngoName.\"],\r\n    \'Accounts Verification\' => [\'email\' => \'compliance@example.com\', \'next_status\' => \'Compliance Review\', \'subject\' => \"Compliance Review Required\", \'message\' => \"NGO: $ngoName has completed payment verification. Please review.\"],\r\n    \'Compliance Review\' => [\'email\' => \'legal@example.com\', \'next_status\' => \'Legal Review\', \'subject\' => \"Legal Due Diligence Required\", \'message\' => \"NGO: $ngoName is ready for legal review.\"],\r\n    \'Legal Review\' => [\'email\' => \'records@example.com\', \'next_status\' => \'Records Update\', \'subject\' => \"Final Records Update Needed\", \'message\' => \"NGO: $ngoName is ready for final records update.\"],\r\n    \'Records Update\' => [\'email\' => $ngoEmail, \'next_status\' => \'Approved\', \'subject\' => \"NGO Registration Approved\", \'message\' => \"Congratulations! Your NGO ($ngoName) has been successfully registered.\"],\r\n];\r\n\r\n// Process workflow after form submission\r\nif (isset($departments[$status])) {\r\n    $recipient = $departments[$status][\'email\'];\r\n    $subject = $departments[$status][\'subject\'];\r\n    $message = $departments[$status][\'message\'];\r\n    $next_status = $departments[$status][\'next_status\'];\r\n\r\n    // Send email asynchronously using Joomla Mailer\r\n    $mailer = Factory::getMailer();\r\n    $mailer->setSender([\'noreply@example.com\', \'NGO Registration System\']);\r\n    $mailer->addRecipient($recipient);\r\n    $mailer->setSubject($subject);\r\n    $mailer->setBody($message);\r\n    \r\n    // Queue email without blocking submission\r\n    Factory::getApplication()->enqueueMessage(\"Email queued for: $recipient\", \'message\');\r\n    $mailer->Send();\r\n\r\n    // Update the status field in the database\r\n    $query = $db->getQuery(true)\r\n        ->update($db->quoteName(\'#__rsform_submission_values\'))\r\n        ->set($db->quoteName(\'FieldValue\') . \' = \' . $db->quote($next_status))\r\n        ->where($db->quoteName(\'SubmissionId\') . \' = \' . $submissionId)\r\n        ->where($db->quoteName(\'FieldName\') . \' = \' . $db->quote(\'ngo_status\'));\r\n\r\n    $db->setQuery($query);\r\n    if (!$db->execute()) {\r\n        error_log(\"Failed to update status for Submission ID: $submissionId\");\r\n    } else {\r\n        error_log(\"Status updated to: $next_status for Submission ID: $submissionId\");\r\n    }\r\n} else {\r\n    error_log(\"Invalid status: $status for Submission ID: $submissionId\");\r\n}\r\n\r\n\r\n $db = Joomla\\CMS\\Factory::getDBO();\r\n    $db->setQuery(\"SELECT `SubmissionId` FROM #__rsform_submissions WHERE `UserId`=\'\".Joomla\\CMS\\Factory::getUser()->id.\"\' AND `FormId`=\'\".$formId.\"\' ORDER BY `SubmissionId` DESC LIMIT 2\");\r\n    $oldSubId = \'\';\r\n    if(count($db->loadColumn()) == 2){\r\n      $oldSubId = $db->loadColumn()[1];\r\n    }\r\n    if(!empty($oldSubId)){\r\n      $db->setQuery(\"DELETE rs,rsv FROM #__rsform_submissions AS rs ,#__rsform_submission_values AS rsv WHERE\r\n      rs.`SubmissionId`=rsv.`SubmissionId` AND rs.`SubmissionId`=\'\".$oldSubId.\"\'\");\r\n      $db->execute();\r\n    }\r\n', 'if (Joomla\\CMS\\Factory::getUser()->id == 0) {\r\n    // If the user is not logged in, display the following message.\r\n    $formLayout = \'Please login in order to access the form.\';\r\n} else {\r\n    $db = Joomla\\CMS\\Factory::getDBO();\r\n    $db->setQuery(\"SELECT `SubmissionId` FROM #__rsform_submissions WHERE `UserId`=\'\" . Joomla\\CMS\\Factory::getUser()->id . \"\' AND `FormId`=\'\" . $formId . \"\' ORDER BY `SubmissionId` DESC LIMIT 1\");\r\n    $SubmissionId = $db->loadResult();\r\n    // Grab the previous user submission, if any.\r\n\r\n    if (!empty($SubmissionId)) {\r\n        // This triggers if the user had submitted the form before.\r\n\r\n        $exclude = implode(\"\',\'\", array(7, 8, 10, 11, 12, 13, 14, 15, 21, 22, 23, 24, 27, 28, 30, 31, 32, 33, 34, 41, 212, 499, 500, 2424));\r\n        // Exclude specific elements (adjust as necessary).\r\n\r\n        $db->setQuery(\"SELECT ct.`ComponentTypeName`, p.`PropertyValue`, sv.`FieldValue` FROM #__rsform_component_types AS ct \r\n                       LEFT JOIN #__rsform_components AS c ON ct.`ComponentTypeId` = c.`ComponentTypeId` \r\n                       LEFT JOIN #__rsform_properties AS p ON c.`ComponentId` = p.`ComponentId` \r\n                       LEFT JOIN #__rsform_submission_values AS sv ON p.`PropertyValue` = sv.`FieldName` \r\n                       WHERE c.`FormId`=\'\" . $formId . \"\' \r\n                       AND c.`ComponentTypeId` NOT IN (\'\" . $exclude . \"\') \r\n                       AND p.`PropertyName`=\'NAME\' \r\n                       AND sv.`SubmissionId` = \'\" . $SubmissionId . \"\'\");\r\n\r\n        $results = $db->loadObjectList();\r\n        // Grab previously submitted data of form fields based on the logged-in user.\r\n\r\n        foreach ($results as $result) {\r\n            if ($result->ComponentTypeName == \'selectList\' || $result->ComponentTypeName == \'checkboxGroup\') {\r\n                // Handle dropdowns and checkbox groups.\r\n                if (strstr($result->FieldValue, \"\\n\") !== false) {\r\n                    // For multi-selections.\r\n                    $multiVals = explode(\"\\n\", $result->FieldValue);\r\n                    foreach ($multiVals as $multiVal) {\r\n                        $val[$result->PropertyValue][] = $multiVal;\r\n                    }\r\n                } else {\r\n                    // For single selections.\r\n                    $val[$result->PropertyValue] = $result->FieldValue;\r\n                }\r\n            } elseif ($result->ComponentTypeName == \'calendar\') {\r\n                // Handle calendar fields.\r\n                $val[$result->PropertyValue] = $result->FieldValue;\r\n            } elseif ($result->ComponentTypeName == \'birthDay\') {\r\n                // Handle birthday fields.\r\n                $bDate = str_replace(\' \', \'\', $result->FieldValue);\r\n                $bDate = explode(\"/\", $bDate);\r\n                $val[$result->PropertyValue][\'d\'] = $bDate[0];\r\n                $val[$result->PropertyValue][\'m\'] = $bDate[1];\r\n                $val[$result->PropertyValue][\'y\'] = $bDate[2];\r\n            } elseif ($result->ComponentTypeName == \'fileUpload\') {\r\n                // Handle file uploads.\r\n                // Assume the file path is stored in the `FieldValue`. Adjust if necessary.\r\n                $filePath = $result->FieldValue;\r\n                $val[$result->PropertyValue] = $filePath;\r\n\r\n                // Optional: Generate a downloadable link for the file.\r\n                $val[$result->PropertyValue] = \'<a href=\"\' . $filePath . \'\" target=\"_blank\">View Uploaded File</a>\';\r\n            } else {\r\n                // Handle other fields (e.g., textboxes, radio groups, etc.).\r\n                $val[$result->PropertyValue] = $result->FieldValue;\r\n            }\r\n        }\r\n    }\r\n}\r\n', '$db = Joomla\\CMS\\Factory::getDBO();\r\n$db->setQuery(\"SELECT `SubmissionId` FROM #__rsform_submissions WHERE `UserId`=\'\" . Joomla\\CMS\\Factory::getUser()->id . \"\' AND `FormId`=\'\" . $formId . \"\' ORDER BY `SubmissionId` DESC LIMIT 2\");\r\n$oldSubId = \'\';\r\nif (count($db->loadColumn()) == 2) {\r\n    $oldSubId = $db->loadColumn()[1];\r\n}\r\nif (!empty($oldSubId)) {\r\n    $db->setQuery(\"DELETE rs, rsv \r\n                   FROM #__rsform_submissions AS rs \r\n                   JOIN #__rsform_submission_values AS rsv ON rs.`SubmissionId` = rsv.`SubmissionId` \r\n                   WHERE rs.`SubmissionId` = \'\" . $oldSubId . \"\'\");\r\n    $db->execute();\r\n}', 'use Joomla\\CMS\\Factory;\r\n\r\n// Get the logged-in user\r\n$user = Factory::getUser();\r\n\r\n// Define user groups that should see the fields\r\n$allowedGroups = [6, 8]; // Replace with your group IDs (e.g., 2 = Registered, 3 = Author)\r\n\r\n// Check if the user belongs to the allowed groups\r\n$showFields = false;\r\nforeach ($allowedGroups as $group) {\r\n    if (in_array($group, $user->groups)) {\r\n        $showFields = true;\r\n        break;\r\n    }\r\n}\r\n\r\n// Hide multiple fields and their captions if the user is not in the allowed groups\r\nif (!$showFields) {\r\n    // Define the fields and their captions to hide\r\n    $fieldsToHide = [\r\n        \'NGO_Category\' => \'NGO Category\', // Field ID => Caption ID\r\n        \'Country_of_Origin\' => \'Country of Origin\', // Field ID => Caption ID\r\n        \'District_of_Operation\' => \'District of Operation\', // Field ID => Caption ID\r\n    ];\r\n\r\n    // Generate CSS to hide the fields and their captions\r\n    $css = \'\';\r\n    foreach ($fieldsToHide as $fieldId => $captionId) {\r\n        $css .= \"#$fieldId, #$captionId { display: none; }\\n\";\r\n    }\r\n\r\n    // Output the CSS\r\n    echo \"<style>$css</style>\";\r\n}\r\n\r\n', '', '', '', '0', '', '', '(*)', '', ', ', '1', '', 'userForm', '', '', '', '1', '1', '1', '1', '0', '0', '0', '\"\"', '', '', '0'),
('5', 'Approval Form', '<h2>{global:formtitle}</h2>\n{error}\n<!-- Do not remove this ID, it is used to identify the page so that the pagination script can work correctly -->\n<div class=\"formContainer\" id=\"rsform_{global:formid}_page_0\">\n	<div class=\"row\">\n		<div class=\"col-md-12\">\n			<div class=\"row mb-3 rsform-block rsform-block-current-status rsform-type-textbox{Current_Status:errorClass}\">\n				<label class=\"col-sm-3 col-form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Current_Status:descriptionhtml}\" for=\"Current_Status\">{Current_Status:caption}</label>\n				<div class=\"formControls col-sm-9\">\n					{Current_Status:body}\n					<div><span class=\"formValidation\">{Current_Status:validation}</span></div>\n				</div>\n			</div>\n			<div class=\"row mb-3 rsform-block rsform-block-update-status rsform-type-selectlist{Update_Status:errorClass}\">\n				<label class=\"col-sm-3 col-form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Update_Status:descriptionhtml}\" for=\"Update_Status\">{Update_Status:caption}</label>\n				<div class=\"formControls col-sm-9\">\n					{Update_Status:body}\n					<div><span class=\"formValidation\">{Update_Status:validation}</span></div>\n				</div>\n			</div>\n			<div class=\"row mb-3 rsform-block rsform-block-submit rsform-type-submitbutton{Submit:errorClass}\">\n				<label class=\"col-sm-3 col-form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Submit:descriptionhtml}\">{Submit:caption}</label>\n				<div class=\"formControls col-sm-9\">\n					{Submit:body}\n					<div><span class=\"formValidation\">{Submit:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n</div>\n					{ngo_file_id:body}', '[[{\"columns\":[[\"58\",\"56\",\"54\"]],\"sizes\":[\"12\"]}],[\"57\"]]', 'bootstrap5', '1', '1', '0', '0', '0', '', '', 'Approval Form', '1', '1', 'en-GB', '', '1', '1', '0', '0', '<p>Dear {FullName:value},</p><p> thank you for your submission. One of our staff members will contact you by  {ContactBy:value} as soon as possible.</p>', '1', '<p>Dear {FullName:value},</p><p> we received your contact request. Someone will get back to you by {ContactBy:value} soon. </p>', '', '', '', '{global:mailfrom}', '', '', '{global:fromname}', 'Contact confirmation', '1', '0', '', '0', '<p>Customize this e-mail also. You will receive it as administrator. </p><p>{FullName:caption}:{FullName:value}<br />\n{Email:caption}:{Email:value}<br />\n{CompanySize:caption}:{CompanySize:value}<br />\n{Position:caption}:{Position:value}<br />\n{ContactBy:caption}:{ContactBy:value}<br />\n{ContactWhen:caption}:{ContactWhen:value}</p>', '', '', '', '{global:mailfrom}', '', '', '{FullName:value}', 'Contact', '1', '0', '', '', '', '', '', '', '', '', '', '1', '', '', '', '', '', '', '', '', '0', '', '', '(*)', '', ', ', '1', '', 'userForm', '', '', '', '0', '0', '1', '1', '0', '0', '0', '\"\"', '', '', '0'),
('6', 'Workers', '<h2>{global:formtitle}</h2>\n{error}\n<!-- Do not remove this ID, it is used to identify the page so that the pagination script can work correctly -->\n<div class=\"formContainer\" id=\"rsform_{global:formid}_page_0\">\n	<div class=\"row\">\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-workername rsform-type-textbox{WorkerName:errorClass}\">\n{if {WorkerName:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{WorkerName:descriptionhtml}\" for=\"WorkerName\">{WorkerName:caption}<strong class=\"formRequired\">(*)</strong></label>\n{/if}\n				<div class=\"formControls\">\n					{WorkerName:body}\n					<div><span class=\"formValidation\">{WorkerName:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-worktitle rsform-type-selectlist{WorkTitle:errorClass}\">\n{if {WorkTitle:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{WorkTitle:descriptionhtml}\" for=\"WorkTitle\">{WorkTitle:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{WorkTitle:body}\n					<div><span class=\"formValidation\">{WorkTitle:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-idnumber rsform-type-selectize{IDnumber:errorClass}\">\n{if {IDnumber:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{IDnumber:descriptionhtml}\" for=\"IDnumber\">{IDnumber:caption}<strong class=\"formRequired\">(*)</strong></label>\n{/if}\n				<div class=\"formControls\">\n					{IDnumber:body}\n					<div><span class=\"formValidation\">{IDnumber:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-check-in rsform-type-timedropper{Check-in:errorClass}\">\n{if {Check-in:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Check-in:descriptionhtml}\" for=\"Check-in\">{Check-in:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Check-in:body}\n					<div><span class=\"formValidation\">{Check-in:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-checkouttime rsform-type-timedropper{CheckOutTime:errorClass}\">\n{if {CheckOutTime:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{CheckOutTime:descriptionhtml}\" for=\"CheckOutTime\">{CheckOutTime:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{CheckOutTime:body}\n					<div><span class=\"formValidation\">{CheckOutTime:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-hoursworked rsform-type-textbox{HoursWorked:errorClass}\">\n{if {HoursWorked:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{HoursWorked:descriptionhtml}\" for=\"HoursWorked\">{HoursWorked:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{HoursWorked:body}\n					<div><span class=\"formValidation\">{HoursWorked:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-overtime rsform-type-textbox{Overtime:errorClass}\">\n{if {Overtime:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Overtime:descriptionhtml}\" for=\"Overtime\">{Overtime:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Overtime:body}\n					<div><span class=\"formValidation\">{Overtime:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-assigned-tasks-or rsform-type-selectize{Assigned_Tasks_or:errorClass}\">\n{if {Assigned_Tasks_or:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Assigned_Tasks_or:descriptionhtml}\" for=\"Assigned_Tasks_or\">{Assigned_Tasks_or:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Assigned_Tasks_or:body}\n					<div><span class=\"formValidation\">{Assigned_Tasks_or:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-hasppe rsform-type-radiogroup{HasPPE:errorClass}\">\n{if {HasPPE:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{HasPPE:descriptionhtml}\" id=\"HasPPE-grouplbl\">{HasPPE:caption}</label>\n{/if}\n				<div class=\"formControls\" role=\"group\" aria-labelledby=\"HasPPE-grouplbl\">\n					{HasPPE:body}\n					<div><span class=\"formValidation\">{HasPPE:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-payamount rsform-type-textbox{PayAmount:errorClass}\">\n{if {PayAmount:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{PayAmount:descriptionhtml}\" for=\"PayAmount\">{PayAmount:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{PayAmount:body}\n					<div><span class=\"formValidation\">{PayAmount:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-overtimepayamount rsform-type-textbox{OvertimePayAmount:errorClass}\">\n{if {OvertimePayAmount:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{OvertimePayAmount:descriptionhtml}\" for=\"OvertimePayAmount\">{OvertimePayAmount:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{OvertimePayAmount:body}\n					<div><span class=\"formValidation\">{OvertimePayAmount:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-6\">\n			<div class=\"mb-3 rsform-block rsform-block-workerefficiencyrating rsform-type-selectlist{WorkerEfficiencyRating:errorClass}\">\n{if {WorkerEfficiencyRating:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{WorkerEfficiencyRating:descriptionhtml}\" for=\"WorkerEfficiencyRating\">{WorkerEfficiencyRating:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{WorkerEfficiencyRating:body}\n					<div><span class=\"formValidation\">{WorkerEfficiencyRating:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-6\">\n			<div class=\"mb-3 rsform-block rsform-block-supervisorperformanceremarks rsform-type-selectlist{SupervisorPerformanceRemarks:errorClass}\">\n{if {SupervisorPerformanceRemarks:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{SupervisorPerformanceRemarks:descriptionhtml}\" for=\"SupervisorPerformanceRemarks\">{SupervisorPerformanceRemarks:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{SupervisorPerformanceRemarks:body}\n					<div><span class=\"formValidation\">{SupervisorPerformanceRemarks:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-12\">\n			<div class=\"mb-3 rsform-block rsform-block-submit rsform-type-submitbutton{Submit:errorClass}\">\n{if {Submit:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Submit:descriptionhtml}\">{Submit:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Submit:body}\n					<div><span class=\"formValidation\">{Submit:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n</div>\n					{Local_Time:body}', '[[{\"columns\":[[\"85\"],[\"135\"],[\"86\"],[\"89\"]],\"sizes\":[\"3\",\"3\",\"3\",\"3\"]},{\"columns\":[[\"88\"],[\"92\"],[\"91\"],[\"95\"]],\"sizes\":[\"3\",\"3\",\"3\",\"3\"]},{\"columns\":[[\"138\"],[\"139\"],[\"140\"]],\"sizes\":[\"4\",\"4\",\"4\"]},{\"columns\":[[\"145\"],[\"146\"]],\"sizes\":[\"6\",\"6\"]},{\"columns\":[[\"83\"]],\"sizes\":[\"12\"]}],[\"147\"]]', 'bootstrap5', '1', '1', '1', '0', '0', '<style>\r\n.form-label {\r\n  margin-bottom: 0.5rem;\r\n  color: #1e41a1;\r\n  font-size: 18px;\r\n  font-weight: bold;\r\n}\r\n</style>', '<script>\r\ndocument.addEventListener(\'DOMContentLoaded\', function() {\r\n    // Function to get local time in the desired format\r\n    function getFormattedLocalTime() {\r\n        const now = new Date();\r\n\r\n        // Extract date and time components\r\n        const year = now.getFullYear();\r\n        const month = String(now.getMonth() + 1).padStart(2, \'0\'); // Months are zero-based\r\n        const day = String(now.getDate()).padStart(2, \'0\');\r\n        const hours = String(now.getHours()).padStart(2, \'0\');\r\n        const minutes = String(now.getMinutes()).padStart(2, \'0\');\r\n        const seconds = String(now.getSeconds()).padStart(2, \'0\');\r\n\r\n        // Construct the desired format\r\n        const formattedTime = `${year}-${month}-${day} ${hours}:${minutes}:${seconds}`;\r\n\r\n        return formattedTime; // e.g., \"2025-02-16 06:09:24\"\r\n    }\r\n\r\n    // Find the hidden field by its name or ID\r\n    const localTimeField = document.querySelector(\'input[name=\"form[Local_Time]\"]\'); // Replace \'form[Local_Time]\' with your hidden field\'s name\r\n    if (localTimeField) {\r\n        localTimeField.value = getFormattedLocalTime();\r\n    }\r\n});\r\n</script>', 'Workers', '1', '1', 'en-GB', '', '1', '1', '0', '1', '<p>{WorkerName:value} has been added successfully. You can edit the person\'s record under workers.</p>', '1', '<p>Dear {FullName:value},</p><p> we received your contact request. Someone will get back to you by {ContactBy:value} soon. </p>', '', '', '', '{global:mailfrom}', '', '', '{global:fromname}', 'Contact confirmation', '1', '0', '', '0', '<p>Customize this e-mail also. You will receive it as administrator. </p><p>{FullName:caption}:{FullName:value}<br />\n{Email:caption}:{Email:value}<br />\n{CompanySize:caption}:{CompanySize:value}<br />\n{Position:caption}:{Position:value}<br />\n{ContactBy:caption}:{ContactBy:value}<br />\n{ContactWhen:caption}:{ContactWhen:value}</p>', 'youradminemail@email.com', '', '', '{global:mailfrom}', '', '', '{FullName:value}', 'Contact', '1', '0', '', '', '', '', '', '', '', '', '', '1', '', '', '', '', '', '', '', '', '0', '', '', '(*)', '', ', ', '1', '', 'userForm', '', '', '', '1', '1', '1', '1', '0', '0', '0', '\"\"', '', '', '0'),
('7', 'Maids Payments', '<h2>{global:formtitle}</h2>\n{error}\n<!-- Do not remove this ID, it is used to identify the page so that the pagination script can work correctly -->\n<div class=\"formContainer\" id=\"rsform_{global:formid}_page_0\">\n	<div class=\"row\">\n		<div class=\"col-md-6\">\n			<div class=\"mb-3 rsform-block rsform-block-maid-name rsform-type-selectize{Maid_Name:errorClass}\">\n{if {Maid_Name:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Maid_Name:descriptionhtml}\" for=\"Maid_Name\">{Maid_Name:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Maid_Name:body}\n					<div><span class=\"formValidation\">{Maid_Name:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-6\">\n			<div class=\"mb-3 rsform-block rsform-block-maid-boss rsform-type-textbox{Maid_Boss:errorClass}\">\n{if {Maid_Boss:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Maid_Boss:descriptionhtml}\" for=\"Maid_Boss\">{Maid_Boss:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Maid_Boss:body}\n					<div><span class=\"formValidation\">{Maid_Boss:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-6\">\n			<div class=\"mb-3 rsform-block rsform-block-maid-pay-amount rsform-type-textbox{Maid_Pay_Amount:errorClass}\">\n{if {Maid_Pay_Amount:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Maid_Pay_Amount:descriptionhtml}\" for=\"Maid_Pay_Amount\">{Maid_Pay_Amount:caption}<strong class=\"formRequired\">(*)</strong></label>\n{/if}\n				<div class=\"formControls\">\n					{Maid_Pay_Amount:body}\n					<div><span class=\"formValidation\">{Maid_Pay_Amount:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-6\">\n			<div class=\"mb-3 rsform-block rsform-block-amount-recieved-from-boss rsform-type-textbox{Amount_Recieved_from_Boss:errorClass}\">\n{if {Amount_Recieved_from_Boss:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Amount_Recieved_from_Boss:descriptionhtml}\" for=\"Amount_Recieved_from_Boss\">{Amount_Recieved_from_Boss:caption}<strong class=\"formRequired\">(*)</strong></label>\n{/if}\n				<div class=\"formControls\">\n					{Amount_Recieved_from_Boss:body}\n					<div><span class=\"formValidation\">{Amount_Recieved_from_Boss:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-12\">\n			<div class=\"mb-3 rsform-block rsform-block-submit rsform-type-submitbutton{Submit:errorClass}\">\n{if {Submit:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Submit:descriptionhtml}\">{Submit:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Submit:body}\n					<div><span class=\"formValidation\">{Submit:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n</div>\n					{Local_Time:body}', '[[{\"columns\":[[\"208\"],[\"210\"]],\"sizes\":[\"6\",\"6\"]},{\"columns\":[[\"195\"],[\"196\"]],\"sizes\":[\"6\",\"6\"]},{\"columns\":[[\"105\"]],\"sizes\":[\"12\"]}],[\"148\"]]', 'bootstrap5', '1', '1', '1', '0', '0', '<style>\r\n.form-label {\r\n  margin-bottom: 0.5rem;\r\n  color: #1e41a1;\r\n  font-size: 18px;\r\n  font-weight: bold;\r\n}\r\n</style>', '<script>\r\ndocument.addEventListener(\'DOMContentLoaded\', function() {\r\n    // Function to get local time with timezone offset\r\n    function getFormattedLocalTime() {\r\n        const now = new Date();\r\n\r\n        // Get the local date and time\r\n        const localTime = now.toLocaleString(\"en-US\", { \r\n            hour12: false, // Use 24-hour format\r\n            timeZoneName: \"short\" // Include timezone abbreviation (e.g., GMT, EST)\r\n        });\r\n\r\n        return localTime; // e.g., \"12/11/2024, 16:30:00 GMT+3\"\r\n    }\r\n\r\n    // Find the hidden field by its name or ID\r\n    const localTimeField = document.querySelector(\'input[name=\"form[Local_Time]\"]\'); // Replace \'local_time\' with your hidden field\'s name\r\n    if (localTimeField) {\r\n        localTimeField.value = getFormattedLocalTime();\r\n    }\r\n});\r\n</script>\r\n', 'Maids Payments', '1', '1', 'en-GB', '', '1', '1', '0', '0', '<p>Dear {FullName:value},</p><p> thank you for your submission. One of our staff members will contact you by  {ContactBy:value} as soon as possible.</p>', '1', '<p>Dear {FullName:value},</p><p> we received your contact request. Someone will get back to you by {ContactBy:value} soon. </p>', '', '', '', '{global:mailfrom}', '', '', '{global:fromname}', 'Contact confirmation', '1', '0', '', '0', '<p> </p>\r\n<p> </p>', 'mubmart7@gmail.com', 'admin@lafabsolution.com', '', '{global:mailfrom}', '', '', 'Lafab Maids', 'Maid {Maid_Name:value} is being paid {Maid_Pay_Amount:value}', '1', '1', '', '', '', '', '', '', '', '', '', '1', '', '', '', '', '', '', '', '', '0', '', '', '(*)', '', ', ', '1', '', 'userForm', '', '', '', '1', '1', '1', '1', '0', '0', '0', '\"\"', '', '', '0'),
('8', 'Maids', '<h2>{global:formtitle}</h2>\n{error}\n<!-- Do not remove this ID, it is used to identify the page so that the pagination script can work correctly -->\n<div class=\"formContainer\" id=\"rsform_{global:formid}_page_0\">\n	<div class=\"row\">\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-fullname rsform-type-textbox{FullName:errorClass}\">\n{if {FullName:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{FullName:descriptionhtml}\" for=\"FullName\">{FullName:caption}<strong class=\"formRequired\">(*)</strong></label>\n{/if}\n				<div class=\"formControls\">\n					{FullName:body}\n					<div><span class=\"formValidation\">{FullName:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-date-of-birth rsform-type-birthday{Date_of_Birth:errorClass}\">\n{if {Date_of_Birth:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Date_of_Birth:descriptionhtml}\">{Date_of_Birth:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Date_of_Birth:body}\n					<div><span class=\"formValidation\">{Date_of_Birth:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-2\">\n			<div class=\"mb-3 rsform-block rsform-block-years-of-experience rsform-type-textbox{Years_of_Experience:errorClass}\">\n{if {Years_of_Experience:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Years_of_Experience:descriptionhtml}\" for=\"Years_of_Experience\">{Years_of_Experience:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Years_of_Experience:body}\n					<div><span class=\"formValidation\">{Years_of_Experience:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-availability rsform-type-selectlist{Availability:errorClass}\">\n{if {Availability:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Availability:descriptionhtml}\" for=\"Availability\">{Availability:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Availability:body}\n					<div><span class=\"formValidation\">{Availability:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-tribe rsform-type-textbox{Tribe:errorClass}\">\n{if {Tribe:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Tribe:descriptionhtml}\" for=\"Tribe\">{Tribe:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Tribe:body}\n					<div><span class=\"formValidation\">{Tribe:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-gender rsform-type-selectlist{Gender:errorClass}\">\n{if {Gender:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Gender:descriptionhtml}\" for=\"Gender\">{Gender:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Gender:body}\n					<div><span class=\"formValidation\">{Gender:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-location rsform-type-textbox{Location:errorClass}\">\n{if {Location:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Location:descriptionhtml}\" for=\"Location\">{Location:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Location:body}\n					<div><span class=\"formValidation\">{Location:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-status rsform-type-selectlist{Status:errorClass}\">\n{if {Status:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Status:descriptionhtml}\" for=\"Status\">{Status:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Status:body}\n					<div><span class=\"formValidation\">{Status:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-contact-information rsform-type-textarea{Contact_Information:errorClass}\">\n{if {Contact_Information:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Contact_Information:descriptionhtml}\" for=\"Contact_Information\">{Contact_Information:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Contact_Information:body}\n					<div><span class=\"formValidation\">{Contact_Information:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-references rsform-type-textarea{References:errorClass}\">\n{if {References:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{References:descriptionhtml}\" for=\"References\">{References:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{References:body}\n					<div><span class=\"formValidation\">{References:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-key-skills rsform-type-textarea{Key_Skills:errorClass}\">\n{if {Key_Skills:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Key_Skills:descriptionhtml}\" for=\"Key_Skills\">{Key_Skills:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Key_Skills:body}\n					<div><span class=\"formValidation\">{Key_Skills:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-active-with-lafab-solutions rsform-type-radiogroup{Active_With_Lafab_Solutions:errorClass}\">\n{if {Active_With_Lafab_Solutions:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Active_With_Lafab_Solutions:descriptionhtml}\" id=\"Active_With_Lafab_Solutions-grouplbl\">{Active_With_Lafab_Solutions:caption}</label>\n{/if}\n				<div class=\"formControls\" role=\"group\" aria-labelledby=\"Active_With_Lafab_Solutions-grouplbl\">\n					{Active_With_Lafab_Solutions:body}\n					<div><span class=\"formValidation\">{Active_With_Lafab_Solutions:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-maid-boss-details rsform-type-textarea{Maid_Boss_Details:errorClass}\">\n{if {Maid_Boss_Details:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Maid_Boss_Details:descriptionhtml}\" for=\"Maid_Boss_Details\">{Maid_Boss_Details:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Maid_Boss_Details:body}\n					<div><span class=\"formValidation\">{Maid_Boss_Details:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-current-package rsform-type-selectlist{Current_Package:errorClass}\">\n{if {Current_Package:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Current_Package:descriptionhtml}\" for=\"Current_Package\">{Current_Package:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Current_Package:body}\n					<div><span class=\"formValidation\">{Current_Package:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-boss-maid-payment-amount rsform-type-textbox{Boss_Maid_Payment_Amount:errorClass}\">\n{if {Boss_Maid_Payment_Amount:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Boss_Maid_Payment_Amount:descriptionhtml}\" for=\"Boss_Maid_Payment_Amount\">{Boss_Maid_Payment_Amount:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Boss_Maid_Payment_Amount:body}\n					<div><span class=\"formValidation\">{Boss_Maid_Payment_Amount:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-amount-paid-to-maid rsform-type-textbox{Amount_Paid_to_Maid:errorClass}\">\n{if {Amount_Paid_to_Maid:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Amount_Paid_to_Maid:descriptionhtml}\" for=\"Amount_Paid_to_Maid\">{Amount_Paid_to_Maid:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Amount_Paid_to_Maid:body}\n					<div><span class=\"formValidation\">{Amount_Paid_to_Maid:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-date-of-payment rsform-type-jquerycalendar{Date_of_Payment:errorClass}\">\n{if {Date_of_Payment:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Date_of_Payment:descriptionhtml}\" for=\"txtjQcal8_0\">{Date_of_Payment:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Date_of_Payment:body}\n					<div><span class=\"formValidation\">{Date_of_Payment:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-advance-payment-for-next-pay rsform-type-radiogroup{Advance_Payment_for_Next_Pay:errorClass}\">\n{if {Advance_Payment_for_Next_Pay:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Advance_Payment_for_Next_Pay:descriptionhtml}\" id=\"Advance_Payment_for_Next_Pay-grouplbl\">{Advance_Payment_for_Next_Pay:caption}</label>\n{/if}\n				<div class=\"formControls\" role=\"group\" aria-labelledby=\"Advance_Payment_for_Next_Pay-grouplbl\">\n					{Advance_Payment_for_Next_Pay:body}\n					<div><span class=\"formValidation\">{Advance_Payment_for_Next_Pay:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-maid-rating rsform-type-selectlist{Maid_Rating:errorClass}\">\n{if {Maid_Rating:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Maid_Rating:descriptionhtml}\" for=\"Maid_Rating\">{Maid_Rating:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Maid_Rating:body}\n					<div><span class=\"formValidation\">{Maid_Rating:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-maid-review-comments rsform-type-textarea{Maid_Review_Comments:errorClass}\">\n{if {Maid_Review_Comments:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Maid_Review_Comments:descriptionhtml}\" for=\"Maid_Review_Comments\">{Maid_Review_Comments:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Maid_Review_Comments:body}\n					<div><span class=\"formValidation\">{Maid_Review_Comments:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-maid-boss-full-name rsform-type-textbox{Maid_Boss_Full_Name:errorClass}\">\n{if {Maid_Boss_Full_Name:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Maid_Boss_Full_Name:descriptionhtml}\" for=\"Maid_Boss_Full_Name\">{Maid_Boss_Full_Name:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Maid_Boss_Full_Name:body}\n					<div><span class=\"formValidation\">{Maid_Boss_Full_Name:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-total-expense-on-maid rsform-type-textbox{Total_Expense_on_Maid:errorClass}\">\n{if {Total_Expense_on_Maid:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Total_Expense_on_Maid:descriptionhtml}\" for=\"Total_Expense_on_Maid\">{Total_Expense_on_Maid:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Total_Expense_on_Maid:body}\n					<div><span class=\"formValidation\">{Total_Expense_on_Maid:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-maid-pay-expectation rsform-type-textbox{Maid_Pay_Expectation:errorClass}\">\n{if {Maid_Pay_Expectation:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Maid_Pay_Expectation:descriptionhtml}\" for=\"Maid_Pay_Expectation\">{Maid_Pay_Expectation:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Maid_Pay_Expectation:body}\n					<div><span class=\"formValidation\">{Maid_Pay_Expectation:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-6\">\n			<div class=\"mb-3 rsform-block rsform-block-lc1-details rsform-type-textarea{LC1_Details:errorClass}\">\n{if {LC1_Details:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{LC1_Details:descriptionhtml}\" for=\"LC1_Details\">{LC1_Details:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{LC1_Details:body}\n					<div><span class=\"formValidation\">{LC1_Details:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-6\">\n			<div class=\"mb-3 rsform-block rsform-block-next-of-kin rsform-type-textarea{Next_of_Kin:errorClass}\">\n{if {Next_of_Kin:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Next_of_Kin:descriptionhtml}\" for=\"Next_of_Kin\">{Next_of_Kin:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Next_of_Kin:body}\n					<div><span class=\"formValidation\">{Next_of_Kin:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-managed-by rsform-type-selectlist{Managed_by:errorClass}\">\n{if {Managed_by:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Managed_by:descriptionhtml}\" for=\"Managed_by\">{Managed_by:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Managed_by:body}\n					<div><span class=\"formValidation\">{Managed_by:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-maid-boss-paid-for-this-month rsform-type-radiogroup{Maid_Boss_Paid_for_this_Month:errorClass}\">\n{if {Maid_Boss_Paid_for_this_Month:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Maid_Boss_Paid_for_this_Month:descriptionhtml}\" id=\"Maid_Boss_Paid_for_this_Month-grouplbl\">{Maid_Boss_Paid_for_this_Month:caption}</label>\n{/if}\n				<div class=\"formControls\" role=\"group\" aria-labelledby=\"Maid_Boss_Paid_for_this_Month-grouplbl\">\n					{Maid_Boss_Paid_for_this_Month:body}\n					<div><span class=\"formValidation\">{Maid_Boss_Paid_for_this_Month:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-maid-paid-this-month rsform-type-radiogroup{Maid_Paid_this_Month:errorClass}\">\n{if {Maid_Paid_this_Month:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Maid_Paid_this_Month:descriptionhtml}\" id=\"Maid_Paid_this_Month-grouplbl\">{Maid_Paid_this_Month:caption}</label>\n{/if}\n				<div class=\"formControls\" role=\"group\" aria-labelledby=\"Maid_Paid_this_Month-grouplbl\">\n					{Maid_Paid_this_Month:body}\n					<div><span class=\"formValidation\">{Maid_Paid_this_Month:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-started-this-month rsform-type-radiogroup{Started_this_Month:errorClass}\">\n{if {Started_this_Month:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Started_this_Month:descriptionhtml}\" id=\"Started_this_Month-grouplbl\">{Started_this_Month:caption}</label>\n{/if}\n				<div class=\"formControls\" role=\"group\" aria-labelledby=\"Started_this_Month-grouplbl\">\n					{Started_this_Month:body}\n					<div><span class=\"formValidation\">{Started_this_Month:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-6\">\n			<div class=\"mb-3 rsform-block rsform-block-maid-photo rsform-type-fileupload{Maid_Photo:errorClass}\">\n{if {Maid_Photo:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Maid_Photo:descriptionhtml}\" for=\"Maid_Photo\">{Maid_Photo:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Maid_Photo:body}\n					<div><span class=\"formValidation\">{Maid_Photo:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-6\">\n			<div class=\"mb-3 rsform-block rsform-block-documents rsform-type-fileupload{Documents:errorClass}\">\n{if {Documents:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Documents:descriptionhtml}\" for=\"Documents\">{Documents:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Documents:body}\n					<div><span class=\"formValidation\">{Documents:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-6\">\n			<div class=\"mb-3 rsform-block rsform-block-their-agent rsform-type-selectize{Their_Agent:errorClass}\">\n{if {Their_Agent:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Their_Agent:descriptionhtml}\" for=\"Their_Agent\">{Their_Agent:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Their_Agent:body}\n					<div><span class=\"formValidation\">{Their_Agent:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-6\">\n			<div class=\"mb-3 rsform-block rsform-block-maid-national-id rsform-type-textbox{Maid_National_ID:errorClass}\">\n{if {Maid_National_ID:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Maid_National_ID:descriptionhtml}\" for=\"Maid_National_ID\">{Maid_National_ID:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Maid_National_ID:body}\n					<div><span class=\"formValidation\">{Maid_National_ID:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-12\">\n			<div class=\"mb-3 rsform-block rsform-block-submit rsform-type-submitbutton{Submit:errorClass}\">\n{if {Submit:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Submit:descriptionhtml}\">{Submit:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Submit:body}\n					<div><span class=\"formValidation\">{Submit:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n</div>\n					{Age:body}\n					{months:body}\n					{days:body}\n					{Local_Time:body}\n					{Documents_Count:body}', '[[{\"columns\":[[\"150\"],[\"158\"],[\"159\"],[\"160\"]],\"sizes\":[\"3\",\"4\",\"2\",\"3\"]},{\"columns\":[[\"182\"],[\"183\"],[\"184\"],[\"181\"]],\"sizes\":[\"3\",\"3\",\"3\",\"3\"]},{\"columns\":[[\"161\"],[\"162\"],[\"166\"],[\"164\"]],\"sizes\":[\"3\",\"3\",\"3\",\"3\"]},{\"columns\":[[\"165\"],[\"167\"],[\"168\"],[\"169\"]],\"sizes\":[\"3\",\"3\",\"3\",\"3\"]},{\"columns\":[[\"170\"],[\"171\"],[\"172\"],[\"173\"]],\"sizes\":[\"3\",\"3\",\"3\",\"3\"]},{\"columns\":[[\"185\"],[\"186\"],[\"187\"]],\"sizes\":[\"4\",\"4\",\"4\"]},{\"columns\":[[\"206\"],[\"207\"]],\"sizes\":[\"6\",\"6\"]},{\"columns\":[[\"189\"],[\"190\"],[\"191\"],[\"192\"]],\"sizes\":[\"3\",\"3\",\"3\",\"3\"]},{\"columns\":[[\"174\"],[\"175\"]],\"sizes\":[\"6\",\"6\"]},{\"columns\":[[\"220\"],[\"221\"]],\"sizes\":[\"6\",\"6\"]},{\"columns\":[[\"156\"]],\"sizes\":[\"12\"]}],[\"176\",\"177\",\"178\",\"188\",\"224\"]]', 'bootstrap5', '1', '1', '1', '0', '0', '<style>\r\n.form-label {\r\n  margin-bottom: 0.5rem;\r\n  color: #1e41a1;\r\n  font-size: 18px;\r\n  font-weight: bold;\r\n}\r\n</style>', '<script>\r\ndocument.addEventListener(\'DOMContentLoaded\', function() {\r\n    // Function to get local time in the desired format\r\n    function getFormattedLocalTime() {\r\n        const now = new Date();\r\n\r\n        // Extract date and time components\r\n        const year = now.getFullYear();\r\n        const month = String(now.getMonth() + 1).padStart(2, \'0\'); // Months are zero-based\r\n        const day = String(now.getDate()).padStart(2, \'0\');\r\n        const hours = String(now.getHours()).padStart(2, \'0\');\r\n        const minutes = String(now.getMinutes()).padStart(2, \'0\');\r\n        const seconds = String(now.getSeconds()).padStart(2, \'0\');\r\n\r\n        // Construct the desired format\r\n        const formattedTime = `${year}-${month}-${day} ${hours}:${minutes}:${seconds}`;\r\n\r\n        return formattedTime; // e.g., \"2025-02-16 06:09:24\"\r\n    }\r\n\r\n    // Find the hidden field by its name or ID\r\n    const localTimeField = document.querySelector(\'input[name=\"form[Local_Time]\"]\'); // Replace \'form[Local_Time]\' with your hidden field\'s name\r\n    if (localTimeField) {\r\n        localTimeField.value = getFormattedLocalTime();\r\n    }\r\n});\r\n</script>', 'Maids', '1', '1', 'en-GB', '', '1', '1', '0', '0', '<p>Maid data saved successfully.</p>\r\n<p>Uploaded file below:</p>\r\n<p><img src=\"{Maid_Photo:path}\"></p>', '1', '<p>Dear {FullName:value},</p><p> we received your contact request. Someone will get back to you by {ContactBy:value} soon. </p>', '', '', '', '{global:mailfrom}', '', '', '{global:fromname}', 'Contact confirmation', '1', '0', '', '0', '', 'mubmart7@gmail.com', 'admin@lafabsolution.com', '', '{global:mailfrom}', 'admin@lafabsolution.com', 'Lafab Solutions Maids Management', 'Lafab Solutions Maids Management', 'New Maid Added - {FullName:value}', '1', '1', '<p>The Maid Record for {FullName:value} has been deleted</p>', 'mubmart7@gmail.com', 'henrymuteesasira242@gmail.com,admin@lafabsolution.com,violacharlotte15@gmail.com', '', 'admin@lafabsolution.com', 'admin@lafabsolution.com', '', 'Lafab Solutions Maid Management', '{FullName:value} Maid has been deleted', '1', '$myBdField = $_POST[\'form\'][\'Date_of_Birth\'];\r\n\r\n$selected_date = $myBdField[\'y\'].\'-\'.$myBdField[\'m\'].\'-\'.$myBdField[\'d\'];\r\n$current_date = date(\'Y-m-d\');\r\n\r\n$selected_date_seconds = strtotime($selected_date);\r\n$current_date_seconds = strtotime($current_date);\r\n\r\nif ($current_date_seconds > $selected_date_seconds) {\r\n  $selected_date = new DateTime($selected_date); //starting seconds\r\n  $current_date = new DateTime($current_date); // ending seconds\r\n\r\n  $interval =  date_diff($current_date, $selected_date); //the time difference\r\n\r\n  $Age = (int) $interval->format(\'%y\');\r\n  $months = (int) $interval->format(\'%m\');\r\n  $days = (int) $interval->format(\'%d\');\r\n}\r\nelse \r\n{\r\n  $Age = 0;\r\n  $months = 0;\r\n  $days = 0;\r\n}\r\n\r\n$_POST[\'form\'][\'Age\'] = $Age;\r\n$_POST[\'form\'][\'months\'] = $months;\r\n$_POST[\'form\'][\'days\'] = $days;', '', '', '', '', '', '', '', '0', '', '', '(*)', '', ', ', '1', '', 'userForm', '', '', '', '0', '0', '1', '1', '0', '0', '0', '\"\"', '', '', '0'),
('9', 'Recieved Money', '<h2>{global:formtitle}</h2>\n{error}\n<!-- Do not remove this ID, it is used to identify the page so that the pagination script can work correctly -->\n<div class=\"formContainer\" id=\"rsform_{global:formid}_page_0\">\n	<div class=\"row\">\n		<div class=\"col-md-6\">\n			<div class=\"mb-3 rsform-block rsform-block-maid-boss rsform-type-textbox{Maid_Boss:errorClass}\">\n{if {Maid_Boss:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Maid_Boss:descriptionhtml}\" for=\"Maid_Boss\">{Maid_Boss:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Maid_Boss:body}\n					<div><span class=\"formValidation\">{Maid_Boss:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-6\">\n			<div class=\"mb-3 rsform-block rsform-block-payment-for rsform-type-selectlist{Payment_for:errorClass}\">\n{if {Payment_for:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Payment_for:descriptionhtml}\" for=\"Payment_for\">{Payment_for:caption}<strong class=\"formRequired\">(*)</strong></label>\n{/if}\n				<div class=\"formControls\">\n					{Payment_for:body}\n					<div><span class=\"formValidation\">{Payment_for:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-amount-recieved rsform-type-textbox{Amount_Recieved:errorClass}\">\n{if {Amount_Recieved:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Amount_Recieved:descriptionhtml}\" for=\"Amount_Recieved\">{Amount_Recieved:caption}<strong class=\"formRequired\">(*)</strong></label>\n{/if}\n				<div class=\"formControls\">\n					{Amount_Recieved:body}\n					<div><span class=\"formValidation\">{Amount_Recieved:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-mode-of-payment rsform-type-selectlist{Mode_of_Payment:errorClass}\">\n{if {Mode_of_Payment:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Mode_of_Payment:descriptionhtml}\" for=\"Mode_of_Payment\">{Mode_of_Payment:caption}<strong class=\"formRequired\">(*)</strong></label>\n{/if}\n				<div class=\"formControls\">\n					{Mode_of_Payment:body}\n					<div><span class=\"formValidation\">{Mode_of_Payment:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-date-recieved rsform-type-jquerycalendar{Date_Recieved:errorClass}\">\n{if {Date_Recieved:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Date_Recieved:descriptionhtml}\" for=\"txtjQcal9_0\">{Date_Recieved:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Date_Recieved:body}\n					<div><span class=\"formValidation\">{Date_Recieved:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-12\">\n			<div class=\"mb-3 rsform-block rsform-block-submit rsform-type-submitbutton{Submit:errorClass}\">\n{if {Submit:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Submit:descriptionhtml}\">{Submit:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Submit:body}\n					<div><span class=\"formValidation\">{Submit:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n</div>\n					{Local_Time:body}', '[[{\"columns\":[[\"198\"],[\"203\"]],\"sizes\":[\"6\",\"6\"]},{\"columns\":[[\"200\"],[\"204\"],[\"205\"]],\"sizes\":[\"4\",\"4\",\"4\"]},{\"columns\":[[\"201\"]],\"sizes\":[\"12\"]}],[\"202\"]]', 'bootstrap5', '1', '1', '1', '0', '0', '<style>\r\n.form-label {\r\n  margin-bottom: 0.5rem;\r\n  color: #1e41a1;\r\n  font-size: 18px;\r\n  font-weight: bold;\r\n}\r\n</style>', '<script>\r\ndocument.addEventListener(\'DOMContentLoaded\', function() {\r\n    // Function to get local time with timezone offset\r\n    function getFormattedLocalTime() {\r\n        const now = new Date();\r\n\r\n        // Get the local date and time\r\n        const localTime = now.toLocaleString(\"en-US\", { \r\n            hour12: false, // Use 24-hour format\r\n            timeZoneName: \"short\" // Include timezone abbreviation (e.g., GMT, EST)\r\n        });\r\n\r\n        return localTime; // e.g., \"12/11/2024, 16:30:00 GMT+3\"\r\n    }\r\n\r\n    // Find the hidden field by its name or ID\r\n    const localTimeField = document.querySelector(\'input[name=\"form[Local_Time]\"]\'); // Replace \'local_time\' with your hidden field\'s name\r\n    if (localTimeField) {\r\n        localTimeField.value = getFormattedLocalTime();\r\n    }\r\n});\r\n</script>\r\n', 'Recieved Money', '1', '1', 'en-GB', '', '1', '1', '0', '0', '<p>Dear {FullName:value},</p><p> thank you for your submission. One of our staff members will contact you by  {ContactBy:value} as soon as possible.</p>', '1', '<p>Dear {FullName:value},</p><p> we received your contact request. Someone will get back to you by {ContactBy:value} soon. </p>', '', '', '', '{global:mailfrom}', '', '', '{global:fromname}', 'Contact confirmation', '1', '0', '', '0', '<p> </p>\r\n<p> </p>', 'mubmart7@gmail.com', 'admin@lafabsolution.com,kyammulumba@gmail.com', '', '{global:mailfrom}', '', '', 'Lafab Maids', 'Maid Boss {Maid_Boss:value} has paid for {Payment_for:value}', '1', '1', '', '', '', '', '', '', '', '', '', '1', '', '', '', '', '', '', '', '', '0', '', '', '(*)', '', ', ', '1', '', 'userForm', '', '', '', '1', '1', '1', '1', '0', '0', '0', '\"\"', '', '', '0'),
('11', 'Maids Workers Agents', '<h2>{global:formtitle}</h2>\n{error}\n<!-- Do not remove this ID, it is used to identify the page so that the pagination script can work correctly -->\n<div class=\"formContainer\" id=\"rsform_{global:formid}_page_0\">\n	<div class=\"row\">\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-name-of-the-agent rsform-type-textbox{Name_of_the_Agent:errorClass}\">\n{if {Name_of_the_Agent:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Name_of_the_Agent:descriptionhtml}\" for=\"Name_of_the_Agent\">{Name_of_the_Agent:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Name_of_the_Agent:body}\n					<div><span class=\"formValidation\">{Name_of_the_Agent:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-district rsform-type-selectize{District:errorClass}\">\n{if {District:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{District:descriptionhtml}\" for=\"District\">{District:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{District:body}\n					<div><span class=\"formValidation\">{District:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-phone-number rsform-type-phonenumber{Phone_Number:errorClass}\">\n{if {Phone_Number:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Phone_Number:descriptionhtml}\" for=\"Phone_Number\">{Phone_Number:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Phone_Number:body}\n					<div><span class=\"formValidation\">{Phone_Number:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-3\">\n			<div class=\"mb-3 rsform-block rsform-block-alternative-phone-number rsform-type-phonenumber{Alternative_Phone_Number:errorClass}\">\n{if {Alternative_Phone_Number:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Alternative_Phone_Number:descriptionhtml}\" for=\"Alternative_Phone_Number\">{Alternative_Phone_Number:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Alternative_Phone_Number:body}\n					<div><span class=\"formValidation\">{Alternative_Phone_Number:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-email rsform-type-textbox{Email:errorClass}\">\n{if {Email:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Email:descriptionhtml}\" for=\"Email\">{Email:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Email:body}\n					<div><span class=\"formValidation\">{Email:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-residence rsform-type-textbox{Residence:errorClass}\">\n{if {Residence:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Residence:descriptionhtml}\" for=\"Residence\">{Residence:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Residence:body}\n					<div><span class=\"formValidation\">{Residence:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-gender rsform-type-selectlist{Gender:errorClass}\">\n{if {Gender:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Gender:descriptionhtml}\" for=\"Gender\">{Gender:caption}<strong class=\"formRequired\">(*)</strong></label>\n{/if}\n				<div class=\"formControls\">\n					{Gender:body}\n					<div><span class=\"formValidation\">{Gender:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-age rsform-type-textbox{Age:errorClass}\">\n{if {Age:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Age:descriptionhtml}\" for=\"Age\">{Age:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Age:body}\n					<div><span class=\"formValidation\">{Age:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-national-id rsform-type-textbox{National_ID:errorClass}\">\n{if {National_ID:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{National_ID:descriptionhtml}\" for=\"National_ID\">{National_ID:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{National_ID:body}\n					<div><span class=\"formValidation\">{National_ID:validation}</span></div>\n				</div>\n			</div>\n		</div>\n		<div class=\"col-md-4\">\n			<div class=\"mb-3 rsform-block rsform-block-documents rsform-type-fileupload{Documents:errorClass}\">\n{if {Documents:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Documents:descriptionhtml}\" for=\"Documents\">{Documents:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Documents:body}\n					<div><span class=\"formValidation\">{Documents:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class=\"row\">\n		<div class=\"col-md-12\">\n			<div class=\"mb-3 rsform-block rsform-block-submit rsform-type-submitbutton{Submit:errorClass}\">\n{if {Submit:caption}}\n				<label class=\"form-label formControlLabel\" data-bs-toggle=\"tooltip\" title=\"{Submit:descriptionhtml}\">{Submit:caption}</label>\n{/if}\n				<div class=\"formControls\">\n					{Submit:body}\n					<div><span class=\"formValidation\">{Submit:validation}</span></div>\n				</div>\n			</div>\n		</div>\n	</div>\n</div>', '[[{\"columns\":[[\"219\"],[\"212\"],[\"213\"],[\"222\"]],\"sizes\":[\"3\",\"3\",\"3\",\"3\"]},{\"columns\":[[\"214\"],[\"215\"],[\"216\"]],\"sizes\":[\"4\",\"4\",\"4\"]},{\"columns\":[[\"217\"],[\"218\"],[\"223\"]],\"sizes\":[\"4\",\"4\",\"4\"]},{\"columns\":[[\"211\"]],\"sizes\":[\"12\"]}],[]]', 'bootstrap5', '1', '1', '1', '0', '0', '<style>\r\n.form-label {\r\n  margin-bottom: 0.5rem;\r\n  color: #1e41a1;\r\n  font-size: 18px;\r\n  font-weight: bold;\r\n}\r\n</style>', '<script>\r\ndocument.addEventListener(\'DOMContentLoaded\', function() {\r\n    // Function to get local time with timezone offset\r\n    function getFormattedLocalTime() {\r\n        const now = new Date();\r\n\r\n        // Get the local date and time\r\n        const localTime = now.toLocaleString(\"en-US\", { \r\n            hour12: false, // Use 24-hour format\r\n            timeZoneName: \"short\" // Include timezone abbreviation (e.g., GMT, EST)\r\n        });\r\n\r\n        return localTime; // e.g., \"12/11/2024, 16:30:00 GMT+3\"\r\n    }\r\n\r\n    // Find the hidden field by its name or ID\r\n    const localTimeField = document.querySelector(\'input[name=\"form[Local_Time]\"]\'); // Replace \'local_time\' with your hidden field\'s name\r\n    if (localTimeField) {\r\n        localTimeField.value = getFormattedLocalTime();\r\n    }\r\n});\r\n</script>\r\n', 'Maids Workers Agents', '1', '1', 'en-GB', '', '1', '1', '0', '0', '<p>Dear {FullName:value},</p><p> thank you for your submission. One of our staff members will contact you by  {ContactBy:value} as soon as possible.</p>', '1', '<p>Dear {FullName:value},</p><p> we received your contact request. Someone will get back to you by {ContactBy:value} soon. </p>', '', '', '', '{global:mailfrom}', '', '', '{global:fromname}', 'Contact confirmation', '1', '0', '', '0', '<p>Agent {Name of the Agent:value} has been added </p>\n<p> </p>', 'mubmart7@gmail.com', 'admin@lafabsolution.com', '', '{global:mailfrom}', '', '', 'Maids System', 'Maid {Name_of_the_Agent:value} has been added ', '1', '1', '', '', '', '', '', '', '', '', '', '1', '', '', '', '', '', '', '', '', '0', '', '', '(*)', '', ', ', '1', '', 'userForm', '', '', '', '1', '1', '1', '1', '0', '0', '0', '\"\"', '', '', '0');
/**ABDB**/CREATE TABLE `#__redirect_links` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `old_url` varchar(2048) NOT NULL,
  `new_url` varchar(2048) DEFAULT NULL,
  `referer` varchar(2048) NOT NULL,
  `comment` varchar(255) NOT NULL DEFAULT '',
  `hits` int(10) unsigned NOT NULL DEFAULT 0,
  `published` tinyint(4) NOT NULL,
  `created_date` datetime NOT NULL,
  `modified_date` datetime NOT NULL,
  `header` smallint(6) NOT NULL DEFAULT 301,
  PRIMARY KEY (`id`),
  KEY `idx_old_url` (`old_url`(100)),
  KEY `idx_link_modified` (`modified_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__akeebabackup_storage` (
  `tag` varchar(255) NOT NULL,
  `lastupdate` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `data` longtext DEFAULT NULL,
  PRIMARY KEY (`tag`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__privacy_consents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `state` int(11) NOT NULL DEFAULT 1,
  `created` datetime NOT NULL,
  `subject` varchar(255) NOT NULL DEFAULT '',
  `body` text NOT NULL,
  `remind` tinyint(4) NOT NULL DEFAULT 0,
  `token` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__schemas` (
  `extension_id` int(11) NOT NULL,
  `version_id` varchar(20) NOT NULL,
  PRIMARY KEY (`extension_id`,`version_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__schemas`  VALUES 
('220', '5.2.2-2024-09-24'),
('235', '9.4.0-20221011'),
('240', '4.0.2');
/**ABDB**/CREATE TABLE `#__finder_terms_common` (
  `term` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `language` char(7) NOT NULL DEFAULT '',
  `custom` int(11) NOT NULL DEFAULT 0,
  UNIQUE KEY `idx_term_language` (`term`,`language`),
  KEY `idx_lang` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__finder_terms_common`  VALUES 
('a', 'en', '0'),
('about', 'en', '0'),
('above', 'en', '0'),
('after', 'en', '0'),
('again', 'en', '0'),
('against', 'en', '0'),
('all', 'en', '0'),
('am', 'en', '0'),
('an', 'en', '0'),
('and', 'en', '0'),
('any', 'en', '0'),
('are', 'en', '0'),
('aren\'t', 'en', '0'),
('as', 'en', '0'),
('at', 'en', '0'),
('be', 'en', '0'),
('because', 'en', '0'),
('been', 'en', '0'),
('before', 'en', '0'),
('being', 'en', '0'),
('below', 'en', '0'),
('between', 'en', '0'),
('both', 'en', '0'),
('but', 'en', '0'),
('by', 'en', '0'),
('can\'t', 'en', '0'),
('cannot', 'en', '0'),
('could', 'en', '0'),
('couldn\'t', 'en', '0'),
('did', 'en', '0'),
('didn\'t', 'en', '0'),
('do', 'en', '0'),
('does', 'en', '0'),
('doesn\'t', 'en', '0'),
('doing', 'en', '0'),
('don\'t', 'en', '0'),
('down', 'en', '0'),
('during', 'en', '0'),
('each', 'en', '0'),
('few', 'en', '0'),
('for', 'en', '0'),
('from', 'en', '0'),
('further', 'en', '0'),
('had', 'en', '0'),
('hadn\'t', 'en', '0'),
('has', 'en', '0'),
('hasn\'t', 'en', '0'),
('have', 'en', '0'),
('haven\'t', 'en', '0'),
('having', 'en', '0'),
('he', 'en', '0'),
('he\'d', 'en', '0'),
('he\'ll', 'en', '0'),
('he\'s', 'en', '0'),
('her', 'en', '0'),
('here', 'en', '0'),
('here\'s', 'en', '0'),
('hers', 'en', '0'),
('herself', 'en', '0'),
('him', 'en', '0'),
('himself', 'en', '0'),
('his', 'en', '0'),
('how', 'en', '0'),
('how\'s', 'en', '0'),
('i', 'en', '0'),
('i\'d', 'en', '0'),
('i\'ll', 'en', '0'),
('i\'m', 'en', '0'),
('i\'ve', 'en', '0'),
('if', 'en', '0'),
('in', 'en', '0'),
('into', 'en', '0'),
('is', 'en', '0'),
('isn\'t', 'en', '0'),
('it', 'en', '0'),
('it\'s', 'en', '0'),
('its', 'en', '0'),
('itself', 'en', '0'),
('let\'s', 'en', '0'),
('me', 'en', '0'),
('more', 'en', '0'),
('most', 'en', '0'),
('mustn\'t', 'en', '0'),
('my', 'en', '0'),
('myself', 'en', '0'),
('no', 'en', '0'),
('nor', 'en', '0'),
('not', 'en', '0'),
('of', 'en', '0'),
('off', 'en', '0'),
('on', 'en', '0'),
('once', 'en', '0'),
('only', 'en', '0'),
('or', 'en', '0'),
('other', 'en', '0'),
('ought', 'en', '0'),
('our', 'en', '0'),
('ours', 'en', '0'),
('ourselves', 'en', '0'),
('out', 'en', '0'),
('over', 'en', '0'),
('own', 'en', '0'),
('same', 'en', '0'),
('shan\'t', 'en', '0'),
('she', 'en', '0'),
('she\'d', 'en', '0'),
('she\'ll', 'en', '0'),
('she\'s', 'en', '0'),
('should', 'en', '0'),
('shouldn\'t', 'en', '0'),
('so', 'en', '0'),
('some', 'en', '0'),
('such', 'en', '0'),
('than', 'en', '0'),
('that', 'en', '0'),
('that\'s', 'en', '0'),
('the', 'en', '0'),
('their', 'en', '0'),
('theirs', 'en', '0'),
('them', 'en', '0'),
('themselves', 'en', '0'),
('then', 'en', '0'),
('there', 'en', '0'),
('there\'s', 'en', '0'),
('these', 'en', '0'),
('they', 'en', '0'),
('they\'d', 'en', '0'),
('they\'ll', 'en', '0'),
('they\'re', 'en', '0'),
('they\'ve', 'en', '0'),
('this', 'en', '0'),
('those', 'en', '0'),
('through', 'en', '0'),
('to', 'en', '0'),
('too', 'en', '0'),
('under', 'en', '0'),
('until', 'en', '0'),
('up', 'en', '0'),
('very', 'en', '0'),
('was', 'en', '0'),
('wasn\'t', 'en', '0'),
('we', 'en', '0'),
('we\'d', 'en', '0'),
('we\'ll', 'en', '0'),
('we\'re', 'en', '0'),
('we\'ve', 'en', '0'),
('were', 'en', '0'),
('weren\'t', 'en', '0'),
('what', 'en', '0'),
('what\'s', 'en', '0'),
('when', 'en', '0'),
('when\'s', 'en', '0'),
('where', 'en', '0'),
('where\'s', 'en', '0'),
('which', 'en', '0'),
('while', 'en', '0'),
('who', 'en', '0'),
('who\'s', 'en', '0'),
('whom', 'en', '0'),
('why', 'en', '0'),
('why\'s', 'en', '0'),
('with', 'en', '0'),
('won\'t', 'en', '0'),
('would', 'en', '0'),
('wouldn\'t', 'en', '0'),
('you', 'en', '0'),
('you\'d', 'en', '0'),
('you\'ll', 'en', '0'),
('you\'re', 'en', '0'),
('you\'ve', 'en', '0'),
('your', 'en', '0'),
('yours', 'en', '0'),
('yourself', 'en', '0'),
('yourselves', 'en', '0');
/**ABDB**/CREATE TABLE `#__finder_terms` (
  `term_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `term` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `stem` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `common` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `phrase` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `weight` float unsigned NOT NULL DEFAULT 0,
  `soundex` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `links` int(11) NOT NULL DEFAULT 0,
  `language` char(7) NOT NULL DEFAULT '',
  PRIMARY KEY (`term_id`),
  UNIQUE KEY `idx_term_language` (`term`,`language`),
  KEY `idx_stem` (`stem`),
  KEY `idx_term_phrase` (`term`,`phrase`),
  KEY `idx_stem_phrase` (`stem`,`phrase`),
  KEY `idx_soundex_phrase` (`soundex`,`phrase`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=2610 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__rsform_submissions` (
  `SubmissionId` int(11) NOT NULL AUTO_INCREMENT,
  `FormId` int(11) NOT NULL DEFAULT 0,
  `DateSubmitted` datetime NOT NULL,
  `UserIp` varchar(255) NOT NULL DEFAULT '',
  `Username` varchar(255) NOT NULL DEFAULT '',
  `UserId` int(11) NOT NULL DEFAULT 0,
  `Lang` varchar(255) NOT NULL,
  `confirmed` tinyint(1) NOT NULL,
  `ConfirmedIp` varchar(255) NOT NULL DEFAULT '',
  `ConfirmedDate` datetime DEFAULT NULL,
  `SubmissionHash` varchar(32) NOT NULL,
  PRIMARY KEY (`SubmissionId`),
  KEY `FormId` (`FormId`),
  KEY `SubmissionId` (`SubmissionId`,`FormId`,`DateSubmitted`),
  KEY `SubmissionHash` (`SubmissionHash`)
) ENGINE=InnoDB AUTO_INCREMENT=303 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/**ABDB**/INSERT INTO `#__rsform_submissions`  VALUES 
('1', '1', '2025-02-02 08:55:43', '154.227.128.193', 'NGOClient', '958', 'en-GB', '1', '', NULL, '52ce2d30f62545189ba8163776ff1f7e'),
('40', '3', '2025-02-10 17:54:28', '154.227.128.188', 'NGOClient', '958', 'en-GB', '1', '', NULL, '60e5dcc8bd4b3fde05978aa0d71f3359'),
('46', '6', '2025-02-16 07:40:57', '41.75.173.38', '', '0', 'en-GB', '1', '', NULL, 'bf6afd08d9834894800e17690be9c912'),
('47', '6', '2025-02-16 08:33:03', '41.75.173.38', '', '0', 'en-GB', '1', '', NULL, '765832a579c8577304d5184c1fc24336'),
('48', '6', '2025-02-16 08:35:48', '41.75.173.38', '', '0', 'en-GB', '1', '', NULL, '0ec8ff79fc460e6ee59090ceaadbb048'),
('49', '6', '2025-02-17 09:29:58', '41.75.182.168', '', '0', 'en-GB', '1', '', NULL, '1ac608fdcb9f73fa3de141961f8308f3'),
('50', '6', '2025-02-18 08:23:10', '41.75.190.51', '', '0', 'en-GB', '1', '', NULL, 'ae5c265cf3f4db326f2ead864289bcaf'),
('51', '6', '2025-02-18 15:04:04', '41.75.173.179', '', '0', 'en-GB', '1', '', NULL, 'fe96173efa9a824159d97c3e6a2338f9'),
('52', '6', '2025-02-18 15:52:47', '41.75.173.179', '', '0', 'en-GB', '1', '', NULL, 'bb760ce75e14856ee85a0b7ecb36688e'),
('53', '6', '2025-02-18 19:20:50', '41.75.185.39', '', '0', 'en-GB', '1', '', NULL, '125f292ac018339e06dae064360e6121'),
('54', '6', '2025-02-19 07:05:00', '41.75.182.212', '', '0', 'en-GB', '1', '', NULL, 'ae0ffe971131b43e724fba279fd477ee'),
('55', '6', '2025-02-19 12:01:06', '41.75.185.253', '', '0', 'en-GB', '1', '', NULL, 'ba7329719c0b8c7fe13c6cc8f0994445'),
('56', '6', '2025-02-20 06:02:10', '197.239.15.122', '', '0', 'en-GB', '1', '', NULL, '1a4ac904a4121fac27f3542c117c8173'),
('65', '8', '2025-02-26 11:45:11', '41.75.176.154', 'sharon', '961', 'en-GB', '1', '', NULL, '930e84bb9eedfe6fbd68a76fee777030'),
('66', '8', '2025-02-26 13:19:30', '41.75.176.154', 'sharon', '961', 'en-GB', '1', '', NULL, 'b4ccf7735ab914fb2ea411df92b173ee'),
('67', '8', '2025-02-27 07:07:08', '197.239.11.118', 'sharon', '961', 'en-GB', '1', '', NULL, '444485242e3820e5057605e3139a05fe'),
('68', '8', '2025-03-03 09:12:59', '41.75.174.44', 'sharon', '961', 'en-GB', '1', '', NULL, '357ddefbe4b60525cb25c3bb094b6645'),
('69', '8', '2025-03-03 09:18:04', '41.75.174.44', 'sharon', '961', 'en-GB', '1', '', NULL, '6c477617c2b643e5cecbf1c5c2045d69'),
('70', '8', '2025-03-03 09:23:26', '41.75.174.44', 'sharon', '961', 'en-GB', '1', '', NULL, '3d86dd90847f83ad6ceaab5dec503d6a'),
('71', '8', '2025-03-03 09:27:22', '41.75.174.44', 'sharon', '961', 'en-GB', '1', '', NULL, 'f62c3bf121ab863aeb4278a917779c11'),
('72', '8', '2025-03-03 09:32:21', '41.75.174.44', 'sharon', '961', 'en-GB', '1', '', NULL, 'aa217f05cfb65d39e9d746bc70c53799'),
('73', '8', '2025-03-03 10:24:18', '41.75.174.44', 'sharon', '961', 'en-GB', '1', '', NULL, 'faaacd2f2cd2eadb7d7c50d71f682f76'),
('74', '8', '2025-03-03 10:34:00', '41.75.174.44', 'sharon', '961', 'en-GB', '1', '', NULL, '6cf09afb9c522f3ee8907ccda7705b78'),
('75', '8', '2025-03-03 10:47:24', '41.75.174.44', 'sharon', '961', 'en-GB', '1', '', NULL, 'a4e8120b67e2b79caa10ae16d4700c13'),
('76', '8', '2025-03-03 10:53:11', '41.75.174.44', 'sharon', '961', 'en-GB', '1', '', NULL, '433b526b4d3f58051f3cd4c0a919aed0'),
('77', '8', '2025-03-03 11:01:32', '41.75.174.44', 'sharon', '961', 'en-GB', '1', '', NULL, '9515e490a8791ff5a53e9c47d930ce7e'),
('78', '8', '2025-03-03 11:32:29', '41.75.174.44', 'sharon', '961', 'en-GB', '1', '', NULL, '3a6736daf8afc320680a5811cc372b21'),
('79', '8', '2025-03-03 11:36:13', '41.75.174.44', 'sharon', '961', 'en-GB', '1', '', NULL, 'f14c47d4f5e75602110053ccd02b64ca'),
('80', '8', '2025-03-03 11:43:09', '41.75.174.44', 'sharon', '961', 'en-GB', '1', '', NULL, '67f449bc6d1976ae1bbd25ab782495be'),
('81', '8', '2025-03-03 12:10:22', '41.75.174.44', 'sharon', '961', 'en-GB', '1', '', NULL, 'aa39f608f9a0352c0dd777a6927af5bc'),
('82', '8', '2025-03-03 12:14:27', '41.75.174.44', 'sharon', '961', 'en-GB', '1', '', NULL, '1993e09f60b5b84c42fd3e9fa4505ab7'),
('83', '8', '2025-03-03 12:22:08', '41.75.174.44', 'sharon', '961', 'en-GB', '1', '', NULL, '58cbddbb02e7699a4aed0d7ad4b5b183'),
('84', '8', '2025-03-04 13:54:49', '41.75.176.199', 'sharon', '961', 'en-GB', '1', '', NULL, 'f319c704ab81ef72284359b732552a46'),
('85', '8', '2025-03-04 13:58:31', '41.75.176.199', 'sharon', '961', 'en-GB', '1', '', NULL, '65edef5cc82f9fd85fc0cc794b37cd0a'),
('86', '8', '2025-03-05 06:42:12', '41.75.190.99', 'sharon', '961', 'en-GB', '1', '', NULL, '4cbd788fa4eeee001d99e870edb04ab0'),
('87', '8', '2025-03-05 06:48:31', '41.75.190.99', 'sharon', '961', 'en-GB', '1', '', NULL, 'cf1fab58a6f4b28104d437714b06322b'),
('88', '8', '2025-03-05 12:34:57', '41.75.190.99', 'sharon', '961', 'en-GB', '1', '', NULL, '16ad16715bb31b877eda76bcaec4852e'),
('89', '8', '2025-03-05 12:43:27', '41.75.190.99', 'sharon', '961', 'en-GB', '1', '', NULL, '7fd1c0186d9b77f9dadd4899d748c1a1'),
('90', '8', '2025-03-05 12:53:31', '41.75.190.99', 'sharon', '961', 'en-GB', '1', '', NULL, '5f1d57828748fee8ca1f803441bc7215'),
('91', '8', '2025-03-05 13:10:23', '41.75.190.99', 'sharon', '961', 'en-GB', '1', '', NULL, '3e8a9294cd3cf9ffed948f9494df1164'),
('92', '8', '2025-03-05 13:28:33', '41.75.190.99', 'sharon', '961', 'en-GB', '1', '', NULL, 'ff6adfdee1c7c3378cd9048c35b924bf'),
('93', '8', '2025-03-07 09:33:53', '102.209.109.81', 'sharon', '961', 'en-GB', '1', '', NULL, '35854a4c030715b6af805144b6eefac8'),
('94', '8', '2025-03-07 10:06:54', '102.209.109.81', 'sharon', '961', 'en-GB', '1', '', NULL, '16762f5ab826cbe5b27611d51e8652ee'),
('95', '8', '2025-03-07 10:31:27', '102.209.109.81', 'sharon', '961', 'en-GB', '1', '', NULL, 'ec8894367b09cbc4d34d1516a50c493e'),
('96', '8', '2025-03-07 11:30:16', '102.209.109.81', 'sharon', '961', 'en-GB', '1', '', NULL, '4532efc554591d0699dce1ae95bd1f8a'),
('97', '8', '2025-03-07 13:52:14', '102.209.109.81', 'sharon', '961', 'en-GB', '1', '', NULL, '8976f8fb6b3bd6d7d800bccb85c45080'),
('98', '8', '2025-03-11 05:41:19', '102.209.109.81', 'sharon', '961', 'en-GB', '1', '', NULL, '88a38b574011383a1d15e948d691e9b1'),
('99', '8', '2025-03-12 06:11:31', '197.239.13.142', 'sharon', '961', 'en-GB', '1', '', NULL, '716582fa07763ca4d2f3deb305c95cc5'),
('100', '8', '2025-03-12 06:14:09', '197.239.13.142', 'sharon', '961', 'en-GB', '1', '', NULL, '89f706d837c01c2d4230236c505e0b9d'),
('101', '8', '2025-03-13 09:12:10', '197.239.9.202', 'sharon', '961', 'en-GB', '1', '', NULL, 'f5771f831ba27d2880de6eb5fc9a1b4f'),
('102', '8', '2025-03-13 09:14:35', '197.239.9.202', 'sharon', '961', 'en-GB', '1', '', NULL, '2e513dec61ed4c8c8c270677c1acb65b'),
('103', '8', '2025-03-13 09:18:00', '197.239.9.202', 'sharon', '961', 'en-GB', '1', '', NULL, '72e4867ec599eaa31767cd6c500f70a8'),
('104', '8', '2025-03-13 09:20:15', '197.239.9.202', 'sharon', '961', 'en-GB', '1', '', NULL, 'f4d22eb442d7560293336541d6afb3bf'),
('105', '8', '2025-03-13 09:22:53', '197.239.9.202', 'sharon', '961', 'en-GB', '1', '', NULL, '9eeb2c7c5f30215098fb30855d59cbf0'),
('106', '8', '2025-03-13 09:25:29', '197.239.9.202', 'sharon', '961', 'en-GB', '1', '', NULL, 'f120e1a5aff67c4b586f51a6315c9735'),
('107', '8', '2025-03-13 09:27:39', '197.239.9.202', 'sharon', '961', 'en-GB', '1', '', NULL, '5d1c77799bdf44256863104c4d31fc55'),
('108', '8', '2025-03-13 09:31:12', '197.239.9.202', 'sharon', '961', 'en-GB', '1', '', NULL, '51f708bbf5a0cc920af18a4c8d68d753'),
('109', '8', '2025-03-13 09:33:11', '197.239.9.202', 'sharon', '961', 'en-GB', '1', '', NULL, 'f77994bbb4a891331e162c6289f89143'),
('110', '8', '2025-03-18 10:10:41', '197.239.14.158', 'sharon', '961', 'en-GB', '1', '', NULL, '64790680d115d151e86effa39fed6990'),
('111', '8', '2025-03-19 05:46:43', '102.209.109.70', 'sharon', '961', 'en-GB', '1', '', NULL, '0ed49109bc0e8799141a92f4d814f419'),
('112', '8', '2025-03-19 05:49:13', '102.209.109.70', 'sharon', '961', 'en-GB', '1', '', NULL, 'dea7c77abd9e2270b4f1c8cf29ff071e'),
('113', '8', '2025-03-19 05:55:04', '102.209.109.70', 'sharon', '961', 'en-GB', '1', '', NULL, '7c9f1c71d3a3c2c9bc0f747c2dc010e5'),
('114', '8', '2025-03-19 08:48:05', '102.209.109.70', 'sharon', '961', 'en-GB', '1', '', NULL, '3278a81942372b6696282f24b039c729'),
('115', '8', '2025-03-25 13:54:25', '102.209.109.70', 'sharon', '961', 'en-GB', '1', '', NULL, '482fd07eb9d918494064877b606a0bc0'),
('116', '8', '2025-03-31 05:21:21', '197.239.15.20', 'sharon', '961', 'en-GB', '1', '', NULL, 'e7b0e63b137aeee169dd71fd66f9c960'),
('117', '8', '2025-03-31 05:23:42', '197.239.15.20', 'sharon', '961', 'en-GB', '1', '', NULL, '8f7c2d5f9e14e100e8aa1dbbc4728eef'),
('118', '8', '2025-03-31 05:27:32', '197.239.15.20', 'sharon', '961', 'en-GB', '1', '', NULL, '671e000f7bce67cd2f38c2bed398dfd3'),
('119', '8', '2025-03-31 05:41:50', '197.239.15.20', 'sharon', '961', 'en-GB', '1', '', NULL, '810c053288710b08bbda5b5a17271df0'),
('120', '8', '2025-03-31 05:45:58', '197.239.15.20', 'sharon', '961', 'en-GB', '1', '', NULL, '3c9c1c91dd6fe0ecc544a24175a4c60f'),
('121', '8', '2025-03-31 05:52:56', '197.239.15.20', 'sharon', '961', 'en-GB', '1', '', NULL, '32df69fd9aaad8ede8d2cc8d351179a8'),
('122', '8', '2025-03-31 06:00:06', '197.239.15.20', 'sharon', '961', 'en-GB', '1', '', NULL, '69d58a37513ea8584182e7a5701289ee'),
('123', '8', '2025-03-31 10:39:39', '102.209.109.70', 'sharon', '961', 'en-GB', '1', '', NULL, '9bfb49ac016e072d13496b62f6bd7fdf'),
('124', '8', '2025-03-31 10:44:30', '102.209.109.70', 'sharon', '961', 'en-GB', '1', '', NULL, '24f5e6ecaeb4d2d7a98903006baae6fa'),
('125', '8', '2025-04-03 08:28:36', '102.209.109.70', 'sharon', '961', 'en-GB', '1', '', NULL, '91ee4b3c77167e97c4ba8ba8acd821a0'),
('126', '7', '2025-04-03 08:35:53', '102.209.109.70', 'sharon', '961', 'en-GB', '1', '', NULL, '5a772d34a3aafd83c5ca21a3dd25ddbf'),
('127', '7', '2025-04-03 08:36:32', '102.209.109.70', 'sharon', '961', 'en-GB', '1', '', NULL, '4493b87cd7cbae296cbb619376a47444'),
('128', '7', '2025-04-03 08:37:33', '102.209.109.70', 'sharon', '961', 'en-GB', '1', '', NULL, 'd9616c8f15ffe4f95be34091cf28b342'),
('129', '7', '2025-04-07 05:08:42', '197.239.11.224', 'sharon', '961', 'en-GB', '1', '', NULL, '7719f503ad38c1c3ede304ffcdbedff2'),
('130', '7', '2025-04-08 08:52:38', '102.209.111.2', 'sharon', '961', 'en-GB', '1', '', NULL, '0c11a256e2a7bed7fdb9a0ff59a4ab54'),
('131', '7', '2025-04-08 08:55:57', '102.209.111.2', 'sharon', '961', 'en-GB', '1', '', NULL, '217172c34cfd1248e0c23a3756ea7322'),
('132', '7', '2025-04-08 08:57:17', '102.209.111.2', 'sharon', '961', 'en-GB', '1', '', NULL, '6ede27d80f5d476b6e28c42b1f8639d6'),
('133', '9', '2025-04-14 07:38:57', '102.209.111.12', 'sharon', '961', 'en-GB', '1', '', NULL, 'e991924930cbea26a72688494e53e5cd'),
('134', '7', '2025-04-14 13:09:28', '102.209.111.8', 'sharon', '961', 'en-GB', '1', '', NULL, 'fd95a6809d611af49db626c77c328d7b'),
('135', '7', '2025-04-17 06:29:27', '102.209.111.12', 'sharon', '961', 'en-GB', '1', '', NULL, 'f62423214332d762c0bc435cce227841'),
('136', '9', '2025-04-18 04:25:53', '41.210.159.210', 'sharon', '961', 'en-GB', '1', '', NULL, 'd8a90e720c03a3d24120200e159d4128'),
('137', '7', '2025-04-24 05:40:54', '102.209.111.15', 'sharon', '961', 'en-GB', '1', '', NULL, 'd74e23cb60b956f5f254801b87c12a6c'),
('138', '7', '2025-04-24 05:41:47', '102.209.111.15', 'sharon', '961', 'en-GB', '1', '', NULL, '68feac7ded37e28a3ee10b4cb41bb295'),
('139', '8', '2025-04-24 05:45:31', '102.209.111.15', 'sharon', '961', 'en-GB', '1', '', NULL, '058acb33ed305adb04a9b55e7f219db6'),
('140', '7', '2025-04-24 06:14:08', '102.209.111.15', 'sharon', '961', 'en-GB', '1', '', NULL, '30b2ad9956f362d2cec4770a4d7225f2'),
('141', '7', '2025-04-25 09:04:49', '102.209.111.12', 'sharon', '961', 'en-GB', '1', '', NULL, 'cb36cbde4f29894e5ec27cde8665a095'),
('142', '9', '2025-04-25 09:05:14', '102.209.111.12', 'sharon', '961', 'en-GB', '1', '', NULL, '0bda008b3bfb24109a86e410041109d6'),
('143', '9', '2025-05-02 06:55:19', '102.209.111.12', 'sharon', '961', 'en-GB', '1', '', NULL, 'f878a27f59a1cc77a5fe9e25e0d33a47'),
('144', '9', '2025-05-02 06:56:07', '102.209.111.12', 'sharon', '961', 'en-GB', '1', '', NULL, '355c40ad4f00523f23c64fc81e54bdf2'),
('145', '9', '2025-05-02 07:11:30', '102.209.111.12', 'sharon', '961', 'en-GB', '1', '', NULL, '4233ccb09dc7af57f4478e41e49ebed3'),
('146', '9', '2025-05-02 07:12:07', '102.209.111.12', 'sharon', '961', 'en-GB', '1', '', NULL, '6b9e2b6012ff99e898149f19fbbffab6'),
('147', '7', '2025-05-02 07:25:00', '102.209.111.12', 'sharon', '961', 'en-GB', '1', '', NULL, '35865dafdaa63fc3ba66a3b9c5ddd826'),
('148', '7', '2025-05-02 07:26:39', '102.209.111.12', 'sharon', '961', 'en-GB', '1', '', NULL, '4625353daf4bed1be14f91090366695e'),
('149', '7', '2025-05-02 07:27:11', '102.209.111.12', 'sharon', '961', 'en-GB', '1', '', NULL, '9d844171ea0b1056b27675886141532e'),
('150', '7', '2025-05-02 07:27:33', '102.209.111.12', 'sharon', '961', 'en-GB', '1', '', NULL, '8fbc0ad4e1b7032e274eaffb250ddf8a'),
('151', '7', '2025-05-02 07:28:12', '102.209.111.12', 'sharon', '961', 'en-GB', '1', '', NULL, '5e2c42e81d5996ee513c8b6ce0f13ce0'),
('152', '8', '2025-05-02 07:36:24', '102.209.111.12', 'sharon', '961', 'en-GB', '1', '', NULL, '706e0b090381f644a5abf4ea84e48186'),
('153', '7', '2025-05-09 08:18:56', '41.75.172.178', 'sharon', '961', 'en-GB', '1', '', NULL, '17daa4f3a89f8bfbe1e794f9fb98bd1c'),
('154', '7', '2025-05-09 08:19:19', '41.75.172.178', 'sharon', '961', 'en-GB', '1', '', NULL, 'ad0c6452b8b8ce483dc5915e3e1b29e2'),
('155', '7', '2025-05-09 08:19:46', '41.75.172.178', 'sharon', '961', 'en-GB', '1', '', NULL, 'c82bd2ea0e8e4f177c36ce5d17fe3eb7'),
('156', '7', '2025-05-09 09:09:20', '41.75.172.178', 'sharon', '961', 'en-GB', '1', '', NULL, '85baa7734d5dbf98a2b15c8a296e20fd'),
('157', '8', '2025-05-12 17:20:28', '197.239.5.167', 'sharon', '961', 'en-GB', '1', '', NULL, 'b06a541c5792ed9e50c8e96ddce5e65c'),
('158', '7', '2025-05-15 11:51:03', '102.209.111.9', 'sharon', '961', 'en-GB', '1', '', NULL, '248da36ea4f7b0f7d501f6f32fe7b9d7'),
('159', '7', '2025-05-23 15:07:43', '102.209.111.12', 'sharon', '961', 'en-GB', '1', '', NULL, '2e85986d525f2f18b5ace81eb2bad8c6'),
('160', '7', '2025-05-23 15:19:52', '102.209.111.12', 'sharon', '961', 'en-GB', '1', '', NULL, '0dbb63ab4c891d4fb20d6462a1ea124c'),
('161', '9', '2025-05-23 15:23:40', '102.209.111.12', 'sharon', '961', 'en-GB', '1', '', NULL, 'e235e0a044be7c486ded5167040e5f25'),
('162', '9', '2025-05-23 15:24:15', '102.209.111.12', 'sharon', '961', 'en-GB', '1', '', NULL, 'a564b32ac9585a097d7b91e3732d9bf8'),
('163', '9', '2025-05-23 15:24:34', '102.209.111.12', 'sharon', '961', 'en-GB', '1', '', NULL, 'e4d0a496844e3cfa4a6346fe09d43615'),
('164', '9', '2025-05-23 15:25:26', '102.209.111.12', 'sharon', '961', 'en-GB', '1', '', NULL, '21debaa5bc7169db0003dd08e8c00f06'),
('165', '9', '2025-05-23 15:26:42', '102.209.111.12', 'sharon', '961', 'en-GB', '1', '', NULL, '97fa5d331932dd814a33e176b30173b4'),
('166', '9', '2025-05-26 11:13:14', '102.209.111.8', 'sharon', '961', 'en-GB', '1', '', NULL, '896e36704ec8f235962e7b8de42a1f89'),
('167', '7', '2025-05-26 11:59:24', '102.209.111.8', 'sharon', '961', 'en-GB', '1', '', NULL, '8cce75387094b89c091970c29ee30e82'),
('168', '7', '2025-05-26 11:59:59', '102.209.111.8', 'sharon', '961', 'en-GB', '1', '', NULL, '236970dfec93197921d1048e53aa0633'),
('169', '7', '2025-05-26 12:00:30', '102.209.111.8', 'sharon', '961', 'en-GB', '1', '', NULL, '2ea1582606050ef564c61e56520977eb'),
('170', '9', '2025-05-26 12:03:25', '102.209.111.8', 'sharon', '961', 'en-GB', '1', '', NULL, '7c3908588350be2c1ead8f75374baf98'),
('171', '8', '2025-05-26 13:24:44', '102.209.111.8', 'sharon', '961', 'en-GB', '1', '', NULL, '0930fd8a3507eb1b63e5dbbc6ab64792'),
('172', '9', '2025-05-28 04:39:23', '197.239.5.62', 'sharon', '961', 'en-GB', '1', '', NULL, '1ad5f6d41280869165cfa2e3453ce0a4'),
('173', '7', '2025-05-29 08:42:13', '102.209.111.9', 'sharon', '961', 'en-GB', '1', '', NULL, '8708be88089de01df47a34028754b24c'),
('174', '8', '2025-05-30 08:56:52', '102.209.111.12', 'sharon', '961', 'en-GB', '1', '', NULL, 'd92471dc366caee93e40892cf152a2bd'),
('175', '9', '2025-05-30 09:20:10', '102.209.111.12', 'sharon', '961', 'en-GB', '1', '', NULL, 'c22beb3ec68a7c36da0428a82a6f78df'),
('176', '8', '2025-06-01 08:26:58', '197.239.10.86', 'sharon', '961', 'en-GB', '1', '', NULL, 'de71ec2499ec38de771b39e899bbc0f1'),
('177', '7', '2025-06-02 07:34:33', '102.209.111.14', 'sharon', '961', 'en-GB', '1', '', NULL, '29d36181180e64aab5ea6914df960aed'),
('178', '7', '2025-06-02 07:35:03', '102.209.111.14', 'sharon', '961', 'en-GB', '1', '', NULL, '05229c8eb7b5fbd532fd6e4e881e8a30'),
('179', '8', '2025-06-02 07:48:10', '102.209.111.14', 'sharon', '961', 'en-GB', '1', '', NULL, '625e7e4c13ea6d5c6b1d0b447ecdcb67'),
('180', '9', '2025-06-02 09:16:05', '102.209.111.14', 'sharon', '961', 'en-GB', '1', '', NULL, 'b1323f9e366df59c5420a4594abe059d'),
('181', '9', '2025-06-07 05:25:51', '102.85.76.71', 'sharon', '961', 'en-GB', '1', '', NULL, '1006d1b07803416ce3fb67e94925bc80'),
('182', '9', '2025-06-07 05:26:18', '102.85.76.71', 'sharon', '961', 'en-GB', '1', '', NULL, 'dd4142a4cd8381a5cd69ea49e8c5668c'),
('183', '8', '2025-06-09 04:45:13', '102.85.34.84', 'sharon', '961', 'en-GB', '1', '', NULL, '540d0432c9bd99be93f88e42447c8ea7'),
('184', '8', '2025-06-09 04:52:16', '102.85.34.84', 'sharon', '961', 'en-GB', '1', '', NULL, 'a83441c5eb5553d0601e20ed0ac7b0ab'),
('185', '8', '2025-06-09 04:55:50', '102.85.34.84', 'sharon', '961', 'en-GB', '1', '', NULL, '3a098c7a60fceb7da012a94ddae03005'),
('186', '8', '2025-06-09 04:59:28', '102.85.34.84', 'sharon', '961', 'en-GB', '1', '', NULL, 'e483b0815a4f677579f868706fbe9c61'),
('187', '8', '2025-06-09 05:09:32', '102.85.34.84', 'sharon', '961', 'en-GB', '1', '', NULL, 'fbb2b4e1ff45d294da6df54f2f1e9c23'),
('188', '8', '2025-06-09 05:14:37', '102.85.34.84', 'sharon', '961', 'en-GB', '1', '', NULL, '64b1134a7f073cb9e53e2b142f5edb79'),
('189', '7', '2025-06-09 05:15:52', '102.85.34.84', 'sharon', '961', 'en-GB', '1', '', NULL, '2716a768641f7db92c8b59cc02f50bd9'),
('190', '7', '2025-06-09 05:16:21', '102.85.34.84', 'sharon', '961', 'en-GB', '1', '', NULL, '8eef55a7f8f11ea82f8765850a0269a6'),
('191', '7', '2025-06-09 05:17:41', '102.85.34.84', 'sharon', '961', 'en-GB', '1', '', NULL, '86b5195f3b41e5259b0362316c9d62d9'),
('192', '9', '2025-06-09 05:18:10', '102.85.34.84', 'sharon', '961', 'en-GB', '1', '', NULL, '885db9bbaf1493f675df125eb5d09d9e'),
('193', '7', '2025-06-09 05:19:04', '102.85.34.84', 'sharon', '961', 'en-GB', '1', '', NULL, '8c089cc51286cfc75664ab0fe27c084f'),
('194', '7', '2025-06-09 05:23:00', '102.85.34.84', 'sharon', '961', 'en-GB', '1', '', NULL, 'f639a7115b1a37aad5bde2c17c321084'),
('195', '7', '2025-06-09 05:23:31', '102.85.34.84', 'sharon', '961', 'en-GB', '1', '', NULL, 'afaa20eadce1987637a53ce0a51f2453'),
('196', '7', '2025-06-09 05:24:35', '102.85.34.84', 'sharon', '961', 'en-GB', '1', '', NULL, '2ef28f52db3af6419ca1f8814b3070b5'),
('197', '8', '2025-06-09 17:03:13', '102.85.86.154', 'sharon', '961', 'en-GB', '1', '', NULL, '53e48c21bdc86e8409198a36193c1421'),
('198', '8', '2025-06-10 05:49:37', '102.209.111.12', 'sharon', '961', 'en-GB', '1', '', NULL, '7785f4e989d491d961439172747ab785'),
('199', '7', '2025-06-19 08:29:25', '102.209.111.10', 'sharon', '961', 'en-GB', '1', '', NULL, 'd7ca1c0b3a9e110345e3058396ddee72'),
('200', '9', '2025-06-24 09:18:55', '102.209.111.8', 'sharon', '961', 'en-GB', '1', '', NULL, '46b0c5be0806a795500b097c0a94e285'),
('201', '8', '2025-06-24 13:36:21', '102.209.111.8', 'sharon', '961', 'en-GB', '1', '', NULL, 'a8f6feab4fe741cbc30498e253b40465'),
('202', '9', '2025-06-26 07:14:54', '102.209.111.13', 'sharon', '961', 'en-GB', '1', '', NULL, '2b7e63fb508aea17f79bceb086f4f787'),
('203', '9', '2025-06-30 04:24:05', '102.85.68.17', 'sharon', '961', 'en-GB', '1', '', NULL, '5603dee7a3a3f0a165929a6792ceaff8'),
('204', '9', '2025-06-30 04:24:28', '102.85.68.17', 'sharon', '961', 'en-GB', '1', '', NULL, '245ca0de144e97f4cd59a8b93f5e0972'),
('205', '9', '2025-06-30 04:24:50', '102.85.68.17', 'sharon', '961', 'en-GB', '1', '', NULL, '1595863d2b9694fd407ef087357ac063'),
('206', '7', '2025-06-30 04:31:59', '102.85.68.17', 'sharon', '961', 'en-GB', '1', '', NULL, '47ad4cdcc75751868540357c4e92b885'),
('207', '7', '2025-06-30 04:33:25', '102.85.68.17', 'sharon', '961', 'en-GB', '1', '', NULL, '24f5949e46122ec12684507294671d76'),
('208', '7', '2025-06-30 04:33:54', '102.85.68.17', 'sharon', '961', 'en-GB', '1', '', NULL, 'e2f4f4e120037b62beceebff38337c92'),
('209', '7', '2025-06-30 04:35:13', '102.85.68.17', 'sharon', '961', 'en-GB', '1', '', NULL, 'dfc3d12ee6453ddf3136874f8d5c04b3'),
('210', '7', '2025-06-30 04:36:45', '102.85.68.17', 'sharon', '961', 'en-GB', '1', '', NULL, '44ebd174c14f1aa6b9b01d045f901d83'),
('211', '7', '2025-06-30 04:37:26', '102.85.68.17', 'sharon', '961', 'en-GB', '1', '', NULL, '90bb17b4ac1fedd76261ee5018353bdd'),
('212', '9', '2025-07-02 03:55:13', '102.86.5.71', 'sharon', '961', 'en-GB', '1', '', NULL, '1c15d096d2bcc626c2722dca65e19063'),
('213', '9', '2025-07-02 03:56:24', '102.86.5.71', 'sharon', '961', 'en-GB', '1', '', NULL, 'aecec4f8cdd42fc0fb71c2731d98b2e5'),
('214', '7', '2025-07-07 09:03:25', '102.209.111.14', 'sharon', '961', 'en-GB', '1', '', NULL, '98e43ad1d5264e8084df1f0be8fff44f'),
('215', '7', '2025-07-07 09:03:53', '102.209.111.14', 'sharon', '961', 'en-GB', '1', '', NULL, '8d84338c385de3cb5eb5f35ec6848fa6'),
('216', '7', '2025-07-07 09:04:27', '102.209.111.14', 'sharon', '961', 'en-GB', '1', '', NULL, '50aa42e1fab81915d3c672818cb4cb53'),
('217', '8', '2025-07-09 08:28:45', '102.209.111.8', 'sharon', '961', 'en-GB', '1', '', NULL, 'fa8e2d884aade1c96d05547a1f79deb1'),
('218', '7', '2025-07-13 07:09:48', '102.209.111.14', 'patricia', '967', 'en-GB', '1', '', NULL, 'b34d8e2c20da717b06779c2476124da8'),
('219', '7', '2025-07-25 07:40:46', '102.209.111.13', 'patricia', '967', 'en-GB', '1', '', NULL, '09a79f7d95265a83b805e03f1068a4f6'),
('220', '8', '2025-07-25 10:03:31', '102.209.111.13', 'patricia', '967', 'en-GB', '1', '', NULL, '05c70790f2b7686337e739dacdc36f97'),
('221', '8', '2025-07-25 10:10:15', '102.209.111.13', 'patricia', '967', 'en-GB', '1', '', NULL, '682ed99a803e602f16cbb49ada110257'),
('222', '7', '2025-07-29 05:11:28', '102.209.111.14', 'patricia', '967', 'en-GB', '1', '', NULL, '22a17205efc47defa3748a738e3558ae'),
('223', '7', '2025-08-04 09:18:15', '102.209.111.8', 'patricia', '967', 'en-GB', '1', '', NULL, '548eb3795c3a8a892e471a9d45f58616'),
('224', '7', '2025-08-04 09:20:44', '102.209.111.8', 'patricia', '967', 'en-GB', '1', '', NULL, 'f2f9410684ee2eb01467cecb51108c8c'),
('225', '7', '2025-08-04 09:21:11', '102.209.111.8', 'patricia', '967', 'en-GB', '1', '', NULL, '6e38e3093c69c74eb5c92b9d29552ab8'),
('226', '7', '2025-08-04 09:22:08', '102.209.111.8', 'patricia', '967', 'en-GB', '1', '', NULL, '6366a1d84d53ff9beba86c31a411f19b'),
('227', '7', '2025-08-04 10:41:56', '102.209.111.8', 'patricia', '967', 'en-GB', '1', '', NULL, '0ae0d914db2e3b84aa858e9e39563351'),
('228', '7', '2025-08-12 09:37:44', '102.209.111.8', 'patricia', '967', 'en-GB', '1', '', NULL, '216c95fcfa675e5341c0c97b5d57dbe7'),
('229', '9', '2025-08-12 12:02:14', '102.209.111.8', 'patricia', '967', 'en-GB', '1', '', NULL, '218d2d68aa6cb446a1103f375d4db49f'),
('230', '7', '2025-08-29 08:13:42', '102.209.111.214', 'patricia', '967', 'en-GB', '1', '', NULL, 'bac35c4d6340d741109f611d1aa8ceda'),
('231', '7', '2025-08-29 08:14:18', '102.209.111.214', 'patricia', '967', 'en-GB', '1', '', NULL, 'bbb10d69c1140581c126e746941a1b28'),
('232', '7', '2025-08-29 08:14:40', '102.209.111.214', 'patricia', '967', 'en-GB', '1', '', NULL, '06a0ab1ea91a59aeac969ccec77e7f93'),
('233', '9', '2025-08-29 08:15:16', '102.209.111.214', 'patricia', '967', 'en-GB', '1', '', NULL, '11b89c543bed2606b18ede817b47c363'),
('234', '9', '2025-08-29 08:15:58', '102.209.111.214', 'patricia', '967', 'en-GB', '1', '', NULL, '1b6d6973a50c58236bb85195ff6970f7'),
('235', '7', '2025-09-02 07:51:07', '102.209.111.214', 'patricia', '967', 'en-GB', '1', '', NULL, '9a0e29649a0db10328847631d39b37bc'),
('236', '9', '2025-09-02 07:52:02', '102.209.111.214', 'patricia', '967', 'en-GB', '1', '', NULL, '8e8bfabc79f5f2c2fa3cae7b6119d1a3'),
('237', '8', '2025-09-03 16:16:17', '102.209.111.214', 'patricia', '967', 'en-GB', '1', '', NULL, '8853496d1a04bb9aa189ef2e96d9aa67'),
('238', '7', '2025-09-05 08:31:22', '102.209.111.214', 'patricia', '967', 'en-GB', '1', '', NULL, '3b32fbfae51bb261349fa01429852574'),
('239', '9', '2025-09-05 08:31:57', '102.209.111.214', 'patricia', '967', 'en-GB', '1', '', NULL, '5b6ee39979b53fe3c5aef79a47ebccbb'),
('240', '8', '2025-09-11 09:09:07', '102.209.111.214', 'patricia', '967', 'en-GB', '1', '', NULL, '72d82ba7638101f6e295f87828d6b3ee'),
('241', '8', '2025-09-23 08:32:56', '102.209.111.62', 'patricia', '967', 'en-GB', '1', '', NULL, 'e25168df71fb52c515dee90dfaf8b35b'),
('242', '8', '2025-09-23 08:41:44', '102.209.111.62', 'patricia', '967', 'en-GB', '1', '', NULL, '32077140f04c3919c9fb7c0e7b75ec7c'),
('243', '8', '2025-09-23 08:50:09', '102.209.111.62', 'patricia', '967', 'en-GB', '1', '', NULL, '8b9713b1229d54f1a21d07e9190997c1'),
('244', '8', '2025-09-23 08:54:13', '102.209.111.62', 'patricia', '967', 'en-GB', '1', '', NULL, 'eb773e0b246a5f05e3496d4e06a7b2a6'),
('245', '7', '2025-10-02 11:06:28', '102.209.111.90', 'patricia', '967', 'en-GB', '1', '', NULL, '1e5c2665160f117e5b2ce08527a09943'),
('246', '7', '2025-10-02 11:08:10', '102.209.111.90', 'patricia', '967', 'en-GB', '1', '', NULL, 'd2becaa62bf6b7489b7b6a3d1a0858a1'),
('247', '7', '2025-10-02 11:08:49', '102.209.111.90', 'patricia', '967', 'en-GB', '1', '', NULL, '52eecb7aad23e10c79e9805dc848dee7'),
('248', '7', '2025-10-02 11:10:05', '102.209.111.90', 'patricia', '967', 'en-GB', '1', '', NULL, '830805f0451e2fd81c1c67e37b3e60ed'),
('249', '9', '2025-10-02 11:11:17', '102.209.111.90', 'patricia', '967', 'en-GB', '1', '', NULL, 'b4d62856763b861d408500ca6dc8b472'),
('250', '9', '2025-10-02 11:13:16', '102.209.111.90', 'patricia', '967', 'en-GB', '1', '', NULL, '7b5b49fdbb6fedb8e627e447b246e4fd'),
('251', '9', '2025-10-02 11:13:46', '102.209.111.90', 'patricia', '967', 'en-GB', '1', '', NULL, '4720c7d6a1bdf72581aab091aa44ede2'),
('252', '9', '2025-10-02 11:14:11', '102.209.111.90', 'patricia', '967', 'en-GB', '1', '', NULL, '3c6934fada4babd11f8574a30c644c8b'),
('253', '7', '2025-10-04 06:15:42', '102.209.111.90', 'patricia', '967', 'en-GB', '1', '', NULL, '9fb247765635b0be2ff5dff7b6e9600d'),
('254', '7', '2025-10-09 07:57:28', '102.209.111.90', 'patricia', '967', 'en-GB', '1', '', NULL, '4324fceba413cb227be21a10af747f84'),
('255', '9', '2025-10-09 07:59:40', '102.209.111.90', 'patricia', '967', 'en-GB', '1', '', NULL, 'ca91a1ef9e4336b477b9c6abda4e4b70'),
('256', '8', '2025-10-13 06:43:12', '102.209.111.90', 'patricia', '967', 'en-GB', '1', '', NULL, '7c10d2f890c72fed58a6a785676b041c'),
('257', '8', '2025-10-13 06:48:25', '102.209.111.90', 'patricia', '967', 'en-GB', '1', '', NULL, 'c3fdee47b74403df9567235582b13e5e'),
('258', '8', '2025-10-13 07:01:51', '102.209.111.90', 'patricia', '967', 'en-GB', '1', '', NULL, 'bec7d3698a699469975cd6bc3208ea49'),
('259', '8', '2025-10-13 07:06:39', '102.209.111.90', 'patricia', '967', 'en-GB', '1', '', NULL, '007c961da5b8926e51581ba44cf6bddb'),
('260', '7', '2025-10-24 05:53:32', '102.209.111.90', 'patricia', '967', 'en-GB', '1', '', NULL, '4f6171aff502ae68fc61a6696febf777'),
('261', '9', '2025-10-24 05:54:17', '102.209.111.90', 'patricia', '967', 'en-GB', '1', '', NULL, '2705e677cf1b2f0df9bb564c6856e758'),
('262', '8', '2025-11-04 04:46:20', '102.209.111.178', 'patricia', '967', 'en-GB', '1', '', NULL, 'aed8a31a648fd1e1c74ada89f5b6f0ab'),
('263', '7', '2025-11-08 07:58:26', '102.209.111.178', 'patricia', '967', 'en-GB', '1', '', NULL, '43fe143d6b4f7241214fc15d935f99fb'),
('264', '9', '2025-11-08 07:59:06', '102.209.111.178', 'patricia', '967', 'en-GB', '1', '', NULL, 'c7dffb3a05aec910f436c5cf8d4d0e82'),
('265', '7', '2025-11-10 11:25:09', '41.75.180.134', 'patricia', '967', 'en-GB', '1', '', NULL, '1b988d9bbfb8353db112883fc83fce9c'),
('266', '9', '2025-11-10 11:25:37', '41.75.180.134', 'patricia', '967', 'en-GB', '1', '', NULL, '96b4d03fcf85b147652033be841dc691'),
('267', '8', '2025-11-10 17:46:17', '102.209.111.48', 'patricia', '967', 'en-GB', '1', '', NULL, '64a44dbd32bff646cd3daebd8dd6a1a0'),
('268', '7', '2025-11-17 13:05:20', '102.209.111.247', 'patricia', '967', 'en-GB', '1', '', NULL, 'cce17facad2bc8a5c0810c9e407c8654'),
('269', '9', '2025-11-17 13:06:01', '102.209.111.247', 'patricia', '967', 'en-GB', '1', '', NULL, '741a29a585ca8928127956adc451e750'),
('270', '8', '2025-11-24 17:56:55', '102.209.111.48', 'patricia', '967', 'en-GB', '1', '', NULL, '5c1eb3e8147ede48a97612244a3aba4d'),
('271', '8', '2025-11-24 18:02:32', '102.209.111.48', 'patricia', '967', 'en-GB', '1', '', NULL, '257279d61dbd4d68629d890ada5e884a'),
('272', '8', '2025-11-24 18:13:37', '102.209.111.48', 'patricia', '967', 'en-GB', '1', '', NULL, 'b6f8d8f3f1fc5537f39f6946f6ba9fcd'),
('273', '7', '2025-12-15 07:17:27', '41.75.182.226', 'patricia', '967', 'en-GB', '1', '', NULL, '3d0cccf6ab3c860a5fd7464901277e0a'),
('274', '9', '2025-12-15 07:18:13', '41.75.182.226', 'patricia', '967', 'en-GB', '1', '', NULL, '484925370e80c7952f570b1ebc26de51'),
('275', '8', '2025-12-15 07:31:55', '41.75.182.226', 'patricia', '967', 'en-GB', '1', '', NULL, '9bdc84d018068ac823de5d2a27fe4608'),
('276', '8', '2025-12-15 07:36:28', '41.75.182.226', 'patricia', '967', 'en-GB', '1', '', NULL, 'fd5859e1a0d6664a6e24ac86534b663a'),
('277', '8', '2026-02-04 07:07:44', '41.210.145.224', 'Cassandra Leah', '975', 'en-GB', '1', '', NULL, '484f99978528346e0baa5fce0446c1ab'),
('278', '8', '2026-02-04 08:04:17', '41.210.145.224', 'Cassandra Leah', '975', 'en-GB', '1', '', NULL, '3bfddcc98bc7bdb38bedc92f5a7de608'),
('279', '8', '2026-02-05 08:42:09', '41.210.145.224', 'Cassandra Leah', '975', 'en-GB', '1', '', NULL, 'cb3d5b4d75ec6abf28d76e1216a307f0'),
('280', '8', '2026-02-05 13:04:25', '41.210.145.224', 'Cassandra Leah', '975', 'en-GB', '1', '', NULL, '6e7275aa4ecf40af447e44bd4fa09e4e'),
('281', '8', '2026-02-06 12:11:22', '41.210.147.199', 'Cassandra Leah', '975', 'en-GB', '1', '', NULL, 'bcac8c6d8c46bd3fec2e695c67eb1f8d'),
('282', '8', '2026-02-07 05:19:53', '41.210.147.199', 'Cassandra Leah', '975', 'en-GB', '1', '', NULL, 'c2e5eb13011079b3d67eba62771c75f5'),
('283', '8', '2026-02-09 10:34:45', '41.210.147.199', 'Cassandra Leah', '975', 'en-GB', '1', '', NULL, 'f809e1b8893a6cc5ae22bee427f9bb1b'),
('284', '8', '2026-02-09 10:44:30', '41.210.147.199', 'Cassandra Leah', '975', 'en-GB', '1', '', NULL, '66362cf762414742f1328fcde2806fdb'),
('285', '8', '2026-02-09 11:55:52', '41.210.147.199', 'Cassandra Leah', '975', 'en-GB', '1', '', NULL, '28d0388faad2882d62e6e30974c40563'),
('286', '8', '2026-02-09 12:00:00', '41.210.147.199', 'Cassandra Leah', '975', 'en-GB', '1', '', NULL, 'f8f978c3cb39e88895b7f154b0f25b39'),
('287', '8', '2026-02-10 14:49:28', '41.210.147.199', 'Cassandra Leah', '975', 'en-GB', '1', '', NULL, 'dd9b651ff378aedb58ee78ba0b81eb0b'),
('288', '8', '2026-02-11 04:10:43', '41.210.147.199', 'Cassandra Leah', '975', 'en-GB', '1', '', NULL, '5a1368e95d0b41c0637de96bd6d12a9a'),
('289', '8', '2026-02-11 04:24:38', '41.210.147.199', 'Cassandra Leah', '975', 'en-GB', '1', '', NULL, 'bee53b69cb3156eb3c8dee5dff3e12b9'),
('290', '8', '2026-02-13 15:07:03', '41.210.141.129', 'Cassandra Leah', '975', 'en-GB', '1', '', NULL, 'd02415220cb282f07fb4b7bb8f5e13c6'),
('291', '8', '2026-02-13 15:16:02', '41.210.141.129', 'Cassandra Leah', '975', 'en-GB', '1', '', NULL, '91bbb7de0bff350ad514550819488260'),
('292', '8', '2026-02-13 15:26:09', '41.210.141.129', 'Cassandra Leah', '975', 'en-GB', '1', '', NULL, '513086dd788dbd03d58202fef4ca454f'),
('293', '8', '2026-02-16 09:00:50', '41.210.141.129', 'Cassandra Leah', '975', 'en-GB', '1', '', NULL, 'bee16a6142fe521c64f7255d852d419c'),
('294', '8', '2026-02-17 09:03:04', '41.210.141.129', 'Cassandra Leah', '975', 'en-GB', '1', '', NULL, '10cae5a9b802fd29a1f199f98f95b655'),
('295', '8', '2026-02-18 10:53:41', '41.210.141.129', 'Cassandra Leah', '975', 'en-GB', '1', '', NULL, 'd970f964f7d756b657fc9516be3544dc'),
('296', '8', '2026-02-18 11:06:12', '41.210.141.129', 'Cassandra Leah', '975', 'en-GB', '1', '', NULL, '812fde583c36d68ed7bf6730cc35f68d'),
('297', '8', '2026-02-18 11:14:33', '41.210.141.129', 'Cassandra Leah', '975', 'en-GB', '1', '', NULL, '7994aba1d0286868b644995768f5c8d4'),
('298', '8', '2026-02-18 11:25:53', '41.210.141.129', 'Cassandra Leah', '975', 'en-GB', '1', '', NULL, 'd4b8be8f204187e52f615270dba5c7e4'),
('299', '8', '2026-02-18 11:38:42', '41.210.141.129', 'Cassandra Leah', '975', 'en-GB', '1', '', NULL, 'e261b329c68e3e48b797091a6ad98f33'),
('300', '8', '2026-02-18 11:47:37', '41.210.141.129', 'Cassandra Leah', '975', 'en-GB', '1', '', NULL, '4d9018264197c4eed86ec2afafb5ef9a'),
('301', '8', '2026-02-19 06:33:31', '41.210.141.129', 'Cassandra Leah', '975', 'en-GB', '1', '', NULL, 'ae170e5e1707c7aab4c4516c25f43254'),
('302', '8', '2026-02-19 06:47:09', '41.210.141.129', 'Cassandra Leah', '975', 'en-GB', '1', '', NULL, 'f23b472cf604e3b467f14fea68b5f7f5');/**ABDB**/
/**ABDB**/CREATE TABLE `#__rsform_component_type_fields` (
  `ComponentTypeId` int(11) NOT NULL DEFAULT 0,
  `FieldName` text NOT NULL,
  `FieldType` varchar(32) NOT NULL DEFAULT 'hidden',
  `FieldValues` text NOT NULL,
  `Properties` text NOT NULL,
  `Ordering` int(11) NOT NULL DEFAULT 0,
  KEY `ComponentTypeId` (`ComponentTypeId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__rsform_component_type_fields`  VALUES 
('1', 'NAME', 'textbox', '', '', '1'),
('1', 'CAPTION', 'textbox', '', '', '2'),
('1', 'REQUIRED', 'select', 'NO\r\nYES', '', '3'),
('1', 'SIZE', 'textbox', '20', 'numeric', '4'),
('1', 'MAXSIZE', 'textbox', '', 'numeric', '5'),
('1', 'VALIDATIONRULE', 'select', '//<code>\r\nreturn RSFormProHelper::getValidationRules();\r\n//</code>', '', '6'),
('1', 'VALIDATIONMULTIPLE', 'selectmultiple', '//<code>\r\nreturn RSFormProHelper::getValidationRules(false, true);\r\n//</code>', '', '7'),
('1', 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', '', '8'),
('1', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '8'),
('1', 'DEFAULTVALUE', 'textarea', '', '', '9'),
('1', 'PLACEHOLDER', 'textbox', '', '', '10'),
('1', 'DESCRIPTION', 'textarea', '', '', '11'),
('1', 'INPUTTYPE', 'select', 'text\r\nemail\r\ntel\r\nnumber\r\nrange\r\nurl', '{\"case\":{\"number\":{\"show\":[\"ATTRMIN\",\"ATTRMAX\",\"ATTRSTEP\"],\"hide\":[\"MAXSIZE\"]},\"range\":{\"show\":[\"ATTRMIN\",\"ATTRMAX\",\"ATTRSTEP\"],\"hide\":[\"MAXSIZE\"]},\"text\":{\"show\":[\"MAXSIZE\"],\"hide\":[\"ATTRMIN\",\"ATTRMAX\",\"ATTRSTEP\"]},\"email\":{\"show\":[\"MAXSIZE\"],\"hide\":[\"ATTRMIN\",\"ATTRMAX\",\"ATTRSTEP\"]},\"tel\":{\"show\":[\"MAXSIZE\"],\"hide\":[\"ATTRMIN\",\"ATTRMAX\",\"ATTRSTEP\"]},\"url\":{\"show\":[\"MAXSIZE\"],\"hide\":[\"ATTRMIN\",\"ATTRMAX\",\"ATTRSTEP\"]}}}', '0'),
('1', 'ATTRMIN', 'textbox', '', 'float', '1'),
('1', 'ATTRMAX', 'textbox', '', 'float', '2'),
('1', 'ATTRSTEP', 'textbox', '1', 'float', '2'),
('1', 'COMPONENTTYPE', 'hidden', '1', '', '15'),
('1', 'VALIDATIONEXTRA', 'textbox', '', '', '8'),
('2', 'NAME', 'textbox', '', '', '1'),
('2', 'CAPTION', 'textbox', '', '', '2'),
('2', 'REQUIRED', 'select', 'NO\r\nYES', '', '3'),
('2', 'COLS', 'textbox', '50', 'textareasize', '4'),
('2', 'ROWS', 'textbox', '5', 'textareasize', '5'),
('2', 'VALIDATIONRULE', 'select', '//<code>\r\nreturn RSFormProHelper::getValidationRules();\r\n//</code>', '', '6'),
('2', 'VALIDATIONMULTIPLE', 'selectmultiple', '//<code>\r\nreturn RSFormProHelper::getValidationRules(false, true);\r\n//</code>', '', '7'),
('2', 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', '', '100'),
('2', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '8'),
('2', 'DEFAULTVALUE', 'textarea', '', '', '9'),
('2', 'DESCRIPTION', 'textarea', '', '', '10'),
('2', 'COMPONENTTYPE', 'hidden', '2', '', '10'),
('2', 'PLACEHOLDER', 'textbox', '', '', '10'),
('2', 'WYSIWYG', 'select', 'NO\r\nYES', '{\"case\":{\"YES\":{\"show\":[\"WYSIWYGBUTTONS\"],\"hide\":[\"MAXSIZE\",\"SHOW_CHAR_COUNT\"]},\"NO\":{\"show\":[\"MAXSIZE\",\"SHOW_CHAR_COUNT\"],\"hide\":[\"WYSIWYGBUTTONS\"]}}}', '11'),
('2', 'WYSIWYGBUTTONS', 'select', 'NO\r\nYES', '', '12'),
('2', 'MAXSIZE', 'textbox', '', 'numeric', '13'),
('2', 'SHOW_CHAR_COUNT', 'select', 'NO\r\nYES', '', '14'),
('2', 'VALIDATIONEXTRA', 'textbox', '', '', '8'),
('3', 'NAME', 'textbox', '', '', '1'),
('3', 'CAPTION', 'textbox', '', '', '2'),
('3', 'SIZE', 'textbox', '', 'numeric', '3'),
('3', 'MULTIPLE', 'select', 'NO\r\nYES', '', '4'),
('3', 'ITEMS', 'textarea', '', '', '5'),
('3', 'REQUIRED', 'select', 'NO\r\nYES', '{\"case\":{\"YES\":{\"show\":[\"VALIDATIONMESSAGE\"],\"hide\":[]},\"NO\":{\"show\":[],\"hide\":[\"VALIDATIONMESSAGE\"]}}}', '6'),
('3', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '7'),
('3', 'DESCRIPTION', 'textarea', '', '', '8'),
('3', 'COMPONENTTYPE', 'hidden', '3', '', '10'),
('3', 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', '', '100'),
('4', 'NAME', 'textbox', '', '', '1'),
('4', 'CAPTION', 'textbox', '', '', '2'),
('4', 'ITEMS', 'textarea', '', '', '3'),
('4', 'FLOW', 'select', 'HORIZONTAL\r\nVERTICAL\r\nVERTICAL2COLUMNS\r\nVERTICAL3COlUMNS\r\nVERTICAL4COLUMNS\r\nVERTICAL6COLUMNS', '', '4'),
('4', 'MAXSELECTIONS', 'textbox', '0', '', '5'),
('4', 'MINSELECTIONS', 'textbox', '0', '', '6'),
('4', 'REQUIRED', 'select', 'NO\r\nYES', '{\"case\":{\"YES\":{\"show\":[\"VALIDATIONMESSAGE\"],\"hide\":[]},\"NO\":{\"show\":[],\"hide\":[\"VALIDATIONMESSAGE\"]}}}', '5'),
('4', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '6'),
('4', 'DESCRIPTION', 'textarea', '', '', '6'),
('4', 'COMPONENTTYPE', 'hidden', '4', '', '7'),
('4', 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', '', '100'),
('5', 'NAME', 'textbox', '', '', '1'),
('5', 'CAPTION', 'textbox', '', '', '2'),
('5', 'ITEMS', 'textarea', '', '', '3'),
('5', 'FLOW', 'select', 'HORIZONTAL\r\nVERTICAL\r\nVERTICAL2COLUMNS\r\nVERTICAL3COlUMNS\r\nVERTICAL4COLUMNS\r\nVERTICAL6COLUMNS', '', '4'),
('5', 'REQUIRED', 'select', 'NO\r\nYES', '{\"case\":{\"YES\":{\"show\":[\"VALIDATIONMESSAGE\"],\"hide\":[]},\"NO\":{\"show\":[],\"hide\":[\"VALIDATIONMESSAGE\"]}}}', '5'),
('5', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '6'),
('5', 'DESCRIPTION', 'textarea', '', '', '6'),
('5', 'COMPONENTTYPE', 'hidden', '5', '', '7'),
('5', 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', '', '100'),
('6', 'NAME', 'textbox', '', '', '1'),
('6', 'CAPTION', 'textbox', '', '', '2'),
('6', 'DEFAULTVALUE', 'textarea', '', '', '3'),
('6', 'REQUIRED', 'select', 'NO\r\nYES', '', '4'),
('6', 'VALIDATIONCALENDAR', 'select', '//<code>\r\nreturn RSFormProHelper::getOtherCalendars(6);\r\n//</code>', '{\"case\":{\"\":{\"show\":[],\"hide\":[\"VALIDATIONCALENDAROFFSET\"]}},\"indexcase\":{\"min\":{\"show\":[\"VALIDATIONCALENDAROFFSET\"],\"hide\":[]},\"max\":{\"show\":[\"VALIDATIONCALENDAROFFSET\"],\"hide\":[]}}}', '4'),
('6', 'VALIDATIONCALENDAROFFSET', 'textbox', '1', 'numeric', '5'),
('6', 'VALIDATIONDATE', 'select', 'YES\r\nNO', '', '8'),
('6', 'DATEFORMAT', 'textbox', 'd-m-Y', '', '4'),
('6', 'CALENDARLAYOUT', 'select', 'FLAT\r\nPOPUP', '{\"case\":{\"POPUP\":{\"show\":[\"READONLY\", \"POPUPLABEL\", \"ALLOWHTML\",\"PLACEHOLDER\"],\"hide\":[]},\"FLAT\":{\"show\":[],\"hide\":[\"READONLY\", \"POPUPLABEL\", \"ALLOWHTML\",\"PLACEHOLDER\"]}}}', '5'),
('6', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '6'),
('6', 'DESCRIPTION', 'textarea', '', '', '7'),
('6', 'COMPONENTTYPE', 'hidden', '6', '', '8'),
('6', 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', '', '100'),
('6', 'READONLY', 'select', 'NO\r\nYES', '', '6'),
('6', 'POPUPLABEL', 'textbox', '...', '', '7'),
('6', 'ALLOWHTML', 'select', 'NO\nYES', '', '8'),
('6', 'PLACEHOLDER', 'textbox', '', '', '9'),
('6', 'MINDATE', 'textarea', '', '', '5'),
('6', 'MAXDATE', 'textarea', '', '', '5'),
('7', 'NAME', 'textbox', '', '', '1'),
('7', 'CAPTION', 'textbox', '', '', '3'),
('7', 'LABEL', 'textbox', '', '', '2'),
('7', 'RESET', 'select', 'NO\r\nYES', '{\"case\":{\"YES\":{\"show\":[\"RESETLABEL\"],\"hide\":[]},\"NO\":{\"show\":[],\"hide\":[\"RESETLABEL\"]}}}', '4'),
('7', 'RESETLABEL', 'textbox', '', '', '5'),
('7', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '6'),
('7', 'DESCRIPTION', 'textarea', '', '', '7'),
('7', 'COMPONENTTYPE', 'hidden', '7', '', '8'),
('7', 'ALLOWHTML', 'select', 'NO\nYES', '', '7'),
('8', 'NAME', 'textbox', '', '', '1'),
('8', 'CAPTION', 'textbox', '', '', '2'),
('8', 'LENGTH', 'textbox', '4', '', '3'),
('8', 'BACKGROUNDCOLOR', 'textbox', '#FFFFFF', '', '4'),
('8', 'TEXTCOLOR', 'textbox', '#000000', '', '5'),
('8', 'TYPE', 'select', 'ALPHA\r\nNUMERIC\r\nALPHANUMERIC', '', '6'),
('8', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '7'),
('8', 'DESCRIPTION', 'textarea', '', '', '9'),
('8', 'COMPONENTTYPE', 'hidden', '8', '', '9'),
('8', 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', '', '100'),
('8', 'FLOW', 'select', 'VERTICAL\r\nHORIZONTAL', '', '7'),
('8', 'SHOWREFRESH', 'select', 'NO\r\nYES', '{\"case\":{\"YES\":{\"show\":[\"REFRESHTEXT\"],\"hide\":[]},\"NO\":{\"show\":[],\"hide\":[\"REFRESHTEXT\"]}}}', '8'),
('8', 'REFRESHTEXT', 'textbox', 'REFRESH', '', '11'),
('8', 'SIZE', 'textbox', '15', 'numeric', '12'),
('8', 'IMAGETYPE', 'select', 'FREETYPE\r\nNOFREETYPE\r\nINVISIBLE', '{\"case\":{\"FREETYPE\":{\"show\":[\"BACKGROUNDCOLOR\",\"TEXTCOLOR\",\"TYPE\",\"FLOW\",\"LENGTH\",\"SHOWREFRESH\",\"REFRESHTEXT\",\"SIZE\"],\"hide\":[]},\"NOFREETYPE\":{\"show\":[\"BACKGROUNDCOLOR\",\"TEXTCOLOR\",\"TYPE\",\"FLOW\",\"LENGTH\",\"SHOWREFRESH\",\"REFRESHTEXT\",\"SIZE\"],\"hide\":[]},\"INVISIBLE\":{\"show\":[],\"hide\":[\"BACKGROUNDCOLOR\",\"TEXTCOLOR\",\"TYPE\",\"FLOW\",\"LENGTH\",\"SHOWREFRESH\",\"REFRESHTEXT\",\"SIZE\"]}}}', '3'),
('9', 'NAME', 'textbox', '', '', '1'),
('9', 'CAPTION', 'textbox', '', '', '2'),
('9', 'REQUIRED', 'select', 'NO\r\nYES', '', '3'),
('9', 'FILESIZE', 'textbox', '', 'numeric', '0'),
('9', 'DESTINATION', 'textbox', '//<code>\r\nreturn \'components/com_rsform/uploads/\';\r\n//</code>', '', '1'),
('9', 'MULTIPLE', 'select', 'NO\r\nYES', '{\"case\":{\"YES\":{\"show\":[\"FILESSEPARATOR\",\"MINFILES\",\"MAXFILES\",\"MULTIPLEPLUS\"],\"hide\":[]},\"NO\":{\"show\":[],\"hide\":[\"FILESSEPARATOR\",\"MINFILES\",\"MAXFILES\",\"MULTIPLEPLUS\"]}}}', '2'),
('9', 'MULTIPLEPLUS', 'select', 'NO\r\nYES', '', '3'),
('9', 'MINFILES', 'textbox', '1', 'numeric', '4'),
('9', 'MAXFILES', 'textbox', '0', 'numeric', '5'),
('9', 'FILESSEPARATOR', 'textbox', '<br />', '', '6'),
('9', 'ACCEPTEDFILES', 'textarea', '', 'oneperline', '7'),
('9', 'ACCEPTEDFILESIMAGES', 'select', 'NO\r\nYES', '{\"case\":{\"YES\":{\"show\":[\"THUMBSIZE\",\"THUMBQUALITY\",\"SHOWIMAGEPREVIEW\",\"THUMBEXTENSION\"],\"hide\":[\"ACCEPTEDFILES\"]},\"NO\":{\"show\":[\"ACCEPTEDFILES\"],\"hide\":[\"THUMBSIZE\",\"THUMBQUALITY\",\"SHOWIMAGEPREVIEW\",\"THUMBEXTENSION\"]}}}', '7'),
('9', 'SHOWIMAGEPREVIEW', 'select', 'NO\r\nYES', '', '8'),
('9', 'THUMBSIZE', 'textbox', '220', 'numeric', '9'),
('9', 'THUMBQUALITY', 'textbox', '75', 'numeric', '10'),
('9', 'THUMBEXTENSION', 'select', 'jpg\r\npng\r\nwebp', '', '11'),
('9', 'SANITIZEFILENAME', 'select', 'NO\r\nYES', '', '101'),
('9', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '7'),
('9', 'DESCRIPTION', 'textarea', '', '', '8'),
('9', 'COMPONENTTYPE', 'hidden', '9', '', '9'),
('9', 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', '', '100'),
('9', 'PREFIX', 'textarea', '', '', '102'),
('9', 'EMAILATTACH', 'selectmultiple', '//<code>\r\nreturn RSFormProHelper::getEmailAttachOptions();\r\n//</code>', '', '103'),
('10', 'NAME', 'textbox', '', '', '1'),
('10', 'TEXT', 'textarea', '', '', '1'),
('10', 'COMPONENTTYPE', 'hidden', '10', '', '9'),
('11', 'NAME', 'textbox', '', '', '1'),
('11', 'DEFAULTVALUE', 'textarea', '', '', '2'),
('11', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '1'),
('11', 'COMPONENTTYPE', 'hidden', '11', '', '9'),
('13', 'NAME', 'textbox', '', '', '1'),
('13', 'CAPTION', 'textbox', '', '', '3'),
('13', 'LABEL', 'textbox', '', '', '2'),
('13', 'RESET', 'select', 'NO\r\nYES', '{\"case\":{\"YES\":{\"show\":[\"RESETLABEL\"],\"hide\":[]},\"NO\":{\"show\":[],\"hide\":[\"RESETLABEL\"]}}}', '6'),
('13', 'RESETLABEL', 'textbox', '', '', '7'),
('13', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '9'),
('13', 'COMPONENTTYPE', 'hidden', '13', '', '12'),
('13', 'ALLOWHTML', 'select', 'NO\nYES', '', '12'),
('13', 'PREVBUTTON', 'textbox', '< Prev', '', '8'),
('13', 'DISPLAYPROGRESS', 'select', 'NO\r\nAUTO\r\nYES', '{\"case\":{\"YES\":{\"show\":[\"DISPLAYPROGRESSMSG\"],\"hide\":[]},\"NO\":{\"show\":[],\"hide\":[\"DISPLAYPROGRESSMSG\"]}, \"AUTO\":{\"show\":[],\"hide\":[\"DISPLAYPROGRESSMSG\"]}}}', '9'),
('13', 'DISPLAYPROGRESSMSG', 'textarea', '<div>\r\n <p><em>Page <strong>{page}</strong> of {total}</em></p>\r\n <div class=\"rsformProgressContainer\">\r\n  <div class=\"rsformProgressBar\" style=\"width: {percent}%;\"></div>\r\n </div>\r\n</div>', '', '10'),
('14', 'NAME', 'textbox', '', '', '1'),
('14', 'CAPTION', 'textbox', '', '', '2'),
('14', 'REQUIRED', 'select', 'NO\r\nYES', '', '3'),
('14', 'SIZE', 'textbox', '', 'numeric', '4'),
('14', 'MAXSIZE', 'textbox', '', 'numeric', '5'),
('14', 'DEFAULTVALUE', 'textarea', '', '', '6'),
('14', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '7'),
('14', 'COMPONENTTYPE', 'hidden', '14', '', '8'),
('14', 'DESCRIPTION', 'textarea', '', '', '100'),
('14', 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', '', '100'),
('14', 'VALIDATIONRULE', 'select', '//<code>\r\nreturn RSFormProHelper::getValidationRules();\r\n//</code>', '', '9'),
('14', 'VALIDATIONMULTIPLE', 'selectmultiple', '//<code>\r\nreturn RSFormProHelper::getValidationRules(false, true);\r\n//</code>', '', '10'),
('14', 'PLACEHOLDER', 'textbox', '', '', '10'),
('14', 'VALIDATIONEXTRA', 'textbox', '', '', '11'),
('15', 'NAME', 'textbox', '', '', '1'),
('15', 'LENGTH', 'textbox', '8', '', '4'),
('15', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '7'),
('15', 'COMPONENTTYPE', 'hidden', '15', '', '8'),
('15', 'CHARACTERS', 'select', 'ALPHANUMERIC\r\nALPHA\r\nNUMERIC', '', '3'),
('15', 'TICKETTYPE', 'select', 'RANDOM\r\nSEQUENTIAL', '{\"case\":{\"RANDOM\":{\"show\":[\"CHARACTERS\", \"LENGTH\"],\"hide\":[\"LEADINGZEROLENGTH\"]},\"SEQUENTIAL\":{\"show\":[\"LEADINGZEROLENGTH\"],\"hide\":[\"CHARACTERS\", \"LENGTH\"]}}}', '2'),
('15', 'LEADINGZEROLENGTH', 'select', '0\r\n1\r\n2\r\n3\r\n4\r\n5\r\n6\r\n7\r\n8\r\n9\r\n10', '', '5'),
('41', 'NAME', 'textbox', '', '', '1'),
('41', 'COMPONENTTYPE', 'hidden', '41', '', '5'),
('41', 'NEXTBUTTON', 'textbox', 'Next >', '', '2'),
('41', 'PREVBUTTON', 'textbox', '< Prev', '', '3'),
('41', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '4'),
('41', 'VALIDATENEXTPAGE', 'select', 'NO\r\nYES', '', '5'),
('41', 'DISPLAYPROGRESS', 'select', 'NO\r\nAUTO\r\nYES', '{\"case\":{\"YES\":{\"show\":[\"DISPLAYPROGRESSMSG\"],\"hide\":[]},\"NO\":{\"show\":[],\"hide\":[\"DISPLAYPROGRESSMSG\"]}, \"AUTO\":{\"show\":[],\"hide\":[\"DISPLAYPROGRESSMSG\"]}}}', '6'),
('41', 'DISPLAYPROGRESSMSG', 'textarea', '<div>\r\n <p><em>Page <strong>{page}</strong> of {total}</em></p>\r\n <div class=\"rsformProgressContainer\">\r\n  <div class=\"rsformProgressBar\" style=\"width: {percent}%;\"></div>\r\n </div>\r\n</div>', '', '7'),
('41', 'ALLOWHTML', 'select', 'NO\nYES', '', '9'),
('211', 'VALIDATION_ALLOW_INCORRECT_DATE', 'select', 'NO\r\nYES', '', '0'),
('211', 'NAME', 'textbox', '', '', '1'),
('211', 'VALIDATIONRULE_DATE', 'select', '//<code>\r\nreturn RSFormProHelper::getDateValidationRules();\r\n//</code>', '', '1'),
('211', 'CAPTION', 'textbox', '', '', '2'),
('211', 'DESCRIPTION', 'textarea', '', '', '3'),
('211', 'REQUIRED', 'select', 'NO\r\nYES', '', '4'),
('211', 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', '', '5'),
('211', 'DATEORDERING', 'select', 'DMY\r\nMDY\r\nYMD\r\nYDM\r\nMYD\r\nDYM', '', '6'),
('211', 'DATESEPARATOR', 'textbox', ' / ', '', '7'),
('211', 'SHOWDAY', 'select', 'YES\r\nNO', '{\"case\":{\"YES\":{\"show\":[\"SHOWDAYPLEASE\" ,\"SHOWDAYTYPE\"],\"hide\":[]},\"NO\":{\"show\":[],\"hide\":[\"SHOWDAYPLEASE\" ,\"SHOWDAYTYPE\"]}}}', '8'),
('211', 'SHOWDAYPLEASE', 'textbox', 'Day', '', '9'),
('211', 'SHOWDAYTYPE', 'select', 'DAY_TYPE_01\r\nDAY_TYPE_1', '', '10'),
('211', 'SHOWMONTH', 'select', 'YES\r\nNO', '{\"case\":{\"YES\":{\"show\":[\"SHOWMONTHPLEASE\" ,\"SHOWMONTHTYPE\"],\"hide\":[]},\"NO\":{\"show\":[],\"hide\":[\"SHOWMONTHPLEASE\" ,\"SHOWMONTHTYPE\"]}}}', '11'),
('211', 'SHOWMONTHPLEASE', 'textbox', 'Month', '', '12'),
('211', 'SHOWMONTHTYPE', 'select', 'MONTH_TYPE_01\r\nMONTH_TYPE_1\r\nMONTH_TYPE_TEXT_SHORT\r\nMONTH_TYPE_TEXT_LONG', '', '13'),
('211', 'SHOWYEAR', 'select', 'YES\r\nNO', '{\"case\":{\"YES\":{\"show\":[\"SHOWYEARPLEASE\" ,\"STARTYEAR\", \"ENDYEAR\"],\"hide\":[]},\"NO\":{\"show\":[],\"hide\":[\"SHOWYEARPLEASE\" ,\"STARTYEAR\", \"ENDYEAR\"]}}}', '14'),
('211', 'SHOWYEARPLEASE', 'textbox', 'Year', '', '15'),
('211', 'STARTYEAR', 'textbox', '1960', '', '16'),
('211', 'ENDYEAR', 'textbox', '0', '', '17'),
('211', 'STORELEADINGZERO', 'select', 'NO\r\nYES', '', '18'),
('211', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '18'),
('211', 'COMPONENTTYPE', 'hidden', '211', '', '19'),
('212', 'NAME', 'textbox', '', '', '0'),
('212', 'CAPTION', 'textbox', '', '', '1'),
('212', 'DESCRIPTION', 'textarea', '', '', '3'),
('212', 'REQUIRED', 'select', 'NO\r\nYES', '{\"case\":{\"YES\":{\"show\":[\"VALIDATIONMESSAGE\"],\"hide\":[]},\"NO\":{\"show\":[],\"hide\":[\"VALIDATIONMESSAGE\"]}}}', '4'),
('212', 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', '', '5'),
('212', 'DEFAULTVALUE', 'textarea', '', '', '2'),
('212', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '6'),
('212', 'MAPWIDTH', 'textbox', '450px', '', '7'),
('212', 'MAPHEIGHT', 'textbox', '300px', '', '8'),
('212', 'REQUESTLOCATION', 'select', 'NO\r\nYES', '', '9'),
('212', 'MAPCENTER', 'textbox', '39.5500507,-105.7820674', '', '9'),
('212', 'COMPONENTTYPE', 'hidden', '212', '', '12'),
('212', 'SIZE', 'textbox', '20', 'numeric', '13'),
('212', 'MAPZOOM', 'textbox', '10', 'numeric', '10'),
('212', 'MAPRESULT', 'select', 'ADDRESS\r\nCOORDINATES', '', '12'),
('212', 'MAPTYPE', 'select', 'ROADMAP\r\nSATELLITE\r\nHYBRID\r\nTERRAIN', '', '13'),
('212', 'GEOLOCATION', 'select', 'NO\r\nYES', '', '11'),
('411', 'NAME', 'textbox', '', '', '1'),
('411', 'CAPTION', 'textbox', '', '', '2'),
('411', 'DEFAULTVALUE', 'textarea', '', '', '3'),
('411', 'DESCRIPTION', 'textarea', '', '', '4'),
('411', 'REQUIRED', 'select', 'NO\r\nYES', '', '5'),
('411', 'VALIDATIONRULE', 'select', '//<code>\r\nreturn RSFormProHelper::getValidationRules(false, array(\'alpha\',\'numeric\',\'alphanumeric\',\'alphaaccented\',\'alphanumericaccented\',\'email\',\'emaildns\',\'uszipcode\',\'phonenumber\',\'creditcard\',\'custom\',\'password\',\'restrictedwords\',\'ipaddress\',\'validurl\',\'multiplerules\',\'iban\',\'minlength\',\'maxlength\'));\r\n//</code>', '', '6'),
('411', 'VALIDATIONMULTIPLE', 'selectmultiple', '//<code>\r\nreturn RSFormProHelper::getValidationRules(false, true);\r\n//</code>', '', '7'),
('411', 'VALIDATIONCALENDAR', 'select', '//<code>\nreturn RSFormProHelper::getOtherCalendars(411);\n//</code>', '{\"case\":{\"\":{\"show\":[],\"hide\":[\"VALIDATIONCALENDAROFFSET\"]}},\"indexcase\":{\"min\":{\"show\":[\"VALIDATIONCALENDAROFFSET\"],\"hide\":[]},\"max\":{\"show\":[\"VALIDATIONCALENDAROFFSET\"],\"hide\":[]}}}', '8'),
('411', 'VALIDATIONCALENDAROFFSET', 'textbox', '1', 'numeric', '9'),
('411', 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', '', '10'),
('411', 'VALIDATIONDATE', 'select', 'YES\r\nNO', '', '11'),
('411', 'VALIDATIONEXTRA', 'textbox', '', '', '8'),
('411', 'DATEFORMAT', 'textbox', 'd-m-Y H:i', '', '8'),
('411', 'MINDATEJQ', 'textarea', '', '', '9'),
('411', 'MAXDATEJQ', 'textarea', '', '', '10'),
('411', 'ALLOWDATERE', 'textbox', '', '', '11'),
('411', 'ALLOWDATES', 'textarea', '', '', '12'),
('411', 'DISABLEDDATES', 'textarea', '', '', '13'),
('411', 'DISABLEDWEEKDAYS', 'textarea', '', '', '14'),
('411', 'TIMEPICKER', 'select', 'YES\r\nNO', '{\"case\":{\"YES\":{\"show\":[\"TIMEPICKERFORMAT\", \"TIMESTEP\",\"MINTIMEJQ\", \"MAXTIMEJQ\"],\"hide\":[]},\"NO\":{\"show\":[],\"hide\":[\"TIMEPICKERFORMAT\", \"TIMESTEP\",\"MINTIMEJQ\", \"MAXTIMEJQ\"]}}}', '15'),
('411', 'TIMEPICKERFORMAT', 'textbox', 'H:i', '', '16'),
('411', 'TIMESTEP', 'textbox', '30', '', '17'),
('411', 'MINTIMEJQ', 'textarea', '', '', '18'),
('411', 'MAXTIMEJQ', 'textarea', '', '', '19'),
('411', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '20'),
('411', 'CALENDARLAYOUT', 'select', 'FLAT\r\nPOPUP', '{\"case\":{\"POPUP\":{\"show\":[\"READONLY\", \"POPUPLABEL\", \"ALLOWHTML\",\"PLACEHOLDER\"],\"hide\":[]},\"FLAT\":{\"show\":[],\"hide\":[\"READONLY\", \"POPUPLABEL\", \"ALLOWHTML\",\"PLACEHOLDER\"]}}}', '21'),
('411', 'READONLY', 'select', 'NO\r\nYES', '', '22'),
('411', 'POPUPLABEL', 'textbox', '...', '', '23'),
('411', 'ALLOWHTML', 'select', 'NO\nYES', '', '24'),
('411', 'THEME', 'select', 'DEFAULT\r\nDARK', '', '25'),
('411', 'PLACEHOLDER', 'textbox', '', '', '26'),
('411', 'COMPONENTTYPE', 'hidden', '411', '', '200'),
('355', 'NAME', 'textbox', '', '', '1'),
('355', 'CAPTION', 'textbox', '', '', '2'),
('355', 'DEFAULTVALUE', 'textarea', '', '', '3'),
('355', 'DESCRIPTION', 'textarea', '', '', '4'),
('355', 'REQUIRED', 'select', 'NO\r\nYES', '{\"case\":{\"YES\":{\"show\":[\"VALIDATIONMESSAGE\"],\"hide\":[]},\"NO\":{\"show\":[],\"hide\":[\"VALIDATIONMESSAGE\"]}}}', '5'),
('355', 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', '', '6'),
('355', 'SLIDERTYPE', 'select', 'SINGLE\r\nDOUBLE', '{\"case\":{\"SINGLE\":{\"show\":[],\"hide\":[\"FROMFIXED\",\"TOFIXED\"]},\"DOUBLE\":{\"show\":[\"FROMFIXED\",\"TOFIXED\"],\"hide\":[]}}}', '7'),
('355', 'SKIN', 'select', 'FLAT\r\nHTML5\r\nMODERN\r\nNICE\r\nSIMPLE', '', '8'),
('355', 'USEVALUES', 'select', 'NO\r\nYES', '{\"case\":{\"YES\":{\"show\":[\"VALUES\"],\"hide\":[\"MINVALUE\", \"MAXVALUE\", \"GRIDSNAP\", \"GRIDSTEP\"]},\"NO\":{\"show\":[\"MINVALUE\", \"MAXVALUE\", \"GRIDSNAP\", \"GRIDSTEP\"],\"hide\":[\"VALUES\"]}}}', '9'),
('355', 'VALUES', 'textarea', '', '', '10'),
('355', 'MINVALUE', 'textbox', '0', 'numeric', '11'),
('355', 'MAXVALUE', 'textbox', '100', 'numeric', '12'),
('355', 'GRID', 'select', 'YES\r\nNO', '', '13'),
('355', 'GRIDSNAP', 'select', 'NO\r\nYES', '', '14'),
('355', 'GRIDSTEP', 'textbox', '10', 'numeric', '15'),
('355', 'FORCEEDGES', 'select', 'YES\r\nNO', '', '16'),
('355', 'FROMFIXED', 'select', 'NO\r\nYES', '', '17'),
('355', 'TOFIXED', 'select', 'NO\r\nYES', '', '18'),
('355', 'KEYBOARD', 'select', 'NO\r\nYES', '', '19'),
('355', 'READONLY', 'select', 'NO\r\nYES', '', '20'),
('355', 'COMPONENTTYPE', 'hidden', '355', '', '21'),
('16', 'NAME', 'textbox', '', '', '1'),
('16', 'CAPTION', 'textbox', '', '', '2'),
('16', 'LABEL', 'textbox', 'HASHCASH_CLICK_ME', '', '3'),
('16', 'DESCRIPTION', 'textarea', '', '', '4'),
('16', 'DIFFICULTY', 'textbox', '4', 'numeric', '3'),
('16', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '7'),
('16', 'COMPONENTTYPE', 'hidden', '16', '', '9'),
('16', 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', '', '100'),
('200', 'NAME', 'textbox', '', '', '1'),
('200', 'CAPTION', 'textbox', '', '', '2'),
('200', 'SELECTFIELD', 'select', '//<code>\nreturn RSFormProHelper::getPreviewFields();\n//</code>', '', '1'),
('200', 'TEXT', 'textarea', '{value}', '', '2'),
('200', 'COMPONENTTYPE', 'hidden', '200', '', '9'),
('201', 'NAME', 'textbox', '', '', '1'),
('201', 'CAPTION', 'textbox', '', '', '2'),
('201', 'REQUIRED', 'select', 'NO\r\nYES', '', '3'),
('201', 'SIZE', 'textbox', '20', 'numeric', '4'),
('201', 'VALIDATIONRULE', 'select', '//<code>\r\nreturn RSFormProHelper::getValidationRules(false, array(\'alpha\',\'numeric\',\'alphanumeric\',\'alphaaccented\',\'alphanumericaccented\',\'email\',\'emaildns\',\'uszipcode\',\'phonenumber\',\'creditcard\',\'custom\',\'password\',\'ipaddress\',\'validurl\',\'multiplerules\',\'restrictedwords\',\'iban\',\'minlength\',\'maxlength\'));\r\n//</code>', '', '6'),
('201', 'VALIDATIONMULTIPLE', 'selectmultiple', '//<code>\r\nreturn RSFormProHelper::getValidationRules(false, true);\r\n//</code>', '', '7'),
('201', 'VALIDATIONEXTRA', 'textbox', '', '', '7'),
('201', 'VALIDATIONPHONE', 'select', 'NO\r\nYES', '', '8'),
('201', 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', '', '9'),
('201', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '8'),
('201', 'DEFAULTVALUE', 'textarea', '', '', '9'),
('201', 'PLACEHOLDER', 'textbox', '', '', '10'),
('201', 'DESCRIPTION', 'textarea', '', '', '11'),
('201', 'HIDEFLAGS', 'select', 'NO\r\nYES', '', '12'),
('201', 'HIDECOUNTRYDROPDOWN', 'select', 'NO\r\nYES', '{\"case\":{\"YES\":{\"show\":[],\"hide\":[\"ONLYCOUNTRIES\"]},\"NO\":{\"show\":[\"ONLYCOUNTRIES\"],\"hide\":[]}}}', '13'),
('201', 'ONLYCOUNTRIES', 'textarea', '', '', '14'),
('201', 'INITIALCOUNTRY', 'select', 'AUTODETECTCOUNTRY\r\nMANUALCOUNTRY', '{\"case\":{\"AUTODETECTCOUNTRY\":{\"show\":[],\"hide\":[\"MANUALCOUNTRY\"]},\"MANUALCOUNTRY\":{\"show\":[\"MANUALCOUNTRY\"],\"hide\":[]}}}', '15'),
('201', 'MANUALCOUNTRY', 'select', ' AF\r\n AX\r\n AL\r\n DZ\r\n AS\r\n AD\r\n AO\r\n AI\r\n AQ\r\n AG\r\n AR\r\n AM\r\n AW\r\n AU\r\n AT\r\n AZ\r\n BS\r\n BH\r\n BD\r\n BB\r\n BY\r\n BE\r\n BZ\r\n BJ\r\n BM\r\n BT\r\n BO\r\n BA\r\n BW\r\n BV\r\n BR\r\n IO\r\n VG\r\n BN\r\n BG\r\n BF\r\n BI\r\n KH\r\n CM\r\n CA\r\n CV\r\n BQ\r\n KY\r\n CF\r\n TD\r\n CL\r\n CN\r\n CX\r\n CC\r\n CO\r\n KM\r\n CG\r\n CD\r\n CK\r\n CR\r\n CI\r\n  HR\r\n CU\r\n CW\r\n CY\r\n CZ\r\n DK\r\n DJ\r\n DM\r\n DO\r\n EC\r\n EG\r\n SV\r\n GQ\r\n ER\r\n EE\r\n SZ\r\n ET\r\n FK\r\n FO\r\n FJ\r\n FI\r\n FR\r\n GF\r\n PF\r\n TF\r\n GA\r\n GM\r\n GE\r\n DE\r\n GH\r\n GI\r\n GR\r\n GL\r\n GD\r\n GP\r\n GU\r\n GT\r\n GG\r\n GN\r\n GW\r\n GY\r\n HT\r\n HM\r\n HN\r\n HK\r\n HU\r\n IS\r\n IN\r\n ID\r\n IR\r\n IQ\r\n IE\r\n IM\r\n IL\r\n IT\r\n JM\r\n JP\r\n JE\r\n JO\r\n KZ\r\n KE\r\n KI\r\n KW\r\n KG\r\n LA\r\n LV\r\n LB\r\n LS\r\n LR\r\n LY\r\n LI\r\n LT\r\n LU\r\n MO\r\n MG\r\n MW\r\n MY\r\n MV\r\n ML\r\n MT\r\n MH\r\n MQ\r\n MR\r\n MU\r\n YT\r\n MX\r\n FM\r\n MD\r\n MC\r\n MN\r\n ME\r\n MS\r\n MA\r\n MZ\r\n MM\r\n NA\r\n NR\r\n NP\r\n NL\r\n NC\r\n NZ\r\n NI\r\n NE\r\n NG\r\n NU\r\n NF\r\n KP\r\n MK\r\n MP\r\n NO\r\n OM\r\n PK\r\n PW\r\n PS\r\n PA\r\n PG\r\n PY\r\n PE\r\n PH\r\n PN\r\n PL\r\n PT\r\n PR\r\n QA\r\n RE\r\n RO\r\n RU\r\n RW\r\n WS\r\n SM\r\n ST\r\n SA\r\n SN\r\n RS\r\n SC\r\n SL\r\n SG\r\n SX\r\n SK\r\n SI\r\n SB\r\n SO\r\n ZA\r\n GS\r\n KR\r\n SS\r\n ES\r\n LK\r\n BL\r\n SH\r\n KN\r\n LC\r\n MF\r\n PM\r\n VC\r\n SD\r\n SR\r\n SJ\r\n SE\r\n CH\r\n SY\r\n TW\r\n TJ\r\n TZ\r\n TH\r\n TL\r\n TG\r\n TK\r\n TO\r\n TT\r\n TN\r\n TR\r\n TM\r\n TC\r\n TV\r\n UM\r\n VI\r\n UG\r\n UA\r\n AE\r\n GB\r\n US\r\n UY\r\n UZ\r\n VU\r\n VA\r\n VE\r\n VN\r\n WF\r\n EH\r\n YE\r\n ZM\r\n ZW', '', '16'),
('201', 'COMPONENTTYPE', 'hidden', '201', '', '15'),
('202', 'NAME', 'textbox', '', '', '1'),
('202', 'CAPTION', 'textbox', '', '', '2'),
('202', 'REQUIRED', 'select', 'NO\r\nYES', '', '3'),
('202', 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', '', '9'),
('202', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '8'),
('202', 'DESCRIPTION', 'textarea', '', '', '11'),
('202', 'QUESTIONS', 'textarea', '', '', '12'),
('202', 'ANSWERS', 'textarea', '', '', '13'),
('202', 'SURVEYTEMPLATE', 'textarea', '{question}: {answer}', '', '14'),
('202', 'COMPONENTTYPE', 'hidden', '202', '', '15'),
('600', 'NAME', 'textbox', '', '', '1'),
('600', 'CAPTION', 'textbox', '', '', '2'),
('600', 'ITEMS', 'hiddenparam', '0\r\n1', '', '11'),
('600', 'SWITCHSTATE', 'select', 'ON\r\nOFF', '', '4'),
('600', 'OFFVALUE', 'textbox', '0', '', '4'),
('600', 'ONVALUE', 'textbox', '1', '', '5'),
('600', 'ONPRICE', 'textbox', '1', '', '6'),
('600', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '6'),
('600', 'DESCRIPTION', 'textarea', '', '', '7'),
('600', 'COMPONENTTYPE', 'hidden', '600', '', '8'),
('600', 'REQUIRED', 'select', 'NO\r\nYES', '', '9'),
('600', 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', '', '10'),
('602', 'NAME', 'textbox', '', '', '1'),
('602', 'CAPTION', 'textbox', '', '', '2'),
('602', 'NUMBERSTARS', 'textbox', '5', 'numeric', '3'),
('602', 'RATINGTYPE', 'select', 'singlecolor\r\nmulticolor', '{\"case\":{\"singlecolor\":{\"show\":[\"FILLCOLOR\"],\"hide\":[\"STARTCOLOR\", \"ENDCOLOR\"]},\"multicolor\":{\"show\":[\"STARTCOLOR\", \"ENDCOLOR\"],\"hide\":[\"FILLCOLOR\"]}}}', '4'),
('602', 'BASECOLOR', 'color', '#808080', '', '5'),
('602', 'FILLCOLOR', 'color', '#F39C12', '', '6'),
('602', 'STARTCOLOR', 'color', '#F39C12', '', '7'),
('602', 'ENDCOLOR', 'color', '#FF0000', '', '8'),
('602', 'HALFSTAR', 'select', 'NO\r\nYES', '', '9'),
('602', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '9'),
('602', 'DESCRIPTION', 'textarea', '', '', '10'),
('602', 'COMPONENTTYPE', 'hidden', '602', '', '11'),
('602', 'REQUIRED', 'select', 'NO\r\nYES', '', '12'),
('602', 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', '', '13'),
('603', 'NAME', 'textbox', '', '', '1'),
('603', 'CAPTION', 'textbox', '', '', '2'),
('603', 'REQUIRED', 'select', 'NO\r\nYES', '', '3'),
('603', 'COLS', 'textbox', '50', 'numeric', '4'),
('603', 'ROWS', 'textbox', '5', 'numeric', '5'),
('603', 'MAXWIDTH', 'textbox', '0', 'numeric', '6'),
('603', 'MAXHEIGHT', 'textbox', '0', 'numeric', '7'),
('603', 'MAXSIZE', 'textbox', '', 'numeric', '8'),
('603', 'SHOW_CHAR_COUNT', 'select', 'NO\r\nYES', '', '9'),
('603', 'VALIDATIONRULE', 'select', '//<code>\r\nreturn RSFormProHelper::getValidationRules();\r\n//</code>', '', '6'),
('603', 'VALIDATIONMULTIPLE', 'selectmultiple', '//<code>\r\nreturn RSFormProHelper::getValidationRules(false, true);\r\n//</code>', '', '6'),
('603', 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', '', '7'),
('603', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '8'),
('603', 'DEFAULTVALUE', 'textarea', '', '', '9'),
('603', 'DESCRIPTION', 'textarea', '', '', '10'),
('603', 'COMPONENTTYPE', 'hidden', '603', '', '10'),
('603', 'PLACEHOLDER', 'textbox', '', '', '10'),
('603', 'VALIDATIONEXTRA', 'textbox', '', '', '6'),
('604', 'NAME', 'textbox', '', '', '1'),
('604', 'CAPTION', 'textbox', '', '', '2'),
('604', 'REQUIRED', 'select', 'NO\r\nYES', '', '3'),
('604', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '4'),
('604', 'COMPONENTTYPE', 'hidden', '604', '', '5'),
('604', 'DEFAULTVALUE', 'textarea', '#FFFFFF', '', '6'),
('604', 'SHOWCOLORINPUT', 'select', 'NO\r\nYES', '', '9'),
('604', 'DESCRIPTION', 'textarea', '', '', '7'),
('604', 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', '', '8'),
('605', 'NAME', 'textbox', '', '', '1'),
('605', 'CAPTION', 'textbox', '', '', '2'),
('605', 'RSFPA_THEME', 'select', 'legacy\r\nstandard\r\nbootstrap2\r\nbootstrap3\r\nbootstrap4\r\nbootstrap5', '', '3'),
('605', 'MULTIPLE', 'select', 'NO\r\nYES', '{\"case\":{\"YES\":{\"show\":[\"NUMBERITEMS\"],\"hide\":[]},\"NO\":{\"show\":[],\"hide\":[\"NUMBERITEMS\"]}}}', '4'),
('605', 'NUMBERITEMS', 'textbox', '3', 'numeric', '5'),
('605', 'ITEMS', 'textarea', '', '', '6'),
('605', 'PLACEHOLDER', 'textbox', '', '', '8'),
('605', 'REQUIRED', 'select', 'NO\r\nYES', '', '7'),
('605', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '8'),
('605', 'DESCRIPTION', 'textarea', '', '', '9'),
('605', 'COMPONENTTYPE', 'hidden', '605', '', '10'),
('605', 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', '', '11'),
('606', 'NAME', 'textbox', '', '', '1'),
('606', 'CAPTION', 'textbox', '', '', '2'),
('606', 'ITEMS', 'textarea', '', '', '3'),
('606', 'FLOW', 'select', 'HORIZONTAL\r\nVERTICAL\r\nVERTICAL2COLUMNS\r\nVERTICAL3COlUMNS\r\nVERTICAL4COLUMNS\r\nVERTICAL6COLUMNS', '', '4'),
('606', 'MAXSELECTIONS', 'textbox', '0', '', '5'),
('606', 'MINSELECTIONS', 'textbox', '0', '', '6'),
('606', 'REQUIRED', 'select', 'NO\r\nYES', '{\"case\":{\"YES\":{\"show\":[\"VALIDATIONMESSAGE\"],\"hide\":[]},\"NO\":{\"show\":[],\"hide\":[\"VALIDATIONMESSAGE\"]}}}', '5'),
('606', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '6'),
('606', 'DESCRIPTION', 'textarea', '', '', '7'),
('606', 'COMPONENTTYPE', 'hidden', '606', '', '8'),
('606', 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', '', '9'),
('607', 'NAME', 'textbox', '', '', '1'),
('607', 'CAPTION', 'textbox', '', '', '2'),
('607', 'ITEMS', 'textarea', '', '', '3'),
('607', 'FLOW', 'select', 'HORIZONTAL\r\nVERTICAL\r\nVERTICAL2COLUMNS\r\nVERTICAL3COlUMNS\r\nVERTICAL4COLUMNS\r\nVERTICAL6COLUMNS', '', '4'),
('607', 'REQUIRED', 'select', 'NO\r\nYES', '{\"case\":{\"YES\":{\"show\":[\"VALIDATIONMESSAGE\"],\"hide\":[]},\"NO\":{\"show\":[],\"hide\":[\"VALIDATIONMESSAGE\"]}}}', '5'),
('607', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '6'),
('607', 'DESCRIPTION', 'textarea', '', '', '6'),
('607', 'COMPONENTTYPE', 'hidden', '607', '', '7'),
('607', 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', '', '8'),
('608', 'NAME', 'textbox', '', '', '1'),
('608', 'CAPTION', 'textbox', '', '', '2'),
('608', 'INIT_ANIMATION', 'select', 'fadein\r\nbounce\r\ndropdown', '', '3'),
('608', 'DATE_FORMAT', 'textbox', 'm-d-Y', '', '4'),
('608', 'DEFAULTVALUE', 'textarea', '', '', '5'),
('608', 'FORCE_DATE', 'select', 'disabled\r\nfrom\r\nto', '', '6'),
('608', 'MINYEAR', 'textbox', '1970', 'numeric', '7'),
('608', 'MAXYEAR', 'textbox', '', 'numeric', '8'),
('608', 'YEARSRANGE', 'textbox', '10', 'numeric', '9'),
('608', 'DROPPRIMARYCOLOR', 'color', '#01CEFF', '', '10'),
('608', 'DROPTEXTCOLOR', 'color', '#333333', '', '11'),
('608', 'DROPBACKGROUNDCOLOR', 'color', '#FFFFFF', '', '12'),
('608', 'DROPBORDER', 'textbox', '1px solid #08C', '', '13'),
('608', 'DROPBORDERRADIUS', 'textbox', '8', 'numeric', '14'),
('608', 'DROPSHADOW', 'textbox', '0 0 10px 0 rgba(0, 136, 204, 0.45)', '', '15'),
('608', 'DROPWIDTH', 'textbox', '124', 'numeric', '16'),
('608', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '17'),
('608', 'DESCRIPTION', 'textarea', '', '', '18'),
('608', 'COMPONENTTYPE', 'hidden', '608', '', '19'),
('608', 'REQUIRED', 'select', 'NO\r\nYES', '', '20'),
('608', 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', '', '21'),
('609', 'NAME', 'textbox', '', '', '1'),
('609', 'CAPTION', 'textbox', '', '', '2'),
('609', 'MERIDIANS', 'select', 'NO\r\nYES', '', '4'),
('609', 'TIME_FORMAT', 'textbox', 'hh:mm A', '', '5'),
('609', 'TIME_INIT_ANIMATION', 'select', 'fadein\r\nbounce\r\ndropdown', '', '7'),
('609', 'SETCURRENTTIME', 'select', 'NO\r\nYES', '', '8'),
('609', 'PRIMARYCOLOR', 'color', '#1977CC', '', '9'),
('609', 'TEXTCOLOR', 'color', '#555555', '', '10'),
('609', 'BACKGROUNDCOLOR', 'color', '#FFFFFF', '', '11'),
('609', 'BORDERCOLOR', 'color', '#1977CC', '', '12'),
('609', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '13'),
('609', 'DEFAULTVALUE', 'textarea', '', '', '14'),
('609', 'COMPONENTTYPE', 'hidden', '609', '', '15'),
('609', 'REQUIRED', 'select', 'NO\r\nYES', '', '16'),
('609', 'DESCRIPTION', 'textarea', '', '', '17'),
('609', 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', '', '18'),
('610', 'NAME', 'textbox', '', '', '1'),
('610', 'CAPTION', 'textbox', '', '', '2'),
('610', 'DEFAULTVALUE', 'textarea', '', '', '3'),
('610', 'DESCRIPTION', 'textarea', '', '', '4'),
('610', 'REQUIRED', 'select', 'NO\r\nYES', '', '5'),
('610', 'VALIDATIONCALENDAR', 'select', '//<code>\r\nreturn RSFormProHelper::getOtherCalendars(610);\r\n//</code>', '{\"case\":{\"\":{\"show\":[],\"hide\":[\"VALIDATIONCALENDAROFFSET\"]}},\"indexcase\":{\"min\":{\"show\":[\"VALIDATIONCALENDAROFFSET\"],\"hide\":[]},\"max\":{\"show\":[\"VALIDATIONCALENDAROFFSET\"],\"hide\":[]}}}', '6'),
('610', 'VALIDATIONCALENDAROFFSET', 'textbox', '1', 'numeric', '7'),
('610', 'VALIDATIONDATE', 'select', 'YES\r\nNO', '', '8'),
('610', 'VALIDATIONMESSAGE', 'textarea', 'INVALIDINPUT', '', '9'),
('610', 'DATE_FORMAT_PICKER', 'textbox', 'm/d/Y', '', '10'),
('610', 'MINDATE', 'textarea', '', '', '11'),
('610', 'MAXDATE', 'textarea', '', '', '12'),
('610', 'SELECTYEARS', 'select', 'NO\r\nYES', '', '13'),
('610', 'SELECTMONTHS', 'select', 'NO\r\nYES', '', '14'),
('610', 'FIRSTDAYOFWEEK', 'select', 'day0\r\nday1', '', '15'),
('610', 'WEEKDAYFORMAT', 'select', 'FULL\r\nSHORT', '', '16'),
('610', 'MONTHSFORMAT', 'select', 'FULL\r\nSHORT', '', '17'),
('610', 'READONLY', 'select', 'NO\r\nYES', '', '18'),
('610', 'DISABLEALL', 'select', 'NO\r\nYES', '{\"case\":{\"YES\":{\"show\":[],\"hide\":[\"DAYSOFWEEKDISABLED\"]},\"NO\":{\"show\":[\"DAYSOFWEEKDISABLED\"],\"hide\":[]}}}', '19'),
('610', 'DAYSOFWEEKDISABLED', 'textbox', '', '', '20'),
('610', 'DISABLEEXCEPTIONS', 'textarea', '', '', '21'),
('610', 'ADDITIONALATTRIBUTES', 'textarea', '', '', '22'),
('610', 'COMPONENTTYPE', 'hidden', '610', '', '23');
/**ABDB**/CREATE TABLE `#__convertforms_connections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `app` varchar(50) NOT NULL,
  `created` datetime NOT NULL,
  `title` varchar(50) NOT NULL,
  `params` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__rsform_condition_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `condition_id` int(11) NOT NULL,
  `component_id` int(11) NOT NULL,
  `operator` varchar(16) NOT NULL,
  `value` mediumtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `condition_id` (`condition_id`),
  KEY `component_id` (`component_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__scheduler_tasks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'FK to the #__assets table.',
  `title` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(128) NOT NULL COMMENT 'unique identifier for job defined by plugin',
  `execution_rules` text DEFAULT NULL COMMENT 'Execution Rules, Unprocessed',
  `cron_rules` text DEFAULT NULL COMMENT 'Processed execution rules, crontab-like JSON form',
  `state` tinyint(4) NOT NULL DEFAULT 0,
  `last_exit_code` int(11) NOT NULL DEFAULT 0 COMMENT 'Exit code when job was last run',
  `last_execution` datetime DEFAULT NULL COMMENT 'Timestamp of last run',
  `next_execution` datetime DEFAULT NULL COMMENT 'Timestamp of next (planned) run, referred for execution on trigger',
  `times_executed` int(11) DEFAULT 0 COMMENT 'Count of successful triggers',
  `times_failed` int(11) DEFAULT 0 COMMENT 'Count of failures',
  `locked` datetime DEFAULT NULL,
  `priority` smallint(6) NOT NULL DEFAULT 0,
  `ordering` int(11) NOT NULL DEFAULT 0 COMMENT 'Configurable list ordering',
  `cli_exclusive` smallint(6) NOT NULL DEFAULT 0 COMMENT 'If 1, the task is only accessible via CLI',
  `params` text NOT NULL,
  `note` text DEFAULT NULL,
  `created` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL DEFAULT 0,
  `checked_out` int(10) unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_type` (`type`),
  KEY `idx_state` (`state`),
  KEY `idx_last_exit` (`last_exit_code`),
  KEY `idx_next_exec` (`next_execution`),
  KEY `idx_locked` (`locked`),
  KEY `idx_priority` (`priority`),
  KEY `idx_cli_exclusive` (`cli_exclusive`),
  KEY `idx_checked_out` (`checked_out`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__scheduler_tasks`  VALUES 
('1', '172', 'Rotate Logs', 'rotation.logs', '{\"rule-type\":\"interval-days\",\"interval-days\":30,\"exec-time\":\"05:29\",\"exec-day\":\"31\"}', '{\"type\":\"interval\",\"exp\":\"P30D\"}', '1', '0', '2026-02-17 05:48:38', '2026-03-19 05:29:00', '17', '0', NULL, '0', '0', '0', '{\"logstokeep\":1}', NULL, '2024-05-31 05:37:37', '957', NULL, NULL),
('2', '173', 'Session GC', 'session.gc', '{\"rule-type\":\"interval-hours\",\"interval-hours\":24,\"exec-time\":\"05:37\",\"exec-day\":\"31\"}', '{\"type\":\"interval\",\"exp\":\"PT24H\"}', '1', '0', '2026-02-19 10:58:36', '2026-02-20 10:58:36', '311', '0', NULL, '0', '0', '0', '{\"enable_session_gc\":1,\"enable_session_metadata_gc\":1}', NULL, '2024-05-31 05:37:37', '957', NULL, NULL),
('3', '174', 'Update Notification', 'update.notification', '{\"rule-type\":\"interval-hours\",\"interval-hours\":6,\"exec-time\":\"05:29\",\"exec-day\":\"31\"}', '{\"type\":\"interval\",\"exp\":\"PT6H\"}', '1', '0', '2026-02-19 10:59:15', '2026-02-19 16:59:15', '714', '0', NULL, '0', '0', '0', '{\"email\":\"\",\"language_override\":\"\"}', NULL, '2024-05-31 05:37:37', '957', NULL, NULL);
/**ABDB**/CREATE TABLE `#__finder_links` (
  `link_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `route` varchar(400) NOT NULL,
  `title` varchar(400) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `indexdate` datetime NOT NULL,
  `md5sum` varchar(32) DEFAULT NULL,
  `published` tinyint(4) NOT NULL DEFAULT 1,
  `state` int(11) NOT NULL DEFAULT 1,
  `access` int(11) NOT NULL DEFAULT 0,
  `language` char(7) NOT NULL DEFAULT '',
  `publish_start_date` datetime DEFAULT NULL,
  `publish_end_date` datetime DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `list_price` double unsigned NOT NULL DEFAULT 0,
  `sale_price` double unsigned NOT NULL DEFAULT 0,
  `type_id` int(11) NOT NULL,
  `object` mediumblob DEFAULT NULL,
  PRIMARY KEY (`link_id`),
  KEY `idx_type` (`type_id`),
  KEY `idx_title` (`title`(100)),
  KEY `idx_md5` (`md5sum`),
  KEY `idx_url` (`url`(75)),
  KEY `idx_language` (`language`),
  KEY `idx_published_list` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`list_price`),
  KEY `idx_published_sale` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`sale_price`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__finder_links`  VALUES 
('1', 'index.php?option=com_tags&view=tag&id=2', 'index.php?option=com_tags&view=tag&id=2:millions', 'Millions', '', '2022-07-26 13:57:30', '23f4b5a428ee5b27dfd81fa5e05f4ed1', '1', '1', '1', '*', NULL, NULL, '2022-07-26 13:57:30', NULL, '0', '0', '5', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:0:\"\";i:3;a:14:{s:2:\"id\";i:2;s:5:\"alias\";s:8:\"millions\";s:7:\"summary\";s:0:\"\";s:10:\"created_by\";i:957;s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":0:{}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:8:\"modified\";s:19:\"2022-07-26 13:57:30\";s:11:\"modified_by\";i:957;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":31:{s:10:\"tag_layout\";s:9:\"_:default\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:5;s:14:\"show_tag_title\";s:1:\"0\";s:23:\"tag_list_show_tag_image\";s:1:\"0\";s:29:\"tag_list_show_tag_description\";s:1:\"0\";s:14:\"tag_list_image\";s:0:\"\";s:16:\"tag_list_orderby\";s:5:\"title\";s:26:\"tag_list_orderby_direction\";s:3:\"ASC\";s:13:\"show_headings\";s:1:\"0\";s:18:\"tag_list_show_date\";s:1:\"0\";s:24:\"tag_list_show_item_image\";s:1:\"0\";s:30:\"tag_list_show_item_description\";s:1:\"0\";s:32:\"tag_list_item_maximum_characters\";i:0;s:17:\"return_any_or_all\";s:1:\"1\";s:16:\"include_children\";s:1:\"0\";s:7:\"maximum\";i:200;s:24:\"tag_list_language_filter\";s:3:\"all\";s:11:\"tags_layout\";s:9:\"_:default\";s:16:\"all_tags_orderby\";s:5:\"title\";s:26:\"all_tags_orderby_direction\";s:3:\"ASC\";s:23:\"all_tags_show_tag_image\";s:1:\"0\";s:29:\"all_tags_show_tag_description\";s:1:\"0\";s:31:\"all_tags_tag_maximum_characters\";i:20;s:22:\"all_tags_show_tag_hits\";s:1:\"0\";s:12:\"filter_field\";s:1:\"1\";s:21:\"show_pagination_limit\";s:1:\"1\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:19:\"tag_field_ajax_mode\";s:1:\"1\";s:14:\"show_feed_link\";s:1:\"1\";}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:4:\"slug\";s:10:\"2:millions\";s:6:\"author\";s:5:\"admin\";s:6:\"layout\";s:3:\"tag\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:9:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:4:\"link\";i:4;s:7:\"metakey\";i:5;s:8:\"metadesc\";i:6;s:10:\"metaauthor\";i:7;s:6:\"author\";i:8;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;N;i:10;N;i:11;s:48:\"index.php?option=com_tags&view=tag&id=2:millions\";i:12;N;i:13;s:19:\"2022-07-26 13:57:30\";i:14;i:1;i:15;a:3:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:3:\"Tag\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:3;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:5:\"admin\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:7;}}}i:16;s:8:\"Millions\";i:17;i:5;i:18;s:39:\"index.php?option=com_tags&view=tag&id=2\";}'),
('2', 'index.php?option=com_tags&view=tag&id=3', 'index.php?option=com_tags&view=tag&id=3:worldwide', 'Worldwide', '', '2022-07-26 13:57:30', '767c55b9915536057759b7ef3300694c', '1', '1', '1', '*', NULL, NULL, '2022-07-26 13:57:30', NULL, '0', '0', '5', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:0:\"\";i:3;a:14:{s:2:\"id\";i:3;s:5:\"alias\";s:9:\"worldwide\";s:7:\"summary\";s:0:\"\";s:10:\"created_by\";i:957;s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":0:{}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:8:\"modified\";s:19:\"2022-07-26 13:57:30\";s:11:\"modified_by\";i:957;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":31:{s:10:\"tag_layout\";s:9:\"_:default\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:5;s:14:\"show_tag_title\";s:1:\"0\";s:23:\"tag_list_show_tag_image\";s:1:\"0\";s:29:\"tag_list_show_tag_description\";s:1:\"0\";s:14:\"tag_list_image\";s:0:\"\";s:16:\"tag_list_orderby\";s:5:\"title\";s:26:\"tag_list_orderby_direction\";s:3:\"ASC\";s:13:\"show_headings\";s:1:\"0\";s:18:\"tag_list_show_date\";s:1:\"0\";s:24:\"tag_list_show_item_image\";s:1:\"0\";s:30:\"tag_list_show_item_description\";s:1:\"0\";s:32:\"tag_list_item_maximum_characters\";i:0;s:17:\"return_any_or_all\";s:1:\"1\";s:16:\"include_children\";s:1:\"0\";s:7:\"maximum\";i:200;s:24:\"tag_list_language_filter\";s:3:\"all\";s:11:\"tags_layout\";s:9:\"_:default\";s:16:\"all_tags_orderby\";s:5:\"title\";s:26:\"all_tags_orderby_direction\";s:3:\"ASC\";s:23:\"all_tags_show_tag_image\";s:1:\"0\";s:29:\"all_tags_show_tag_description\";s:1:\"0\";s:31:\"all_tags_tag_maximum_characters\";i:20;s:22:\"all_tags_show_tag_hits\";s:1:\"0\";s:12:\"filter_field\";s:1:\"1\";s:21:\"show_pagination_limit\";s:1:\"1\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:19:\"tag_field_ajax_mode\";s:1:\"1\";s:14:\"show_feed_link\";s:1:\"1\";}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:4:\"slug\";s:11:\"3:worldwide\";s:6:\"author\";s:5:\"admin\";s:6:\"layout\";s:3:\"tag\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:9:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:4:\"link\";i:4;s:7:\"metakey\";i:5;s:8:\"metadesc\";i:6;s:10:\"metaauthor\";i:7;s:6:\"author\";i:8;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;N;i:10;N;i:11;s:49:\"index.php?option=com_tags&view=tag&id=3:worldwide\";i:12;N;i:13;s:19:\"2022-07-26 13:57:30\";i:14;i:1;i:15;a:3:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:3:\"Tag\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:3;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:5:\"admin\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:7;}}}i:16;s:9:\"Worldwide\";i:17;i:5;i:18;s:39:\"index.php?option=com_tags&view=tag&id=3\";}'),
('3', 'index.php?option=com_tags&view=tag&id=4', 'index.php?option=com_tags&view=tag&id=4:love', 'Love', '', '2022-07-26 13:57:30', 'afc042e43db07b6c3010371b131b17c1', '1', '1', '1', '*', NULL, NULL, '2022-07-26 13:57:30', NULL, '0', '0', '5', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:0:\"\";i:3;a:14:{s:2:\"id\";i:4;s:5:\"alias\";s:4:\"love\";s:7:\"summary\";s:0:\"\";s:10:\"created_by\";i:957;s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":0:{}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:8:\"modified\";s:19:\"2022-07-26 13:57:30\";s:11:\"modified_by\";i:957;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":31:{s:10:\"tag_layout\";s:9:\"_:default\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:5;s:14:\"show_tag_title\";s:1:\"0\";s:23:\"tag_list_show_tag_image\";s:1:\"0\";s:29:\"tag_list_show_tag_description\";s:1:\"0\";s:14:\"tag_list_image\";s:0:\"\";s:16:\"tag_list_orderby\";s:5:\"title\";s:26:\"tag_list_orderby_direction\";s:3:\"ASC\";s:13:\"show_headings\";s:1:\"0\";s:18:\"tag_list_show_date\";s:1:\"0\";s:24:\"tag_list_show_item_image\";s:1:\"0\";s:30:\"tag_list_show_item_description\";s:1:\"0\";s:32:\"tag_list_item_maximum_characters\";i:0;s:17:\"return_any_or_all\";s:1:\"1\";s:16:\"include_children\";s:1:\"0\";s:7:\"maximum\";i:200;s:24:\"tag_list_language_filter\";s:3:\"all\";s:11:\"tags_layout\";s:9:\"_:default\";s:16:\"all_tags_orderby\";s:5:\"title\";s:26:\"all_tags_orderby_direction\";s:3:\"ASC\";s:23:\"all_tags_show_tag_image\";s:1:\"0\";s:29:\"all_tags_show_tag_description\";s:1:\"0\";s:31:\"all_tags_tag_maximum_characters\";i:20;s:22:\"all_tags_show_tag_hits\";s:1:\"0\";s:12:\"filter_field\";s:1:\"1\";s:21:\"show_pagination_limit\";s:1:\"1\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:19:\"tag_field_ajax_mode\";s:1:\"1\";s:14:\"show_feed_link\";s:1:\"1\";}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:4:\"slug\";s:6:\"4:love\";s:6:\"author\";s:5:\"admin\";s:6:\"layout\";s:3:\"tag\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:9:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:4:\"link\";i:4;s:7:\"metakey\";i:5;s:8:\"metadesc\";i:6;s:10:\"metaauthor\";i:7;s:6:\"author\";i:8;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;N;i:10;N;i:11;s:44:\"index.php?option=com_tags&view=tag&id=4:love\";i:12;N;i:13;s:19:\"2022-07-26 13:57:30\";i:14;i:1;i:15;a:3:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:3:\"Tag\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:3;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:5:\"admin\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:7;}}}i:16;s:4:\"Love\";i:17;i:5;i:18;s:39:\"index.php?option=com_tags&view=tag&id=4\";}'),
('4', 'index.php?option=com_tags&view=tag&id=5', 'index.php?option=com_tags&view=tag&id=5:joomla-4', 'Joomla 4', '', '2022-07-26 13:57:30', '5867255cc77bfa15d1892d7ff9d1138b', '1', '1', '1', '*', NULL, NULL, '2022-07-26 13:57:30', NULL, '0', '0', '5', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:0:\"\";i:3;a:14:{s:2:\"id\";i:5;s:5:\"alias\";s:8:\"joomla 4\";s:7:\"summary\";s:0:\"\";s:10:\"created_by\";i:957;s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":0:{}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:8:\"modified\";s:19:\"2022-07-26 13:57:30\";s:11:\"modified_by\";i:957;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":31:{s:10:\"tag_layout\";s:9:\"_:default\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:5;s:14:\"show_tag_title\";s:1:\"0\";s:23:\"tag_list_show_tag_image\";s:1:\"0\";s:29:\"tag_list_show_tag_description\";s:1:\"0\";s:14:\"tag_list_image\";s:0:\"\";s:16:\"tag_list_orderby\";s:5:\"title\";s:26:\"tag_list_orderby_direction\";s:3:\"ASC\";s:13:\"show_headings\";s:1:\"0\";s:18:\"tag_list_show_date\";s:1:\"0\";s:24:\"tag_list_show_item_image\";s:1:\"0\";s:30:\"tag_list_show_item_description\";s:1:\"0\";s:32:\"tag_list_item_maximum_characters\";i:0;s:17:\"return_any_or_all\";s:1:\"1\";s:16:\"include_children\";s:1:\"0\";s:7:\"maximum\";i:200;s:24:\"tag_list_language_filter\";s:3:\"all\";s:11:\"tags_layout\";s:9:\"_:default\";s:16:\"all_tags_orderby\";s:5:\"title\";s:26:\"all_tags_orderby_direction\";s:3:\"ASC\";s:23:\"all_tags_show_tag_image\";s:1:\"0\";s:29:\"all_tags_show_tag_description\";s:1:\"0\";s:31:\"all_tags_tag_maximum_characters\";i:20;s:22:\"all_tags_show_tag_hits\";s:1:\"0\";s:12:\"filter_field\";s:1:\"1\";s:21:\"show_pagination_limit\";s:1:\"1\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:19:\"tag_field_ajax_mode\";s:1:\"1\";s:14:\"show_feed_link\";s:1:\"1\";}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:4:\"slug\";s:10:\"5:joomla-4\";s:6:\"author\";s:5:\"admin\";s:6:\"layout\";s:3:\"tag\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:9:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:4:\"link\";i:4;s:7:\"metakey\";i:5;s:8:\"metadesc\";i:6;s:10:\"metaauthor\";i:7;s:6:\"author\";i:8;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;N;i:10;N;i:11;s:48:\"index.php?option=com_tags&view=tag&id=5:joomla-4\";i:12;N;i:13;s:19:\"2022-07-26 13:57:30\";i:14;i:1;i:15;a:3:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:3:\"Tag\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:3;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:5:\"admin\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:7;}}}i:16;s:8:\"Joomla 4\";i:17;i:5;i:18;s:39:\"index.php?option=com_tags&view=tag&id=5\";}'),
('5', 'index.php?option=com_content&view=category&id=8', 'index.php?option=com_content&view=category&id=8', 'Blog', '', '2022-07-26 13:57:30', '9ab1fb8f7681800b16fe5675eb59c6ee', '1', '1', '1', '*', NULL, NULL, '2022-07-26 13:57:30', NULL, '0', '0', '1', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:0:\"\";i:3;a:17:{s:2:\"id\";i:8;s:5:\"alias\";s:4:\"blog\";s:9:\"extension\";s:11:\"com_content\";s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":0:{}s:14:\"\0*\0initialized\";b:0;s:9:\"separator\";s:1:\".\";}s:3:\"lft\";i:11;s:9:\"parent_id\";i:1;s:5:\"level\";i:1;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":1:{s:11:\"workflow_id\";s:1:\"2\";}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"summary\";s:0:\"\";s:10:\"created_by\";i:957;s:8:\"modified\";s:19:\"2022-07-26 13:57:30\";s:11:\"modified_by\";i:957;s:4:\"slug\";s:6:\"8:blog\";s:6:\"layout\";s:8:\"category\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:4:\"link\";i:4;s:7:\"metakey\";i:5;s:8:\"metadesc\";i:6;s:10:\"metaauthor\";i:7;s:6:\"author\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;N;i:10;N;i:11;s:47:\"index.php?option=com_content&view=category&id=8\";i:12;N;i:13;s:19:\"2022-07-26 13:57:30\";i:14;i:1;i:15;a:2:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:8:\"Category\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:8;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:7;}}}i:16;s:4:\"Blog\";i:17;i:1;i:18;s:47:\"index.php?option=com_content&view=category&id=8\";}'),
('6', 'index.php?option=com_content&view=category&id=9', 'index.php?option=com_content&view=category&id=9', 'Help', '', '2022-07-26 13:57:30', 'c3a12cce6e96dea76685f336bbf97fa3', '1', '1', '1', '*', NULL, NULL, '2022-07-26 13:57:30', NULL, '0', '0', '1', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:0:\"\";i:3;a:17:{s:2:\"id\";i:9;s:5:\"alias\";s:4:\"help\";s:9:\"extension\";s:11:\"com_content\";s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":0:{}s:14:\"\0*\0initialized\";b:0;s:9:\"separator\";s:1:\".\";}s:3:\"lft\";i:13;s:9:\"parent_id\";i:1;s:5:\"level\";i:1;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":0:{}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"summary\";s:0:\"\";s:10:\"created_by\";i:957;s:8:\"modified\";s:19:\"2022-07-26 13:57:30\";s:11:\"modified_by\";i:957;s:4:\"slug\";s:6:\"9:help\";s:6:\"layout\";s:8:\"category\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:4:\"link\";i:4;s:7:\"metakey\";i:5;s:8:\"metadesc\";i:6;s:10:\"metaauthor\";i:7;s:6:\"author\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;N;i:10;N;i:11;s:47:\"index.php?option=com_content&view=category&id=9\";i:12;N;i:13;s:19:\"2022-07-26 13:57:30\";i:14;i:1;i:15;a:2:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:8:\"Category\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:8;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:7;}}}i:16;s:4:\"Help\";i:17;i:1;i:18;s:47:\"index.php?option=com_content&view=category&id=9\";}'),
('7', 'index.php?option=com_content&view=category&id=10', 'index.php?option=com_content&view=category&id=10', 'Joomla', '', '2022-07-26 13:57:30', 'b91110aff010ec7c1415113d15c93f28', '1', '1', '1', '*', NULL, NULL, '2022-07-26 13:57:30', NULL, '0', '0', '1', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:0:\"\";i:3;a:17:{s:2:\"id\";i:10;s:5:\"alias\";s:6:\"joomla\";s:9:\"extension\";s:11:\"com_content\";s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":0:{}s:14:\"\0*\0initialized\";b:0;s:9:\"separator\";s:1:\".\";}s:3:\"lft\";i:15;s:9:\"parent_id\";i:1;s:5:\"level\";i:1;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":0:{}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"summary\";s:0:\"\";s:10:\"created_by\";i:957;s:8:\"modified\";s:19:\"2022-07-26 13:57:30\";s:11:\"modified_by\";i:957;s:4:\"slug\";s:9:\"10:joomla\";s:6:\"layout\";s:8:\"category\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:4:\"link\";i:4;s:7:\"metakey\";i:5;s:8:\"metadesc\";i:6;s:10:\"metaauthor\";i:7;s:6:\"author\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;N;i:10;N;i:11;s:48:\"index.php?option=com_content&view=category&id=10\";i:12;N;i:13;s:19:\"2022-07-26 13:57:30\";i:14;i:1;i:15;a:2:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:8:\"Category\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:8;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:7;}}}i:16;s:6:\"Joomla\";i:17;i:1;i:18;s:48:\"index.php?option=com_content&view=category&id=10\";}'),
('8', 'index.php?option=com_content&view=category&id=11', 'index.php?option=com_content&view=category&id=11', 'Typography', '', '2022-07-26 13:57:30', '4c52c23900009f9fb37919154aacd901', '1', '1', '1', '*', NULL, NULL, '2022-07-26 13:57:30', NULL, '0', '0', '1', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:0:\"\";i:3;a:17:{s:2:\"id\";i:11;s:5:\"alias\";s:10:\"typography\";s:9:\"extension\";s:11:\"com_content\";s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":0:{}s:14:\"\0*\0initialized\";b:0;s:9:\"separator\";s:1:\".\";}s:3:\"lft\";i:17;s:9:\"parent_id\";i:1;s:5:\"level\";i:1;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":0:{}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"summary\";s:0:\"\";s:10:\"created_by\";i:957;s:8:\"modified\";s:19:\"2022-07-26 13:57:30\";s:11:\"modified_by\";i:957;s:4:\"slug\";s:13:\"11:typography\";s:6:\"layout\";s:8:\"category\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:4:\"link\";i:4;s:7:\"metakey\";i:5;s:8:\"metadesc\";i:6;s:10:\"metaauthor\";i:7;s:6:\"author\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;N;i:10;N;i:11;s:48:\"index.php?option=com_content&view=category&id=11\";i:12;N;i:13;s:19:\"2022-07-26 13:57:30\";i:14;i:1;i:15;a:2:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:8:\"Category\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:8;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:7;}}}i:16;s:10:\"Typography\";i:17;i:1;i:18;s:48:\"index.php?option=com_content&view=category&id=11\";}'),
('9', 'index.php?option=com_content&view=article&id=1', 'index.php?option=com_content&view=article&id=1:about&catid=9', 'About', ' This tells you a bit about this blog and the person who writes it. When you are logged in you will be able to edit this page by selecting the edit icon. ', '2022-07-26 13:57:30', 'fc8fedfba9b3030fe6075f287632db1b', '1', '1', '1', '*', '2022-07-26 13:57:30', NULL, '2022-07-26 13:57:30', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:154:\" This tells you a bit about this blog and the person who writes it. When you are logged in you will be able to edit this page by selecting the edit icon. \";i:3;a:25:{s:2:\"id\";i:1;s:5:\"alias\";s:5:\"about\";s:7:\"summary\";s:166:\"<p>This tells you a bit about this blog and the person who writes it. </p><p>When you are logged in you will be able to edit this page by selecting the edit icon.</p>\";s:4:\"body\";s:0:\"\";s:6:\"images\";s:0:\"\";s:5:\"catid\";i:9;s:10:\"created_by\";i:957;s:16:\"created_by_alias\";s:6:\"Joomla\";s:8:\"modified\";s:19:\"2022-07-26 13:57:30\";s:11:\"modified_by\";i:957;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":86:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"0\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"1\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"1\";s:9:\"show_hits\";s:1:\"1\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"0\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"left\";s:14:\"float_fulltext\";s:4:\"left\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:1;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"0\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:11:\"display_num\";s:2:\"10\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":0:{}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"version\";i:1;s:8:\"ordering\";i:0;s:8:\"category\";s:4:\"Help\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:7:\"1:about\";s:7:\"catslug\";s:6:\"9:help\";s:6:\"author\";s:5:\"admin\";s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2022-07-26 13:57:30\";i:10;N;i:11;s:60:\"index.php?option=com_content&view=article&id=1:about&catid=9\";i:12;N;i:13;s:19:\"2022-07-26 13:57:30\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:9;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:6:\"Joomla\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:10;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:4:\"Help\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:12;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:7;}}}i:16;s:5:\"About\";i:17;i:3;i:18;s:46:\"index.php?option=com_content&view=article&id=1\";}'),
('10', 'index.php?option=com_content&view=article&id=2', 'index.php?option=com_content&view=article&id=2:working-on-your-site&catid=9', 'Working on Your Site', ' Here are some basic tips for working on your site. Joomla! has a \'front end\' that you are looking at now and an \'administrator\' or \'back end\' which is where you do the more advanced work of creating your site such as setting up the menus and deciding what modules to show. You need to login to the administrator separately using the same user name and password that you used to login to this part of the site. One of the first things you will probably want to do is change the site title and tag line and to add a logo. To do this select the Template Settings link in the menu which is visible if you log in. To change your site description, browser title, default email and other items, select Site Settings. More advanced configuration options are available in the administrator. To totally change the look of your site you will probably want to install a new template. Go to System, select Install - Extensions from the list and the extension installer will open. There are many free and commercial templates available for Joomla. As you have already seen, you can control who can see different parts of you site. When you work with modules and articles, setting the Access level to Registered will mean that only logged in users can see them. When you create a new article or other kind of content you also can save it as Published or Unpublished. If it is Unpublished site visitors will not be able to see it but you will. You can learn much more about working with Joomla from the Joomla documentation site and get help from other users at the Joomla forums. In the administrator there are help buttons on every page that provide detailed information about the functions on that page. ', '2022-07-26 13:57:30', 'a9586e1db168b2b879ffc445746f4e9c', '1', '1', '3', '*', '2022-07-26 13:57:30', NULL, '2022-07-26 13:57:30', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:3;i:1;s:5:\"en-GB\";i:2;s:1692:\" Here are some basic tips for working on your site. Joomla! has a \'front end\' that you are looking at now and an \'administrator\' or \'back end\' which is where you do the more advanced work of creating your site such as setting up the menus and deciding what modules to show. You need to login to the administrator separately using the same user name and password that you used to login to this part of the site. One of the first things you will probably want to do is change the site title and tag line and to add a logo. To do this select the Template Settings link in the menu which is visible if you log in. To change your site description, browser title, default email and other items, select Site Settings. More advanced configuration options are available in the administrator. To totally change the look of your site you will probably want to install a new template. Go to System, select Install - Extensions from the list and the extension installer will open. There are many free and commercial templates available for Joomla. As you have already seen, you can control who can see different parts of you site. When you work with modules and articles, setting the Access level to Registered will mean that only logged in users can see them. When you create a new article or other kind of content you also can save it as Published or Unpublished. If it is Unpublished site visitors will not be able to see it but you will. You can learn much more about working with Joomla from the Joomla documentation site and get help from other users at the Joomla forums. In the administrator there are help buttons on every page that provide detailed information about the functions on that page. \";i:3;a:25:{s:2:\"id\";i:2;s:5:\"alias\";s:20:\"working on your site\";s:7:\"summary\";s:1833:\"<p>Here are some basic tips for working on your site.</p><ul><li>Joomla! has a \'front end\' that you are looking at now and an \'administrator\' or \'back end\' which is where you do the more advanced work of creating your site such as setting up the menus and deciding what modules to show. You need to login to the administrator separately using the same user name and password that you used to login to this part of the site.</li><li>One of the first things you will probably want to do is change the site title and tag line and to add a logo. To do this select the Template Settings link in the menu which is visible if you log in. To change your site description, browser title, default email and other items, select Site Settings. More advanced configuration options are available in the administrator.</li><li>To totally change the look of your site you will probably want to install a new template. Go to System, select Install - Extensions from the list and the extension installer will open. There are many free and commercial templates available for Joomla.</li><li>As you have already seen, you can control who can see different parts of you site. When you work with modules and articles, setting the Access level to Registered will mean that only logged in users can see them.</li><li>When you create a new article or other kind of content you also can save it as Published or Unpublished. If it is Unpublished site visitors will not be able to see it but you will.</li><li>You can learn much more about working with Joomla from the <a href=\'https://docs.joomla.org/\'>Joomla documentation site</a> and get help from other users at the <a href=\'https://forum.joomla.org/\'>Joomla forums</a>. In the administrator there are help buttons on every page that provide detailed information about the functions on that page.</li></ul>\";s:4:\"body\";s:0:\"\";s:6:\"images\";s:0:\"\";s:5:\"catid\";i:9;s:10:\"created_by\";i:957;s:16:\"created_by_alias\";s:6:\"Joomla\";s:8:\"modified\";s:19:\"2022-07-26 13:57:30\";s:11:\"modified_by\";i:957;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":86:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"0\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"1\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"1\";s:9:\"show_hits\";s:1:\"1\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"0\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"left\";s:14:\"float_fulltext\";s:4:\"left\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:1;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"0\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:11:\"display_num\";s:2:\"10\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":0:{}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"version\";i:1;s:8:\"ordering\";i:0;s:8:\"category\";s:4:\"Help\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:22:\"2:working-on-your-site\";s:7:\"catslug\";s:6:\"9:help\";s:6:\"author\";s:5:\"admin\";s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2022-07-26 13:57:30\";i:10;N;i:11;s:75:\"index.php?option=com_content&view=article&id=2:working-on-your-site&catid=9\";i:12;N;i:13;s:19:\"2022-07-26 13:57:30\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:9;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:6:\"Joomla\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:10;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:4:\"Help\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:12;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:7;}}}i:16;s:20:\"Working on Your Site\";i:17;i:3;i:18;s:46:\"index.php?option=com_content&view=article&id=2\";}'),
('15', 'index.php?option=com_content&view=article&id=7', 'index.php?option=com_content&view=article&id=7:millions&catid=10', 'Millions', ' Millions of Websites are built on Joomla! Learn more about beautiful blog presentation. ', '2022-07-26 13:57:30', 'd6e0729c79610b73712d18b0e236451e', '1', '1', '1', '*', '2022-07-26 13:57:30', NULL, '2022-07-26 13:57:30', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:89:\" Millions of Websites are built on Joomla! Learn more about beautiful blog presentation. \";i:3;a:27:{s:2:\"id\";i:7;s:5:\"alias\";s:8:\"millions\";s:7:\"summary\";s:117:\"<p><strong>Millions of Websites are built on Joomla!</strong></p><p>Learn more about beautiful blog presentation.</p>\";s:4:\"body\";s:274:\"<p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum. Stet clita kasd gubergren, no sea takimata sanctus est</p>\";s:6:\"images\";s:241:\"{\"image_intro\":\"images\\/sampledata\\/cassiopeia\\/nasa1-640.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/cassiopeia\\/nasa1-640.jpg?width=640&height=320\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_alt_empty\":1,\"image_intro_caption\":\"\"}\";s:5:\"catid\";i:10;s:10:\"created_by\";i:957;s:16:\"created_by_alias\";s:6:\"Joomla\";s:8:\"modified\";s:19:\"2022-07-26 13:57:30\";s:11:\"modified_by\";i:957;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":86:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"0\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"1\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"1\";s:9:\"show_hits\";s:1:\"1\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"0\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"left\";s:14:\"float_fulltext\";s:4:\"left\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:1;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"0\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:11:\"display_num\";s:2:\"10\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":0:{}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"version\";i:1;s:8:\"ordering\";i:0;s:8:\"category\";s:6:\"Joomla\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:10:\"7:millions\";s:7:\"catslug\";s:9:\"10:joomla\";s:6:\"author\";s:5:\"admin\";s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:8:\"imageUrl\";s:126:\"images/sampledata/cassiopeia/nasa1-640.jpg#joomlaImage://local-images/sampledata/cassiopeia/nasa1-640.jpg?width=640&height=320\";s:8:\"imageAlt\";s:0:\"\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2022-07-26 13:57:30\";i:10;N;i:11;s:64:\"index.php?option=com_content&view=article&id=7:millions&catid=10\";i:12;N;i:13;s:19:\"2022-07-26 13:57:30\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:9;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:6:\"Joomla\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:10;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:6:\"Joomla\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:14;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:7;}}}i:16;s:8:\"Millions\";i:17;i:3;i:18;s:46:\"index.php?option=com_content&view=article&id=7\";}'),
('16', 'index.php?option=com_content&view=article&id=8', 'index.php?option=com_content&view=article&id=8:love&catid=10', 'Love', ' We love Joomla to the moon and back! Thank you to all volunteers who have contributed! ', '2022-07-26 13:57:30', 'd355135db7d0310f7018fc388cf010a2', '1', '1', '1', '*', '2022-07-26 13:57:30', NULL, '2022-07-26 13:57:30', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:88:\" We love Joomla to the moon and back! Thank you to all volunteers who have contributed! \";i:3;a:27:{s:2:\"id\";i:8;s:5:\"alias\";s:4:\"love\";s:7:\"summary\";s:116:\"<p><strong>We love Joomla to the moon and back!</strong></p><p>Thank you to all volunteers who have contributed!</p>\";s:4:\"body\";s:557:\"<p>Uurnip greens yarrow ricebean rutabaga endive cauliflower sea lettuce kohlrabi amaranth water spinach avocado daikon napa cabbage asparagus winter purslane kale. Celery potato scallion desert raisin horseradish spinach carrot soko. Lotus root water spinach fennel kombu maize bamboo shoot green bean swiss chard seakale pumpkin onion chickpea gram corn pea. Brussels sprout coriander water chestnut gourd swiss chard wakame kohlrabi beetroot carrot watercress. Corn amaranth salsify bunya nuts nori azuki bean chickweed potato bell pepper artichoke.</p> \";s:6:\"images\";s:241:\"{\"image_intro\":\"images\\/sampledata\\/cassiopeia\\/nasa2-640.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/cassiopeia\\/nasa2-640.jpg?width=640&height=320\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_alt_empty\":1,\"image_intro_caption\":\"\"}\";s:5:\"catid\";i:10;s:10:\"created_by\";i:957;s:16:\"created_by_alias\";s:6:\"Joomla\";s:8:\"modified\";s:19:\"2022-07-26 13:57:30\";s:11:\"modified_by\";i:957;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":86:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"0\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"1\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"1\";s:9:\"show_hits\";s:1:\"1\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"0\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"left\";s:14:\"float_fulltext\";s:4:\"left\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:1;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"0\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:11:\"display_num\";s:2:\"10\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":0:{}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"version\";i:1;s:8:\"ordering\";i:0;s:8:\"category\";s:6:\"Joomla\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:6:\"8:love\";s:7:\"catslug\";s:9:\"10:joomla\";s:6:\"author\";s:5:\"admin\";s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:8:\"imageUrl\";s:126:\"images/sampledata/cassiopeia/nasa2-640.jpg#joomlaImage://local-images/sampledata/cassiopeia/nasa2-640.jpg?width=640&height=320\";s:8:\"imageAlt\";s:0:\"\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2022-07-26 13:57:30\";i:10;N;i:11;s:60:\"index.php?option=com_content&view=article&id=8:love&catid=10\";i:12;N;i:13;s:19:\"2022-07-26 13:57:30\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:9;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:6:\"Joomla\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:10;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:6:\"Joomla\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:14;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:7;}}}i:16;s:4:\"Love\";i:17;i:3;i:18;s:46:\"index.php?option=com_content&view=article&id=8\";}'),
('17', 'index.php?option=com_content&view=article&id=9', 'index.php?option=com_content&view=article&id=9:joomla&catid=10', 'Joomla', ' We proudly present Joomla Version 4! Learn more about workflows in Joomla. ', '2022-07-26 13:57:30', 'f026ca9e8fe030e7270e1ef00834e27c', '1', '1', '1', '*', '2022-07-26 13:57:30', NULL, '2022-07-26 13:57:30', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:76:\" We proudly present Joomla Version 4! Learn more about workflows in Joomla. \";i:3;a:27:{s:2:\"id\";i:9;s:5:\"alias\";s:6:\"joomla\";s:7:\"summary\";s:104:\"<p><strong>We proudly present Joomla Version 4!</strong></p><p>Learn more about workflows in Joomla.</p>\";s:4:\"body\";s:396:\"<p>Cupcake ipsum dolor. Sit amet cotton candy ice cream sesame snaps cake marshmallow powder. Ice cream chocolate cake marshmallow halvah bonbon. Dragée carrot cake danish candy muffin brownie. Candy sugar plum ice cream chupa chups macaroon tiramisu soufflé oat cake. Topping cheesecake lollipop gummi bears icing sweet roll donut liquorice. Pie jelly-o candy donut oat cake cotton candy. </p>\";s:6:\"images\";s:241:\"{\"image_intro\":\"images\\/sampledata\\/cassiopeia\\/nasa3-640.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/cassiopeia\\/nasa3-640.jpg?width=640&height=320\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_alt_empty\":1,\"image_intro_caption\":\"\"}\";s:5:\"catid\";i:10;s:10:\"created_by\";i:957;s:16:\"created_by_alias\";s:6:\"Joomla\";s:8:\"modified\";s:19:\"2022-07-26 13:57:30\";s:11:\"modified_by\";i:957;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":86:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"0\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"1\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"1\";s:9:\"show_hits\";s:1:\"1\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"0\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"left\";s:14:\"float_fulltext\";s:4:\"left\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:1;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"0\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:11:\"display_num\";s:2:\"10\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":0:{}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"version\";i:1;s:8:\"ordering\";i:0;s:8:\"category\";s:6:\"Joomla\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:8:\"9:joomla\";s:7:\"catslug\";s:9:\"10:joomla\";s:6:\"author\";s:5:\"admin\";s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:8:\"imageUrl\";s:126:\"images/sampledata/cassiopeia/nasa3-640.jpg#joomlaImage://local-images/sampledata/cassiopeia/nasa3-640.jpg?width=640&height=320\";s:8:\"imageAlt\";s:0:\"\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2022-07-26 13:57:30\";i:10;N;i:11;s:62:\"index.php?option=com_content&view=article&id=9:joomla&catid=10\";i:12;N;i:13;s:19:\"2022-07-26 13:57:30\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:9;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:6:\"Joomla\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:10;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:6:\"Joomla\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:14;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:7;}}}i:16;s:6:\"Joomla\";i:17;i:3;i:18;s:46:\"index.php?option=com_content&view=article&id=9\";}'),
('20', 'index.php?option=com_content&view=article&id=11', 'index.php?option=com_content&view=article&id=11:typography&catid=11', 'Typography', ' We\'ve used Inter font family for all of the themes because it\'s a beautiful font for UI design and is completely open-source and free. Using a custom font is nice because it allows us to make the components look the same on all browsers and operating systems. You can choose Google font via theme settings instead using local font. It\'s optional. Headings All HTML headings, through are available. Typography (h1) Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p) Lorem Ipsum Dolor Sit Amet (h2) Lorem ipsum dolor sit amet, consectetuer adipiscing elit (strong), sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p) Lorem Ipsum Dolor Sit Amet (h3) Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p) Lorem Ipsum Dolor Sit Amet (h4) Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p) Lorem Ipsum Dolor Sit Amet (h5) Joomla 4 bootstrap 5 button secondary primary info success warning danger text-secondary text-primary text-info text-success text-warning text-danger Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p) Lorem ipsumdolor (a) Lists (ol)(li) Lorem ipsum dolor sit amet consectetur Lorem ipsum dolor sit amet consectetur (ul)(li) Lorem ipsum dolor sit amet consectetur Lorem ipsum dolor sit amet consectetur Theme Buttons Buttons have a number of great variations to choose from. You should note that in the HTML breakdown we have added a button class in addition to the variation, which is a requirement for these particular variations to work. You can also combine these variations. Default Button Button Primary Button Secondary Button Danger Button Text Default Button Button Primary Button Secondary Button Danger Button Text Notice Styles Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. … Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. … Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. … Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. … Blockquotes For quoting blocks of content from another source within your document. Default blockquote Wrap around any HTML as the quote. For straight quotes we recommend a . Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante. Blockquote options Style and content changes for simple variations on a standard blockquote. Naming a source Add tag for identifying the source. Wrap the name of the source work in . Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante. Someone famous in Source Title Lorem ipsum dolor sit amet,consectetur adipiscing elit. Integer posuere erat a ante. Someone famous Source Title The blockquote element represents content that is quoted from another source, optionally with a citation which must be within a footer or cite element. Someone famous in Source Title Tables # First Name Last Name Username 1 John Doe JohnDoe 2 Jane Doe JaneDoe 3 Bob Doe BobDoe … ', '2022-07-26 14:02:46', '2b5c83be7792b560787dd18742e201ef', '1', '1', '1', '*', '2022-07-26 13:57:30', NULL, '2022-07-26 13:57:30', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:4237:\" We\'ve used Inter font family for all of the themes because it\'s a beautiful font for UI design and is completely open-source and free. Using a custom font is nice because it allows us to make the components look the same on all browsers and operating systems. You can choose Google font via theme settings instead using local font. It\'s optional. Headings All HTML headings, through are available. Typography (h1) Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p) Lorem Ipsum Dolor Sit Amet (h2) Lorem ipsum dolor sit amet, consectetuer adipiscing elit (strong), sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p) Lorem Ipsum Dolor Sit Amet (h3) Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p) Lorem Ipsum Dolor Sit Amet (h4) Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p) Lorem Ipsum Dolor Sit Amet (h5) Joomla 4 bootstrap 5 button secondary primary info success warning danger text-secondary text-primary text-info text-success text-warning text-danger Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p) Lorem ipsumdolor (a) Lists (ol)(li) Lorem ipsum dolor sit amet consectetur Lorem ipsum dolor sit amet consectetur (ul)(li) Lorem ipsum dolor sit amet consectetur Lorem ipsum dolor sit amet consectetur Theme Buttons Buttons have a number of great variations to choose from. You should note that in the HTML breakdown we have added a button class in addition to the variation, which is a requirement for these particular variations to work. You can also combine these variations. Default Button Button Primary Button Secondary Button Danger Button Text Default Button Button Primary Button Secondary Button Danger Button Text Notice Styles Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. … Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. … Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. … Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. … Blockquotes For quoting blocks of content from another source within your document. Default blockquote Wrap around any HTML as the quote. For straight quotes we recommend a . Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante. Blockquote options Style and content changes for simple variations on a standard blockquote. Naming a source Add tag for identifying the source. Wrap the name of the source work in . Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante. Someone famous in Source Title Lorem ipsum dolor sit amet,consectetur adipiscing elit. Integer posuere erat a ante. Someone famous Source Title The blockquote element represents content that is quoted from another source, optionally with a citation which must be within a footer or cite element. Someone famous in Source Title Tables # First Name Last Name Username 1 John Doe JohnDoe 2 Jane Doe JaneDoe 3 Bob Doe BobDoe … \";i:3;a:25:{s:2:\"id\";i:11;s:5:\"alias\";s:10:\"typography\";s:7:\"summary\";s:7099:\"<p>We\'ve used <a href=\"https://rsms.me/inter\">Inter</a> font family for all of the themes because it\'s a beautiful font for UI design and is completely open-source and free. Using a custom font is nice because it allows us to make the components look the same on all browsers and operating systems. You can choose Google font via theme settings instead using local font. It\'s optional.</p>\r\n<h1>Headings</h1>\r\n<p>All HTML headings, <code>&lt;h1&gt;</code> through <code>&lt;h6&gt;</code> are available.</p>\r\n<h1>Typography (h1)</h1>\r\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p)</p>\r\n<h2>Lorem Ipsum Dolor Sit Amet (h2)</h2>\r\n<p><strong>Lorem ipsum dolor sit amet, consectetuer adipiscing elit </strong> (strong), sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p)</p>\r\n<h3>Lorem Ipsum Dolor Sit Amet (h3)</h3>\r\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p)</p>\r\n<h4>Lorem Ipsum Dolor Sit Amet (h4)</h4>\r\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p)</p>\r\n<h5>Lorem Ipsum Dolor Sit Amet (h5)</h5>\r\n<h1>Joomla 4 bootstrap 5 button</h1>\r\n<p><span class=\"btn btn-secondary\">secondary</span> <span class=\"btn btn-primary\">primary</span> <span class=\"btn btn-info\">info</span> <span class=\"btn btn-success\">success</span> <span class=\"btn btn-warning\">warning</span> <span class=\"btn btn-danger\">danger</span></p>\r\n<p><span class=\"text text-secondary\">text-secondary</span> <span class=\"text text-primary\">text-primary</span> <span class=\"text text-info\">text-info</span> <span class=\"text text-success\">text-success</span> <span class=\"text text-warning\">text-warning</span> <span class=\"text text-danger\">text-danger</span></p>\r\n<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit, sed diam nonummy nibh euismod tincidunt ut laoreet dolore magna aliquam erat volutpat. Ut wisi enim ad minim veniam, quis nostrud exerci tation ullamcorper suscipit lobortis nisl ut aliquip ex. (p)</p>\r\n<p><a href=\"index.php\"> Lorem ipsum dolor (a)</a></p>\r\n<h1>Lists</h1>\r\n<p>(ol)(li)</p>\r\n<ol>\r\n<li>Lorem ipsum dolor sit amet consectetur</li>\r\n<li>Lorem ipsum dolor sit amet consectetur</li>\r\n</ol>\r\n<p>(ul)(li)</p>\r\n<ul>\r\n<li>Lorem ipsum dolor sit amet consectetur</li>\r\n<li>Lorem ipsum dolor sit amet consectetur</li>\r\n</ul>\r\n<h2>Theme Buttons</h2>\r\n<p>Buttons have a number of great variations to choose from. You should note that in the HTML breakdown we have added a <code>button</code> class in addition to the variation, which is a requirement for these particular variations to work. You can also combine these variations.</p>\r\n<p><a class=\"jl-button jl-button-default\" href=\"#\">Default Button</a>   <a class=\"jl-button jl-button-primary\" href=\"#\">Button Primary</a>   <a class=\"jl-button jl-button-secondary\" href=\"#\">Button Secondary</a>   <a class=\"jl-button jl-button-danger\" href=\"#\">Button Danger</a>   <a class=\"jl-button jl-button-text\" href=\"#\">Button Text</a></p>\r\n<pre>&lt;a href=\"#\" class=\"jl-button jl-button-default\"&gt;Default Button&lt;/a&gt;\r\n&lt;a href=\"#\" class=\"jl-button jl-button-primary\"&gt;Button Primary&lt;/a&gt;\r\n&lt;a href=\"#\" class=\"jl-button jl-button-secondary\"&gt;Button Secondary&lt;/a&gt;\r\n&lt;a href=\"#\" class=\"jl-button jl-button-danger\"&gt;Button Danger&lt;/a&gt;\r\n&lt;a href=\"#\" class=\"jl-button jl-button-text\"&gt;Button Text&lt;/a&gt;\r\n\r\n</pre>\r\n<h1>Notice Styles</h1>\r\n<p class=\"alert alert-success\">Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n<pre>&lt;p class=\"alert alert-success\"&gt;…&lt;/p&gt;</pre>\r\n<p class=\"alert alert-info\">Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n<pre>&lt;p class=\"alert alert-info\"&gt;…&lt;/p&gt;</pre>\r\n<p class=\"alert alert-warning\">Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n<pre>&lt;p class=\"alert alert-warning\"&gt;…&lt;/p&gt;</pre>\r\n<p class=\"alert alert-error\">Nullam quis risus eget urna mollis ornare vel eu leo. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>\r\n<pre>&lt;p class=\"alert alert-error\"&gt;…&lt;/p&gt;</pre>\r\n<h1>Blockquotes</h1>\r\n<p>For quoting blocks of content from another source within your document.</p>\r\n<h3>Default blockquote</h3>\r\n<p>Wrap <code>&lt;blockquote&gt;</code> around any <abbr title=\"HyperText Markup Language\">HTML</abbr> as the quote. For straight quotes we recommend a <code>&lt;p&gt;</code>.</p>\r\n<blockquote>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.</p>\r\n</blockquote>\r\n<pre>&lt;blockquote&gt;\r\n&lt;p&gt;Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.&lt;/p&gt;\r\n&lt;/blockquote&gt;</pre>\r\n<h3>Blockquote options</h3>\r\n<p>Style and content changes for simple variations on a standard blockquote.</p>\r\n<h4>Naming a source</h4>\r\n<p>Add <code>&lt;small&gt;</code> tag for identifying the source. Wrap the name of the source work in <code>&lt;cite&gt;</code>.</p>\r\n<blockquote>\r\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.</p>\r\n<small>Someone famous in <cite title=\"Source Title\">Source Title</cite></small></blockquote>\r\n<pre>&lt;blockquote&gt;&lt;p&gt;Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer posuere erat a ante.&lt;/p&gt;&lt;small&gt;Someone famous &lt;cite title=\"Source Title\"&gt;Source Title&lt;/cite&gt;&lt;/small&gt;&lt;/blockquote&gt;</pre>\r\n<blockquote class=\"jl-margin-medium\" cite=\"#\">\r\n<p>The blockquote element represents content that is quoted from another source, optionally with a citation which must be within a footer or cite element.</p>\r\n<footer>Someone famous in <cite><a href=\"#\">Source Title</a></cite></footer></blockquote>\r\n<h1>Tables</h1>\r\n<table>\r\n<thead>\r\n<tr>\r\n<th>#</th>\r\n<th>First Name</th>\r\n<th>Last Name</th>\r\n<th>Username</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td>1</td>\r\n<td>John</td>\r\n<td>Doe</td>\r\n<td>JohnDoe</td>\r\n</tr>\r\n<tr>\r\n<td>2</td>\r\n<td>Jane</td>\r\n<td>Doe</td>\r\n<td>JaneDoe</td>\r\n</tr>\r\n<tr>\r\n<td>3</td>\r\n<td>Bob</td>\r\n<td>Doe</td>\r\n<td>BobDoe</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n<pre>&lt;table class=\"table\"&gt;…&lt;/table&gt;</pre>\";s:4:\"body\";s:0:\"\";s:6:\"images\";s:173:\"{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}\";s:5:\"catid\";i:11;s:10:\"created_by\";i:957;s:16:\"created_by_alias\";s:6:\"Joomla\";s:8:\"modified\";s:19:\"2022-07-26 14:02:46\";s:11:\"modified_by\";i:957;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":86:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"0\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"1\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"1\";s:9:\"show_hits\";s:1:\"1\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"0\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"left\";s:14:\"float_fulltext\";s:4:\"left\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:1;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"0\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:11:\"display_num\";s:2:\"10\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:6:\"robots\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"rights\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"version\";i:2;s:8:\"ordering\";i:0;s:8:\"category\";s:10:\"Typography\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:13:\"11:typography\";s:7:\"catslug\";s:13:\"11:typography\";s:6:\"author\";s:5:\"admin\";s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2022-07-26 13:57:30\";i:10;N;i:11;s:67:\"index.php?option=com_content&view=article&id=11:typography&catid=11\";i:12;N;i:13;s:19:\"2022-07-26 13:57:30\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:9;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:6:\"Joomla\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:10;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:10:\"Typography\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:15;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:7;}}}i:16;s:10:\"Typography\";i:17;i:3;i:18;s:47:\"index.php?option=com_content&view=article&id=11\";}');
/**ABDB**/INSERT INTO `#__finder_links`  VALUES 
('23', 'index.php?option=com_content&view=article&id=12', 'index.php?option=com_content&view=article&id=12:uikit-overview&catid=2', 'Uikit Overview', ' Logo Active Parent Active Parent Sub item Sub item Header Item Item Item Item Item Home Blog Category Post Article Title Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Written by Super User on 12 April 2012. Posted in Blog  Default Primary Secondary Danger Disabled a element abbr element code element del element dfn element Link Muted em element ins element mark element q inside a q strong element Link Reset Text Muted Text Emphasis Text Primary Text Secondary Text Success Text Warning Text Danger Text Meta Default Success Warning Danger 1  ... The blockquote element represents content that is quoted from another source, optionally with a citation which must be within a footer or cite element. Someone famous in Source Title Read more 5 Comments Author 12 days ago Reply  Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. 1 ... 4 5 6 7 8 9 10 ... 20 Active Parent Sub item Sub item Sub item Sub item Parent Sub item Sub item Header Item Item Item Default Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Primary Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Secondary Lorem ipsum dolor sitamet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Hover Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. 2X-Large X-Large Heading L Heading M Heading S Heading H1 Heading H2 Heading H3 Heading H4 Heading H5 Heading H6 Heading Divider Heading Bullet Heading Line Table Heading Table Heading Table Heading Table Data Table Data Table Data Table Data Table Data Table Data Table Data Table Data Table Data Table Data Table Data Table Data 365 : 18 : 21 : 05 Active Parent Sub item  Sub item Sub item Sub item Header Item Item Item Active Item Item Item Active Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do. Item Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do. Item Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do. Item Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do. Default Primary Success Warning Danger Default Lorem ipsum dolor sit amet, consectetur. Primary Lorem ipsum dolor sit amet, consectetur. Item 1 Item 2 Item 3 Item 4 Item 5 Item 6  Tooltip Active Item Disabled Active Item Disabled Active Item Disabled List item 1 List item 2 List item 3 List item 1 List item 2 List item 3 List item 1 List item 2 List item 3 Description lists A description text Description lists A description text Item 1 Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco. Item 2 Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut  labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco. Item 3 Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Button Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Button Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Button Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Button Headline Lorem ipsum dolor sit amet, consecteturadipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Cancel Save Active Item Item Item Active Parent Sub item Sub item Header Item Item Item Title Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. ', '2023-10-26 09:34:18', 'a71a57def3b282125671c91e4ee768b2', '1', '1', '1', '*', '2022-07-27 13:17:35', NULL, '2022-07-27 13:17:35', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:5331:\" Logo Active Parent Active Parent Sub item Sub item Header Item Item Item Item Item Home Blog Category Post Article Title Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Written by Super User on 12 April 2012. Posted in Blog  Default Primary Secondary Danger Disabled a element abbr element code element del element dfn element Link Muted em element ins element mark element q inside a q strong element Link Reset Text Muted Text Emphasis Text Primary Text Secondary Text Success Text Warning Text Danger Text Meta Default Success Warning Danger 1  ... The blockquote element represents content that is quoted from another source, optionally with a citation which must be within a footer or cite element. Someone famous in Source Title Read more 5 Comments Author 12 days ago Reply  Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. 1 ... 4 5 6 7 8 9 10 ... 20 Active Parent Sub item Sub item Sub item Sub item Parent Sub item Sub item Header Item Item Item Default Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Primary Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Secondary Lorem ipsum dolor sitamet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Hover Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. 2X-Large X-Large Heading L Heading M Heading S Heading H1 Heading H2 Heading H3 Heading H4 Heading H5 Heading H6 Heading Divider Heading Bullet Heading Line Table Heading Table Heading Table Heading Table Data Table Data Table Data Table Data Table Data Table Data Table Data Table Data Table Data Table Data Table Data Table Data 365 : 18 : 21 : 05 Active Parent Sub item  Sub item Sub item Sub item Header Item Item Item Active Item Item Item Active Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do. Item Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do. Item Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do. Item Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do. Default Primary Success Warning Danger Default Lorem ipsum dolor sit amet, consectetur. Primary Lorem ipsum dolor sit amet, consectetur. Item 1 Item 2 Item 3 Item 4 Item 5 Item 6  Tooltip Active Item Disabled Active Item Disabled Active Item Disabled List item 1 List item 2 List item 3 List item 1 List item 2 List item 3 List item 1 List item 2 List item 3 Description lists A description text Description lists A description text Item 1 Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco. Item 2 Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut  labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco. Item 3 Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Button Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Button Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Button Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor. Button Headline Lorem ipsum dolor sit amet, consecteturadipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Cancel Save Active Item Item Item Active Parent Sub item Sub item Header Item Item Item Title Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. \";i:3;a:25:{s:2:\"id\";i:12;s:5:\"alias\";s:14:\"uikit overview\";s:7:\"summary\";s:37695:\"<nav class=\"jl-navbar-container\">\r\n    <div jl-navbar class=\"jl-navbar-container g-content nomargintop nomarginbottom nomarginleft nomarginright nopaddingtop nopaddingbottom\">\r\n        <div class=\"jl-navbar-left\">\r\n\r\n            <a class=\"jl-navbar-item jl-logo\" href=\"#\">Logo</a>\r\n\r\n            <ul class=\"jl-navbar-nav\">\r\n                <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                <li>\r\n                    <a href=\"#\" aria-expanded=\"false\">Parent<span jl-navbar-parent-icon></span></a>\r\n                    <div class=\"jl-navbar-dropdown\">\r\n                        <ul class=\"jl-nav jl-navbar-dropdown-nav\">\r\n                            <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                            <li class=\"jl-parent\">\r\n                                <a href=\"#\">Parent</a>\r\n                                <ul class=\"jl-nav-sub\">\r\n                                    <li><a href=\"#\">Sub item</a></li>\r\n                                    <li><a href=\"#\">Sub item</a></li>\r\n                                </ul>\r\n                            </li>\r\n                            <li class=\"jl-nav-header\">Header</li>\r\n                            <li><a href=\"#\"><span class=\"jl-margin-small-right jl-icon\" jl-icon=\"icon: table\"></span>\r\n                                    Item</a></li>\r\n                            <li><a href=\"#\"><span class=\"jl-margin-small-right jl-icon\"\r\n                                        jl-icon=\"icon: thumbnails\"></span> Item</a></li>\r\n                            <li class=\"jl-nav-divider\"></li>\r\n                            <li><a href=\"#\"><span class=\"jl-margin-small-right jl-icon\" jl-icon=\"icon: trash\"></span>\r\n                                    Item</a></li>\r\n                        </ul>\r\n                    </div>\r\n                </li>\r\n                <li><a href=\"#\">Item</a></li>\r\n                <li><a href=\"#\">Item</a></li>\r\n            </ul>\r\n\r\n        </div>\r\n        <div class=\"jl-navbar-right\">\r\n            <a class=\"jl-navbar-toggle jl-icon\" href=\"#modal\" jl-icon=\"icon: more-vertical\" jl-toggle></a>\r\n            <a class=\"jl-navbar-toggle jl-icon jl-search-icon\" href=\"#modal-search\" jl-search-icon jl-toggle></a>\r\n            <a class=\"jl-navbar-toggle jl-navbar-toggle-animate\" href=\"#offcanvas\" jl-navbar-toggle-icon jl-toggle></a>\r\n        </div>\r\n    </div>\r\n</nav>\r\n\r\n<div class=\"jl-section\">\r\n\r\n    <div jl-grid class=\"jl-grid\">\r\n        <div class=\"jl-width-2-3@m\">\r\n\r\n            <ul class=\"jl-breadcrumb\">\r\n                <li><a href=\"#\">Home</a></li>\r\n                <li><a href=\"#\">Blog</a></li>\r\n                <li class=\"jl-disabled\"><a>Category</a></li>\r\n                <li><span>Post</span></li>\r\n            </ul>\r\n\r\n            <article class=\"jl-article\">\r\n\r\n                <h1 class=\"jl-article-title\"><a class=\"jl-link-reset\" href=\"#\">Article Title</a></h1>\r\n\r\n                <hr class=\"jl-divider-small\">\r\n\r\n                <p class=\"jl-text-lead\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor\r\n                    incididunt ut labore et dolore magna aliqua.</p>\r\n\r\n                <p class=\"jl-column-1-2@s jl-dropcap\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do\r\n                    eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud\r\n                    exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in\r\n                    reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint\r\n                    occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>\r\n\r\n                <p class=\"jl-article-meta\">Written by <a href=\"#\">Super User</a> on 12 April 2012. Posted in <a\r\n                        href=\"#\">Blog</a></p>\r\n\r\n                <hr class=\"jl-divider-icon jl-margin-medium\">\r\n\r\n                <div class=\"jl-grid-small jl-child-width-auto jl-flex-middle jl-margin-medium\" jl-grid>\r\n                    <div>\r\n                        <button class=\"jl-button jl-button-default\" aria-expanded=\"false\">Default</button>\r\n                    </div>\r\n                    <div>\r\n                        <button class=\"jl-button jl-button-primary\">Primary</button>\r\n                    </div>\r\n                    <div>\r\n                        <button class=\"jl-button jl-button-secondary\">Secondary</button>\r\n                    </div>\r\n                    <div>\r\n                        <button class=\"jl-button jl-button-danger\">Danger</button>\r\n                    </div>\r\n                    <div>\r\n                        <button class=\"jl-button jl-button-default\" disabled=\"\">Disabled</button>\r\n                    </div>\r\n\r\n                </div>\r\n\r\n                <hr class=\"jl-margin-medium\">\r\n\r\n                <div class=\"jl-child-width-1-2 jl-child-width-1-4@s jl-margin\" jl-grid>\r\n                    <div>\r\n                        <ul class=\"jl-list\">\r\n                            <li><a href=\"#\">a element</a></li>\r\n                            <li><abbr title=\"Title text\">abbr element</abbr></li>\r\n                            <li><code>code element</code></li>\r\n                            <li><del>del element</del></li>\r\n                            <li><dfn title=\"Title text\">dfn element</dfn></li>\r\n                            <li><a href=\"#\" class=\"jl-link-muted\">Link Muted</a></li>\r\n                        </ul>\r\n                    </div>\r\n                    <div>\r\n                        <ul class=\"jl-list\">\r\n                            <li><em>em element</em></li>\r\n                            <li><ins>ins element</ins></li>\r\n                            <li><mark>mark element</mark></li>\r\n                            <li><q>q <q>inside</q> a q</q></li>\r\n                            <li><strong>strong element</strong></li>\r\n                            <li><a href=\"#\" class=\"jl-link-reset\">Link Reset</a></li>\r\n                        </ul>\r\n                    </div>\r\n                    <div>\r\n                        <ul class=\"jl-list\">\r\n                            <li class=\"jl-text-muted\">Text Muted</li>\r\n                            <li class=\"jl-text-emphasis\">Text Emphasis</li>\r\n                            <li class=\"jl-text-primary\">Text Primary</li>\r\n                            <li class=\"jl-text-secondary\">Text Secondary</li>\r\n                            <li class=\"jl-text-success\">Text Success</li>\r\n                            <li class=\"jl-text-warning\">Text Warning</li>\r\n                            <li class=\"jl-text-danger\">Text Danger</li>\r\n                            <li class=\"jl-text-meta\">Text Meta</li>\r\n                        </ul>\r\n                    </div>\r\n                    <div>\r\n                        <ul class=\"jl-list\">\r\n                            <li><span class=\"jl-label\">Default</span></li>\r\n                            <li><span class=\"jl-label jl-label-success\">Success</span></li>\r\n                            <li><span class=\"jl-label jl-label-warning\">Warning</span></li>\r\n                            <li><span class=\"jl-label jl-label-danger\">Danger</span></li>\r\n                            <li><a class=\"jl-badge\" href=\"#\">1</a></li>\r\n                            <li>\r\n                                <a class=\"jl-icon-button jl-icon\" href=\"#\" jl-icon=\"icon: home\">\r\n                                    <svg width=\"20\" height=\"20\" viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\">\r\n                                        <polygon points=\"18.65 11.35 10 2.71 1.35 11.35 0.65 10.65 10 1.29 19.35 10.65\">\r\n                                        </polygon>\r\n                                        <polygon points=\"15 4 18 4 18 7 17 7 17 5 15 5\"></polygon>\r\n                                        <polygon\r\n                                            points=\"3 11 4 11 4 18 7 18 7 12 12 12 12 18 16 18 16 11 17 11 17 19 11 19 11 13 8 13 8 19 3 19\">\r\n                                        </polygon>\r\n                                    </svg>\r\n                                </a>\r\n                                <a class=\"jl-icon-button jl-icon\" href=\"#\" jl-icon=\"icon: github\">\r\n                                    <svg width=\"20\" height=\"20\" viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\">\r\n                                        <path\r\n                                            d=\"M10,1 C5.03,1 1,5.03 1,10 C1,13.98 3.58,17.35 7.16,18.54 C7.61,18.62 7.77,18.34 7.77,18.11 C7.77,17.9 7.76,17.33 7.76,16.58 C5.26,17.12 4.73,15.37 4.73,15.37 C4.32,14.33 3.73,14.05 3.73,14.05 C2.91,13.5 3.79,13.5 3.79,13.5 C4.69,13.56 5.17,14.43 5.17,14.43 C5.97,15.8 7.28,15.41 7.79,15.18 C7.87,14.6 8.1,14.2 8.36,13.98 C6.36,13.75 4.26,12.98 4.26,9.53 C4.26,8.55 4.61,7.74 5.19,7.11 C5.1,6.88 4.79,5.97 5.28,4.73 C5.28,4.73 6.04,4.49 7.75,5.65 C8.47,5.45 9.24,5.35 10,5.35 C10.76,5.35 11.53,5.45 12.25,5.65 C13.97,4.48 14.72,4.73 14.72,4.73 C15.21,5.97 14.9,6.88 14.81,7.11 C15.39,7.74 15.73,8.54 15.73,9.53 C15.73,12.99 13.63,13.75 11.62,13.97 C11.94,14.25 12.23,14.8 12.23,15.64 C12.23,16.84 12.22,17.81 12.22,18.11 C12.22,18.35 12.38,18.63 12.84,18.54 C16.42,17.35 19,13.98 19,10 C19,5.03 14.97,1 10,1 L10,1 Z\">\r\n                                        </path>\r\n                                    </svg>\r\n                                </a>\r\n                                <a class=\"jl-icon-link jl-icon\" href=\"#\" jl-icon=\"icon: trash\">\r\n                                    <svg width=\"20\" height=\"20\" viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\">\r\n                                        <polyline fill=\"none\" stroke=\"#000\" points=\"6.5 3 6.5 1.5 13.5 1.5 13.5 3\">\r\n                                        </polyline>\r\n                                        <polyline fill=\"none\" stroke=\"#000\" points=\"4.5 4 4.5 18.5 15.5 18.5 15.5 4\">\r\n                                        </polyline>\r\n                                        <rect x=\"8\" y=\"7\" width=\"1\" height=\"9\"></rect>\r\n                                        <rect x=\"11\" y=\"7\" width=\"1\" height=\"9\"></rect>\r\n                                        <rect x=\"2\" y=\"3\" width=\"16\" height=\"1\"></rect>\r\n                                    </svg>\r\n                                </a>\r\n                            </li>\r\n                        </ul>\r\n                    </div>\r\n                </div>\r\n\r\n                <pre class=\"jl-pre jl-margin-medium\"><code>&lt;div class=\"myclass\"&gt;...&lt;div&gt;</code></pre>\r\n\r\n                <blockquote class=\"jl-margin-medium\" cite=\"#\">\r\n                    <p>The blockquote element represents content that is quoted from another source, optionally with a\r\n                        citation which must be within a footer or cite element.</p>\r\n                    <footer>Someone famous in <cite><a href=\"#\">Source Title</a></cite></footer>\r\n                </blockquote>\r\n\r\n                <div class=\"jl-grid-small\" jl-grid>\r\n                    <div>\r\n                        <a class=\"jl-button jl-button-text\" href=\"#\">Read more</a>\r\n                    </div>\r\n                    <div>\r\n                        <a class=\"jl-button jl-button-text\" href=\"#\">5 Comments</a>\r\n                    </div>\r\n                </div>\r\n\r\n            </article>\r\n\r\n            <hr class=\"jl-margin-medium\">\r\n\r\n            <ul class=\"jl-comment-list jl-margin-medium\">\r\n                <li>\r\n                    <article class=\"jl-comment jl-visible-toggle\" tabindex=\"-1\">\r\n                        <header class=\"jl-comment-header jl-position-relative\">\r\n                            <div class=\"jl-grid-medium jl-flex-middle\" jl-grid>\r\n                                <div class=\"jl-width-auto\">\r\n                                    <img class=\"jl-comment-avatar test-img-small\"\r\n                                        src=\"https://source.unsplash.com/random/50x50\" width=\"50\" height=\"50\" alt=\"\">\r\n                                </div>\r\n                                <div class=\"jl-width-expand\">\r\n                                    <h4 class=\"jl-comment-title jl-margin-remove\"><a class=\"jl-link-reset\"\r\n                                            href=\"#\">Author</a></h4>\r\n                                    <p class=\"jl-comment-meta jl-margin-remove-top\"><a class=\"jl-link-reset\" href=\"#\">12\r\n                                            days ago</a></p>\r\n                                </div>\r\n                            </div>\r\n                            <div class=\"jl-position-top-right jl-position-small jl-hidden-hover\"><a\r\n                                    class=\"jl-button jl-button-text\" href=\"#\">Reply</a></div>\r\n                        </header>\r\n                        <div class=\"jl-comment-body\">\r\n                            <p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor\r\n                                invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua.</p>\r\n                        </div>\r\n                    </article>\r\n                </li>\r\n            </ul>\r\n\r\n            <ul class=\"jl-pagination jl-flex-center\" jl-margin=\"\">\r\n                <li><a href=\"#\"><span jl-pagination-previous=\"\"\r\n                            class=\"jl-icon jl-pagination-previous\"></span></a></li>\r\n                <li><a href=\"#\">1</a></li>\r\n                <li class=\"jl-disabled\"><span>...</span></li>\r\n                <li><a href=\"#\">4</a></li>\r\n                <li><a href=\"#\">5</a></li>\r\n                <li><a href=\"#\">6</a></li>\r\n                <li class=\"jl-active\"><span>7</span></li>\r\n                <li><a href=\"#\">8</a></li>\r\n                <li><a href=\"#\">9</a></li>\r\n                <li><a href=\"#\">10</a></li>\r\n                <li class=\"jl-disabled\"><span>...</span></li>\r\n                <li><a href=\"#\">20</a></li>\r\n                <li><a href=\"#\"><span jl-pagination-next=\"\" class=\"jl-icon jl-pagination-next\"></span></a></li>\r\n            </ul>\r\n\r\n        </div>\r\n        <div class=\"jl-width-expand@m\">\r\n\r\n            <div class=\"jl-margin-medium-bottom\">\r\n                <form class=\"jl-search jl-search-default jl-width-1-1\">\r\n                    <span jl-search-icon class=\"jl-icon jl-search-icon\"></span>\r\n                    <input class=\"jl-search-input\" type=\"search\" placeholder=\"Search...\">\r\n                </form>\r\n            </div>\r\n\r\n            <ul class=\"jl-nav-default jl-nav-parent-icon jl-margin-medium jl-nav\" jl-nav>\r\n                <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                <li class=\"jl-parent\">\r\n                    <a href=\"#\">Parent <span jl-nav-parent-icon></span></a>\r\n                    <ul class=\"jl-nav-sub\" hidden aria-hidden=\"true\">\r\n                        <li><a href=\"#\">Sub item</a></li>\r\n                        <li><a href=\"#\">Sub item</a>\r\n                            <ul>\r\n                                <li><a href=\"#\">Sub item</a></li>\r\n                                <li><a href=\"#\">Sub item</a></li>\r\n                            </ul>\r\n                        </li>\r\n                    </ul>\r\n                </li>\r\n                <li class=\"jl-parent\">\r\n                    <a href=\"#\">Parent <span jl-nav-parent-icon></span></a>\r\n                    <ul class=\"jl-nav-sub\" hidden aria-hidden=\"true\">\r\n                        <li><a href=\"#\">Sub item</a></li>\r\n                        <li><a href=\"#\">Sub item</a></li>\r\n                    </ul>\r\n                </li>\r\n                <li class=\"jl-nav-header\">Header</li>\r\n                    <li><a href=\"#\"><span class=\"jl-margin-small-right jl-icon\" jl-icon=\"icon: table\"><svg width=\"20\" height=\"20\" viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\"><rect x=\"1\" y=\"3\" width=\"18\" height=\"1\"></rect><rect x=\"1\" y=\"7\" width=\"18\" height=\"1\"></rect><rect x=\"1\" y=\"11\" width=\"18\" height=\"1\"></rect><rect x=\"1\" y=\"15\" width=\"18\" height=\"1\"></rect></svg></span> Item</a></li>\r\n                    <li><a href=\"#\"><span class=\"jl-margin-small-right jl-icon\" jl-icon=\"icon: thumbnails\"><svg width=\"20\" height=\"20\" viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\"><rect fill=\"none\" stroke=\"#000\" x=\"3.5\" y=\"3.5\" width=\"5\" height=\"5\"></rect><rect fill=\"none\" stroke=\"#000\" x=\"11.5\" y=\"3.5\" width=\"5\" height=\"5\"></rect><rect fill=\"none\" stroke=\"#000\" x=\"11.5\" y=\"11.5\" width=\"5\" height=\"5\"></rect><rect fill=\"none\" stroke=\"#000\" x=\"3.5\" y=\"11.5\" width=\"5\" height=\"5\"></rect></svg></span> Item</a></li>\r\n                    <li class=\"jl-nav-divider\"></li>\r\n                    <li><a href=\"#\"><span class=\"jl-margin-small-right jl-icon\" jl-icon=\"icon: trash\"><svg width=\"20\" height=\"20\" viewBox=\"0 0 20 20\" xmlns=\"http://www.w3.org/2000/svg\"><polyline fill=\"none\" stroke=\"#000\" points=\"6.5 3 6.5 1.5 13.5 1.5 13.5 3\"></polyline><polyline fill=\"none\" stroke=\"#000\" points=\"4.5 4 4.5 18.5 15.5 18.5 15.5 4\"></polyline><rect x=\"8\" y=\"7\" width=\"1\" height=\"9\"></rect><rect x=\"11\" y=\"7\" width=\"1\" height=\"9\"></rect><rect x=\"2\" y=\"3\" width=\"16\" height=\"1\"></rect></svg></span> Item</a></li>\r\n                </ul>\r\n\r\n            <div class=\"jl-card jl-card-body jl-card-default jl-card-hover\">\r\n                <h3 class=\"jl-card-title\">Default</h3>\r\n                <p>Lorem ipsum <a href=\"#\">dolor</a> sit amet, consectetur adipiscing elit, sed do eiusmod tempor\r\n                    incididunt ut labore et dolore magna aliqua.</p>\r\n            </div>\r\n\r\n            <div class=\"jl-margin jl-card jl-card-body jl-card-primary jl-light jl-card-hover\">\r\n                <h3 class=\"jl-card-title\">Primary</h3>\r\n                <p>Lorem ipsum <a href=\"#\">dolor</a> sit amet, consectetur adipiscing elit, sed do eiusmod tempor\r\n                    incididunt ut labore et dolore magna aliqua.</p>\r\n            </div>\r\n\r\n            <div class=\"jl-margin jl-card jl-card-body jl-card-secondary jl-light jl-card-hover\">\r\n                <h3 class=\"jl-card-title\">Secondary</h3>\r\n                <p>Lorem ipsum <a href=\"#\">dolor</a> sit amet, consectetur adipiscing elit, sed do eiusmod tempor\r\n                    incididunt ut labore et dolore magna aliqua.</p>\r\n            </div>\r\n\r\n            <div class=\"jl-margin jl-card jl-card-body jl-card-hover\">\r\n                <h3 class=\"jl-card-title\">Hover</h3>\r\n                <p>Lorem ipsum <a href=\"#\">dolor</a> sit amet, consectetur adipiscing elit, sed do eiusmod tempor\r\n                    incididunt ut labore et dolore magna aliqua.</p>\r\n            </div>\r\n\r\n        </div>\r\n    </div>\r\n\r\n<hr class=\"jl-margin-large\">\r\n\r\n<div class=\"jl-grid-divider\" jl-grid>\r\n    <div class=\"jl-width-2-3@m\">\r\n\r\n        <h1 class=\"jl-heading-2xlarge jl-margin-small\">2X-Large</h1>\r\n        <h1 class=\"jl-heading-xlarge jl-margin-small\">X-Large</h1>\r\n        <h1 class=\"jl-heading-large jl-margin-small\">Heading L</h1>\r\n        <h1 class=\"jl-heading-medium jl-margin-small\">Heading M</h1>\r\n        <h1 class=\"jl-heading-small jl-margin-small\">Heading S</h1>\r\n\r\n        <h1 class=\"jl-margin-small\">Heading H1</h1>\r\n        <h2 class=\"jl-margin-small\">Heading H2</h2>\r\n        <h3 class=\"jl-margin-small\">Heading H3</h3>\r\n        <h4 class=\"jl-margin-small\">Heading H4</h4>\r\n        <h5 class=\"jl-margin-small\">Heading H5</h5>\r\n        <h6 class=\"jl-margin-small\">Heading H6</h6>\r\n\r\n        <h3 class=\"jl-heading-divider\">Heading Divider</h3>\r\n        <h3 class=\"jl-heading-bullet\">Heading Bullet</h3>\r\n        <h3 class=\"jl-heading-line\"><span>Heading Line</span></h3>\r\n\r\n        <div class=\"jl-overflow-auto jl-margin-medium-top\">\r\n            <table class=\"jl-table jl-table-divider jl-table-hover jl-table-small\">\r\n                <thead>\r\n                    <tr>\r\n                        <th>Table Heading</th>\r\n                        <th>Table Heading</th>\r\n                        <th>Table Heading</th>\r\n                    </tr>\r\n                </thead>\r\n                <tbody>\r\n                    <tr>\r\n                        <td>Table Data</td>\r\n                        <td>Table Data</td>\r\n                        <td>Table Data</td>\r\n                    </tr>\r\n                    <tr>\r\n                        <td>Table Data</td>\r\n                        <td>Table Data</td>\r\n                        <td>Table Data</td>\r\n                    </tr>\r\n                    <tr>\r\n                        <td>Table Data</td>\r\n                        <td>Table Data</td>\r\n                        <td>Table Data</td>\r\n                    </tr>\r\n                    <tr>\r\n                        <td>Table Data</td>\r\n                        <td>Table Data</td>\r\n                        <td>Table Data</td>\r\n                    </tr>\r\n                </tbody>\r\n            </table>\r\n        </div>\r\n\r\n        <div class=\"jl-grid-small jl-child-width-auto jl-margin-medium-top\" jl-grid js-countdown>\r\n            <div>\r\n                <div class=\"jl-countdown-number jl-countdown-days\">365</div>\r\n            </div>\r\n            <div class=\"jl-countdown-separator\">:</div>\r\n            <div>\r\n                <div class=\"jl-countdown-number jl-countdown-hours\">18</div>\r\n            </div>\r\n            <div class=\"jl-countdown-separator\">:</div>\r\n            <div>\r\n                <div class=\"jl-countdown-number jl-countdown-minutes\">21</div>\r\n            </div>\r\n            <div class=\"jl-countdown-separator\">:</div>\r\n            <div>\r\n                <div class=\"jl-countdown-number jl-countdown-seconds\">05</div>\r\n            </div>\r\n        </div>\r\n\r\n\r\n    </div>\r\n    <div class=\"jl-width-1-3@m\">\r\n\r\n        <ul class=\"jl-nav jl-nav-default\">\r\n            <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n            <li class=\"jl-parent\">\r\n                <a href=\"#\">Parent</a>\r\n                <ul class=\"jl-nav-sub\">\r\n                    <li><a href=\"#\">Sub item</a></li>\r\n                    <li>\r\n                        <a href=\"#\">Sub item</a>\r\n                        <ul>\r\n                            <li><a href=\"#\">Sub item</a></li>\r\n                            <li><a href=\"#\">Sub item</a></li>\r\n                        </ul>\r\n                    </li>\r\n                </ul>\r\n            </li>\r\n            <li class=\"jl-nav-header\">Header</li>\r\n            <li><a href=\"#\">Item</a></li>\r\n            <li><a href=\"#\">Item</a></li>\r\n            <li class=\"jl-nav-divider\"></li>\r\n            <li><a href=\"#\">Item</a></li>\r\n        </ul>\r\n\r\n        <ul class=\"jl-nav jl-nav-primary jl-margin-medium\">\r\n            <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n            <li><a href=\"#\">Item</a></li>\r\n            <li><a href=\"#\">Item</a></li>\r\n            <li><a href=\"#\">Item</a></li>\r\n        </ul>\r\n\r\n        <ul class=\"jl-nav jl-nav-secondary jl-margin-medium\">\r\n            <li class=\"jl-active\"><a href=\"#\"><div>Active<div class=\"jl-nav-subtitle\">Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do.</div></div></a></li>\r\n            <li><a href=\"#\"><div>Item<div class=\"jl-nav-subtitle\">Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do.</div></div></a></li>\r\n            <li><a href=\"#\"><div>Item<div class=\"jl-nav-subtitle\">Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do.</div></div></a></li>\r\n            <li><a href=\"#\"><div>Item<div class=\"jl-nav-subtitle\">Subtitle lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do.</div></div></a></li>\r\n        </ul>\r\n\r\n        <div class=\"jl-margin-medium-top\" jl-alert>\r\n            <a href=\"#\" class=\"jl-alert-close\" jl-close></a>\r\n            <p>Default</p>\r\n        </div>\r\n\r\n        <div class=\"jl-alert-primary\" jl-alert>\r\n            <a href=\"#\" class=\"jl-alert-close\" jl-close></a>\r\n            <p>Primary</p>\r\n        </div>\r\n\r\n        <div class=\"jl-alert-success\" jl-alert>\r\n            <a href=\"#\" class=\"jl-alert-close\" jl-close></a>\r\n            <p>Success</p>\r\n        </div>\r\n\r\n        <div class=\"jl-alert-warning\" jl-alert>\r\n            <a href=\"#\" class=\"jl-alert-close\" jl-close></a>\r\n            <p>Warning</p>\r\n        </div>\r\n\r\n        <div class=\"jl-alert-danger jl-margin-remove-bottom\" jl-alert>\r\n            <a href=\"#\" class=\"jl-alert-close\" jl-close></a>\r\n            <p>Danger</p>\r\n        </div>\r\n\r\n    </div>\r\n</div>\r\n\r\n<hr class=\"jl-margin-medium\">\r\n\r\n    <div class=\"jl-child-width-1-2@s jl-child-width-expand@m\" jl-grid>\r\n        <div>\r\n            <div class=\"jl-inline\">\r\n                <img src=\"https://source.unsplash.com/random/800x600\" width=\"\" height=\"\" alt=\"\">\r\n                <a class=\"jl-position-absolute jl-transform-center jl-icon jl-marker\" style=\"left: 20%; top: 30%\"\r\n                    href=\"#\" jl-marker></a>\r\n                <a class=\"jl-position-absolute jl-transform-center jl-icon jl-marker\" style=\"left: 60%; top: 40%\"\r\n                    href=\"#\" jl-marker></a>\r\n                <a class=\"jl-position-absolute jl-transform-center jl-icon jl-marker\" style=\"left: 80%; top: 70%\"\r\n                    href=\"#\" jl-marker></a>\r\n            </div>\r\n        </div>\r\n        <div>\r\n\r\n            <div class=\"jl-inline-clip\">\r\n                <img src=\"https://source.unsplash.com/random/800x600\" width=\"\" height=\"\" alt=\"\">\r\n                <div class=\"jl-overlay jl-overlay-default jl-position-bottom\">\r\n                    <p>Default Lorem ipsum dolor sit amet, consectetur.</p>\r\n                </div>\r\n            </div>\r\n\r\n        </div>\r\n        <div>\r\n\r\n            <div class=\"jl-inline-clip\">\r\n                <img src=\"https://source.unsplash.com/random/800x600\" width=\"\" height=\"\" alt=\"\">\r\n                <div class=\"jl-overlay jl-overlay-primary jl-light jl-position-bottom\">\r\n                    <p>Primary Lorem ipsum dolor sit amet, consectetur.</p>\r\n                </div>\r\n            </div>\r\n\r\n        </div>\r\n        <div>\r\n\r\n            <div class=\"jl-inline\">\r\n                <img src=\"https://source.unsplash.com/random/800x600\" width=\"\" height=\"\" alt=\"\">\r\n                <div class=\"jl-position-center\">\r\n                    <span jl-overlay-icon=\"\" class=\"jl-icon jl-overlay-icon\"></span>\r\n                </div>\r\n            </div>\r\n\r\n        </div>\r\n    </div>\r\n\r\n    <hr class=\"jl-margin-medium\">\r\n\r\n    <div class=\"jl-grid-divider jl-child-width-auto@m\" jl-grid>\r\n        <div>\r\n\r\n            <ul class=\"jl-dotnav\">\r\n                <li class=\"jl-active\"><a href=\"#\">Item 1</a></li>\r\n                <li><a href=\"#\">Item 2</a></li>\r\n                <li><a href=\"#\">Item 3</a></li>\r\n                <li><a href=\"#\">Item 4</a></li>\r\n                <li><a href=\"#\">Item 5</a></li>\r\n                <li><a href=\"#\">Item 6</a></li>\r\n            </ul>\r\n\r\n        </div>\r\n        <div>\r\n\r\n            <a href=\"#\" jl-slidenav-previous=\"\" class=\"jl-icon jl-slidenav-previous jl-slidenav\"></a>\r\n            <a href=\"#\" jl-slidenav-next=\"\" class=\"jl-icon jl-slidenav-next jl-slidenav\"></a>\r\n\r\n        </div>\r\n        <div>\r\n\r\n            <ul class=\"jl-thumbnav\">\r\n                <li class=\"jl-active\"><a href=\"#\"><img src=\"https://source.unsplash.com/random/60x40\" width=\"60\"\r\n                            height=\"40\" alt=\"\"></a></li>\r\n                <li><a href=\"#\"><img src=\"https://source.unsplash.com/random/60x40\" width=\"60\" height=\"40\" alt=\"\"></a>\r\n                </li>\r\n                <li><a href=\"#\"><img src=\"https://source.unsplash.com/random/60x40\" width=\"60\" height=\"40\" alt=\"\"></a>\r\n                </li>\r\n            </ul>\r\n\r\n        </div>\r\n        <div>\r\n\r\n            <div class=\"jl-tooltip jl-tooltip-top-center jl-display-inline-block jl-margin-remove jl-position-relative\">\r\n                Tooltip</div>\r\n\r\n        </div>\r\n\r\n        <div>\r\n\r\n            <button type=\"button\" jl-close class=\"jl-icon jl-close\"></button>\r\n\r\n        </div>\r\n        <div>\r\n\r\n            <a href=\"#\" jl-totop=\"\" class=\"jl-icon jl-totop\"></a>\r\n\r\n        </div>\r\n    </div>\r\n\r\n    <hr class=\"jl-margin-medium\">\r\n\r\n    <div class=\"jl-grid-divider jl-child-width-expand@m\" jl-grid>\r\n        <div>\r\n\r\n            <ul class=\"jl-subnav jl-subnav-divider\" jl-margin=\"\">\r\n                <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                <li><a href=\"#\">Item</a></li>\r\n                <li class=\"jl-disabled\"><a>Disabled</a></li>\r\n            </ul>\r\n\r\n        </div>\r\n        <div>\r\n\r\n            <ul class=\"jl-subnav jl-subnav-pill\" jl-margin=\"\">\r\n                <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                <li><a href=\"#\">Item</a></li>\r\n                <li class=\"jl-disabled\"><a>Disabled</a></li>\r\n            </ul>\r\n\r\n        </div>\r\n        <div>\r\n\r\n            <ul jl-tab=\"\" class=\"jl-tab\">\r\n                <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                <li><a href=\"#\">Item</a></li>\r\n                <li class=\"jl-disabled\"><a>Disabled</a></li>\r\n            </ul>\r\n\r\n        </div>\r\n    </div>\r\n\r\n    <hr class=\"jl-margin-medium\">\r\n\r\n    <div class=\"jl-grid-divider jl-child-width-expand@m\" jl-grid>\r\n        <div>\r\n\r\n            <ul class=\"jl-list jl-list-bullet jl-margin-medium\">\r\n                <li>List item 1</li>\r\n                <li>List item 2</li>\r\n                <li>List item 3</li>\r\n            </ul>\r\n\r\n            <ul class=\"jl-list jl-list-striped\">\r\n                <li>List item 1</li>\r\n                <li>List item 2</li>\r\n                <li>List item 3</li>\r\n            </ul>\r\n\r\n        </div>\r\n        <div>\r\n\r\n            <ul class=\"jl-list jl-list-divider jl-margin-medium\">\r\n                <li>List item 1</li>\r\n                <li>List item 2</li>\r\n                <li>List item 3</li>\r\n            </ul>\r\n\r\n            <dl class=\"jl-description-list jl-description-list-divider\">\r\n                <dt>Description lists</dt>\r\n                <dd>A description text</dd>\r\n                <dt>Description lists</dt>\r\n                <dd>A description text</dd>\r\n            </dl>\r\n\r\n        </div>\r\n        <div>\r\n\r\n            <ul jl-accordion=\"\" class=\"jl-accordion\">\r\n                <li class=\"jl-open\">\r\n\r\n                    <a class=\"jl-accordion-title\" href=\"#\">Item 1</a>\r\n                    <div class=\"jl-accordion-content\" aria-hidden=\"false\">\r\n                        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut\r\n                            labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco.\r\n                        </p>\r\n                    </div>\r\n\r\n                </li>\r\n                <li>\r\n\r\n                    <a class=\"jl-accordion-title\" href=\"#\">Item 2</a>\r\n                    <div class=\"jl-accordion-content\" hidden aria-hidden=\"true\">\r\n                        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut\r\n                            labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco.\r\n                        </p>\r\n                    </div>\r\n\r\n                </li>\r\n                <li>\r\n\r\n                    <a class=\"jl-accordion-title\" href=\"#\">Item 3</a>\r\n                    <div class=\"jl-accordion-content\" hidden aria-hidden=\"true\">\r\n                        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut\r\n                            labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco.\r\n                        </p>\r\n                    </div>\r\n\r\n                </li>\r\n            </ul>\r\n\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<div class=\"jl-section jl-padding-remove-vertical\">\r\n    <div class=\"jl-child-width-1-2@s jl-child-width-1-4@l jl-grid-collapse jl-grid-match\" jl-grid>\r\n        <div>\r\n            <div class=\"jl-tile jl-tile-default\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod\r\n                tempor.</div>\r\n        </div>\r\n        <div>\r\n            <div class=\"jl-tile jl-tile-muted\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod\r\n                tempor.</div>\r\n        </div>\r\n        <div>\r\n            <div class=\"jl-tile jl-tile-primary jl-light\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed\r\n                do eiusmod\r\n                tempor.</div>\r\n        </div>\r\n        <div>\r\n            <div class=\"jl-tile jl-tile-secondary jl-light\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed\r\n                do\r\n                eiusmod tempor.</div>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<div class=\"jl-section\">\r\n    <div class=\"jl-grid-large jl-flex-middle\" jl-grid>\r\n        <div class=\"jl-width-expand@m\">\r\n            <p class=\"jl-text-large\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor.</p>\r\n        </div>\r\n        <div class=\"jl-width-auto@m\">\r\n            <a class=\"jl-button jl-button-default jl-button-large\" href=\"#\">Button</a>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<div class=\"jl-section jl-section-muted jl-padding\">\r\n\r\n    <div class=\"jl-grid-large jl-flex-middle\" jl-grid>\r\n        <div class=\"jl-width-expand@m\">\r\n            <p class=\"jl-text-large\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor.</p>\r\n        </div>\r\n        <div class=\"jl-width-auto@m\">\r\n            <a class=\"jl-button jl-button-default jl-button-large\" href=\"#\">Button</a>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<div class=\"jl-section jl-section-primary jl-padding jl-light\">\r\n\r\n    <div class=\"jl-grid-large jl-flex-middle\" jl-grid>\r\n        <div class=\"jl-width-expand@m\">\r\n            <p class=\"jl-text-large\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor.</p>\r\n        </div>\r\n        <div class=\"jl-width-auto@m\">\r\n            <a class=\"jl-button jl-button-default jl-button-large\" href=\"#\">Button</a>\r\n        </div>\r\n    </div>\r\n\r\n</div>\r\n\r\n<div class=\"jl-section jl-padding jl-light\">\r\n    <div class=\"jl-grid-large jl-flex-middle\" jl-grid>\r\n        <div class=\"jl-width-expand@m\">\r\n            <p class=\"jl-text-large\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor.</p>\r\n        </div>\r\n        <div class=\"jl-width-auto@m\">\r\n            <a class=\"jl-button jl-button-default jl-button-large\" href=\"#\">Button</a>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<div id=\"modal\" jl-modal class=\"jl-modal\">\r\n    <div class=\"jl-modal-dialog\">\r\n        <button class=\"jl-modal-close-default jl-icon jl-close\" type=\"button\" jl-close></button>\r\n        <div class=\"jl-modal-header\">\r\n            <h2 class=\"jl-modal-title\">Headline</h2>\r\n        </div>\r\n        <div class=\"jl-modal-body\">\r\n            <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et\r\n                dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip\r\n                ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu\r\n                fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia\r\n                deserunt mollit anim id est laborum.</p>\r\n        </div>\r\n        <div class=\"jl-modal-footer jl-text-right\">\r\n            <button class=\"jl-button jl-button-default jl-modal-close\" type=\"button\">Cancel</button>\r\n            <button class=\"jl-button jl-button-primary\" type=\"button\">Save</button>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n<div id=\"modal-search\" class=\"jl-modal-full jl-modal\" jl-modal>\r\n    <div class=\"jl-modal-dialog jl-flex jl-flex-center jl-flex-middle\" jl-height-viewport>\r\n\r\n        <button class=\"jl-modal-close-full jl-close-large jl-icon jl-close\" type=\"button\" jl-close></button>\r\n\r\n        <div>\r\n\r\n            <ul class=\"jl-nav-primary jl-nav-center jl-nav\" jl-nav>\r\n                <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n                <li><a href=\"#\">Item</a></li>\r\n                <li><a href=\"#\">Item</a></li>\r\n                <li><a href=\"#\">Item</a></li>\r\n            </ul>\r\n\r\n            <div class=\"jl-margin\">\r\n                <form class=\"jl-search jl-search-large\">\r\n                    <input class=\"jl-search-input jl-text-center\" type=\"search\" placeholder=\"Search...\">\r\n                </form>\r\n            </div>\r\n\r\n        </div>\r\n\r\n    </div>\r\n</div>\r\n\r\n<div id=\"offcanvas\" jl-offcanvas=\"flip: true; overlay: true\" class=\"jl-offcanvas\">\r\n    <div class=\"jl-offcanvas-bar\">\r\n\r\n        <button class=\"jl-offcanvas-close jl-icon jl-close\" type=\"button\" jl-close></button>\r\n\r\n        <ul class=\"jl-nav jl-nav-default\">\r\n            <li class=\"jl-active\"><a href=\"#\">Active</a></li>\r\n            <li class=\"jl-parent\">\r\n                <a href=\"#\">Parent</a>\r\n                <ul class=\"jl-nav-sub\">\r\n                    <li><a href=\"#\">Sub item</a></li>\r\n                    <li><a href=\"#\">Sub item</a></li>\r\n                </ul>\r\n            </li>\r\n            <li class=\"jl-nav-header\">Header</li>\r\n            <li><a href=\"#\"><span class=\"jl-margin-small-right jl-icon\" jl-icon=\"icon: table\"></span> Item</a></li>\r\n            <li><a href=\"#\"><span class=\"jl-margin-small-right jl-icon\" jl-icon=\"icon: thumbnails\"></span> Item</a></li>\r\n            <li class=\"jl-nav-divider\"></li>\r\n            <li><a href=\"#\"><span class=\"jl-margin-small-right jl-icon\" jl-icon=\"icon: trash\"></span> Item</a></li>\r\n        </ul>\r\n\r\n        <h3>Title</h3>\r\n\r\n        <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore\r\n            magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea\r\n            commodo consequat.</p>\r\n\r\n    </div>\r\n</div>\";s:4:\"body\";s:0:\"\";s:6:\"images\";s:173:\"{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}\";s:5:\"catid\";i:2;s:10:\"created_by\";i:957;s:16:\"created_by_alias\";s:0:\"\";s:8:\"modified\";s:19:\"2023-10-26 09:34:18\";s:11:\"modified_by\";i:957;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":86:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"0\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"1\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"0\";s:9:\"show_hits\";s:1:\"0\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"0\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"left\";s:14:\"float_fulltext\";s:4:\"left\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:1;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"0\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:11:\"display_num\";s:2:\"10\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:6:\"robots\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"rights\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:12:\"\0*\0separator\";s:1:\".\";}s:7:\"version\";i:4;s:8:\"ordering\";i:3;s:8:\"category\";s:13:\"Uncategorised\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:17:\"12:uikit-overview\";s:7:\"catslug\";s:15:\"2:uncategorised\";s:6:\"author\";s:5:\"admin\";s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2022-07-27 13:17:35\";i:10;N;i:11;s:70:\"index.php?option=com_content&view=article&id=12:uikit-overview&catid=2\";i:12;N;i:13;s:19:\"2022-07-27 13:17:35\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:9;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:5:\"admin\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:13:\"Uncategorised\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:16;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:7;}}}i:16;s:14:\"Uikit Overview\";i:17;i:3;i:18;s:47:\"index.php?option=com_content&view=article&id=12\";}'),
('24', 'index.php?option=com_content&view=article&id=13', 'index.php?option=com_content&view=article&id=13:header-layouts&catid=2', 'Header Layouts', ' Create a navigation bar that can be used for your main site navigation. The theme included JL Navbar particle with 10 predefined header layouts. Choose between 10 different header layouts and select one of the many navigation options to create the perfect header for your Joomla, WordPress or Grav website. Customize the header and navigation bar of your website can be found in the Base Outline → Navigation section of the theme. Check the live demo here. ', '2022-07-27 13:24:26', '0c9c5889b70ac2032855d64231617aa1', '1', '1', '1', '*', '2022-07-27 13:24:26', NULL, '2022-07-27 13:24:26', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:460:\" Create a navigation bar that can be used for your main site navigation. The theme included JL Navbar particle with 10 predefined header layouts. Choose between 10 different header layouts and select one of the many navigation options to create the perfect header for your Joomla, WordPress or Grav website. Customize the header and navigation bar of your website can be found in the Base Outline → Navigation section of the theme. Check the live demo here. \";i:3;a:25:{s:2:\"id\";i:13;s:5:\"alias\";s:14:\"header layouts\";s:7:\"summary\";s:558:\"<p>Create a navigation bar that can be used for your main site navigation. The theme included JL Navbar particle with 10 predefined header layouts. Choose between 10 different header layouts and select one of the many navigation options to create the perfect header for your Joomla, WordPress or Grav website.</p>\r\n<p>Customize the header and navigation bar of your website can be found in the Base Outline → Navigation section of the theme.</p>\r\n<p>Check the <a href=\"https://demo.joomlead.com/particles/index.php/particles/navbar\">live demo here</a>.</p>\";s:4:\"body\";s:0:\"\";s:6:\"images\";s:173:\"{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}\";s:5:\"catid\";i:2;s:10:\"created_by\";i:957;s:16:\"created_by_alias\";s:0:\"\";s:8:\"modified\";s:19:\"2022-07-27 13:24:26\";s:11:\"modified_by\";i:957;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":86:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"0\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"1\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"1\";s:9:\"show_hits\";s:1:\"1\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"0\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"left\";s:14:\"float_fulltext\";s:4:\"left\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:1;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"0\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:11:\"display_num\";s:2:\"10\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:6:\"robots\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"rights\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"version\";i:1;s:8:\"ordering\";i:0;s:8:\"category\";s:13:\"Uncategorised\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:17:\"13:header-layouts\";s:7:\"catslug\";s:15:\"2:uncategorised\";s:6:\"author\";s:5:\"admin\";s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2022-07-27 13:24:26\";i:10;N;i:11;s:70:\"index.php?option=com_content&view=article&id=13:header-layouts&catid=2\";i:12;N;i:13;s:19:\"2022-07-27 13:24:26\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:9;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:5:\"admin\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:13:\"Uncategorised\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:16;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:7;}}}i:16;s:14:\"Header Layouts\";i:17;i:3;i:18;s:47:\"index.php?option=com_content&view=article&id=13\";}'),
('25', 'index.php?option=com_content&view=article&id=14', 'index.php?option=com_content&view=article&id=14:variations&catid=2', 'Variations', ' Basic Box Variations Box 1 Lorem ipsum dolor sit amet, consecetur adipiscing elit donec sit amet nibh. Read More Box 2 Lorem ipsum dolor sit amet, consecetur adipiscing elit donec sit amet nibh. Read More Box 3 Lorem ipsum dolor sit amet, consecetur adipiscing elit donec sit amet nibh. Read More Box 4 Lorem ipsum dolor sit amet, consecetur adipiscing elit donec sit amet nibh. Read More Box 5 Lorem ipsum dolor sit amet, consecetur adipiscing elit donec sit amet nibh. Read More Box 6 Lorem ipsum dolor sit amet, consecetur adipiscing elit donec sit amet nibh. Read More Inverse (Custom card) Add the jl-light class to improve the visibility of objects on dark backgrounds in a light style. When using a dark style, add the jl-dark class to elements on a light background. Light Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Button Dark Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Button ', '2022-07-27 13:26:04', '46baac54297ba4b52ba36cb15b6d2d46', '1', '1', '1', '*', '2022-07-27 13:26:04', NULL, '2022-07-27 13:26:04', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:1049:\" Basic Box Variations Box 1 Lorem ipsum dolor sit amet, consecetur adipiscing elit donec sit amet nibh. Read More Box 2 Lorem ipsum dolor sit amet, consecetur adipiscing elit donec sit amet nibh. Read More Box 3 Lorem ipsum dolor sit amet, consecetur adipiscing elit donec sit amet nibh. Read More Box 4 Lorem ipsum dolor sit amet, consecetur adipiscing elit donec sit amet nibh. Read More Box 5 Lorem ipsum dolor sit amet, consecetur adipiscing elit donec sit amet nibh. Read More Box 6 Lorem ipsum dolor sit amet, consecetur adipiscing elit donec sit amet nibh. Read More Inverse (Custom card) Add the jl-light class to improve the visibility of objects on dark backgrounds in a light style. When using a dark style, add the jl-dark class to elements on a light background. Light Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Button Dark Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Button \";i:3;a:25:{s:2:\"id\";i:14;s:5:\"alias\";s:10:\"variations\";s:7:\"summary\";s:2939:\"<div class=\"center g-title-large\">\r\n<h2 class=\"g-title\">Basic Box Variations</h2>\r\n</div>\r\n<div class=\"g-grid\">\r\n<div class=\"g-block box1 size-33-3\">\r\n<div class=\"g-content\">\r\n<h3 class=\"g-title\">Box 1</h3>\r\n<p>Lorem <strong>ipsum dolor</strong> sit amet, <a>consecetur</a> adipiscing elit <em>donec sit</em> amet nibh.</p>\r\n<a class=\"jl-button jl-button-primary\">Read More</a></div>\r\n</div>\r\n<div class=\"g-block box2 size-33-3\">\r\n<div class=\"g-content\">\r\n<h3 class=\"g-title\">Box 2</h3>\r\n<p>Lorem <strong>ipsum dolor</strong> sit amet, <a>consecetur</a> adipiscing elit <em>donec sit</em> amet nibh.</p>\r\n<a class=\"jl-button jl-button-secondary\">Read More</a></div>\r\n</div>\r\n<div class=\"g-block box3 size-33-3\">\r\n<div class=\"g-content\">\r\n<h3 class=\"g-title\">Box 3</h3>\r\n<p>Lorem <strong>ipsum dolor</strong> sit amet, <a>consecetur</a> adipiscing elit <em>donec sit</em> amet nibh.</p>\r\n<a class=\"jl-button jl-button-default\">Read More</a></div>\r\n</div>\r\n</div>\r\n<div class=\"g-grid\">\r\n<div class=\"g-block box4 size-33-3\">\r\n<div class=\"g-content\">\r\n<h3 class=\"g-title\">Box 4</h3>\r\n<p>Lorem <strong>ipsum dolor</strong> sit amet, <a>consecetur</a> adipiscing elit <em>donec sit</em> amet nibh.</p>\r\n<a class=\"jl-button jl-button-primary\">Read More</a></div>\r\n</div>\r\n<div class=\"g-block box5 size-33-3\">\r\n<div class=\"g-content\">\r\n<h3 class=\"g-title\">Box 5</h3>\r\n<p>Lorem <strong>ipsum dolor</strong> sit amet, <a>consecetur</a> adipiscing elit <em>donec sit</em> amet nibh.</p>\r\n<a class=\"jl-button jl-button-default\">Read More</a></div>\r\n</div>\r\n<div class=\"g-block box6 size-33-3\">\r\n<div class=\"g-content\">\r\n<h3 class=\"g-title\">Box 6</h3>\r\n<p>Lorem <strong>ipsum dolor</strong> sit amet, <a>consecetur</a> adipiscing elit <em>donec sit</em> amet nibh.</p>\r\n<a class=\"jl-button jl-button-default\">Read More</a></div>\r\n</div>\r\n</div>\r\n<hr class=\"jl-margin-large\" />\r\n<div class=\"center g-title-large\">\r\n<h2 class=\"g-title\">Inverse (Custom card)</h2>\r\n<p>Add the <code>jl-light</code> class to improve the visibility of objects on dark backgrounds in a light style. When using a dark style, add the <code>jl-dark</code> class to elements on a light background.</p>\r\n</div>\r\n<div class=\"g-grid\">\r\n<div class=\"g-block title-grey size-50\">\r\n<div class=\"g-content\">\r\n<div class=\"jl-light jl-background-secondary jl-padding\">\r\n<h3>Light</h3>\r\n<p>Lorem ipsum <a href=\"#\">dolor</a> sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\r\n<button class=\"jl-button jl-button-default\">Button</button></div>\r\n</div>\r\n</div>\r\n<div class=\"g-block title-pink size-50\">\r\n<div class=\"g-content\">\r\n<div class=\"jl-dark jl-background-muted jl-padding\">\r\n<h3>Dark</h3>\r\n<p>Lorem ipsum <a href=\"#\">dolor</a> sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\r\n<button class=\"jl-button jl-button-default\">Button</button></div>\r\n</div>\r\n</div>\r\n</div>\";s:4:\"body\";s:0:\"\";s:6:\"images\";s:173:\"{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}\";s:5:\"catid\";i:2;s:10:\"created_by\";i:957;s:16:\"created_by_alias\";s:0:\"\";s:8:\"modified\";s:19:\"2022-07-27 13:26:04\";s:11:\"modified_by\";i:957;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":86:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"0\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"1\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"1\";s:9:\"show_hits\";s:1:\"1\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"0\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"left\";s:14:\"float_fulltext\";s:4:\"left\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:1;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"0\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:11:\"display_num\";s:2:\"10\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:6:\"robots\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"rights\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"version\";i:1;s:8:\"ordering\";i:0;s:8:\"category\";s:13:\"Uncategorised\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:13:\"14:variations\";s:7:\"catslug\";s:15:\"2:uncategorised\";s:6:\"author\";s:5:\"admin\";s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2022-07-27 13:26:04\";i:10;N;i:11;s:66:\"index.php?option=com_content&view=article&id=14:variations&catid=2\";i:12;N;i:13;s:19:\"2022-07-27 13:26:04\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:9;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:5:\"admin\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:13:\"Uncategorised\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:16;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:7;}}}i:16;s:10:\"Variations\";i:17;i:3;i:18;s:47:\"index.php?option=com_content&view=article&id=14\";}'),
('26', 'index.php?option=com_content&view=article&id=10', 'index.php?option=com_content&view=article&id=10:new-feature-workflows&catid=9', 'New feature: Workflows', ' Workflows manage the stages your articles must go through until they are published. The component to manage workflows is not enabled by default. To see the workflow that we have provided with the sample data, you first need to enable this functionality. Access the administration area From \'Content\' > \'Articles\' > \'Options\' > \'Integration\' tab set \'Enable workflow\' to \'Yes\' Save changes Now when you access \'Content\' again you will see the section \'Workflows\'. When you edit an article you will also see the new transitions for articles related to workflows. ', '2022-07-27 13:29:42', '647357372f3201ee28febcbfe45a51e3', '1', '1', '1', '*', '2022-07-26 13:57:30', NULL, '2022-07-26 13:57:30', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:562:\" Workflows manage the stages your articles must go through until they are published. The component to manage workflows is not enabled by default. To see the workflow that we have provided with the sample data, you first need to enable this functionality. Access the administration area From \'Content\' > \'Articles\' > \'Options\' > \'Integration\' tab set \'Enable workflow\' to \'Yes\' Save changes Now when you access \'Content\' again you will see the section \'Workflows\'. When you edit an article you will also see the new transitions for articles related to workflows. \";i:3;a:25:{s:2:\"id\";i:10;s:5:\"alias\";s:21:\"new feature workflows\";s:7:\"summary\";s:651:\"<p>Workflows manage the stages your articles must go through until they are published.</p>\r\n<p>The component to manage workflows is not enabled by default.</p>\r\n<p>To see the workflow that we have provided with the sample data, you first need to enable this functionality.</p>\r\n<ol>\r\n<li>Access the administration area</li>\r\n<li>From \'Content\' &gt; \'Articles\' &gt; \'Options\' &gt; \'Integration\' tab set \'Enable workflow\' to \'Yes\'</li>\r\n<li>Save changes</li>\r\n</ol>\r\n<p>Now when you access \'Content\' again you will see the section \'Workflows\'.</p>\r\n<p>When you edit an article you will also see the new transitions for articles related to workflows.</p>\";s:4:\"body\";s:0:\"\";s:6:\"images\";s:347:\"{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/sampledata\\/cassiopeia\\/nasa4-400.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/cassiopeia\\/nasa4-400.jpg?width=400&height=400\",\"image_fulltext_alt\":\"\",\"image_fulltext_alt_empty\":\"1\",\"float_fulltext\":\"float-end\",\"image_fulltext_caption\":\"\"}\";s:5:\"catid\";i:9;s:10:\"created_by\";i:957;s:16:\"created_by_alias\";s:6:\"Joomla\";s:8:\"modified\";s:19:\"2022-07-27 13:29:42\";s:11:\"modified_by\";i:957;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":86:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"0\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"1\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"0\";s:9:\"show_hits\";s:1:\"0\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"0\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"left\";s:14:\"float_fulltext\";s:4:\"left\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:1;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"0\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:11:\"display_num\";s:2:\"10\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:6:\"robots\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"rights\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"version\";i:2;s:8:\"ordering\";i:0;s:8:\"category\";s:4:\"Help\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:24:\"10:new-feature-workflows\";s:7:\"catslug\";s:6:\"9:help\";s:6:\"author\";s:5:\"admin\";s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2022-07-26 13:57:30\";i:10;N;i:11;s:77:\"index.php?option=com_content&view=article&id=10:new-feature-workflows&catid=9\";i:12;N;i:13;s:19:\"2022-07-26 13:57:30\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:9;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:6:\"Joomla\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:10;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:4:\"Help\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:12;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:7;}}}i:16;s:22:\"New feature: Workflows\";i:17;i:3;i:18;s:47:\"index.php?option=com_content&view=article&id=10\";}'),
('36', 'index.php?option=com_content&view=article&id=4', 'index.php?option=com_content&view=article&id=4:about-your-home-page&catid=8', 'About your home page', ' Your home page is set to display the content like slideshow, image, text, blog content and so on using Gantry layout manager. The Layout Manager in the Gantry-based theme administration interface provides several options for setting up the layout of the theme\'s Outlines. You can change the content by editing the Home Layout settings in the Layout manager in your site template administrator. Go to System -> Site Template Styles -> here you can see the Home layout style, i.e Veno Pro - Home (Template Name - Layout Name). The layout(Home in this case) consists of several different sections, particles, each with its own set of settings that enable you to customize the behavior and look of your site on the front end. You can find out all about Layout documentation in Gantry5 Layout Manager Guide. ', '2022-07-27 13:53:07', '8de9c36c96934107babafc239a10981e', '1', '1', '1', '*', '2022-07-26 13:57:30', NULL, '2022-07-26 13:57:30', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:804:\" Your home page is set to display the content like slideshow, image, text, blog content and so on using Gantry layout manager. The Layout Manager in the Gantry-based theme administration interface provides several options for setting up the layout of the theme\'s Outlines. You can change the content by editing the Home Layout settings in the Layout manager in your site template administrator. Go to System -> Site Template Styles -> here you can see the Home layout style, i.e Veno Pro - Home (Template Name - Layout Name). The layout(Home in this case) consists of several different sections, particles, each with its own set of settings that enable you to customize the behavior and look of your site on the front end. You can find out all about Layout documentation in Gantry5 Layout Manager Guide. \";i:3;a:27:{s:2:\"id\";i:4;s:5:\"alias\";s:20:\"about your home page\";s:7:\"summary\";s:960:\"<p>Your home page is set to display the content like slideshow, image, text, blog content and so on using Gantry layout manager. The Layout Manager in the Gantry-based theme administration interface provides several options for setting up the layout of the theme\'s Outlines.</p>\r\n<p>You can change the content by editing the Home Layout settings in the Layout manager in your site template administrator. Go to System -&gt; Site Template Styles -&gt; here you can see the <strong>Home</strong> layout style, i.e Veno Pro - Home (Template Name - Layout Name).</p>\r\n<p>The layout(Home in this case) consists of several different sections, particles, each with its own set of settings that enable you to customize the behavior and look of your site on the front end.</p>\r\n<p>You can find out all about Layout documentation in Gantry5 <a href=\"https://docs.gantry.org/gantry5/configure/layout-manager\" target=\"_blank\" rel=\"noopener\">Layout Manager</a> Guide.</p>\r\n\";s:4:\"body\";s:984:\"\r\n<p>Gantry 5 is the latest generation of a powerful, flexible open source theming framework currently available for Joomla, WordPress, and Grav. One of the primary goals behind Gantry 5\'s development has been to make it easier for non-developers to get a lot more done without ever having to open a single code editor or directly alter any files. Gantry 5 is really easy to use. It has drag-and-drop functionality that enables you to dramatically change the layout of your site in seconds without ever having to even touch your keyboard. Explore all the Gantry 5 features <a href=\"https://docs.gantry.org/\" target=\"_blank\" rel=\"noopener\">here</a>.</p>\r\n<h4>Gantry 5 particles</h4>\r\n<p>Discover Gantry 5\'s core Particles, and how they work within the Layout Manager to make creating your site\'s Layout quick and easy.</p>\r\n<p>On the full page you will see both the introductory content and the rest of the article. You can change the settings to hide the introduction if you want.</p>\";s:6:\"images\";s:532:\"{\"image_intro\":\"images\\/sampledata\\/cassiopeia\\/nasa2-1200.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/cassiopeia\\/nasa2-1200.jpg?width=1200&height=400\",\"image_intro_alt\":\"\",\"image_intro_alt_empty\":\"1\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/sampledata\\/cassiopeia\\/nasa2-400.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/cassiopeia\\/nasa2-400.jpg?width=400&height=400\",\"image_fulltext_alt\":\"\",\"image_fulltext_alt_empty\":\"1\",\"float_fulltext\":\"jl-float-left jl-margin-right\",\"image_fulltext_caption\":\"\"}\";s:5:\"catid\";i:8;s:10:\"created_by\";i:957;s:16:\"created_by_alias\";s:6:\"Joomla\";s:8:\"modified\";s:19:\"2022-07-27 13:53:07\";s:11:\"modified_by\";i:957;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":86:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"0\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"1\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"0\";s:9:\"show_hits\";s:1:\"0\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"0\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"left\";s:14:\"float_fulltext\";s:4:\"left\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:1;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"0\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:11:\"display_num\";s:2:\"10\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:6:\"robots\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"rights\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"version\";i:12;s:8:\"ordering\";i:2;s:8:\"category\";s:4:\"Blog\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:22:\"4:about-your-home-page\";s:7:\"catslug\";s:6:\"8:blog\";s:6:\"author\";s:5:\"admin\";s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:8:\"imageUrl\";s:129:\"images/sampledata/cassiopeia/nasa2-1200.jpg#joomlaImage://local-images/sampledata/cassiopeia/nasa2-1200.jpg?width=1200&height=400\";s:8:\"imageAlt\";s:0:\"\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2022-07-26 13:57:30\";i:10;N;i:11;s:75:\"index.php?option=com_content&view=article&id=4:about-your-home-page&catid=8\";i:12;N;i:13;s:19:\"2022-07-26 13:57:30\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:9;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:6:\"Joomla\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:10;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:4:\"Blog\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:13;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:7;}}}i:16;s:20:\"About your home page\";i:17;i:3;i:18;s:46:\"index.php?option=com_content&view=article&id=4\";}'),
('38', 'index.php?option=com_contact&view=contact&id=1', 'index.php?option=com_contact&view=contact&id=1:contact-us&catid=4:uncategorised', 'Contact us', '', '2022-07-27 13:56:50', 'f6a3aacea47045379aaec9f744103538', '1', '1', '1', '*', NULL, NULL, '2022-07-27 13:54:16', NULL, '0', '0', '2', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:0:\"\";i:3;a:33:{s:2:\"id\";i:1;s:5:\"alias\";s:10:\"contact us\";s:8:\"position\";s:0:\"\";s:7:\"address\";s:0:\"\";s:16:\"created_by_alias\";s:0:\"\";s:8:\"modified\";s:19:\"2022-07-27 13:56:50\";s:11:\"modified_by\";i:957;s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";s:25:\"{\"robots\":\"\",\"rights\":\"\"}\";s:9:\"sortname1\";s:0:\"\";s:9:\"sortname2\";s:0:\"\";s:9:\"sortname3\";s:0:\"\";s:4:\"city\";s:0:\"\";s:6:\"region\";s:0:\"\";s:7:\"country\";s:0:\"\";s:3:\"zip\";s:0:\"\";s:9:\"telephone\";s:0:\"\";s:3:\"fax\";s:0:\"\";s:7:\"summary\";s:0:\"\";s:5:\"email\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:7:\"webpage\";s:0:\"\";s:8:\"ordering\";i:1;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":40:{s:21:\"show_contact_category\";s:0:\"\";s:17:\"show_contact_list\";s:0:\"\";s:9:\"show_tags\";s:0:\"\";s:9:\"show_info\";s:0:\"\";s:9:\"show_name\";s:0:\"\";s:13:\"show_position\";s:0:\"\";s:10:\"show_email\";s:0:\"\";s:15:\"add_mailto_link\";s:0:\"\";s:19:\"show_street_address\";s:0:\"\";s:11:\"show_suburb\";s:0:\"\";s:10:\"show_state\";s:0:\"\";s:13:\"show_postcode\";s:0:\"\";s:12:\"show_country\";s:0:\"\";s:14:\"show_telephone\";s:0:\"\";s:11:\"show_mobile\";s:0:\"\";s:8:\"show_fax\";s:0:\"\";s:12:\"show_webpage\";s:0:\"\";s:10:\"show_image\";s:0:\"\";s:9:\"show_misc\";s:0:\"\";s:11:\"allow_vcard\";s:0:\"\";s:13:\"show_articles\";s:0:\"\";s:20:\"articles_display_num\";s:0:\"\";s:12:\"show_profile\";s:0:\"\";s:14:\"contact_layout\";s:0:\"\";s:10:\"show_links\";s:0:\"\";s:10:\"linka_name\";s:0:\"\";s:5:\"linka\";s:0:\"\";s:10:\"linkb_name\";s:0:\"\";s:5:\"linkb\";s:0:\"\";s:10:\"linkc_name\";s:0:\"\";s:5:\"linkc\";s:0:\"\";s:10:\"linkd_name\";s:0:\"\";s:5:\"linkd\";s:0:\"\";s:10:\"linke_name\";s:0:\"\";s:5:\"linke\";s:0:\"\";s:15:\"show_email_form\";s:0:\"\";s:15:\"show_email_copy\";s:0:\"\";s:16:\"validate_session\";s:0:\"\";s:12:\"custom_reply\";s:0:\"\";s:8:\"redirect\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:5:\"catid\";i:4;s:8:\"category\";s:13:\"Uncategorised\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:12:\"1:contact-us\";s:7:\"catslug\";s:15:\"4:uncategorised\";s:4:\"name\";s:5:\"admin\";s:6:\"layout\";s:7:\"contact\";}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:15:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:8:\"position\";i:4;s:7:\"address\";i:5;s:4:\"city\";i:6;s:6:\"region\";i:7;s:7:\"country\";i:8;s:3:\"zip\";i:9;s:9:\"telephone\";i:10;s:3:\"fax\";i:11;s:5:\"email\";i:12;s:6:\"mobile\";i:13;s:7:\"webpage\";i:14;s:4:\"user\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;N;i:10;N;i:11;s:79:\"index.php?option=com_contact&view=contact&id=1:contact-us&catid=4:uncategorised\";i:12;N;i:13;s:19:\"2022-07-27 13:54:16\";i:14;i:1;i:15;a:3:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Contact\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:17;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:13:\"Uncategorised\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:16;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:7;}}}i:16;s:10:\"Contact us\";i:17;i:2;i:18;s:46:\"index.php?option=com_contact&view=contact&id=1\";}'),
('42', 'index.php?option=com_content&view=article&id=15', 'index.php?option=com_content&view=article&id=15:offline-page&catid=2', 'Offline Page', ' There may be occasions when you will make your website completely unavailable to visitors for a short time. There is a simple switch in the Gantry 5 platform settings that enables you to take your website offline very quickly. It can be returned to service at a later time just as easily. ', '2022-07-28 00:25:37', 'b4e3bb695105925e0950e0282ef8c133', '1', '1', '1', '*', '2022-07-28 00:21:48', NULL, '2022-07-28 00:21:48', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:290:\" There may be occasions when you will make your website completely unavailable to visitors for a short time. There is a simple switch in the Gantry 5 platform settings that enables you to take your website offline very quickly. It can be returned to service at a later time just as easily. \";i:3;a:25:{s:2:\"id\";i:15;s:5:\"alias\";s:12:\"offline page\";s:7:\"summary\";s:432:\"<p>There may be occasions when you will make your website completely unavailable to visitors for a short time. There is a simple switch in the Gantry 5 platform settings that enables you to take your website offline very quickly. It can be returned to service at a later time just as easily.</p>\r\n<p><img class=\"jl-box-shadow-small\" src=\"images/sampledata/offline.png\" alt=\"Gantry 5 Offline Layout\" width=\"1920\" height=\"1236\" /></p>\";s:4:\"body\";s:0:\"\";s:6:\"images\";s:173:\"{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}\";s:5:\"catid\";i:2;s:10:\"created_by\";i:957;s:16:\"created_by_alias\";s:0:\"\";s:8:\"modified\";s:19:\"2022-07-28 00:25:37\";s:11:\"modified_by\";i:957;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":86:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"0\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"1\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"0\";s:9:\"show_hits\";s:1:\"0\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"0\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"left\";s:14:\"float_fulltext\";s:4:\"left\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:1;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"0\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:11:\"display_num\";s:2:\"10\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:6:\"robots\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"rights\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"version\";i:4;s:8:\"ordering\";i:0;s:8:\"category\";s:13:\"Uncategorised\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:15:\"15:offline-page\";s:7:\"catslug\";s:15:\"2:uncategorised\";s:6:\"author\";s:5:\"admin\";s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2022-07-28 00:21:48\";i:10;N;i:11;s:68:\"index.php?option=com_content&view=article&id=15:offline-page&catid=2\";i:12;N;i:13;s:19:\"2022-07-28 00:21:48\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:9;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:5:\"admin\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:5;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:13:\"Uncategorised\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:16;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:7;}}}i:16;s:12:\"Offline Page\";i:17;i:3;i:18;s:47:\"index.php?option=com_content&view=article&id=15\";}'),
('44', 'index.php?option=com_content&view=article&id=5', 'index.php?option=com_content&view=article&id=5:your-modules&catid=8', 'Your Modules', ' Your site has some commonly used modules already preconfigured. These include: Image (type: Custom), which holds the image beneath the menu. This is a Custom module that you can edit to change the image. Popular Tags (type: Tags - Popular), which will appear if you use tagging on your articles. Enter a tag in the Tags field when editing. Older Posts (type: Articles - Category), which lists out articles by categories. Syndication (type: Syndication Feeds), which allows your readers to read your posts in a news reader. Login Form (type: Login), which allows your users to access restricted areas of the website. Each of these modules has many options which you can experiment with in the Module Manager in your site Administrator. When you are logged in you can also select the edit icon in the top right corner which will take you to an edit screen for that module. Always be sure to save and close any module you edit. Joomla! also includes many other modules you can incorporate in your site. As you develop your site you may want to add more modules that you can find at the Joomla Extensions Directory. ', '2022-08-14 22:50:06', '6f006be3ab1b74adba6fb72e23a89de5', '1', '1', '1', '*', '2022-07-26 13:57:30', NULL, '2022-07-26 13:57:30', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:1113:\" Your site has some commonly used modules already preconfigured. These include: Image (type: Custom), which holds the image beneath the menu. This is a Custom module that you can edit to change the image. Popular Tags (type: Tags - Popular), which will appear if you use tagging on your articles. Enter a tag in the Tags field when editing. Older Posts (type: Articles - Category), which lists out articles by categories. Syndication (type: Syndication Feeds), which allows your readers to read your posts in a news reader. Login Form (type: Login), which allows your users to access restricted areas of the website. Each of these modules has many options which you can experiment with in the Module Manager in your site Administrator. When you are logged in you can also select the edit icon in the top right corner which will take you to an edit screen for that module. Always be sure to save and close any module you edit. Joomla! also includes many other modules you can incorporate in your site. As you develop your site you may want to add more modules that you can find at the Joomla Extensions Directory. \";i:3;a:27:{s:2:\"id\";i:5;s:5:\"alias\";s:12:\"your modules\";s:7:\"summary\";s:1242:\"<p>Your site has some commonly used modules already preconfigured. These include:</p>\r\n<ul>\r\n<li>Image (type: Custom), which holds the image beneath the menu. This is a Custom module that you can edit to change the image.</li>\r\n<li>Popular Tags (type: Tags - Popular), which will appear if you use tagging on your articles. Enter a tag in the Tags field when editing.</li>\r\n<li>Older Posts (type: Articles - Category), which lists out articles by categories.</li>\r\n<li>Syndication (type: Syndication Feeds), which allows your readers to read your posts in a news reader.</li>\r\n<li>Login Form (type: Login), which allows your users to access restricted areas of the website.</li>\r\n</ul>\r\n<p>Each of these modules has many options which you can experiment with in the Module Manager in your site Administrator. When you are logged in you can also select the edit icon in the top right corner which will take you to an edit screen for that module. Always be sure to save and close any module you edit.</p>\r\n<p>Joomla! also includes many other modules you can incorporate in your site. As you develop your site you may want to add more modules that you can find at the <a href=\"https://extensions.joomla.org/\">Joomla Extensions Directory.</a></p>\";s:4:\"body\";s:0:\"\";s:6:\"images\";s:550:\"{\"image_intro\":\"images\\/sampledata\\/cassiopeia\\/nasa3-1200.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/cassiopeia\\/nasa3-1200.jpg?width=1200&height=400\",\"image_intro_alt\":\"\",\"image_intro_alt_empty\":\"1\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/sampledata\\/cassiopeia\\/nasa3-400.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/cassiopeia\\/nasa3-400.jpg?width=400&height=400\",\"image_fulltext_alt\":\"Crab Nebula\",\"float_fulltext\":\"jl-float-left jl-margin-right\",\"image_fulltext_caption\":\"www.nasa.gov\\/multimedia\\/imagegallery\"}\";s:5:\"catid\";i:8;s:10:\"created_by\";i:957;s:16:\"created_by_alias\";s:6:\"Joomla\";s:8:\"modified\";s:19:\"2022-08-14 22:50:06\";s:11:\"modified_by\";i:957;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":86:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"0\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"1\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"0\";s:9:\"show_hits\";s:1:\"0\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"0\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"left\";s:14:\"float_fulltext\";s:4:\"left\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:1;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"0\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:11:\"display_num\";s:2:\"10\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:6:\"robots\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"rights\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"version\";i:3;s:8:\"ordering\";i:1;s:8:\"category\";s:4:\"Blog\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:14:\"5:your-modules\";s:7:\"catslug\";s:6:\"8:blog\";s:6:\"author\";s:5:\"admin\";s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:8:\"imageUrl\";s:129:\"images/sampledata/cassiopeia/nasa3-1200.jpg#joomlaImage://local-images/sampledata/cassiopeia/nasa3-1200.jpg?width=1200&height=400\";s:8:\"imageAlt\";s:0:\"\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2022-07-26 13:57:30\";i:10;N;i:11;s:67:\"index.php?option=com_content&view=article&id=5:your-modules&catid=8\";i:12;N;i:13;s:19:\"2022-07-26 13:57:30\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:9;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:6:\"Joomla\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:10;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:4:\"Blog\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:13;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:7;}}}i:16;s:12:\"Your Modules\";i:17;i:3;i:18;s:46:\"index.php?option=com_content&view=article&id=5\";}'),
('45', 'index.php?option=com_content&view=article&id=3', 'index.php?option=com_content&view=article&id=3:welcome-to-your-blog&catid=8', 'Welcome to your blog', ' This is a sample blog posting. If you log in to the site (the Administrator Login link is on the very bottom of this page) you will be able to edit it and all of the other existing articles. You will also be able to create a new article and make other changes to the site. As you add and modify articles you will see how your site changes and also how you can customise it in various ways. Go ahead, you can\'t break it. ', '2022-08-14 22:50:25', '5f67a8e3bdf7a200654d4464cf5a7124', '1', '1', '1', '*', '2022-07-26 13:57:30', NULL, '2022-07-26 13:57:30', NULL, '0', '0', '3', 'O:52:\"Joomla\\Component\\Finder\\Administrator\\Indexer\\Result\":19:{i:0;i:1;i:1;s:5:\"en-GB\";i:2;s:421:\" This is a sample blog posting. If you log in to the site (the Administrator Login link is on the very bottom of this page) you will be able to edit it and all of the other existing articles. You will also be able to create a new article and make other changes to the site. As you add and modify articles you will see how your site changes and also how you can customise it in various ways. Go ahead, you can\'t break it. \";i:3;a:27:{s:2:\"id\";i:3;s:5:\"alias\";s:20:\"welcome to your blog\";s:7:\"summary\";s:450:\"<p>This is a sample blog posting.</p>\r\n<p>If you log in to the site (the Administrator Login link is on the very bottom of this page) you will be able to edit it and all of the other existing articles. You will also be able to create a new article and make other changes to the site.</p>\r\n<p>As you add and modify articles you will see how your site changes and also how you can customise it in various ways.</p>\r\n<p>Go ahead, you can\'t break it.</p>\";s:4:\"body\";s:0:\"\";s:6:\"images\";s:566:\"{\"image_intro\":\"images\\/sampledata\\/cassiopeia\\/nasa1-1200.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/cassiopeia\\/nasa1-1200.jpg?width=1200&height=400\",\"image_intro_alt\":\"Amazing Andromeda Galaxy\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/sampledata\\/cassiopeia\\/nasa1-400.jpg#joomlaImage:\\/\\/local-images\\/sampledata\\/cassiopeia\\/nasa1-400.jpg?width=400&height=400\",\"image_fulltext_alt\":\"\",\"image_fulltext_alt_empty\":\"1\",\"float_fulltext\":\"jl-float-left jl-margin-right\",\"image_fulltext_caption\":\"www.nasa.gov\\/multimedia\\/imagegallery\"}\";s:5:\"catid\";i:8;s:10:\"created_by\";i:957;s:16:\"created_by_alias\";s:6:\"Joomla\";s:8:\"modified\";s:19:\"2022-08-14 22:50:25\";s:11:\"modified_by\";i:957;s:6:\"params\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":86:{s:14:\"article_layout\";s:9:\"_:default\";s:10:\"show_title\";s:1:\"1\";s:11:\"link_titles\";s:1:\"1\";s:10:\"show_intro\";s:1:\"1\";s:19:\"info_block_position\";s:1:\"0\";s:21:\"info_block_show_title\";s:1:\"1\";s:13:\"show_category\";s:1:\"1\";s:13:\"link_category\";s:1:\"1\";s:20:\"show_parent_category\";s:1:\"0\";s:20:\"link_parent_category\";s:1:\"0\";s:17:\"show_associations\";s:1:\"0\";s:5:\"flags\";s:1:\"1\";s:11:\"show_author\";s:1:\"1\";s:11:\"link_author\";s:1:\"0\";s:16:\"show_create_date\";s:1:\"0\";s:16:\"show_modify_date\";s:1:\"0\";s:17:\"show_publish_date\";s:1:\"1\";s:20:\"show_item_navigation\";s:1:\"1\";s:13:\"show_readmore\";s:1:\"1\";s:19:\"show_readmore_title\";s:1:\"1\";s:14:\"readmore_limit\";i:100;s:9:\"show_tags\";s:1:\"1\";s:11:\"record_hits\";s:1:\"0\";s:9:\"show_hits\";s:1:\"0\";s:11:\"show_noauth\";s:1:\"0\";s:13:\"urls_position\";i:0;s:7:\"captcha\";s:0:\"\";s:23:\"show_publishing_options\";s:1:\"1\";s:20:\"show_article_options\";s:1:\"1\";s:27:\"show_configure_edit_options\";s:1:\"1\";s:16:\"show_permissions\";s:1:\"1\";s:22:\"show_associations_edit\";s:1:\"1\";s:12:\"save_history\";s:1:\"1\";s:13:\"history_limit\";i:10;s:25:\"show_urls_images_frontend\";s:1:\"0\";s:24:\"show_urls_images_backend\";s:1:\"1\";s:7:\"targeta\";i:0;s:7:\"targetb\";i:0;s:7:\"targetc\";i:0;s:11:\"float_intro\";s:4:\"left\";s:14:\"float_fulltext\";s:4:\"left\";s:15:\"category_layout\";s:6:\"_:blog\";s:19:\"show_category_title\";s:1:\"0\";s:16:\"show_description\";s:1:\"0\";s:22:\"show_description_image\";s:1:\"0\";s:8:\"maxLevel\";s:1:\"1\";s:21:\"show_empty_categories\";s:1:\"0\";s:16:\"show_no_articles\";s:1:\"1\";s:32:\"show_category_heading_title_text\";s:1:\"1\";s:16:\"show_subcat_desc\";s:1:\"1\";s:21:\"show_cat_num_articles\";s:1:\"0\";s:13:\"show_cat_tags\";s:1:\"1\";s:21:\"show_base_description\";s:1:\"1\";s:11:\"maxLevelcat\";s:2:\"-1\";s:25:\"show_empty_categories_cat\";s:1:\"0\";s:20:\"show_subcat_desc_cat\";s:1:\"1\";s:25:\"show_cat_num_articles_cat\";s:1:\"1\";s:20:\"num_leading_articles\";i:1;s:18:\"blog_class_leading\";s:0:\"\";s:18:\"num_intro_articles\";i:4;s:10:\"blog_class\";s:0:\"\";s:11:\"num_columns\";i:1;s:18:\"multi_column_order\";s:1:\"0\";s:9:\"num_links\";i:4;s:24:\"show_subcategory_content\";s:1:\"0\";s:16:\"link_intro_image\";s:1:\"0\";s:21:\"show_pagination_limit\";s:1:\"1\";s:12:\"filter_field\";s:4:\"hide\";s:13:\"show_headings\";s:1:\"1\";s:14:\"list_show_date\";s:1:\"0\";s:11:\"date_format\";s:0:\"\";s:14:\"list_show_hits\";s:1:\"1\";s:16:\"list_show_author\";s:1:\"1\";s:11:\"display_num\";s:2:\"10\";s:11:\"orderby_pri\";s:5:\"order\";s:11:\"orderby_sec\";s:5:\"rdate\";s:10:\"order_date\";s:9:\"published\";s:15:\"show_pagination\";s:1:\"2\";s:23:\"show_pagination_results\";s:1:\"1\";s:13:\"show_featured\";s:4:\"show\";s:14:\"show_feed_link\";s:1:\"1\";s:12:\"feed_summary\";s:1:\"0\";s:18:\"feed_show_readmore\";s:1:\"0\";s:7:\"sef_ids\";i:1;s:20:\"custom_fields_enable\";s:1:\"1\";s:16:\"workflow_enabled\";s:1:\"0\";}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"metakey\";s:0:\"\";s:8:\"metadesc\";s:0:\"\";s:8:\"metadata\";O:24:\"Joomla\\Registry\\Registry\":3:{s:7:\"\0*\0data\";O:8:\"stdClass\":3:{s:6:\"robots\";s:0:\"\";s:6:\"author\";s:0:\"\";s:6:\"rights\";s:0:\"\";}s:14:\"\0*\0initialized\";b:1;s:9:\"separator\";s:1:\".\";}s:7:\"version\";i:2;s:8:\"ordering\";i:3;s:8:\"category\";s:4:\"Blog\";s:9:\"cat_state\";i:1;s:10:\"cat_access\";i:1;s:4:\"slug\";s:22:\"3:welcome-to-your-blog\";s:7:\"catslug\";s:6:\"8:blog\";s:6:\"author\";s:5:\"admin\";s:6:\"layout\";s:7:\"article\";s:7:\"context\";s:19:\"com_content.article\";s:8:\"imageUrl\";s:129:\"images/sampledata/cassiopeia/nasa1-1200.jpg#joomlaImage://local-images/sampledata/cassiopeia/nasa1-1200.jpg?width=1200&height=400\";s:8:\"imageAlt\";s:24:\"Amazing Andromeda Galaxy\";s:10:\"metaauthor\";N;}i:4;N;i:5;a:5:{i:1;a:3:{i:0;s:5:\"title\";i:1;s:8:\"subtitle\";i:2;s:2:\"id\";}i:2;a:2:{i:0;s:7:\"summary\";i:1;s:4:\"body\";}i:3;a:8:{i:0;s:4:\"meta\";i:1;s:10:\"list_price\";i:2;s:10:\"sale_price\";i:3;s:7:\"metakey\";i:4;s:8:\"metadesc\";i:5;s:10:\"metaauthor\";i:6;s:6:\"author\";i:7;s:16:\"created_by_alias\";}i:4;a:2:{i:0;s:4:\"path\";i:1;s:5:\"alias\";}i:5;a:1:{i:0;s:8:\"comments\";}}i:6;s:1:\"*\";i:7;N;i:8;N;i:9;s:19:\"2022-07-26 13:57:30\";i:10;N;i:11;s:75:\"index.php?option=com_content&view=article&id=3:welcome-to-your-blog&catid=8\";i:12;N;i:13;s:19:\"2022-07-26 13:57:30\";i:14;i:1;i:15;a:4:{s:4:\"Type\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:7:\"Article\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:9;}}s:6:\"Author\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:6:\"Joomla\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:10;}}s:8:\"Category\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:4:\"Blog\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:1:\"*\";s:6:\"nested\";b:1;s:2:\"id\";i:13;}}s:8:\"Language\";a:1:{i:0;O:8:\"stdClass\":6:{s:5:\"title\";s:1:\"*\";s:5:\"state\";i:1;s:6:\"access\";i:1;s:8:\"language\";s:0:\"\";s:6:\"nested\";b:0;s:2:\"id\";i:7;}}}i:16;s:20:\"Welcome to your blog\";i:17;i:3;i:18;s:46:\"index.php?option=com_content&view=article&id=3\";}');/**ABDB**/
