<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Date\Date;

// Get module parameters
$formId = $params->get('form_id');

if (!$formId) {
    echo '<div class="alert alert-warning">Please configure the RSForm Form ID in the module settings.</div>';
    return;
}

// Get database instance
$db = Factory::getDbo();

// Get current date for month calculations
$currentDate = new Date();
$currentMonth = $currentDate->format('Y-m');
$lastMonth = $currentDate->sub(new DateInterval('P1M'))->format('Y-m');
$monthBeforeLast = $currentDate->sub(new DateInterval('P1M'))->format('Y-m');

// Query to fetch all submissions with additional fields
$query = $db->getQuery(true)
    ->select('s.SubmissionId, s.DateSubmitted, s.Username, sv.FieldName, sv.FieldValue')
    ->from($db->quoteName('#__rsform_submissions', 's'))
    ->join('LEFT', $db->quoteName('#__rsform_submission_values', 'sv') . ' ON ' . $db->quoteName('s.SubmissionId') . ' = ' . $db->quoteName('sv.SubmissionId'))
    ->where($db->quoteName('s.FormId') . ' = ' . $db->quote($formId))
    ->where($db->quoteName('sv.FieldName') . ' IN (' . $db->quote('Status') . ',' . $db->quote('Active_With_Lafab_Solutions') . ',' . $db->quote('Current_Package') . ',' . $db->quote('Maid_Rating') . ',' . $db->quote('Maid_Photo') . ',' . $db->quote('Documents') . ',' . $db->quote('{file_upload_0:path}') . ',' . $db->quote('{file_upload_1:path}') . ',' . $db->quote('{file_upload_2:path}') . ')');

$db->setQuery($query);
$rows = $db->loadObjectList();

// Organize submissions by SubmissionId
$submissions = [];
$submissionDates = [];
$submissionUsernames = [];

foreach ($rows as $row) {
    if (!isset($submissions[$row->SubmissionId])) {
        $submissions[$row->SubmissionId] = [];
        $submissionDates[$row->SubmissionId] = $row->DateSubmitted;
        $submissionUsernames[$row->SubmissionId] = $row->Username;
    }
    $submissions[$row->SubmissionId][$row->FieldName] = $row->FieldValue;
}

// Initialize metrics
$metrics = [
    // New Maid Count Metrics
    'total_maids_current_month' => 0,
    'total_maids_last_month' => 0,
    'total_maids_month_before_last' => 0,
    'total_maids_deployed' => 0,
    'total_maids_available' => 0,
    'total_maids_unavailable' => 0,

    // Team Member Metrics
    'maids_by_team_current_month' => [],
    'maids_by_team_last_month' => [],

    // Photo and Document Metrics
    'maids_photos_missing' => 0,
    'placed_maids_photos_missing' => 0,
    'placed_maids_documents_missing' => 0,
    'placed_maids_documents_1' => 0,
    'placed_maids_documents_2' => 0,
    'placed_maids_documents_3' => 0,

    // Existing Metrics to Keep
    'active_counts' => [
        'Yes' => 0,
        'No' => 0,
        'Once Worked with Lafab' => 0,
    ],
    'package_counts' => [
        'Silver Maids' => 0,
        'Platinum Maids' => 0,
        'Golden Maids' => 0,
        'Diamond Maids' => 0,
        'Professional Cook or Chef working at home' => 0,
        'Part-Time or Live-Out' => 0,
    ],
    'rating_counts' => [
        'Not Tested by Lafab Solutions' => 0,
        'Poor' => 0,
        'Fair' => 0,
        'Good' => 0,
        'Very Good' => 0,
        'Excellent' => 0,
    ],
];

// Process submissions
foreach ($submissions as $submissionId => $submission) {
    $submissionDate = $submissionDates[$submissionId];
    $username = $submissionUsernames[$submissionId];
    $submissionMonth = substr($submissionDate, 0, 7); // Get YYYY-MM
    
    // Count maids by month
    if ($submissionMonth === $currentMonth) {
        $metrics['total_maids_current_month']++;
        
        // Count by team member for current month using Username
        if (!empty($username)) {
            if (!isset($metrics['maids_by_team_current_month'][$username])) {
                $metrics['maids_by_team_current_month'][$username] = 0;
            }
            $metrics['maids_by_team_current_month'][$username]++;
        }
    } elseif ($submissionMonth === $lastMonth) {
        $metrics['total_maids_last_month']++;
        
        // Count by team member for last month using Username
        if (!empty($username)) {
            if (!isset($metrics['maids_by_team_last_month'][$username])) {
                $metrics['maids_by_team_last_month'][$username] = 0;
            }
            $metrics['maids_by_team_last_month'][$username]++;
        }
    } elseif ($submissionMonth === $monthBeforeLast) {
        $metrics['total_maids_month_before_last']++;
    }

    // ... rest of the processing code remains the same ...

    // Count by status
    if (isset($submission['Status'])) {
        switch ($submission['Status']) {
            case 'Taken':
                $metrics['total_maids_deployed']++;
                break;
            case 'Available':
                $metrics['total_maids_available']++;
                break;
            case 'Unavailable':
                $metrics['total_maids_unavailable']++;
                break;
        }
    }

    // Photo missing checks
    if (!isset($submission['Maid_Photo']) || empty($submission['Maid_Photo'])) {
        $metrics['maids_photos_missing']++;
        
        // Check if placed maid with missing photo
        if (isset($submission['Status']) && $submission['Status'] === 'Taken') {
            $metrics['placed_maids_photos_missing']++;
        }
    }

    // Document checks for placed maids
    if (isset($submission['Status']) && $submission['Status'] === 'Taken') {
        // Documents missing
        if (!isset($submission['Documents']) || empty($submission['Documents'])) {
            $metrics['placed_maids_documents_missing']++;
        }
        
        // Count documents
        $docCount = 0;
        if (isset($submission['{file_upload_0:path}']) && !empty($submission['{file_upload_0:path}'])) {
            $docCount++;
        }
        if (isset($submission['{file_upload_1:path}']) && !empty($submission['{file_upload_1:path}'])) {
            $docCount++;
        }
        if (isset($submission['{file_upload_2:path}']) && !empty($submission['{file_upload_2:path}'])) {
            $docCount++;
        }
        
        switch ($docCount) {
            case 1:
                $metrics['placed_maids_documents_1']++;
                break;
            case 2:
                $metrics['placed_maids_documents_2']++;
                break;
            case 3:
                $metrics['placed_maids_documents_3']++;
                break;
        }
    }

    // Existing Metrics
    if (isset($submission['Active_With_Lafab_Solutions'])) {
        $metrics['active_counts'][$submission['Active_With_Lafab_Solutions']]++;
    }
    if (isset($submission['Current_Package'])) {
        $metrics['package_counts'][$submission['Current_Package']]++;
    }
    if (isset($submission['Maid_Rating'])) {
        $metrics['rating_counts'][$submission['Maid_Rating']]++;
    }
}

// Pass metrics to the template
require JModuleHelper::getLayoutPath('mod_maids_management_dashboard', 'default');