<?php
defined('_JEXEC') or die;

// Define icons and colors for each status
$statusIcons = [
    'Front Desk Review' => 'fa-desktop',
    'Accounts Verification' => 'fa-file-invoice',
    'Compliance Review' => 'fa-check-circle',
    'Legal Review' => 'fa-balance-scale',
    'Records Update' => 'fa-sync-alt',
    'Approved' => 'fa-check',
    'Rejected' => 'fa-times',
    'Pending' => 'fa-clock'
];

$statusColors = [
    'Front Desk Review' => 'text-primary',
    'Accounts Verification' => 'text-info',
    'Compliance Review' => 'text-success',
    'Legal Review' => 'text-danger',
    'Records Update' => 'text-secondary',
    'Approved' => 'text-success',
    'Rejected' => 'text-dark',
    'Pending' => 'text-warning'
];
?>

<div class="rsforms-submissions card p-3 shadow-sm">
    <h3 class="text-center mb-3">NGO Submissions Overview</h3>
    <ul class="list-group">
        <li class="list-group-item d-flex justify-content-between align-items-center">
            <span><i class="fas fa-chart-bar"></i> <strong>Total NGOs:</strong></span>
            <span class="badge bg-primary rounded-pill"><?php echo $data['totalSubmissions']; ?></span>
        </li>
        <?php foreach ($data['statusCounts'] as $status => $count): ?>
            <li class="list-group-item d-flex justify-content-between align-items-center">
                <span>
                    <i class="fas <?php echo $statusIcons[$status] ?? 'fa-question-circle'; ?> <?php echo $statusColors[$status] ?? ''; ?>"></i>
                    <strong><?php echo $status; ?>:</strong>
                </span>
                <span class="badge bg-secondary rounded-pill"><?php echo $count; ?></span>
            </li>
        <?php endforeach; ?>
    </ul>
</div>

<!-- Include Bootstrap 5 and FontAwesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">