<?php
defined('_JEXEC') or die;

// Load CSS for styling
JHtml::_('stylesheet', 'com_rsforms/submissions.css', array('version' => 'auto', 'relative' => true));

// Fetch submissions
$submissions = $this->items;
?>

<div class="rsform-submission-directory">
    <?php if (!empty($submissions)): ?>
        <div class="submission-grid">
            <?php foreach ($submissions as $submission): ?>
                <div class="submission-item">
                    <?php
                    // Display Maid Photo (Image instead of link)
                    foreach ($submission->values as $field) {
                        if ($field->FieldName === 'Maid_Photo' && !empty($field->FieldValue)) {
                            echo '<div class="maid-photo">';
                            echo '<img src="' . JUri::root() . 'components/com_rsform/uploads/' . $field->FieldValue . '" alt="Maid Photo" width="150">';
                            echo '</div>';
                        }
                    }
                    ?>

                    <div class="submission-details">
                        <?php foreach ($submission->values as $field): ?>
                            <?php if ($field->FieldName !== 'Maid_Photo'): ?>
                                <div class="field">
                                    <strong><?php echo $field->FieldName; ?>:</strong>
                                    <span><?php echo $field->FieldValue; ?></span>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php else: ?>
        <p>No submissions found.</p>
    <?php endif; ?>
</div>