<?php
/**
 * @package RSForm! Pro
 * @copyright (C) 2007-2019 www.rsjoomla.com
 * @license GPL, http://www.gnu.org/copyleft/gpl.html
 */

defined('_JEXEC') or die;

use Joomla\CMS\Language\Text;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Factory;

$listOrder = $this->escape($this->filter_order);
$listDirn = $this->escape($this->filter_order_Dir);

Text::script('RSFP_SUBM_DIR_DELETE_SURE');
HTMLHelper::_('stylesheet', 'com_rsform/rsicons.css', array('relative' => true, 'version' => 'auto'));

$alignmentClass = $this->escape('directoryAlign' . ucfirst($this->params->get('alignment', 'center')));

// Get the current user
$user = Factory::getUser();
$isPublicUser = $user->guest; // Check if the user is a guest (non-logged-in)
?>

<!-- Add Custom CSS for Grid Layout -->
<style>
    .directory-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); /* Responsive grid */
        gap: 20px;
        padding: 20px;
    }

    /* Mobile responsiveness */
    @media (max-width: 600px) {
        .directory-grid {
            grid-template-columns: 1fr; /* 1 column on mobile */
        }
    }

    .directory-item {
        border: 1px solid #ddd;
        padding: 15px;
        border-radius: 8px;
        background-color: #f9f9f9;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        transition: transform 0.2s ease, box-shadow 0.2s ease; /* Add hover effect */
    }

    .directory-item:hover {
        transform: translateY(-5px);
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
    }

    .directory-item img {
        max-width: 100%;
        height: auto;
        border-radius: 8px;
        display: block;
        margin: 0 auto; /* Center images */
        loading: lazy; /* Lazy loading for images */
    }

    .directory-item .field {
        display: flex;
        align-items: center;
        margin-bottom: 10px;
    }

    .directory-item .field strong {
        margin-right: 10px;
        font-weight: bold;
        color: #333;
    }

    .directory-item .field span {
        color: #666;
        word-wrap: break-word; /* Wrap long text */
    }

    .directory-actions {
        display: flex;
        gap: 10px; /* Space between action buttons */
        margin-top: 15px;
    }

    .directory-actions a {
        text-decoration: none;
        color: #333;
        transition: color 0.2s ease;
    }

    .directory-actions a:hover {
        color: #007bff; /* Highlight on hover */
    }

    .no-submissions {
        text-align: center;
        padding: 20px;
        color: #666;
    }

    /* Checkbox for selection */
    .directory-item .select-checkbox {
        margin-bottom: 10px;
    }

    .directory-item .select-checkbox input {
        margin-right: 5px;
    }

    /* Select All checkbox */
    .select-all-container {
        text-align: center;
        margin-bottom: 20px;
    }

    .select-all-container input {
        margin-right: 5px;
    }
</style>

<!-- Select All Checkbox -->
<?php if ($this->directory->enablecsv && !$isPublicUser) : ?>
    <div class="select-all-container">
        <label>
            <input type="checkbox" id="select-all" /> Select All
        </label>
    </div>
<?php endif; ?>

<div class="directory-grid">
    <?php if ($this->items) : ?>
        <?php foreach ($this->items as $i => $item) : ?>
            <div class="directory-item">
                <!-- Checkbox for selection -->
                <?php if ($this->directory->enablecsv && !$isPublicUser) : ?>
                    <div class="select-checkbox">
                        <input type="checkbox" name="cid[]" value="<?php echo $item->SubmissionId; ?>" class="select-checkbox-item" />
                    </div>
                <?php endif; ?>

                <?php foreach ($this->viewableFields as $field) : ?>
                    <?php if ($field->FieldName === 'Maid_Photo') : ?>
                        <!-- Display Maid Photo as Image -->
                        <?php
                        // Get the file name from the submission
                        $fileName = $this->getValue($item, $field);

                        // Sanitize the file name to remove any HTML tags or unwanted characters
                        $fileName = strip_tags($fileName); // Remove HTML tags
                        $fileName = htmlspecialchars($fileName, ENT_QUOTES, 'UTF-8'); // Encode special characters

                        // Construct the full image URL
                        $baseUrl = 'https://maids.lafabsolution.com/components/com_rsform/uploads/';
                        $imageUrl = $baseUrl . $fileName;

                        // Display the image if the file name is not empty
                        if (!empty($fileName)) : ?>
                            <img src="<?php echo $imageUrl; ?>" loading="lazy" />
                        <?php endif; ?>
                    <?php else : ?>
                        <!-- Display Other Fields -->
                        <div class="field">
                            <strong><?php echo htmlspecialchars($field->FieldCaption, ENT_QUOTES, 'UTF-8'); ?>:</strong>
                            <span><?php echo htmlspecialchars($this->getValue($item, $field), ENT_QUOTES, 'UTF-8'); ?></span>
                        </div>
                    <?php endif; ?>
                <?php endforeach; ?>

                <!-- Actions (View, Edit, Delete, PDF) -->
                <div class="directory-actions">
                    <?php if ($this->hasDetailFields && !$isPublicUser) : ?>
                        <a class="<?php echo $this->tooltipClass; ?> directoryDetail" title="<?php echo RSFormProHelper::getTooltipText(Text::_('RSFP_SUBM_DIR_VIEW')); ?>" href="<?php echo Route::_('index.php?option=com_rsform&view=directory&layout=view&id=' . $item->SubmissionId); ?>" aria-label="View Submission">
                            <span class="rsficon rsficon-zoom-in"></span>
                        </a>
                    <?php endif; ?>
                    <?php if (RSFormProHelper::canEdit($this->params->get('formId'), $item->SubmissionId)) : ?>
                        <a class="<?php echo $this->tooltipClass; ?> directoryEdit" title="<?php echo RSFormProHelper::getTooltipText(Text::_('RSFP_SUBM_DIR_EDIT')); ?>" href="<?php echo Route::_('index.php?option=com_rsform&view=directory&layout=edit&id=' . $item->SubmissionId); ?>" aria-label="Edit Submission">
                            <span class="rsficon rsficon-edit"></span>
                        </a>
                    <?php endif; ?>
                    <?php if (RSFormProHelper::canDelete($this->params->get('formId'), $item->SubmissionId)) : ?>
                        <a onclick="return confirm(Joomla.JText._('RSFP_SUBM_DIR_DELETE_SURE'));" class="<?php echo $this->tooltipClass; ?> directoryDelete" title="<?php echo RSFormProHelper::getTooltipText(Text::_('RSFP_SUBM_DIR_DELETE')); ?>" href="<?php echo Route::_('index.php?option=com_rsform&controller=directory&task=delete&id=' . $item->SubmissionId); ?>" aria-label="Delete Submission">
                            <span class="rsficon rsficon-remove"></span>
                        </a>
                    <?php endif; ?>
                    <?php if ($this->directory->enablepdf && !$isPublicUser) : ?>
                        <a class="<?php echo $this->tooltipClass; ?> directoryPdf" title="<?php echo RSFormProHelper::getTooltipText(Text::_('RSFP_SUBM_DIR_PDF')); ?>" href="<?php echo $this->pdfLink($item->SubmissionId); ?>" aria-label="Download PDF">
                            <span class="rsficon rsficon-file-pdf"></span>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>
    <?php else : ?>
        <p class="no-submissions">No submissions found.</p>
    <?php endif; ?>
</div>

<!-- Download Selected as CSV Button -->
<?php if ($this->directory->enablecsv && !$isPublicUser) : ?>
    <div style="text-align: center; margin-top: 20px;">
        <button onclick="downloadSelectedAsCSV()" class="btn btn-primary">Download Selected as CSV</button>
    </div>
<?php endif; ?>

<script>
    // Select All functionality
    document.getElementById('select-all')?.addEventListener('change', function () {
        const checkboxes = document.querySelectorAll('.select-checkbox-item');
        checkboxes.forEach(checkbox => {
            checkbox.checked = this.checked;
        });
    });

    // Download Selected as CSV functionality
    function downloadSelectedAsCSV() {
        const selected = [];
        document.querySelectorAll('.select-checkbox-item:checked').forEach(checkbox => {
            selected.push(checkbox.value);
        });

        if (selected.length > 0) {
            // Send the selected IDs to the server
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = '<?php echo Route::_('index.php?option=com_rsform&task=directory.exportCSV'); ?>';

            selected.forEach(id => {
                const input = document.createElement('input');
                input.type = 'hidden';
                input.name = 'cid[]';
                input.value = id;
                form.appendChild(input);
            });

            document.body.appendChild(form);
            form.submit();
        } else {
            alert('Please select at least one submission to download.');
        }
    }
</script>